/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.alibaba.excel.EasyExcel;
import com.github.pagehelper.PageInfo;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.dto.TjbbExcelChartDto;
import com.wgcloud.entity.ReportInfo;
import com.wgcloud.entity.ReportInstance;
import com.wgcloud.service.ReportInfoService;
import com.wgcloud.service.ReportInstanceService;
import com.wgcloud.service.TaskUtilService;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/report"})
public class ReportController {
    private static final Logger logger = LoggerFactory.getLogger(ReportController.class);
    @Autowired
    private TaskUtilService taskUtilService;
    @Resource
    private ReportInfoService reportInfoService;
    @Autowired
    private ReportInstanceService reportInstanceService;
    @Autowired
    private CommonConfig commonConfig;

    private void testThread() {
        Runnable runnable = () -> logger.info("ReportController----------testThread");
        ThreadPoolUtil.executor.execute(runnable);
    }

    @RequestMapping(value={"list"})
    public String reportInfoList(ReportInfo reportInfo, Model model, HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            LicenseUtil.maxLicense_10((Model)model, (HttpServletRequest)request, (Object)reportInfo);
            StringBuffer url = new StringBuffer();
            String reportType = request.getParameter("reportType");
            String timePart = null;
            if (!StringUtils.isEmpty((CharSequence)reportInfo.getReportType())) {
                reportType = reportInfo.getReportType();
                params.put("reportType", reportType.trim());
                url.append("&reportType=").append(reportType);
            }
            if (!StringUtils.isEmpty((CharSequence)reportInfo.getTimePart())) {
                timePart = reportInfo.getTimePart();
                params.put("timePartLike", timePart.trim());
                url.append("&timePartLike=").append(timePart);
            }
            PageInfo pageInfo = this.reportInfoService.selectByParams(params, reportInfo.getPage().intValue(), reportInfo.getPageSize().intValue());
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            model.addAttribute("pageUrl", (Object)("/report/list?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("reportInfo", (Object)reportInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5de1\u68c0\u62a5\u544a\u5217\u8868\u9519\u8bef", (Throwable)e);
        }
        return "report/list";
    }

    @RequestMapping(value={"view"})
    public String viewReportInfo(Model model, HttpServletRequest request) {
        String id = request.getParameter("id");
        ReportInfo reportInfo = new ReportInfo();
        try {
            reportInfo = this.reportInfoService.selectById(id);
            model.addAttribute("reportInfo", (Object)reportInfo);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("reportInfoId", id);
            List reportInstanceList = this.reportInstanceService.selectAllByParams(params);
            model.addAttribute("reportInstanceList", (Object)reportInstanceList);
        }
        catch (Exception e) {
            logger.error("\u67e5\u770b\u5de1\u68c0\u62a5\u544a\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
        return "report/view";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"chartExcel"})
    public void chartExcel(Model model, HttpServletRequest request, HttpServletResponse response) {
        Object out = null;
        try {
            if (!StaticKeys.LICENSE_STATE.equals("1")) {
                response.setContentType("text/html;charset=UTF-8");
                response.getOutputStream().write("The module needs to professional version. Please contact us at www.wgstart.com".getBytes());
                return;
            }
            String id = request.getParameter("id");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("reportInfoId", id);
            List reportInstanceList = this.reportInstanceService.selectAllByParams(params);
            ArrayList<TjbbExcelChartDto> excelList = new ArrayList<TjbbExcelChartDto>();
            for (int i = 0; i < reportInstanceList.size(); ++i) {
                ReportInstance reportInstance = (ReportInstance)reportInstanceList.get(i);
                TjbbExcelChartDto excelChartDto = new TjbbExcelChartDto();
                excelChartDto.setInfoKey(reportInstance.getInfoKey());
                excelChartDto.setInfoContent(reportInstance.getInfoContent());
                excelList.add(excelChartDto);
            }
            String fileName = "report_" + id;
            response.setContentType("application/vnd.ms-exce");
            response.setCharacterEncoding("utf-8");
            response.addHeader("Content-Disposition", "filename=" + fileName + ".xlsx");
            EasyExcel.write((OutputStream)response.getOutputStream(), TjbbExcelChartDto.class).sheet("sheet").doWrite(excelList);
        }
        catch (Exception e) {
            logger.error("\u5de1\u68c0\u62a5\u544a\u5bfc\u51faexcel\u9519\u8bef", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

