/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util;

import com.wgcloud.entity.SnmpInfo;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class SnmpTestUtil {
    private static final Logger logger = LoggerFactory.getLogger(SnmpTestUtil.class);

    public static Target createDefault(String ip, String community, String port, int snmpVersion) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            logger.error("ip is null.");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)community)) {
            logger.error("community is null.");
            return null;
        }
        Address address = GenericAddress.parse((String)("udp:" + ip + "/" + port));
        UserTarget target = null;
        if (snmpVersion == 3) {
            target = new UserTarget();
            target.setSecurityLevel(3);
            target.setSecurityName(new OctetString(community));
        } else {
            target = new CommunityTarget();
            ((CommunityTarget)target).setCommunity(new OctetString(community));
            if (snmpVersion == 1) {
                target.setSecurityModel(2);
            }
        }
        target.setVersion(snmpVersion);
        target.setAddress(address);
        target.setTimeout(3000L);
        target.setRetries(2);
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String snmpGet(SnmpInfo snmpInfo, String oid) {
        String resultValue;
        block9: {
            if (StringUtils.isEmpty((CharSequence)oid)) {
                return "";
            }
            Snmp snmp = null;
            DefaultUdpTransportMapping transport = null;
            resultValue = "";
            Vector vector = null;
            try {
                String ip = snmpInfo.getHostname();
                String community = snmpInfo.getSnmpCommunity();
                String port = snmpInfo.getSnmpPort();
                int snmpVersion = Integer.valueOf(snmpInfo.getSnmpVersion());
                Target myTarget = SnmpTestUtil.createDefault((String)ip, (String)community, (String)port, (int)snmpVersion);
                transport = new DefaultUdpTransportMapping();
                transport.listen();
                snmp = new Snmp((TransportMapping)transport);
                PDU request = new PDU();
                SnmpTestUtil.bindingRequestVars((PDU)request, (String)oid);
                request.setType(-96);
                ResponseEvent responseEvent = snmp.send(request, myTarget);
                PDU response = responseEvent.getResponse();
                vector = response.getVariableBindings();
                for (int i = 0; i < vector.size(); ++i) {
                    try {
                        VariableBinding vb1 = (VariableBinding)vector.get(i);
                        if (StringUtils.isEmpty((CharSequence)oid) || !oid.contains(String.valueOf(vb1.getOid()))) continue;
                        resultValue = String.valueOf(vb1.getVariable());
                        break;
                    }
                    catch (Exception e) {
                        logger.error("snmp\u5e94\u7b54pdu\u83b7\u5f97mib\u4fe1\u606f\u9519\u8bef", (Throwable)e);
                        resultValue = e.toString();
                    }
                }
                SnmpTestUtil.closeTransport((TransportMapping)transport);
            }
            catch (Exception e) {
                logger.error("snmp\u68c0\u6d4b\u9519\u8bef", (Throwable)e);
                resultValue = e.toString();
                break block9;
            }
            finally {
                SnmpTestUtil.closeTransport(transport);
                SnmpTestUtil.closeSnmp(snmp);
            }
            SnmpTestUtil.closeSnmp((Snmp)snmp);
        }
        return resultValue;
    }

    private static void bindingRequestVars(PDU request, String oid) {
        if (!StringUtils.isEmpty((CharSequence)oid)) {
            request.add(new VariableBinding(new OID(oid.trim())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String walkSnmp(SnmpInfo snmpInfo, String oid) {
        if (StringUtils.isEmpty((CharSequence)oid)) {
            return "";
        }
        String result = "";
        logger.info("walkSnmp Test------" + snmpInfo.getHostname());
        Snmp snmp = null;
        try {
            String ip = snmpInfo.getHostname();
            String community = snmpInfo.getSnmpCommunity();
            String port = snmpInfo.getSnmpPort();
            int snmpVersion = Integer.valueOf(snmpInfo.getSnmpVersion());
            snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
            snmp.listen();
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(community));
            target.setVersion(snmpVersion);
            target.setAddress((Address)new UdpAddress(ip + "/" + port));
            target.setTimeout(60000L);
            target.setRetries(1);
            TableUtils utils = new TableUtils((Session)snmp, (PDUFactory)new DefaultPDUFactory(-91));
            utils.setMaxNumRowsPerPDU(5);
            OID[] columnOids = new OID[]{new OID(oid)};
            List l = utils.getTable((Target)target, columnOids, null, null);
            for (TableEvent e : l) {
                logger.info("TableEvent---------" + e.toString());
                result = result + e.toString() + "</br>";
            }
            SnmpTestUtil.closeSnmp((Snmp)snmp);
        }
        catch (Exception e) {
            logger.error("walkSnmpOperStatus\u9519\u8bef", (Throwable)e);
            result = e.toString();
        }
        finally {
            SnmpTestUtil.closeSnmp(snmp);
        }
        return result;
    }

    private static void closeTransport(TransportMapping transport) {
        try {
            if (null != transport) {
                transport.close();
            }
        }
        catch (Exception e) {
            logger.error("closeTransport\u9519\u8bef", (Throwable)e);
        }
    }

    private static void closeSnmp(Snmp snmp) {
        try {
            if (null != snmp) {
                snmp.close();
            }
        }
        catch (Exception e) {
            logger.error("closeSnmp\u9519\u8bef", (Throwable)e);
        }
    }
}

