/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.wgcloud.entity.SystemInfo;
import com.wgcloud.service.AppInfoService;
import com.wgcloud.service.DiskStateService;
import com.wgcloud.service.DockerInfoService;
import com.wgcloud.service.PortInfoService;
import com.wgcloud.service.SystemInfoService;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.PropertyUtil;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskUtilService {
    private Logger logger = LoggerFactory.getLogger(TaskUtilService.class);
    @Autowired
    SystemInfoService systemInfoService;
    @Autowired
    AppInfoService appInfoService;
    @Autowired
    DockerInfoService dockerInfoService;
    @Autowired
    PortInfoService portInfoService;
    @Autowired
    DiskStateService diskStateService;
    @Autowired
    private ServletContext servletContext;

    @Transactional
    public void refreshCommitDate() throws Exception {
        Date nowDate = new Date();
        this.logger.info("\u5237\u65b0\u76d1\u63a7\u6570\u636e\u66f4\u65b0\u65f6\u95f4\uff1a" + nowDate);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("state", "1");
        List systemInfolist = this.systemInfoService.selectAllByParamsForTask(params);
        ArrayList<SystemInfo> systemInfoUpdateList = new ArrayList<SystemInfo>();
        for (SystemInfo systemInfo : systemInfolist) {
            SystemInfo systemInfoUpdate = new SystemInfo();
            systemInfoUpdate.setCreateTime(nowDate);
            systemInfoUpdate.setId(systemInfo.getId());
            systemInfoUpdateList.add(systemInfoUpdate);
        }
        this.systemInfoService.updateRecord(systemInfoUpdateList);
    }

    public String sumDiskSizeCache(HttpServletRequest request) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        HostUtil.addAccountquery((HttpServletRequest)request, params);
        params.put("countBlockNe", "2");
        List hostList = this.systemInfoService.selectAllByParams(params);
        BigDecimal sumSize = new BigDecimal(0);
        for (SystemInfo systemInfo : hostList) {
            if (StringUtils.isEmpty((CharSequence)systemInfo.getDiskSumSize())) continue;
            try {
                sumSize = sumSize.add(new BigDecimal(systemInfo.getDiskSumSize().replace("G", "")));
            }
            catch (Exception e) {
                this.logger.error("double\u7c7b\u578b\u8f6c\u6362\u9519\u8bef", (Throwable)e);
            }
        }
        String sumSizeStr = String.valueOf(sumSize);
        if (sumSizeStr.indexOf(".") > 0) {
            sumSizeStr = sumSizeStr.substring(0, sumSizeStr.lastIndexOf("."));
        }
        return FormatUtil.gToT((String)sumSizeStr);
    }

    public String sumDiskSizeCacheByGroup(Object groupId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("groupId", groupId);
            params.put("countBlockNe", "2");
            List hostList = this.systemInfoService.selectAllByParams(params);
            BigDecimal sumSize = new BigDecimal(0);
            for (SystemInfo systemInfo : hostList) {
                if (StringUtils.isEmpty((CharSequence)systemInfo.getDiskSumSize())) continue;
                try {
                    sumSize = sumSize.add(new BigDecimal(systemInfo.getDiskSumSize().replace("G", "")));
                }
                catch (Exception e) {
                    this.logger.error("double\u7c7b\u578b\u8f6c\u6362\u9519\u8bef", (Throwable)e);
                }
            }
            String sumSizeStr = String.valueOf(sumSize);
            if (sumSizeStr.indexOf(".") > 0) {
                sumSizeStr = sumSizeStr.substring(0, sumSizeStr.lastIndexOf("."));
            }
            return FormatUtil.gToT((String)sumSizeStr);
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u6807\u7b7e\u7edf\u8ba1\u78c1\u76d8\u5bb9\u91cf\u603b\u548c\u9519\u8bef", (Throwable)e);
            return "";
        }
    }

    public String getValFromContext(String key, String defaultVal) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return defaultVal;
        }
        Object obj = this.servletContext.getAttribute(key);
        if (null == obj) {
            return defaultVal;
        }
        return obj.toString();
    }

    public void initMenuNames() {
        try {
            this.servletContext.setAttribute("jianKongGaiYao", (Object)"\u76d1\u63a7\u6982\u8981");
            this.servletContext.setAttribute("ziYuanGuanLi", (Object)"\u8d44\u6e90\u7ba1\u7406");
            this.servletContext.setAttribute("zhuJiGuanLi", (Object)"\u4e3b\u673a\u7ba1\u7406");
            this.servletContext.setAttribute("yiChangJinCheng", (Object)"\u4e3b\u673a\u5f02\u5e38\u8fdb\u7a0b");
            this.servletContext.setAttribute("jinChengJianCe", (Object)"\u8fdb\u7a0b\u76d1\u6d4b");
            this.servletContext.setAttribute("duanKouJianCe", (Object)"\u7aef\u53e3\u76d1\u6d4b");
            this.servletContext.setAttribute("riZhiJianKong", (Object)"\u65e5\u5fd7\u76d1\u63a7");
            this.servletContext.setAttribute("wenJianFangCuanGai", (Object)"\u6587\u4ef6\u9632\u7be1\u6539");
            this.servletContext.setAttribute("dockerJianCe", (Object)"DOCKER\u76d1\u6d4b");
            this.servletContext.setAttribute("ziDingYiJianKongXiang", (Object)"\u81ea\u5b9a\u4e49\u76d1\u63a7\u9879");
            this.servletContext.setAttribute("shuJuJianKong", (Object)"\u6570\u636e\u76d1\u63a7");
            this.servletContext.setAttribute("shuJuKuGuanLi", (Object)"\u6570\u636e\u5e93\u7ba1\u7406");
            this.servletContext.setAttribute("shuJuBiaoJianCe", (Object)"\u6570\u636e\u8868\u76d1\u6d4b");
            this.servletContext.setAttribute("fuWuJieKouJianCe", (Object)"\u670d\u52a1\u63a5\u53e3\u76d1\u6d4b");
            this.servletContext.setAttribute("zhanShiKanBan", (Object)"\u5c55\u793a\u770b\u677f");
            this.servletContext.setAttribute("wangLuoSheBeiJianCe", (Object)"\u7f51\u7edc\u8bbe\u5907\u76d1\u6d4b");
            this.servletContext.setAttribute("pingJianCe", (Object)"PING\u76d1\u6d4b");
            this.servletContext.setAttribute("snmpJianCe", (Object)"SNMP\u76d1\u6d4b");
            this.servletContext.setAttribute("snmpDeepJianCe", (Object)"SNMP\u6df1\u5ea6\u76d1\u63a7");
            this.servletContext.setAttribute("ftpJianCe", (Object)"FTP/SFTP\u76d1\u6d4b");
            this.servletContext.setAttribute("zhongJianJianJianCe", (Object)"\u4e2d\u95f4\u4ef6\u76d1\u6d4b");
            this.servletContext.setAttribute("redis", (Object)"Redis");
            this.servletContext.setAttribute("dongHuanJianCe", (Object)"\u52a8\u73af\u76d1\u6d4b");
            this.servletContext.setAttribute("nginxRiZhiJianCe", (Object)"Nginx\u65e5\u5fd7\u68c0\u6d4b");
            this.servletContext.setAttribute("kafka", (Object)"Kafka");
            this.servletContext.setAttribute("rabbitmq", (Object)"RabbitMQ");
            this.servletContext.setAttribute("activemq", (Object)"ActiveMQ");
            this.servletContext.setAttribute("k8sNode", (Object)"K8S-Node");
            this.servletContext.setAttribute("k8sDeployment", (Object)"K8S-Deployment");
            this.servletContext.setAttribute("k8sNamespace", (Object)"K8S-Namespace");
            this.servletContext.setAttribute("k8sPod", (Object)"K8S-Pod");
            this.servletContext.setAttribute("k8sService", (Object)"K8S-Service");
            this.servletContext.setAttribute("k8sContainer", (Object)"K8S-Container");
            this.servletContext.setAttribute("serverBackupName", (Object)"Server-Backup");
            this.servletContext.setAttribute("tuopuTu", (Object)"\u62d3\u6251\u56fe");
            this.servletContext.setAttribute("zhuJiTuopuTu", (Object)"\u4e3b\u673a\u62d3\u6251\u56fe");
            this.servletContext.setAttribute("pingTuopuTu", (Object)"PING\u62d3\u6251\u56fe");
            this.servletContext.setAttribute("snmpTuopuTu", (Object)"SNMP\u62d3\u6251\u56fe");
            this.servletContext.setAttribute("snmpDeepTuopuTu", (Object)"SNMP\u6df1\u5ea6\u62d3\u6251");
            this.servletContext.setAttribute("xunJianBaoGao", (Object)"\u5de1\u68c0\u62a5\u544a");
            this.servletContext.setAttribute("jiHuaRenWu", (Object)"\u8ba1\u5212\u4efb\u52a1");
            this.servletContext.setAttribute("xiTongGuanLi", (Object)"\u7cfb\u7edf\u7ba1\u7406");
            this.servletContext.setAttribute("xiTongRiZhi", (Object)"\u7cfb\u7edf\u65e5\u5fd7");
            this.servletContext.setAttribute("zhiLingXiaFa", (Object)"\u6307\u4ee4\u4e0b\u53d1");
            this.servletContext.setAttribute("biaoQianGuanLi", (Object)"\u6807\u7b7e\u7ba1\u7406");
            this.servletContext.setAttribute("chengYuanZhangHao", (Object)"\u6210\u5458\u8d26\u53f7");
            this.servletContext.setAttribute("gaoJingSheZhi", (Object)"\u544a\u8b66\u8bbe\u7f6e");
            this.servletContext.setAttribute("youJianGaoJing", (Object)"\u90ae\u4ef6\u544a\u8b66");
            this.servletContext.setAttribute("jiaoBenGaoJing", (Object)"\u811a\u672c\u544a\u8b66");
            this.servletContext.setAttribute("ziDingYiGaoJing", (Object)"\u81ea\u5b9a\u4e49\u544a\u8b66");
            this.servletContext.setAttribute("ziChanGuanLi", (Object)"\u8d44\u4ea7\u7ba1\u7406");
            this.servletContext.setAttribute("sheBeiZhangHao", (Object)"\u8bbe\u5907\u8d26\u53f7\u7ba1\u7406");
            this.servletContext.setAttribute("gongZuoBiJi", (Object)"\u5de5\u4f5c\u7b14\u8bb0");
            this.servletContext.setAttribute("zhongDuanYunXing", (Object)"\u7ec8\u7aef\u8fd0\u884c\u7edf\u8ba1");
            this.servletContext.setAttribute("aillm", (Object)"AI-LLM");
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u8bbe\u7f6e\u83dc\u5355\u540d\u79f0\u9519\u8bef", (Throwable)e);
        }
    }

    public void setDiyMenuNames() {
        try {
            Map mapColNames = PropertyUtil.getMenuNames((String)(StaticKeys.JAR_PATH + "/config/menusNameDiy.properties"));
            if (null != mapColNames) {
                if (!LicenseUtil.checkEnterpriseVersion()) {
                    this.logger.info("\u5f53\u524d\u5df2\u4f7f\u7528\u7cfb\u7edf\u9ed8\u8ba4\u914d\u7f6e\u7684\u83dc\u5355\u540d\u79f0");
                    return;
                }
                for (Map.Entry entry : mapColNames.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    this.servletContext.setAttribute(key, (Object)value);
                }
                this.logger.info("\u5f53\u524d\u5df2\u4f7f\u7528\u81ea\u5b9a\u4e49\u914d\u7f6e\u7684\u83dc\u5355\u540d\u79f0");
            }
        }
        catch (Exception e) {
            this.logger.error("\u81ea\u5b9a\u4e49\u8bbe\u7f6e\u83dc\u5355\u540d\u79f0\u9519\u8bef", (Throwable)e);
        }
    }
}

