/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.wgcloud.common.ApplicationContextHelper;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.dto.ChartInfo;
import com.wgcloud.dto.NetworkInfoDto;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.entity.AppExceptionInfo;
import com.wgcloud.entity.DiskState;
import com.wgcloud.entity.SystemInfo;
import com.wgcloud.service.AccountInfoService;
import com.wgcloud.service.SystemInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.redis.RedisDataUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.Model;

/*
 * Exception performing whole class analysis ignored.
 */
public class HostUtil {
    private static final Logger logger = LoggerFactory.getLogger(HostUtil.class);
    private static CommonConfig commonConfig = (CommonConfig)ApplicationContextHelper.getBean(CommonConfig.class);
    private static AccountInfoService accountInfoService = (AccountInfoService)ApplicationContextHelper.getBean(AccountInfoService.class);
    private static SystemInfoService systemInfoService = (SystemInfoService)ApplicationContextHelper.getBean(SystemInfoService.class);
    public static List<DiskState> DISK_LIST_COMPUTE = Collections.synchronizedList(new ArrayList());

    public static void addAccountListModel(Model model) {
        try {
            if (!"true".equals(commonConfig.getUserInfoManage())) {
                return;
            }
            HashMap params = new HashMap();
            List accountInfoList = accountInfoService.selectAllByParams(params);
            if (!CollectionUtil.isEmpty((Collection)accountInfoList)) {
                model.addAttribute("accountList", (Object)accountInfoList);
            }
        }
        catch (Exception e) {
            logger.error("addAccountListModel", (Throwable)e);
        }
    }

    public static void addAccountquery(HttpServletRequest request, Map<String, Object> params) {
        if (null == request || null == params) {
            return;
        }
        AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
        if (!"admin".equals(accountInfo.getRole()) && !"guest".equals(accountInfo.getRole()) && null != accountInfo.getAccount()) {
            params.put("account", accountInfo.getAccount());
        }
    }

    public static void addAccountqueryDaping(HttpServletRequest request, Map<String, Object> params) {
        if (null == request || null == params) {
            return;
        }
        if (!"1".equals(request.getParameter("viewDapingNowAccount"))) {
            return;
        }
        AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
        if (!"admin".equals(accountInfo.getRole()) && !"guest".equals(accountInfo.getRole()) && null != accountInfo.getAccount()) {
            params.put("account", accountInfo.getAccount());
        }
    }

    public static void setDiskSumPer(List<DiskState> diskStates, SystemInfo systemInfo) {
        try {
            Double sumSize = 0.0;
            Double useSize = 0.0;
            for (DiskState diskState : diskStates) {
                if (StringUtils.isEmpty((CharSequence)diskState.getDiskSize()) || StringUtils.isEmpty((CharSequence)diskState.getUsed())) continue;
                sumSize = sumSize + Double.valueOf(diskState.getDiskSize().replace("G", ""));
                useSize = useSize + Double.valueOf(diskState.getUsed().replace("G", ""));
            }
            systemInfo.setDiskPer(Double.valueOf(0.0));
            systemInfo.setDiskSumSize("0G");
            if (sumSize != 0.0) {
                systemInfo.setDiskPer(Double.valueOf(FormatUtil.formatDouble((Double)(useSize / sumSize * 100.0), (int)2)));
            }
            systemInfo.setDiskSumSize(FormatUtil.formatDouble((Double)sumSize, (int)2) + "G");
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u78c1\u76d8\u603b\u4f7f\u7528\u7387\u9519\u8bef", (Throwable)e);
        }
    }

    public static void setDiskListSumSize(List<DiskState> diskStates) {
        try {
            DiskState diskStateSum = new DiskState();
            Double sumSize = 0.0;
            Double useSize = 0.0;
            Double availSize = 0.0;
            for (DiskState diskState : diskStates) {
                if (!StringUtils.isEmpty((CharSequence)diskState.getDiskSize())) {
                    sumSize = sumSize + Double.valueOf(diskState.getDiskSize().replace("G", ""));
                }
                if (!StringUtils.isEmpty((CharSequence)diskState.getUsed())) {
                    useSize = useSize + Double.valueOf(diskState.getUsed().replace("G", ""));
                }
                if (StringUtils.isEmpty((CharSequence)diskState.getAvail())) continue;
                availSize = availSize + Double.valueOf(diskState.getAvail().replace("G", ""));
            }
            diskStateSum.setUsePer("0%");
            if (sumSize != 0.0) {
                diskStateSum.setUsePer(FormatUtil.formatDouble((Double)(useSize / sumSize * 100.0), (int)2) + "%");
            }
            diskStateSum.setUsed(FormatUtil.formatDouble((Double)useSize, (int)2) + "G");
            diskStateSum.setDiskSize(FormatUtil.formatDouble((Double)sumSize, (int)2) + "G");
            diskStateSum.setAvail(FormatUtil.formatDouble((Double)availSize, (int)2) + "G");
            diskStateSum.setFileSystem("\u603b\u8ba1");
            diskStates.add(diskStateSum);
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u78c1\u76d8\u603b\u8ba1\u9519\u8bef", (Throwable)e);
        }
    }

    public static void setSysImage(SystemInfo systemInfo) {
        if (!StringUtils.isEmpty((CharSequence)systemInfo.getPlatForm())) {
            String platForm = systemInfo.getPlatForm().toLowerCase();
            if (platForm.contains("windows")) {
                systemInfo.setImage(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/static/images/windows.png");
            } else if (platForm.contains("centos")) {
                systemInfo.setImage(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/static/images/centos.png");
            } else if (platForm.contains("hat")) {
                systemInfo.setImage(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/static/images/redhat.png");
            } else if (platForm.contains("ubuntu")) {
                systemInfo.setImage(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/static/images/ubuntu.png");
            } else if (platForm.contains("debian")) {
                systemInfo.setImage(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/static/images/debian.png");
            } else if (platForm.contains("darwin")) {
                systemInfo.setImage(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/static/images/darwin.png");
            } else if (platForm.contains("android")) {
                systemInfo.setImage(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/static/images/android.png");
            } else if (platForm.contains("suse")) {
                systemInfo.setImage(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/static/images/suse.png");
            } else if (platForm.contains("fedora")) {
                systemInfo.setImage(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/static/images/fedora.png");
            } else if (platForm.contains("freebsd")) {
                systemInfo.setImage(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/static/images/freebsd.png");
            } else if (platForm.contains("kylin")) {
                systemInfo.setImage(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/static/images/kylin.png");
            } else {
                systemInfo.setImage(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/static/images/linux.png");
            }
        } else {
            systemInfo.setImage(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/static/images/linux.png");
        }
    }

    public static void setSysFontAwesome(SystemInfo systemInfo) {
        if (!StringUtils.isEmpty((CharSequence)systemInfo.getPlatForm())) {
            String platForm = systemInfo.getPlatForm().toLowerCase();
            if (platForm.contains("windows")) {
                systemInfo.setImage("<i class=\"fa-brands fa-windows\"></i>");
            } else if (platForm.contains("centos")) {
                systemInfo.setImage("<i class=\"fa-brands fa-centos\"></i>");
            } else if (platForm.contains("hat")) {
                systemInfo.setImage("<i class=\"fa-brands fa-redhat\"></i>");
            } else if (platForm.contains("ubuntu")) {
                systemInfo.setImage("<i class=\"fa-brands fa-ubuntu\"></i>");
            } else if (platForm.contains("debian")) {
                systemInfo.setImage("<svg style=\"font-weight:400;width:20px;height:20px;\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 448 512\"><path fill=\"#ffffff\" d=\"M380.2 245.6c3-7.6 5.5-14 5.2-24.4l-4.3 9c4.4-13.2 4-27.1 3.6-40.4c-.2-6-.3-11.8 0-17.4l-1.8-.5c-1.5-45.2-40.6-93.1-75.3-109.4c-30-13.8-76.1-16.2-97.3-5.8c1.3-1.1 4.2-2 6.8-2.7l.3-.1c3.3-1 6-1.7 4-2.9c-19.2 1.9-24.9 5.5-31.1 9.4l-.1 0c-4.6 2.9-9.5 6-20.3 8.7c-3.5 3.4 1.7 2 5.8 .9l0 0c4.1-1.1 7.2-1.9-.1 2.4c-3.5 1-6.6 1.3-9.6 1.6l-.1 0c-8.3 .8-15.8 1.6-30.7 17c.8 1.3 3.4-.2 5.3-1.3l.1-.1c2.3-1.4 3.4-2-1.7 4.4c-19.1-2.4-60.3 43.7-69.1 59l4.6 .8c-3.2 8-6.8 14.8-10 20.8c-4.3 8.1-7.9 14.9-8.7 21.3c-.3 5.1-1 11-1.7 17.3l0 0c-.1 1-.2 2-.3 3l-.1 .6c-3 27.3-6.7 60.8 3.9 73l-1.3 13c.6 1.2 1.1 2.3 1.6 3.5c.2 .4 .4 .8 .5 1.1l0 0 0 0 0 0 0 0 0 0 0 0 0 0c1 2.1 2 4.2 3.3 6.2l-3 .2c7 22.1 10.8 22.5 15.1 22.9l0 0c4.4 .4 9.3 .9 18.7 24.2c-2.7-.9-5.5-1.9-9.4-7.2c-.5 4.1 5.8 16.3 13.1 25.8l-3.1 3.6c2.1 3.7 4.8 6.2 7.6 8.8l0 0 0 0c1 .9 2.1 1.9 3.1 2.9c-11.9-6.5 3.2 13.7 11.9 25.2c.8 1.1 1.5 2 2.2 2.9l0 0 0 0 0 0 0 0 0 0c1.4 1.9 2.5 3.4 2.9 4.1l2.4-4.2c-.3 6.1 4.3 13.9 13.1 24.7l7.3-.3c3 6 14 16.7 20.7 17.2l-4.4 5.8c8.1 2.6 10.3 4.3 12.7 6.2c2.6 2.1 5.4 4.3 16.1 8.1l-4.2-7.4c3.5 3 6.2 5.9 8.8 8.7l.1 .1c5.2 5.6 9.9 10.6 19.7 15.3c10.7 3.7 16.6 4.7 22.7 5.8c.3 0 .6 .1 .9 .1c5.4 .8 11.2 1.8 20.8 4.5c-1.1-.1-2.2-.1-3.3-.1h0c-2.3-.1-4.7-.1-7-.1l0 0 0 0 0 0 0 0 0 0 0 0 0 0c-14.4-.2-29.2-.4-42.7-5.2C107.8 480.5 19.5 367.2 26 250.6c-.6-9.9-.3-20.9 0-30.7c.4-13.5 .7-24.8-1.6-28.3l1-3.1c5.3-17.4 11.7-38.2 23.8-62.8l-.1-.2v-.1c.4 .4 3.4 3.4 8.8-5.8c.8-1.8 1.6-3.7 2.4-5.6c.5-1.1 .9-2.2 1.4-3.2c2.5-6.1 5.1-12.3 8.4-17.9l2.6-.6c1.7-10.1 17-23.8 29.8-35.2l1.1-1c5.7-5.1 10.7-9.7 13.6-13.1l.7 4.4c17-15.9 44.6-27.5 65.6-36.4l.5-.2c4.8-2 9.3-3.9 13.3-5.7c-3.4 3.8 2.2 2.7 10 1c4.8-1 10.4-2.1 15.3-2.4l-3.9 2.1c-2.7 1.4-5.4 2.8-8 4.6c8.1-2 11.7-1.4 15.7-.8l.3 0c3.5 .6 7.3 1.2 14.6 .2c-5.6 .8-12.3 3-11.2 3.8c7.9 .9 12.8-.1 17.2-1l.2 0c5.5-1.1 10.3-2 19.3 .9l-1-4.8c7.3 2.6 12.7 4.3 17.5 5.8l.5 .1c10 3 17.6 5.3 34.2 14.1c3.2 .2 5.3-.5 7.4-1.2l.1 0c3.6-1.1 7-2.1 15.2 1.2c.3 .5 .5 1 .7 1.4c.1 .2 .2 .5 .3 .7l0 .1c1 2.6 1.8 4.6 14.6 12.1c1.7-.7-2.7-4.7-6.4-8.2c0 0 0 0-.1-.1c-.2-.1-.3-.3-.5-.4c32.2 17.3 67.3 54.1 78 93.5c-6-11.1-5.2-5.5-4.3 .5c.6 4 1.2 8.1-.2 7.5c4.5 12.1 8.1 24.5 10.4 37.4l-.8-2.9-.1-.3c-3.3-11.9-9.6-34.3-19.9-49.3c-.4 4.3-2.8 3.9-5.2 3.5l-.1 0 0 0c-3.3-.6-6.2-1.1-1.9 12.6c2.6 3.8 3.1 2.4 3.5 1.1l0 0c.5-1.5 .9-2.7 4.7 5.2c.1 4.1 1 8.2 2.1 12.7l0 0 0 0 .1 .6c.1 .3 .1 .5 .2 .8l.1 .6c.6 2.6 1.3 5.4 1.8 8.4c-1.1-.2-2.3-2.2-3.4-4.2c-1.4-2.4-2.8-4.7-3.7-3.2c2.4 11.5 6.5 17.4 8 18.3c-.3 .6-.6 .7-1.1 .7c-.8 0-1.8 .1-1.9 5.3c.7 13.7 3.3 12.5 5.3 11.6l0 0c.6-.3 1.2-.6 1.7-.4c-.6 2.5-1.6 5.1-2.7 7.9c-2.8 7.1-6 15.4-3.4 26.1c-.8-3-2-6-3.1-8.9l-.1-.4c-.2-.5-.4-1-.6-1.5l0 0c-.3-.8-.6-1.6-.9-2.3c-.6 4.4-.3 7.7-.1 10.6c0 .2 0 .5 0 .7c.4 5.3 .7 10-3 19.9c4.3-14.2 3.8-26.9-.2-20.8c1 10.9-3.7 20.4-8 28.9l-.1 .2c-3.6 7.1-6.8 13.5-5.9 19.3l-5.2-7.1c-7.5 10.9-7 13.3-6.5 15.5l0 .1c.5 1.9 1 3.8-3.4 10.8c1.7-2.9 1.3-3.6 1-4.2l0 0c-.4-.8-.7-1.5 1.7-5.1c-1.6 .1-5.5 3.9-10.1 8.5c-3.9 3.9-8.5 8.4-12.8 11.8c-37.5 30.1-82.3 34-125.6 17.8c.2-1-.2-2.1-3.1-4.1c-36.8-28.2-58.5-52.1-50.9-107.5c2.1-1.6 3.6-5.8 5.3-10.8l0 0 0 0 .2-.4 .1-.3 0-.1c2.9-8.4 6.5-18.8 14.3-23.8c7.8-17.3 31.3-33.3 56.4-33.7c25.6-1.4 47.2 13.7 58.1 27.9c-19.8-18.4-52.1-24-79.7-10.4c-28.2 12.7-45 43.8-42.5 74.7c.3-.4 .6-.6 .9-.8l0 0s0 0 0 0c0 0 .1-.1 .1-.1l.1-.1c.6-.5 1.1-.9 1.4-3.3c-.9 60.2 64.8 104.3 112.1 82l.6 1.3c12.7-3.5 15.9-6.5 20.3-10.7l.1-.1 0 0c2.2-2.1 4.7-4.5 8.9-7.3c-.3 .7-1.3 1.7-2.4 2.7c-2.2 2.1-4.6 4.5-1.6 4.6c5-1.3 18.5-13.4 28.5-22.3l0 0 0 0c.6-.5 1.2-1 1.7-1.5c1.5-1.3 2.8-2.5 4-3.6l0 0 .3-.3c1.9-4.2 1.6-5.6 1.3-7l0-.1c-.4-1.6-.8-3.3 2.4-9.6l7.3-3.7c.8-2.1 1.5-4.1 2.2-6c.2-.6 .5-1.2 .7-1.8l-.4-.2zM349.3 34.3l-.2-.1 .2 .1 0 0zM247.8 334.1c-6-3-13.7-8.9-14.8-11.4l-.4 .3c-.3 .6-.5 1.3-.2 2.2c-12.2-5.7-23.4-14.3-32.6-24.9c4.9 7.1 10.1 14.1 17 19.5c-6.9-2.3-15.1-11.8-21.6-19.3l-.1-.1c-4.3-5-7.9-9.1-9.7-9.5c19.8 35.5 80.5 62.3 112.3 49c-14.7 .5-33.4 .3-49.9-5.8zm79.3-119.7l-.1-.2c-.5-1.5-1.1-3.1-1.7-3.4c1.4-5.8 5.4-10.7 4.4 4.6c-1 3.8-1.8 1.5-2.6-1zm-4.2 22.2c-1.3 7.9-5 15.5-10.1 22.5c.2-2-1.2-2.4-2.6-2.8l0 0c-2.9-.8-5.9-1.6 5.6-16.1c-.5 1.9-2.1 4.6-3.7 7.3l0 0 0 0-.3 .4c-3.6 5.9-6.7 11 4 4.3l1-1.8c2.6-4.5 5-8.8 6-13.8h.1zm-55.6 33.9c7.1 .6 14.1 .6 21-1.1c-2.5 2.4-5.2 4.8-8.3 7.2c-11.1-1.7-21.2-6-12.7-6.1zm-92.6 11.6c3.6 7.1 6.4 11.5 9 15.7l.1 .2c2.3 3.7 4.4 7.1 6.8 11.7c-5.1-4.2-8.7-9.5-12.5-15l-.3-.5c-1.4-2.1-2.8-4.2-4.4-6.2l1.2-5.9h.1zm7.5-9.6c1.6 3.3 3.2 6.4 5.7 9.1l2.6 7.7-1.3-2.1c-3.2-5.3-6.3-10.6-8-16.7l.8 1.6 .2 .4zm238.9-41.6c-2.3 17.4-7.7 34.6-16 50.3c7.6-14.9 12.5-30.9 14.8-47.2l1.2-3.1zM35.6 110.6c.4 .8 1.4 .5 2.3 .3c1.9-.5 3.6-.9-.1 7.6c-.5 .3-1 .7-1.5 1l0 0 0 0c-1.4 .9-2.8 1.9-3.9 3c1.9-3.8 3.5-7.4 3.2-11.9zM25.3 152.3c-.7 3.7-1.5 7.9-3.4 13.9c.2-1.9 0-3.5-.2-4.9l0-.1c-.4-3.4-.7-6.3 4.3-12.8c-.3 1.2-.5 2.5-.7 3.8v.1z\"/></svg>");
            } else if (platForm.contains("darwin")) {
                systemInfo.setImage("<i class=\"fa-brands fa-apple\"></i>");
            } else if (platForm.contains("android")) {
                systemInfo.setImage("<i class=\"fa-brands fa-android\"></i>");
            } else if (platForm.contains("suse")) {
                systemInfo.setImage("<i class=\"fa-brands fa-suse\"></i>");
            } else if (platForm.contains("fedora")) {
                systemInfo.setImage("<i class=\"fa-brands fa-fedora\"></i>");
            } else if (platForm.contains("freebsd")) {
                systemInfo.setImage("<i class=\"fa-brands fa-freebsd\"></i>");
            } else {
                systemInfo.setImage("<i style=\"color:#343a40\" class=\"fa-brands fa-linux\"></i>");
            }
        } else {
            systemInfo.setImage("<i style=\"color:#343a40\" class=\"fa-brands fa-linux\"></i>");
        }
    }

    public static List<ChartInfo> getSystemTypeList(List<SystemInfo> systemInfoList) {
        ArrayList<ChartInfo> chartInfoList = new ArrayList<ChartInfo>();
        Map map = HostUtil.getSystemTypeMap(systemInfoList);
        for (Map.Entry entry : map.entrySet()) {
            ChartInfo chartInfo = new ChartInfo();
            chartInfo.setItem((String)entry.getKey());
            chartInfo.setCount((Integer)entry.getValue());
            chartInfoList.add(chartInfo);
        }
        return chartInfoList;
    }

    public static Map<String, Integer> getSystemTypeMap(List<SystemInfo> systemInfoList) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (SystemInfo systemInfo : systemInfoList) {
            if (!StringUtils.isEmpty((CharSequence)systemInfo.getPlatForm())) {
                String platForm = systemInfo.getPlatForm().toLowerCase();
                if (platForm.contains("windows")) {
                    if (map.get("windows") != null) {
                        map.put("windows", (Integer)map.get("windows") + 1);
                        continue;
                    }
                    map.put("windows", 1);
                    continue;
                }
                if (platForm.contains("centos")) {
                    if (map.get("centos") != null) {
                        map.put("centos", (Integer)map.get("centos") + 1);
                        continue;
                    }
                    map.put("centos", 1);
                    continue;
                }
                if (platForm.contains("redhat")) {
                    if (map.get("redhat") != null) {
                        map.put("redhat", (Integer)map.get("redhat") + 1);
                        continue;
                    }
                    map.put("redhat", 1);
                    continue;
                }
                if (platForm.contains("ubuntu")) {
                    if (map.get("ubuntu") != null) {
                        map.put("ubuntu", (Integer)map.get("ubuntu") + 1);
                        continue;
                    }
                    map.put("ubuntu", 1);
                    continue;
                }
                if (platForm.contains("debian")) {
                    if (map.get("debian") != null) {
                        map.put("debian", (Integer)map.get("debian") + 1);
                        continue;
                    }
                    map.put("debian", 1);
                    continue;
                }
                if (platForm.contains("darwin")) {
                    if (map.get("macOS") != null) {
                        map.put("macOS", (Integer)map.get("macOS") + 1);
                        continue;
                    }
                    map.put("macOS", 1);
                    continue;
                }
                if (platForm.contains("android")) {
                    if (map.get("android") != null) {
                        map.put("android", (Integer)map.get("android") + 1);
                        continue;
                    }
                    map.put("android", 1);
                    continue;
                }
                if (platForm.contains("kylin")) {
                    if (map.get("kylin") != null) {
                        map.put("kylin", (Integer)map.get("kylin") + 1);
                        continue;
                    }
                    map.put("kylin", 1);
                    continue;
                }
                if (map.get("\u5176\u4ed6") != null) {
                    map.put("\u5176\u4ed6", (Integer)map.get("\u5176\u4ed6") + 1);
                    continue;
                }
                map.put("\u5176\u4ed6", 1);
                continue;
            }
            if (map.get("\u5176\u4ed6") != null) {
                map.put("\u5176\u4ed6", (Integer)map.get("\u5176\u4ed6") + 1);
                continue;
            }
            map.put("\u5176\u4ed6", 1);
        }
        return map;
    }

    public static String addRemark(String hostname) {
        if (StringUtils.isEmpty((CharSequence)hostname)) {
            return "";
        }
        String remark = (String)StaticKeys.HOST_MAP.get(hostname);
        remark = !StringUtils.isEmpty((CharSequence)remark) ? "(" + remark + ")" : "";
        return remark;
    }

    public static String getAccount(String hostname) {
        if (StringUtils.isEmpty((CharSequence)hostname)) {
            return "";
        }
        String account = (String)StaticKeys.HOST_ACCOUNT_MAP.get(hostname);
        return account;
    }

    public static AccountInfo getAccountByRequest(HttpServletRequest request) {
        AccountInfo accountInfo = (AccountInfo)request.getSession().getAttribute("LOGIN_KEY");
        if (accountInfo == null) {
            return new AccountInfo();
        }
        return accountInfo;
    }

    public static void clearCacheMap() {
        logger.info("\u6e05\u7a7a\u7f13\u5b58\u4e3b\u673a\u7f13\u5b58\u7684map");
        StaticKeys.HOST_MAP.clear();
        StaticKeys.HOST_ACCOUNT_MAP.clear();
        try {
            HashMap params = new HashMap();
            List list = systemInfoService.selectAllByParamsForTask(params);
            HostUtil.initHostCacheMap((List)list);
        }
        catch (Exception e) {
            logger.error("clearCacheMap\u9519\u8bef", (Throwable)e);
        }
    }

    public static void initHostCacheMap(List<SystemInfo> list) throws Exception {
        try {
            if (!CollectionUtil.isEmpty(list)) {
                for (SystemInfo systemInfo : list) {
                    if (!StringUtils.isEmpty((CharSequence)systemInfo.getRemark())) {
                        StaticKeys.HOST_MAP.put(systemInfo.getHostname(), systemInfo.getRemark());
                    }
                    if (!"true".equals(commonConfig.getUserInfoManage()) || StringUtils.isEmpty((CharSequence)systemInfo.getAccount()) || !StaticKeys.LICENSE_STATE.equals("1")) continue;
                    StaticKeys.HOST_ACCOUNT_MAP.put(systemInfo.getHostname(), systemInfo.getAccount());
                }
            }
        }
        catch (Exception e) {
            logger.error("initHostCacheMap\u9519\u8bef", (Throwable)e);
        }
    }

    public static List<Object> compressChartListData(List<Object> list, Model model) {
        Integer maxValue = commonConfig.getChartDataMaxShowValue();
        if (list.size() <= maxValue || maxValue == 0) {
            return list;
        }
        Integer radixValue = list.size() / maxValue;
        if ((radixValue = Integer.valueOf(radixValue + 1)) < 2) {
            return list;
        }
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            if (i % radixValue != 0) continue;
            resultList.add(list.get(i));
        }
        model.addAttribute("compressDataMsg", (Object)("\u7cfb\u7edf\u5df2\u5bf9\u56fe\u8868\u6570\u636e\u8fdb\u884c\u538b\u7f29\u5747\u8861\u5316\u5904\u7406\uff0c\u5904\u7406\u524d" + list.size() + "\u6761\uff0c\u5904\u7406\u540e" + resultList.size() + "\u6761"));
        return resultList;
    }

    public static void addDapingTipMsg(HttpServletRequest request, Model model) {
        Integer refreshTimes = commonConfig.getDapingRefreshTimes();
        model.addAttribute("dapingRefreshTimes", (Object)(refreshTimes * 1000));
        String msg = "\u5f53\u524d\u5df2\u663e\u793a\u6240\u6709\u76d1\u63a7\u8d44\u6e90\uff0c" + refreshTimes + "\u79d2\u540e\u4f1a\u81ea\u52a8\u5237\u65b0";
        if (!"1".equals(request.getParameter("viewDapingNowAccount"))) {
            model.addAttribute("tipInfoMsg", (Object)msg);
            return;
        }
        AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
        if (!"admin".equals(accountInfo.getRole()) && !"guest".equals(accountInfo.getRole()) && null != accountInfo.getAccount()) {
            msg = "\u5f53\u524d\u5df2\u663e\u793a\u3010" + accountInfo.getAccount() + "\u3011\u6240\u6709\u76d1\u63a7\u8d44\u6e90\uff0c" + refreshTimes + "\u79d2\u540e\u4f1a\u81ea\u52a8\u5237\u65b0";
        }
        model.addAttribute("tipInfoMsg", (Object)msg);
    }

    public static void viewAllProcessHandler(AppExceptionInfo appExceptionInfo, Model model, String id) throws Exception {
        SystemInfo systemInfo = systemInfoService.selectById(id);
        model.addAttribute("systemInfo", (Object)systemInfo);
        HostUtil.setSysFontAwesome((SystemInfo)systemInfo);
        if (!LicenseUtil.checkEnterpriseVersion()) {
            model.addAttribute("tipInfo", (Object)"\u63d0\u793a: \u5347\u7ea7\u5230\u4f01\u4e1a\u7248\u53ef\u4ee5\u67e5\u770b\u5168\u91cf\u8fd0\u884c\u8fdb\u7a0b\u54e6");
        }
        model.addAttribute("appExceptionInfo", (Object)appExceptionInfo);
        if (!StringUtils.isEmpty((CharSequence)commonConfig.getRedisUrl())) {
            HostUtil.getAllProcessFromRedis((SystemInfo)systemInfo, (AppExceptionInfo)appExceptionInfo, (Model)model);
            return;
        }
        List cacheList = (List)StaticKeys.HOST_ALL_PROCESS.get(systemInfo.getHostname());
        HostUtil.sortAllProcess((AppExceptionInfo)appExceptionInfo, (List)cacheList);
        model.addAttribute("cacheList", (Object)cacheList);
        if (null != cacheList) {
            model.addAttribute("cacheListSize", (Object)(" (" + cacheList.size() + ")"));
        }
        String caijiDateTime = (String)StaticKeys.HOST_ALL_PROCESS.get(systemInfo.getHostname() + "_DATETIME");
        model.addAttribute("caijiDateTime", (Object)caijiDateTime);
    }

    private static void sortAllProcess(AppExceptionInfo appExceptionInfo, List cacheList) {
        if (!StringUtils.isEmpty((CharSequence)appExceptionInfo.getOrderBy())) {
            if ("appName".equals(appExceptionInfo.getOrderBy())) {
                Collections.sort(cacheList, new /* Unavailable Anonymous Inner Class!! */);
            }
            if ("gatherPid".equals(appExceptionInfo.getOrderBy())) {
                Collections.sort(cacheList, new /* Unavailable Anonymous Inner Class!! */);
            }
            if ("appTimes".equals(appExceptionInfo.getOrderBy())) {
                Collections.sort(cacheList, new /* Unavailable Anonymous Inner Class!! */);
            }
            if ("cpuPer".equals(appExceptionInfo.getOrderBy())) {
                Collections.sort(cacheList, new /* Unavailable Anonymous Inner Class!! */);
            }
            if ("memPer".equals(appExceptionInfo.getOrderBy())) {
                Collections.sort(cacheList, new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    public static void getAllProcessFromRedis(SystemInfo systemInfo, AppExceptionInfo appExceptionInfo, Model model) {
        try {
            String jsonString = RedisDataUtil.getValue((String)(systemInfo.getHostname() + "_ALL_PROCESS"));
            if (!StringUtils.isEmpty((CharSequence)jsonString)) {
                JSONArray jsonArray = JSONUtil.parseArray((String)jsonString);
                List cacheList = JSONUtil.toList((JSONArray)jsonArray, AppExceptionInfo.class);
                HostUtil.sortAllProcess((AppExceptionInfo)appExceptionInfo, (List)cacheList);
                model.addAttribute("cacheList", (Object)cacheList);
                if (null != jsonArray) {
                    model.addAttribute("cacheListSize", (Object)(" (" + jsonArray.size() + ")"));
                }
                model.addAttribute("caijiDateTime", (Object)RedisDataUtil.getValue((String)(systemInfo.getHostname() + "_ALL_PROCESS" + "_DATETIME")));
            }
        }
        catch (Exception e) {
            logger.error("\u4eceredis\u4e2d\u83b7\u53d6\u5168\u91cf\u8fdb\u7a0b\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
    }

    public static void setAllProcessHandler(String bindIp, List<AppExceptionInfo> willCacheList, Date date) {
        if (StringUtils.isEmpty((CharSequence)commonConfig.getRedisUrl())) {
            StaticKeys.HOST_ALL_PROCESS.put(bindIp, willCacheList);
            StaticKeys.HOST_ALL_PROCESS.put(bindIp + "_DATETIME", DateUtil.getDateTimeString((Date)date));
        } else {
            RedisDataUtil.setValue((String)(bindIp + "_ALL_PROCESS"), (String)JSONUtil.toJsonStr(willCacheList));
            RedisDataUtil.setValue((String)(bindIp + "_ALL_PROCESS" + "_DATETIME"), (String)DateUtil.getDateTimeString((Date)date));
        }
    }

    public static void setImportDataHandler(String key, String data, Date date) {
        if (StringUtils.isEmpty((CharSequence)commonConfig.getRedisUrl())) {
            StaticKeys.HOST_IMPORT_DATA.put(key, data);
            StaticKeys.HOST_IMPORT_DATA.put(key + "_DATETIME", DateUtil.getDateTimeString((Date)date));
        } else {
            RedisDataUtil.setValue((String)key, (String)data);
            RedisDataUtil.setValue((String)(key + "_DATETIME"), (String)DateUtil.getDateTimeString((Date)date));
        }
    }

    public static void viewImportInfoHandler(Model model, String id) throws Exception {
        SystemInfo systemInfo = systemInfoService.selectById(id);
        model.addAttribute("systemInfo", (Object)systemInfo);
        HostUtil.setSysFontAwesome((SystemInfo)systemInfo);
        if (!LicenseUtil.checkEnterpriseVersion()) {
            model.addAttribute("tipInfo", (Object)"\u63d0\u793a: \u5347\u7ea7\u5230\u4f01\u4e1a\u7248\u53ef\u4ee5\u67e5\u770bGPU\u3001\u9632\u706b\u5899\u3001CRONTAB\u4fe1\u606f\u3001\u4e2a\u6027\u5316\u91c7\u96c6\u54e6");
        }
        if (!StringUtils.isEmpty((CharSequence)commonConfig.getRedisUrl())) {
            model.addAttribute("gpuInfo", (Object)RedisDataUtil.getValue((String)(systemInfo.getHostname() + "_GPU")));
            model.addAttribute("gpuInfoDateTime", (Object)RedisDataUtil.getValue((String)(systemInfo.getHostname() + "_GPU" + "_DATETIME")));
            model.addAttribute("fireWallInfo", (Object)RedisDataUtil.getValue((String)(systemInfo.getHostname() + "_FIREWALL")));
            model.addAttribute("fireWallDateTime", (Object)RedisDataUtil.getValue((String)(systemInfo.getHostname() + "_FIREWALL" + "_DATETIME")));
            model.addAttribute("crontabInfo", (Object)RedisDataUtil.getValue((String)(systemInfo.getHostname() + "_CRONTAB")));
            model.addAttribute("crontabDateTime", (Object)RedisDataUtil.getValue((String)(systemInfo.getHostname() + "_CRONTAB" + "_DATETIME")));
            model.addAttribute("likeShellInfo", (Object)RedisDataUtil.getValue((String)(systemInfo.getHostname() + "_LIKE_SHELL")));
            model.addAttribute("likeShellDateTime", (Object)RedisDataUtil.getValue((String)(systemInfo.getHostname() + "_LIKE_SHELL" + "_DATETIME")));
            return;
        }
        model.addAttribute("gpuInfo", StaticKeys.HOST_IMPORT_DATA.get(systemInfo.getHostname() + "_GPU"));
        model.addAttribute("gpuInfoDateTime", StaticKeys.HOST_IMPORT_DATA.get(systemInfo.getHostname() + "_GPU" + "_DATETIME"));
        model.addAttribute("fireWallInfo", StaticKeys.HOST_IMPORT_DATA.get(systemInfo.getHostname() + "_FIREWALL"));
        model.addAttribute("fireWallDateTime", StaticKeys.HOST_IMPORT_DATA.get(systemInfo.getHostname() + "_FIREWALL" + "_DATETIME"));
        model.addAttribute("crontabInfo", StaticKeys.HOST_IMPORT_DATA.get(systemInfo.getHostname() + "_CRONTAB"));
        model.addAttribute("crontabDateTime", StaticKeys.HOST_IMPORT_DATA.get(systemInfo.getHostname() + "_CRONTAB" + "_DATETIME"));
        model.addAttribute("likeShellInfo", StaticKeys.HOST_IMPORT_DATA.get(systemInfo.getHostname() + "_LIKE_SHELL"));
        model.addAttribute("likeShellDateTime", StaticKeys.HOST_IMPORT_DATA.get(systemInfo.getHostname() + "_LIKE_SHELL" + "_DATETIME"));
    }

    public static void viewAllPortInfoHandler(Model model, String id) throws Exception {
        SystemInfo systemInfo = systemInfoService.selectById(id);
        model.addAttribute("systemInfo", (Object)systemInfo);
        HostUtil.setSysFontAwesome((SystemInfo)systemInfo);
        if (!LicenseUtil.checkEnterpriseVersion()) {
            model.addAttribute("tipInfo", (Object)"\u63d0\u793a: \u5347\u7ea7\u5230\u4f01\u4e1a\u7248\u53ef\u4ee5\u67e5\u770b\u4e3b\u673a\u7684\u5168\u91cf\u7aef\u53e3\u5217\u8868\u54e6");
        }
        if (!StringUtils.isEmpty((CharSequence)commonConfig.getRedisUrl())) {
            model.addAttribute("allPortInfo", (Object)RedisDataUtil.getValue((String)(systemInfo.getHostname() + "_ALLPORT")));
            model.addAttribute("allPortDateTime", (Object)RedisDataUtil.getValue((String)(systemInfo.getHostname() + "_ALLPORT" + "_DATETIME")));
            return;
        }
        model.addAttribute("allPortInfo", StaticKeys.HOST_IMPORT_DATA.get(systemInfo.getHostname() + "_ALLPORT"));
        model.addAttribute("allPortDateTime", StaticKeys.HOST_IMPORT_DATA.get(systemInfo.getHostname() + "_ALLPORT" + "_DATETIME"));
    }

    public static void viewAllNetworkHandler(Model model, String hostname) {
        try {
            String jsonString = "";
            if (!StringUtils.isEmpty((CharSequence)commonConfig.getRedisUrl())) {
                jsonString = RedisDataUtil.getValue((String)(hostname + "_ALL_NETWORK"));
            } else if (null != StaticKeys.HOST_IMPORT_DATA.get(hostname + "_ALL_NETWORK")) {
                jsonString = StaticKeys.HOST_IMPORT_DATA.get(hostname + "_ALL_NETWORK").toString();
            }
            if (!StringUtils.isEmpty((CharSequence)jsonString)) {
                JSONArray jsonArray = JSONUtil.parseArray((String)jsonString);
                List allNetworkList = JSONUtil.toList((JSONArray)jsonArray, NetworkInfoDto.class);
                model.addAttribute("allNetworkList", (Object)allNetworkList);
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636eIP\u67e5\u8be2\u670d\u52a1\u5668\u7684\u5168\u90e8\u7f51\u5361\u540d\u79f0\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
    }

    public static void viewIfconfigInfoHandler(Model model, String id) throws Exception {
        SystemInfo systemInfo = systemInfoService.selectById(id);
        model.addAttribute("systemInfo", (Object)systemInfo);
        HostUtil.setSysFontAwesome((SystemInfo)systemInfo);
        if (!StringUtils.isEmpty((CharSequence)commonConfig.getRedisUrl())) {
            model.addAttribute("ifconfigInfo", (Object)RedisDataUtil.getValue((String)(systemInfo.getHostname() + "_IFCONFIG")));
            model.addAttribute("ifconfigInfoDateTime", (Object)RedisDataUtil.getValue((String)(systemInfo.getHostname() + "_IFCONFIG" + "_DATETIME")));
            return;
        }
        model.addAttribute("ifconfigInfo", StaticKeys.HOST_IMPORT_DATA.get(systemInfo.getHostname() + "_IFCONFIG"));
        model.addAttribute("ifconfigInfoDateTime", StaticKeys.HOST_IMPORT_DATA.get(systemInfo.getHostname() + "_IFCONFIG" + "_DATETIME"));
    }

    public static void viewLastUserInfoHandler(Model model, String id) {
        try {
            SystemInfo systemInfo = systemInfoService.selectById(id);
            if (!StringUtils.isEmpty((CharSequence)commonConfig.getRedisUrl())) {
                model.addAttribute("hostUsersList", (Object)RedisDataUtil.getValue((String)(systemInfo.getHostname() + "_LASTUSER")));
                model.addAttribute("hostUsersListDateTime", (Object)RedisDataUtil.getValue((String)(systemInfo.getHostname() + "_LASTUSER" + "_DATETIME")));
                return;
            }
            model.addAttribute("hostUsersList", StaticKeys.HOST_IMPORT_DATA.get(systemInfo.getHostname() + "_LASTUSER"));
            model.addAttribute("hostUsersListDateTime", StaticKeys.HOST_IMPORT_DATA.get(systemInfo.getHostname() + "_LASTUSER" + "_DATETIME"));
        }
        catch (Exception e) {
            logger.error("\u6839\u636eIP\u67e5\u8be2\u670d\u52a1\u5668\u7528\u6237\u7684\u6700\u8fd1\u767b\u5f55\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
    }
}

