/*
Navicat Oracle Data Transfer
Oracle Client Version : 10.2.0.5.0

Source Server         : 192.168.1.22
Source Server Version : 110200
Source Host           : 192.168.1.22:1521
Source Schema         : WGCLOUD

Target Server Type    : ORACLE
Target Server Version : 110200
File Encoding         : 65001

Date: 2022-07-12 10:21:10
*/


-- ----------------------------
-- Table structure for ACCOUNT_INFO
-- ----------------------------
CREATE TABLE "ACCOUNT_INFO" (
"ID" VARCHAR2(32) NOT NULL ,
"ACCOUNT" VARCHAR2(50) NULL ,
"EMAIL" VARCHAR2(200) NULL ,
"PASSWD" VARCHAR2(50) NULL ,
"ACCOUNT_KEY" VARCHAR2(50) NULL ,
"REMARK" VARCHAR2(50) NULL ,
"MENU_IDS" VARCHAR2(200) NULL ,
"ACCOUNT_ROLE" VARCHAR2(10) NULL ,
"ACCOUNT_PHONE" VARCHAR2(50) NULL ,
"CREATE_TIME" DATE NULL 
);

-- ----------------------------
-- Table structure for APP_INFO
-- ----------------------------
CREATE TABLE "APP_INFO" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"APP_PID" VARCHAR2(200) NULL ,
"CREATE_TIME" DATE NULL ,
"APP_NAME" VARCHAR2(50) NULL ,
"CPU_PER" NUMBER NULL ,
"MEM_PER" NUMBER NULL ,
"APP_TYPE" VARCHAR2(1) NULL ,
"STATE" VARCHAR2(1) NULL ,
"ACTIVE" VARCHAR2(1) NULL ,
"READ_BYTES" VARCHAR2(20) NULL ,
"WRITES_BYTES" VARCHAR2(20) NULL ,
"THREADS_NUM" VARCHAR2(20) NULL ,
"GATHER_PID" VARCHAR2(20) NULL ,
"APP_TIMES" VARCHAR2(50) NULL ,
"PRO_USERNAME" VARCHAR2(100) NULL ,
"CUSTOM_SHELL" VARCHAR2(500) NULL ,
"WARN_LEVEL" VARCHAR2(10) NULL ,
"NET_CONNECTIONS" VARCHAR2(8) NULL ,
"APP_CMD_LINE" VARCHAR2(200) NULL ,
"GROUP_ID" VARCHAR2(500) NULL 
);

-- ----------------------------
-- Table structure for APP_STATE
-- ----------------------------
CREATE TABLE "APP_STATE" (
"ID" VARCHAR2(32) NOT NULL ,
"APP_INFO_ID" VARCHAR2(32) NULL ,
"CPU_PER" NUMBER NULL ,
"MEM_PER" NUMBER NULL ,
"CREATE_TIME" DATE NULL ,
"NET_CONNECTIONS" VARCHAR2(8) NULL ,
"THREADS_NUM" VARCHAR2(10) NULL 
);

-- ----------------------------
-- Table structure for CPU_STATE
-- ----------------------------
CREATE TABLE "CPU_STATE" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"SYS" NUMBER NULL ,
"PROCS_NUM" NUMBER NULL ,
"CREATE_TIME" DATE NULL 
);

-- ----------------------------
-- Table structure for CPU_TEMPERATURES
-- ----------------------------
CREATE TABLE "CPU_TEMPERATURES" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"CORE_INDEX" VARCHAR2(50) NULL ,
"CRIT" VARCHAR2(10) NULL ,
"INPUT" VARCHAR2(10) NULL ,
"MAX" VARCHAR2(10) NULL ,
"CREATE_TIME" DATE NULL 
);

-- ----------------------------
-- Table structure for DB_INFO
-- ----------------------------
CREATE TABLE "DB_INFO" (
"ID" VARCHAR2(32) NOT NULL ,
"DBTYPE" VARCHAR2(32) NULL ,
"USER_NAME" VARCHAR2(50) NULL ,
"PASSWD" VARCHAR2(100) NULL ,
"DBURL" VARCHAR2(500) NULL ,
"CREATE_TIME" DATE NULL ,
"DB_STATE" VARCHAR2(1) NULL ,
"ALIAS_NAME" VARCHAR2(50) NULL ,
"WARN_LEVEL" VARCHAR2(10) NULL ,
"ACTIVE" VARCHAR2(1) NULL ,
"DRIVER_NAME" VARCHAR2(100) NULL ,
"TEST_QUERY_SQL" VARCHAR2(100) NULL ,
"GROUP_ID" VARCHAR2(500) NULL ,
"RES_TIMES" NUMBER(11) NULL,
"ACCOUNT" VARCHAR2(50) NULL 
);

-- ----------------------------
-- Table structure for DB_TABLE
-- ----------------------------
CREATE TABLE "DB_TABLE" (
"ID" VARCHAR2(32) NOT NULL ,
"TABLE_NAME" VARCHAR2(100) NULL ,
"WHERE_VAL" VARCHAR2(2000) NULL ,
"CREATE_TIME" DATE NULL ,
"REMARK" VARCHAR2(50) NULL ,
"TABLE_COUNT" VARCHAR2(100) NULL ,
"DBINFO_ID" VARCHAR2(32) NULL ,
"ACTIVE" VARCHAR2(1) NULL ,
"STATE" VARCHAR2(1) NULL ,
"WARN_LEVEL" VARCHAR2(10) NULL ,
"REMARK_EXT" VARCHAR2(100)  NULL,
"RES_TIMES" NUMBER(11) NULL,
"RESULT_EXP" VARCHAR2(100) NULL 
);

-- ----------------------------
-- Table structure for DB_TABLE_COUNT
-- ----------------------------
CREATE TABLE "DB_TABLE_COUNT" (
"ID" VARCHAR2(32) NOT NULL ,
"DB_TABLE_ID" VARCHAR2(32) NULL ,
"TABLE_COUNT" VARCHAR2(100) NULL ,
"CREATE_TIME" DATE NULL 
);

-- ----------------------------
-- Table structure for DCE_INFO
-- ----------------------------
CREATE TABLE "DCE_INFO" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"CREATE_TIME" DATE NULL ,
"ACTIVE" VARCHAR2(1) NULL ,
"RES_TIMES" NUMBER(11) NULL ,
"REMARK" VARCHAR2(50) NULL ,
"GROUP_ID" VARCHAR2(500) NULL ,
"WARN_LEVEL" VARCHAR2(10) NULL ,
"ORDER_NUM" NUMBER(11) NULL ,
"ACCOUNT" VARCHAR2(50) NULL 
);

-- ----------------------------
-- Table structure for DCE_STATE
-- ----------------------------
CREATE TABLE "DCE_STATE" (
"ID" VARCHAR2(32) NOT NULL ,
"DCE_ID" VARCHAR2(32) NULL ,
"RES_TIMES" NUMBER(11) NULL ,
"CREATE_TIME" DATE NULL 
);

-- ----------------------------
-- Table structure for DESK_IO
-- ----------------------------
CREATE TABLE "DESK_IO" (
"ID" VARCHAR2(32) NOT NULL ,
"FILE_STSTEM" VARCHAR2(200) NULL ,
"READ_COUNT" VARCHAR2(20) NULL ,
"WRITE_OUNT" VARCHAR2(20) NULL ,
"READ_BYTES" VARCHAR2(20) NULL ,
"WRITE_BYTES" VARCHAR2(20) NULL ,
"READ_TIME" VARCHAR2(20) NULL ,
"WRITE_TIME" VARCHAR2(20) NULL ,
"CREATE_TIME" DATE NULL ,
"HOST_NAME" VARCHAR2(50) NULL 
);

-- ----------------------------
-- Table structure for DISK_SMART
-- ----------------------------
CREATE TABLE "DISK_SMART" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"FILE_STSTEM" VARCHAR2(255) NULL ,
"DISK_STATE" VARCHAR2(50) NULL ,
"POWER_HOURS" VARCHAR2(50) NULL ,
"POWER_COUNT" VARCHAR2(50) NULL ,
"TEMPERATURE" VARCHAR2(50) NULL ,
"CREATE_TIME" DATE NULL 
);

-- ----------------------------
-- Table structure for DISK_STATE
-- ----------------------------
CREATE TABLE "DISK_STATE" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"FILE_STSTEM" VARCHAR2(200) NULL ,
"DISK_SIZE" VARCHAR2(30) NULL ,
"USED" VARCHAR2(30) NULL ,
"AVAIL" VARCHAR2(30) NULL ,
"USE_PER" VARCHAR2(10) NULL ,
"DATE_STR" VARCHAR2(30) NULL ,
"CREATE_TIME" DATE NULL 
);

-- ----------------------------
-- Table structure for DOCKER_INFO
-- ----------------------------
CREATE TABLE "DOCKER_INFO" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"DOCKER_ID" VARCHAR2(200) NULL ,
"DOCKER_NAME" VARCHAR2(100) NULL ,
"DOCKER_STATE" VARCHAR2(50) NULL ,
"MEM_PER" NUMBER NULL ,
"STATE" VARCHAR2(1) NULL ,
"CREATE_TIME" DATE NULL ,
"USER_TIME" VARCHAR2(20) NULL ,
"ACTIVE" VARCHAR2(1) NULL ,
"APP_TYPE" VARCHAR2(1) NULL ,
"DOCKER_IMAGE" VARCHAR2(200) NULL ,
"DOCKER_PORT" VARCHAR2(200) NULL ,
"DOCKER_COMMAND" VARCHAR2(500) NULL ,
"DOCKER_CREATED" VARCHAR2(50) NULL ,
"DOCKER_SIZE" VARCHAR2(20) NULL ,
"DOCKER_STATUS" VARCHAR2(100) NULL ,
"GATHER_DOCKER_NAMES" VARCHAR2(150) NULL ,
"WARN_LEVEL" VARCHAR2(10) NULL ,
"GROUP_ID" VARCHAR2(500) NULL 
);

-- ----------------------------
-- Table structure for DOCKER_STATE
-- ----------------------------
CREATE TABLE "DOCKER_STATE" (
"ID" VARCHAR2(32) NOT NULL ,
"DOCKER_INFO_ID" VARCHAR2(32) NULL ,
"CPU_PER" NUMBER NULL ,
"MEM_PER" NUMBER NULL ,
"CREATE_TIME" DATE NULL 
);

-- ----------------------------
-- Table structure for EQUIPMENT
-- ----------------------------
CREATE TABLE "EQUIPMENT" (
"ID" VARCHAR2(32) NOT NULL ,
"EQ_NAME" VARCHAR2(50) NULL ,
"XINGHAO" VARCHAR2(50) NULL ,
"PERSON" VARCHAR2(50) NULL ,
"DEPT" VARCHAR2(50) NULL ,
"CODE" VARCHAR2(50) NULL ,
"PRICE" NUMBER NULL ,
"GONGYINGSHANG" VARCHAR2(50) NULL ,
"CAIGOU_DATE" VARCHAR2(50) NULL ,
"WEIBAO_DATE" VARCHAR2(50) NULL ,
"REMARK" VARCHAR2(255) NULL ,
"CREATE_TIME" DATE NULL ,
"GROUP_ID" VARCHAR2(500) NULL ,
"FILE_NAME" VARCHAR2(50) NULL ,
"FILE_PATH" VARCHAR2(150) NULL ,
"FILE_SIZE" VARCHAR2(20) NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"ACCOUNT" VARCHAR2(50) NULL 
);

-- ----------------------------
-- Table structure for FILE_SAFE
-- ----------------------------
CREATE TABLE "FILE_SAFE" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"FILE_NAME" VARCHAR2(50) NULL ,
"STATE" VARCHAR2(1) NULL ,
"FILE_PATH" VARCHAR2(255) NULL ,
"ACTIVE" VARCHAR2(1) NULL ,
"FILE_SIGN" VARCHAR2(50) NULL ,
"FILE_MODTIME" VARCHAR2(50) NULL ,
"WARN_LEVEL" VARCHAR2(10) NULL ,
"FILE_IS_DIR" VARCHAR2(10) NULL ,
"CUSTOM_SHELL" VARCHAR2(500) NULL ,
"GROUP_ID" VARCHAR2(500) NULL ,
"CREATE_TIME" DATE NULL 
);

-- ----------------------------
-- Table structure for FILE_WARN
-- ----------------------------
CREATE TABLE "FILE_WARN" (
"ID" VARCHAR2(32) NOT NULL ,
"FILE_PATH" VARCHAR2(255) NULL ,
"FILE_SIZE" VARCHAR2(32) NULL ,
"WARN_CHARS" VARCHAR2(500) NULL ,
"CREATE_TIME" DATE NULL ,
"WARN_ROWS" VARCHAR2(20) NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"REMARK" VARCHAR2(255) NULL ,
"ACTIVE" VARCHAR2(1) NULL ,
"FILE_TYPE" VARCHAR2(1) NULL ,
"WARN_LEVEL" VARCHAR2(10) NULL ,
"CUSTOM_SHELL" VARCHAR2(500) NULL ,
"FILE_NAME_PREFIX" VARCHAR2(50) NULL 
);

-- ----------------------------
-- Table structure for FILE_WARN_STATE
-- ----------------------------
CREATE TABLE "FILE_WARN_STATE" (
"ID" VARCHAR2(32) NOT NULL ,
"WAR_CONTENT" NCLOB NULL ,
"CREATE_TIME" DATE NULL ,
"FILE_WARN_ID" VARCHAR2(32) NULL ,
"ROWS_GATHER_COUNT" VARCHAR2(10) NULL ,
"ROWS_COUNT" VARCHAR2(10) NULL ,
"FILE_PATH" VARCHAR2(255) NULL 
);

-- ----------------------------
-- Table structure for HEATH_MONITOR
-- ----------------------------
CREATE TABLE "HEATH_MONITOR" (
"ID" VARCHAR2(32) NOT NULL ,
"APP_NAME" VARCHAR2(50) NULL ,
"HEATH_URL" VARCHAR2(255) NULL ,
"CREATE_TIME" DATE NULL ,
"HEATH_STATUS" VARCHAR2(10) NULL ,
"RES_TIMES" NUMBER(11) NULL ,
"ACTIVE" VARCHAR2(1) NULL ,
"RES_KEYWORD" VARCHAR2(255) NULL ,
"METHOD" VARCHAR2(5) NULL ,
"POST_STR" VARCHAR2(2000) NULL ,
"RES_NO_KEYWORD" VARCHAR2(255) NULL ,
"HEADER_JSON" VARCHAR2(1500) NULL ,
"RESPONSE_BODY_SIZE" VARCHAR2(20) NULL ,
"FORM_JSON" VARCHAR2(1500) NULL ,
"ERROR_MSG" VARCHAR2(200) NULL ,
"WARN_LEVEL" VARCHAR2(10) NULL ,
"GROUP_ID" VARCHAR2(500) NULL ,
"ACCOUNT" VARCHAR2(50) NULL 
);

-- ----------------------------
-- Table structure for HEATH_STATE
-- ----------------------------
CREATE TABLE "HEATH_STATE" (
"ID" VARCHAR2(32) NOT NULL ,
"HEATH_ID" VARCHAR2(32) NULL ,
"CREATE_TIME" DATE NULL ,
"RES_TIMES" NUMBER(11) NULL 
);

-- ----------------------------
-- Table structure for HOST_DISK_PER
-- ----------------------------
CREATE TABLE "HOST_DISK_PER" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"DISK_SUM_PER" NUMBER NULL ,
"CREATE_TIME" DATE NULL 
);

-- ----------------------------
-- Table structure for HOST_GROUP
-- ----------------------------
CREATE TABLE "HOST_GROUP" (
"ID" VARCHAR2(32) NOT NULL ,
"GROUP_NAME" VARCHAR2(100) NULL ,
"CREATE_TIME" DATE NULL ,
"REMARK" VARCHAR2(255) NULL ,
"ACCOUNT" VARCHAR2(50) NULL ,
"GROUP_TYPE" VARCHAR2(5) NULL 
);

-- ----------------------------
-- Table structure for INTRUSION_INFO
-- ----------------------------
CREATE TABLE "INTRUSION_INFO" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(30) NULL ,
"LSMOD" NCLOB NULL ,
"PASSWD_INFO" VARCHAR2(100) NULL ,
"CRONTAB" NCLOB NULL ,
"PROMISC" VARCHAR2(100) NULL ,
"RPCINFO" NCLOB NULL ,
"CREATE_TIME" DATE NULL 
);

-- ----------------------------
-- Table structure for LOG_INFO
-- ----------------------------
CREATE TABLE "LOG_INFO" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(200) NULL ,
"INFO_CONTENT" NCLOB NULL ,
"STATE" VARCHAR2(1) NULL ,
"CREATE_TIME" DATE NOT NULL 
);

-- ----------------------------
-- Table structure for MAIL_SET
-- ----------------------------
CREATE TABLE "MAIL_SET" (
"ID" VARCHAR2(32) NOT NULL ,
"SEND_MAIL" VARCHAR2(60) NULL ,
"FROM_MAIL_NAME" VARCHAR2(60) NULL ,
"FROM_PWD" VARCHAR2(100) NULL ,
"SMTP_HOST" VARCHAR2(100) NULL ,
"SMTP_PORT" VARCHAR2(30) NULL ,
"SMTP_SSL" VARCHAR2(30) NULL ,
"TO_MAIL" VARCHAR2(300) NULL ,
"CPU_PER" VARCHAR2(30) NULL ,
"CREATE_TIME" DATE NULL ,
"ACTIVE" VARCHAR2(30) NULL ,
"JAVAX_MAIL" VARCHAR2(30) NULL 
);

-- ----------------------------
-- Table structure for MEM_STATE
-- ----------------------------
CREATE TABLE "MEM_STATE" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"USE_PER" NUMBER NULL ,
"CREATE_TIME" DATE NULL 
);

-- ----------------------------
-- Table structure for NETIO_STATE
-- ----------------------------
CREATE TABLE "NETIO_STATE" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"RXPCK" VARCHAR2(15) NULL ,
"TXPCK" VARCHAR2(15) NULL ,
"RXBYT" VARCHAR2(15) NULL ,
"TXBYT" VARCHAR2(15) NULL ,
"CREATE_TIME" DATE NULL ,
"DROPIN" VARCHAR2(15) NULL ,
"DROPOUT" VARCHAR2(15) NULL ,
"NET_CONNECTIONS" VARCHAR2(10) NULL 
);

-- ----------------------------
-- Table structure for PORT_INFO
-- ----------------------------
CREATE TABLE "PORT_INFO" (
"ID" VARCHAR2(32) NOT NULL ,
"PORT" VARCHAR2(30) NULL ,
"PORT_NAME" VARCHAR2(30) NULL ,
"STATE" VARCHAR2(1) NULL ,
"CREATE_TIME" DATE NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"ACTIVE" VARCHAR2(1) NULL ,
"TELNET_IP" VARCHAR2(300) NULL ,
"WARN_LEVEL" VARCHAR2(10) NULL ,
"PORT_TYPE" VARCHAR2(5) NULL ,
"GROUP_ID" VARCHAR2(500) NULL 
);

-- ----------------------------
-- Table structure for SHELL_INFO
-- ----------------------------
CREATE TABLE "SHELL_INFO" (
"ID" VARCHAR2(32) NOT NULL ,
"SHELL" VARCHAR2(2000) NULL ,
"CREATE_TIME" DATE NULL ,
"STATE" VARCHAR2(1) NULL ,
"SHELL_NAME" VARCHAR2(100) NULL ,
"SHELL_TYPE" VARCHAR2(5) NULL ,
"SHELL_TIME" VARCHAR2(20) NULL ,
"SHELL_DAY" VARCHAR2(5) NULL ,
"ACCOUNT" VARCHAR2(50) NULL 
);

-- ----------------------------
-- Table structure for SHELL_STATE
-- ----------------------------
CREATE TABLE "SHELL_STATE" (
"ID" VARCHAR2(32) NOT NULL ,
"SHELL_ID" VARCHAR2(32) NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"CREATE_TIME" DATE NULL ,
"STATE" VARCHAR2(50) NULL ,
"SHELL" VARCHAR2(2000) NULL ,
"SHELL_RESULT" VARCHAR2(4000) NULL ,
"SHELL_TIME" VARCHAR2(20) NULL 
);

-- ----------------------------
-- Table structure for SNMP_INFO
-- ----------------------------
CREATE TABLE "SNMP_INFO" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"BYTES_RECV" VARCHAR2(30) NULL ,
"BYTES_SENT" VARCHAR2(30) NULL ,
"RECV_AVG" VARCHAR2(2000) NULL ,
"SENT_AVG" VARCHAR2(2000) NULL ,
"STATE" VARCHAR2(1) NULL ,
"ACTIVE" VARCHAR2(1) NULL ,
"CREATE_TIME" DATE NULL ,
"SNMP_UNIT" VARCHAR2(20) NULL ,
"REMARK" VARCHAR2(50) NULL ,
"RECV_OID" NCLOB NULL ,
"SENT_OID" NCLOB NULL ,
"SNMP_COMMUNITY" VARCHAR2(50) NULL ,
"SNMP_PORT" VARCHAR2(10) NULL ,
"SNMP_VERSION" VARCHAR2(10) NULL ,
"CPU_PER_OID" VARCHAR2(300) NULL ,
"MEM_SIZE_OID" VARCHAR2(300) NULL ,
"TEMPERATURE_OID" VARCHAR2(100) NULL ,
"CPU_PER" VARCHAR2(10) NULL ,
"MEM_PER" VARCHAR2(10) NULL ,
"DISK_PER_OID" VARCHAR2(300) NULL ,
"DISK_PER" VARCHAR2(10) NULL ,
"SYS_DESC_VAL" VARCHAR2(200) NULL ,
"SYS_DESC_OID" VARCHAR2(100) NULL ,
"WARN_LEVEL" VARCHAR2(10) NULL ,
"GROUP_ID" VARCHAR2(500) NULL ,
"TEMPERATURE_VALUE" VARCHAR2(10) NULL ,
"VOLTAGE_OID" VARCHAR2(100) NULL ,
"VOLTAGE_VALUE" VARCHAR2(30) NULL ,
"VOLTAGE_UNIT" VARCHAR2(10) NULL ,
"IFOPERSTATUS_OID" VARCHAR2(100) NULL ,
"IFOPERSTATUS_VALUE" VARCHAR2(1500) NULL ,
"ACCOUNT" VARCHAR2(50) NULL 
);

-- ----------------------------
-- Table structure for SNMP_STATE
-- ----------------------------
CREATE TABLE "SNMP_STATE" (
"ID" VARCHAR2(32) NOT NULL ,
"SNMP_INFO_ID" VARCHAR2(32) NULL ,
"RECV_AVG" VARCHAR2(20) NULL ,
"SENT_AVG" VARCHAR2(20) NULL ,
"CPU_PER" VARCHAR2(10) NULL ,
"MEM_PER" VARCHAR2(10) NULL ,
"VOLTAGE_VALUE" VARCHAR2(10) NULL ,
"TEMPERATURE_VALUE" VARCHAR2(10) NULL ,
"CREATE_TIME" DATE NULL 
);

-- ----------------------------
-- Table structure for SYS_LOAD_STATE
-- ----------------------------
CREATE TABLE "SYS_LOAD_STATE" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"ONE_LOAD" NUMBER NULL ,
"FIVE_LOAD" NUMBER NULL ,
"FIFTEEN_LOAD" NUMBER NULL ,
"USERS" VARCHAR2(10) NULL ,
"CREATE_TIME" DATE NULL 
);

-- ----------------------------
-- Table structure for SYSTEM_INFO
-- ----------------------------
CREATE TABLE "SYSTEM_INFO" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"CPU_PER" NUMBER NULL ,
"MEM_PER" NUMBER NULL ,
"CPU_CORE_NUM" VARCHAR2(10) NULL ,
"CREATE_TIME" DATE NULL ,
"STATE" VARCHAR2(1) NULL ,
"PROCS" VARCHAR2(11) NULL ,
"GROUP_ID" VARCHAR2(500) NULL ,
"REMARK" VARCHAR2(100) NULL ,
"TOTAL_MEM" VARCHAR2(50) NULL ,
"RXBYT" VARCHAR2(15) NULL ,
"TXBYT" VARCHAR2(15) NULL ,
"WIN_CONSOLE" VARCHAR2(255) NULL ,
"HOST_NAME_EXT" VARCHAR2(100) NULL ,
"FIVE_LOAD" NUMBER NULL ,
"FIFTEEN_LOAD" NUMBER NULL ,
"NET_CONNECTIONS" VARCHAR2(10) NULL ,
"ACTIVE" VARCHAR2(1) NULL ,
"COUNT_BLOCK" VARCHAR2(1) NULL ,
"ORDER_NUM" NUMBER(11) NULL ,
"DISK_PER" NUMBER NULL ,
"DISK_SUM_SIZE" VARCHAR2(20) NULL ,
"ACCOUNT" VARCHAR2(50) NULL 
);

-- ----------------------------
-- Table structure for TCP_STATE
-- ----------------------------
CREATE TABLE "TCP_STATE" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(30) NULL ,
"ACTIVE" VARCHAR2(30) NULL ,
"PASSIVE" VARCHAR2(30) NULL ,
"RETRANS" VARCHAR2(30) NULL ,
"DATE_STR" VARCHAR2(30) NULL ,
"CREATE_TIME" DATE NULL 
);

-- ----------------------------
-- Table structure for custom_info
-- ----------------------------
CREATE TABLE "CUSTOM_INFO" (
  "ID" VARCHAR2(32) NOT NULL,
  "CUSTOM_NAME" VARCHAR2(200) DEFAULT NULL,
  "CUSTOM_SHELL" VARCHAR2(2000) DEFAULT NULL,
  "CREATE_TIME" DATE NULL,
  "HOST_NAME" VARCHAR2(50) DEFAULT NULL,
  "ACTIVE" VARCHAR2(1) DEFAULT NULL,
  "STATE" VARCHAR2(1) DEFAULT NULL,
  "RESULT_EXP" VARCHAR2(100) DEFAULT NULL,
  "GROUP_ID" VARCHAR2(500) DEFAULT NULL,
  "WARN_LEVEL" VARCHAR2(10) NULL ,
  "CUSTOM_VALUE" VARCHAR2(50) DEFAULT NULL
);

-- ----------------------------
-- Table structure for custom_state
-- ----------------------------
CREATE TABLE "CUSTOM_STATE" (
  "ID" VARCHAR2(32) NOT NULL,
  "CUSTOM_INFO_ID" VARCHAR2(32) DEFAULT NULL,
  "CREATE_TIME" DATE NULL,
  "CUSTOM_VALUE" VARCHAR2(50) DEFAULT NULL
);

-- ----------------------------
-- Table structure for FTP_INFO
-- ----------------------------
CREATE TABLE "FTP_INFO" (
  "ID" VARCHAR2(32) NOT NULL,
  "FTP_HOST" VARCHAR2(100) DEFAULT NULL,
  "USER_NAME" VARCHAR2(50) DEFAULT NULL,
  "PASSWD" VARCHAR2(100) DEFAULT NULL,
  "PORT" VARCHAR2(50) DEFAULT NULL,
  "ACTIVE" char(1) DEFAULT NULL,
  "WARN_TYPE" VARCHAR2(10) DEFAULT NULL,
  "STATE" char(1) DEFAULT NULL,
  "FTP_TYPE" VARCHAR2(10) DEFAULT NULL,
  "CREATE_TIME" DATE NULL,
  "ACCOUNT" VARCHAR2(50) DEFAULT NULL,
  "FTP_NAME" VARCHAR2(50) DEFAULT NULL,
  "WARN_LEVEL" VARCHAR2(10) NULL ,
  "GROUP_ID" VARCHAR2(500) NULL ,
  "RES_TIMES" NUMBER(20) NULL
);

CREATE TABLE "REPORT_INFO" (
  "ID" VARCHAR2(32) NOT NULL,
  "TIME_PART" VARCHAR2(100) NULL,
  "REPORT_TYPE" VARCHAR2(1) NULL,
  "GROUP_NAME" VARCHAR2(50) NULL,
  "CREATE_TIME" DATE NULL
);


CREATE TABLE "REPORT_INSTANCE" (
  "ID" VARCHAR2(32) NOT NULL,
  "INFO_KEY" VARCHAR2(100) NULL,
  "INFO_CONTENT" VARCHAR2(200) NULL,
  "REPORT_INFO_ID" VARCHAR2(32)NULL,
  "CREATE_TIME" DATE NULL
);

CREATE TABLE "HOST_USERS" (
  "ID" VARCHAR2(32) NOT NULL,
  "HOST_NAME" VARCHAR2(50) NULL,
  "HOST_USER" VARCHAR2(50) NULL,
  "LAST_LOGIN_IP" VARCHAR2(50) NULL,
  "LAST_LOGIN_TIME" VARCHAR2(50)NULL,
  "TERMINAL" VARCHAR2(50)NULL,
  "CREATE_TIME" DATE NULL
);
ALTER TABLE "HOST_USERS" ADD PRIMARY KEY ("ID");

CREATE TABLE "PASSWD_INFO" (
  "ID" VARCHAR2(32) NOT NULL,
  "HOST_NAME" VARCHAR2(100) NULL,
  "HOST_ACCOUNT" VARCHAR2(50) NULL,
  "HOST_PASSWD" VARCHAR2(100) NULL,
  "HOST_REMARK" VARCHAR2(300) NULL,
  "ACCOUNT" VARCHAR2(50) NULL,
  "GROUP_ID" VARCHAR2(500)NULL,
  "HOST_MARK" VARCHAR2(100)NULL,
  "CREATE_TIME" DATE NULL
);
ALTER TABLE "PASSWD_INFO" ADD PRIMARY KEY ("ID");

CREATE TABLE "HOST_WARN_DIY"  (
  "ID" VARCHAR2(32)  NOT NULL,
  "HOST_NAME" VARCHAR2(50)   NULL,
  "MEM_WARN_VAL" NUMBER   NULL,
  "CPU_WARN_VAL" NUMBER   NULL,
  "UPSPEED_VAL" NUMBER   NULL,
  "UPSPEED_MIN_VAL" NUMBER   NULL,
  "DOWNSPEED_VAL" NUMBER   NULL,
  "DOWNSPEED_MIN_VAL" NUMBER   NULL,
  "CPUTEMPERATURE_WARN_VAL" NUMBER   NULL,
  "MEM_WARN_MAIL" VARCHAR2(10)   NULL,
  "UPSPEED_MAIL" VARCHAR2(10)   NULL,
  "DOWNSPEED_MAIL" VARCHAR2(10)   NULL,
  "CPU_WARN_MAIL" VARCHAR2(10)   NULL,
  "CPUTEMPERATURE_WARN_MAIL" VARCHAR2(10)   NULL,
  "DISK_WARN_MAIL" VARCHAR2(10)   NULL,
  "SMART_WARN_MAIL" VARCHAR2(10)   NULL,
  "DISK_BLOCK" VARCHAR2(200)   NULL,
  "DISK_WARN_VAL" NUMBER   NULL,
  "SYSLOAD_WARN_MAIL" VARCHAR2(10)   NULL,
  "SYSLOAD_WARN_VAL" NUMBER   NULL,
  "HOST_DOWN_WARN_MAIL" VARCHAR2(10)   NULL,
  "HOST_LOGIN_WARN_MAIL" VARCHAR2(10)   NULL,
  "CREATE_TIME" DATE NULL,
  "ACCOUNT" VARCHAR2(50)  NULL,
  "ACTIVE" VARCHAR2(1)   NULL,
  "HOST_BLOCK_ALL_WARN" VARCHAR2(10)  NULL,
  "SPEED_WARN_LEVEL" VARCHAR2(10)  NULL,
  "MEM_WARN_LEVEL" VARCHAR2(10)  NULL,
  "SYSLOAD_WARN_LEVEL" VARCHAR2(10)  NULL,
  "CPU_WARN_LEVEL" VARCHAR2(10)  NULL,
  "CPUTEMPERATURE_WARN_LEVEL" VARCHAR2(10)  NULL,
  "DISK_WARN_LEVEL" VARCHAR2(10)  NULL,
  "SMART_WARN_LEVEL" VARCHAR2(10)  NULL,
  "HOST_DOWN_WARN_LEVEL" VARCHAR2(10)  NULL,
  "HOST_LOGIN_WARN_LEVEL" VARCHAR2(10)  NULL,
  "NETCONNECTIONS_WARN_MAIL" VARCHAR2(10)  NULL,
  "NETCONNECTIONS_WARN_VAL" NUMBER  NULL,
  "NETCONNECTIONS_WARN_LEVEL" VARCHAR2(10)  NULL,
  "DISK_BLOCK_SAVE" VARCHAR2(200)  NULL,
  "HOST_DOWN_WARN_COUNT" VARCHAR2(2)  NULL,
  "CUSTOM_WARN_MAIL" VARCHAR2(100)  NULL,
  "CUSTOM_WARN_ACCOUNT_KEY" VARCHAR2(100)  NULL,
  "DISKIO_SPEED_WARN_MAIL" VARCHAR2(10)  NULL,
  "DISKIO_SPEED_WARN_VAL" NUMBER  NULL,
  "REMARK" VARCHAR2(255)   NULL
);
ALTER TABLE "HOST_WARN_DIY" ADD PRIMARY KEY ("ID");

CREATE TABLE "APP_EXCEPTION_INFO" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"APP_PID" VARCHAR2(200) NULL ,
"CREATE_TIME" DATE NULL ,
"APP_NAME" VARCHAR2(100) NULL ,
"CPU_PER" NUMBER NULL ,
"MEM_PER" NUMBER NULL ,
"APP_TYPE" VARCHAR2(1) NULL ,
"STATE" VARCHAR2(1) NULL ,
"ACTIVE" VARCHAR2(1) NULL ,
"READ_BYTES" VARCHAR2(20) NULL ,
"WRITES_BYTES" VARCHAR2(20) NULL ,
"THREADS_NUM" VARCHAR2(20) NULL ,
"GATHER_PID" VARCHAR2(20) NULL ,
"APP_TIMES" VARCHAR2(50) NULL ,
"PRO_USERNAME" VARCHAR2(100) NULL ,
"CUSTOM_SHELL" VARCHAR2(500) NULL ,
"WARN_LEVEL" VARCHAR2(10) NULL ,
"NET_CONNECTIONS" VARCHAR2(8) NULL ,
"APP_CMD_LINE" VARCHAR2(200) NULL ,
"GROUP_ID" VARCHAR2(500) NULL 
);
ALTER TABLE "APP_EXCEPTION_INFO" ADD PRIMARY KEY ("ID");

CREATE TABLE "K8S_MONITOR" (
"ID" VARCHAR2(32) NOT NULL ,
"DATA_TYPE" VARCHAR2(20) NULL ,
"K8S_NAME" VARCHAR2(50) NULL ,
"CREATE_TIME" DATE NULL ,
"DATA_JSON" VARCHAR2(500) NULL
);
ALTER TABLE "K8S_MONITOR" ADD PRIMARY KEY ("ID");

CREATE TABLE "SYSTEM_INFO_EXT" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"PLATFORM" VARCHAR2(200) NULL ,
"CPU_XH" VARCHAR2(200) NULL ,
"BOOT_TIME" NUMBER(20) NULL ,
"PLATFORM_VERSION" VARCHAR2(100) NULL ,
"UPTIME" NUMBER(20) NULL ,
"SUBMIT_SECONDS" VARCHAR2(10) NULL ,
"AGENT_VER" VARCHAR2(50) NULL ,
"BYTES_RECV" VARCHAR2(20) NULL ,
"BYTES_SENT" VARCHAR2(20) NULL ,
"HOST_NAME_EXT" VARCHAR2(100) NULL ,
"SWAP_MEM_PER" VARCHAR2(20) NULL ,
"TOTAL_SWAP_MEM" VARCHAR2(50) NULL ,
"CPU_PHYSICALID" VARCHAR2(50) NULL ,
"CPU_FAMILY" VARCHAR2(50) NULL ,
"KERNEL_ARCH" VARCHAR2(50) NULL ,
"NET_INTERFACE_NAME" VARCHAR2(150) NULL ,
"CREATE_TIME" DATE NULL ,
"CPU_MHZ" VARCHAR2(50) NULL
);
ALTER TABLE "SYSTEM_INFO_EXT" ADD PRIMARY KEY ("ID");

CREATE TABLE "SHELL_NOTE_INFO" (
"ID" VARCHAR2(32) NOT NULL ,
"SHELL_TITLE" VARCHAR2(100) NULL ,
"SHELL_CONTENT" NCLOB NULL ,
"ACCOUNT" VARCHAR2(50) NULL ,
"CREATE_TIME" DATE NULL 
);
ALTER TABLE "SHELL_NOTE_INFO" ADD PRIMARY KEY ("ID");

CREATE TABLE "HOST_MAC_INFO" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"MAC_NAME" VARCHAR2(100) NULL ,
"MAC_ADDRESS" VARCHAR2(100) NULL ,
"CREATE_TIME" DATE NULL 
);
ALTER TABLE "HOST_MAC_INFO" ADD PRIMARY KEY ("ID");

CREATE TABLE "KAFKA_MONITOR" (
  "ID" VARCHAR2(32) NOT NULL ,
  "KAFKA_NAME" VARCHAR2(50)  NULL,
  "GROUP_ID" VARCHAR2(100)  NULL,
  "TOPIC_NAME" VARCHAR2(100)  NULL,
  "KAFKA_PARTITION" VARCHAR2(50)  NULL,
  "KAFKA_OFFSET" VARCHAR2(50)  NULL,
  "LAG_COUNT" VARCHAR2(50)  NULL,
  "STATE" VARCHAR2(1) NULL,
  "CREATE_TIME" DATE NULL 
);
ALTER TABLE "KAFKA_MONITOR" ADD PRIMARY KEY ("ID");

CREATE TABLE "REDIS_MONITOR"  (
  "ID" VARCHAR2(32) NOT NULL ,
  "REDIS_NAME" VARCHAR2(50)  NULL,
  "REDIS_VERSION" VARCHAR2(50)  NULL,
  "REDIS_MODE" VARCHAR2(50)  NULL,
  "PROCESS_ID" VARCHAR2(20)  NULL,
  "TCP_PORT" VARCHAR2(10)  NULL,
  "UPTIME_IN_DAYS" VARCHAR2(10)  NULL,
  "EXECUTABLE" VARCHAR2(100)  NULL,
  "CONFIG_FILE" VARCHAR2(100)  NULL,
  "CONNECTED_CLIENTS" VARCHAR2(10)  NULL,
  "BLOCKED_CLIENTS" VARCHAR2(10)  NULL,
  "USED_MEMORY_HUMAN" VARCHAR2(30)  NULL,
  "USED_MEMORY_PEAK_HUMAN" VARCHAR2(30)  NULL,
  "MAXMEMORY_HUMAN" VARCHAR2(30)  NULL,
  "AOF_ENABLED" VARCHAR2(5)  NULL,
  "RDB_LAST_BGSAVE_STATUS" VARCHAR2(10)  NULL,
  "RDB_LAST_BGSAVE_TIME_SEC" VARCHAR2(20)  NULL,
  "INSTANTANEOUS_OPS_PER_SEC" VARCHAR2(20)  NULL,
  "TOTAL_NET_INPUT_BYTES" VARCHAR2(50)  NULL,
  "TOTAL_NET_OUTPUT_BYTES" VARCHAR2(50)  NULL,
  "REJECTED_CONNECTIONS" VARCHAR2(10)  NULL,
  "REDIS_ROLE" VARCHAR2(20)  NULL,
  "CONNECTED_SLAVES" VARCHAR2(10)  NULL,
  "USED_CPU_SYS" VARCHAR2(20)  NULL,
  "EXPIRED_KEYS" VARCHAR2(20)  NULL,
  "EVICTED_KEYS" VARCHAR2(20)  NULL,
  "KEYSPACE_HITS" VARCHAR2(20)  NULL,
  "KEYSPACE_MISSES" VARCHAR2(20)  NULL,
  "PUBSUB_CHANNELS" VARCHAR2(10)  NULL,
  "PUBSUB_PATTERNS" VARCHAR2(10)  NULL,
  "CLUSTER_ENABLED" VARCHAR2(10)  NULL,
  "STATE" VARCHAR2(1) NULL,
  "REDIS_NODE_INFO" VARCHAR2(50) NULL,
  "CREATE_TIME" DATE NULL 
);
ALTER TABLE "REDIS_MONITOR" ADD PRIMARY KEY ("ID");

CREATE TABLE "DISK_IO_STATE" (
  "ID" VARCHAR2(32) NOT NULL ,
  "READ_IO_AVG" VARCHAR2(10)  NULL,
  "WRITE_IO_AVG" VARCHAR2(10)  NULL,
  "HOST_NAME" VARCHAR2(50)  NULL,
  "CREATE_TIME" DATE NULL 
);
ALTER TABLE "DISK_IO_STATE" ADD PRIMARY KEY ("ID");
CREATE INDEX "DISK_IO_STATE_INDEX" ON "DISK_IO_STATE" ("HOST_NAME" ASC);

CREATE TABLE "TASK_JOB_INFO" (
  "ID" VARCHAR2(32) NOT NULL ,
  "HOST_NAME" VARCHAR2(50)  NULL,
  "JOB_NAME" VARCHAR2(50)  NULL,
  "JOB_REMARK" VARCHAR2(200)  NULL,
  "CRON_VALUE" VARCHAR2(100)  NULL,
  "ACTIVE" VARCHAR2(1)  NULL,
  "ACCOUNT" VARCHAR2(50)  NULL,
  "GROUP_ID" VARCHAR2(500)  NULL,
  "CALL_BACK_TIME" DATE NULL,
  "CALL_BACK_STATE" VARCHAR2(50)  NULL,
  "SHELL" VARCHAR2(2000)  NULL,
  "CALL_BACK_RESULT" VARCHAR2(1000)  NULL,
  "CREATE_TIME" DATE NULL 
);
ALTER TABLE "TASK_JOB_INFO" ADD PRIMARY KEY ("ID");

CREATE TABLE "AGENT_RUN_STATE" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"CREATE_TIME" DATE NULL ,
"ONLINE_TIME" NUMBER(11) NULL ,
"DOWN_TIME" NUMBER(11) NULL ,
"LAST_TIME" DATE NULL
);
ALTER TABLE "AGENT_RUN_STATE" ADD PRIMARY KEY ("ID");

CREATE TABLE "SNMP_DEEP_INFO" (
"ID" VARCHAR2(32) NOT NULL ,
"HOST_NAME" VARCHAR2(50) NULL ,
"CREATE_TIME" DATE NULL ,
"STATE" VARCHAR2(1) NULL ,
"ACTIVE" VARCHAR2(1) NULL ,
"REMARK" VARCHAR2(100) NULL ,
"SNMP_COMMUNITY" VARCHAR2(50) NULL ,
"SNMP_PORT" VARCHAR2(10) NULL ,
"SNMP_VERSION" VARCHAR2(50) NULL ,
"ACCOUNT" VARCHAR2(50) NULL ,
"GROUP_ID" VARCHAR2(500) NULL ,
"WARN_LEVEL" VARCHAR2(10) NULL
);
ALTER TABLE "SNMP_DEEP_INFO" ADD PRIMARY KEY ("ID");
CREATE TABLE "SNMP_DEEP_STATE" (
"ID" VARCHAR2(32) NOT NULL ,
"SNMP_DEEP_INFO_ID" VARCHAR2(32) NULL ,
"CREATE_TIME" DATE NULL ,
"OID_VALUE" VARCHAR2(100) NULL ,
"OID_TYPE" VARCHAR2(50) NULL ,
"OID_NAME" VARCHAR2(100) NULL ,
"OID_ORDER_NUM" NUMBER(11) NULL
);
ALTER TABLE "SNMP_DEEP_STATE" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table ACCOUNT_INFO
-- ----------------------------
ALTER TABLE "ACCOUNT_INFO" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table APP_INFO
-- ----------------------------
ALTER TABLE "APP_INFO" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table APP_STATE
-- ----------------------------
CREATE INDEX "APP_STAT_INDEX" ON "APP_STATE" ("APP_INFO_ID" ASC, "CREATE_TIME" ASC);


-- ----------------------------
-- Primary Key structure for table APP_STATE
-- ----------------------------
ALTER TABLE "APP_STATE" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table CPU_STATE
-- ----------------------------
CREATE INDEX "CPU_ACC_HOST_INDEX" ON "CPU_STATE" ("HOST_NAME" ASC, "CREATE_TIME" ASC);


-- ----------------------------
-- Primary Key structure for table CPU_STATE
-- ----------------------------
ALTER TABLE "CPU_STATE" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table CPU_TEMPERATURES
-- ----------------------------
ALTER TABLE "CPU_TEMPERATURES" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table DB_INFO
-- ----------------------------
ALTER TABLE "DB_INFO" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table DB_TABLE
-- ----------------------------
ALTER TABLE "DB_TABLE" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table DB_TABLE_COUNT
-- ----------------------------
CREATE INDEX "DBTABLE_ID_CREATE_TIME" ON "DB_TABLE_COUNT" ("DB_TABLE_ID" ASC, "CREATE_TIME" ASC);

-- ----------------------------
-- Primary Key structure for table DB_TABLE_COUNT
-- ----------------------------
ALTER TABLE "DB_TABLE_COUNT" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table DCE_INFO
-- ----------------------------
CREATE INDEX "DCE_INFO_HOSTNAME_INDEX" ON "DCE_INFO" ("HOST_NAME" ASC);


-- ----------------------------
-- Primary Key structure for table DCE_INFO
-- ----------------------------
ALTER TABLE "DCE_INFO" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table DCE_STATE
-- ----------------------------
CREATE INDEX "DCE_STATE_DCEID_INDEX" ON "DCE_STATE" ("DCE_ID" ASC, "CREATE_TIME" ASC);

-- ----------------------------
-- Primary Key structure for table DCE_STATE
-- ----------------------------
ALTER TABLE "DCE_STATE" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table DESK_IO
-- ----------------------------
ALTER TABLE "DESK_IO" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table DISK_SMART
-- ----------------------------
ALTER TABLE "DISK_SMART" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table DISK_STATE
-- ----------------------------
ALTER TABLE "DISK_STATE" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table DOCKER_INFO
-- ----------------------------
ALTER TABLE "DOCKER_INFO" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table DOCKER_STATE
-- ----------------------------
CREATE INDEX "DOCKER_STATE_INDEX" ON "DOCKER_STATE" ("DOCKER_INFO_ID" ASC, "CREATE_TIME" ASC);

-- ----------------------------
-- Primary Key structure for table DOCKER_STATE
-- ----------------------------
ALTER TABLE "DOCKER_STATE" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table EQUIPMENT
-- ----------------------------
ALTER TABLE "EQUIPMENT" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table FILE_SAFE
-- ----------------------------
ALTER TABLE "FILE_SAFE" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table FILE_WARN
-- ----------------------------
ALTER TABLE "FILE_WARN" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table FILE_WARN_STATE
-- ----------------------------
CREATE INDEX "FILE_WARN_ID_INDEX" ON "FILE_WARN_STATE" ("FILE_WARN_ID" ASC);

-- ----------------------------
-- Primary Key structure for table FILE_WARN_STATE
-- ----------------------------
ALTER TABLE "FILE_WARN_STATE" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table HEATH_MONITOR
-- ----------------------------
ALTER TABLE "HEATH_MONITOR" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table HEATH_STATE
-- ----------------------------
CREATE INDEX "HEATH_ID_CREATE_TIME" ON "HEATH_STATE" ("HEATH_ID" ASC, "CREATE_TIME" ASC);

-- ----------------------------
-- Primary Key structure for table HEATH_STATE
-- ----------------------------
ALTER TABLE "HEATH_STATE" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table HOST_DISK_PER
-- ----------------------------
ALTER TABLE "HOST_DISK_PER" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table HOST_GROUP
-- ----------------------------
ALTER TABLE "HOST_GROUP" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table INTRUSION_INFO
-- ----------------------------
ALTER TABLE "INTRUSION_INFO" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table LOG_INFO
-- ----------------------------
ALTER TABLE "LOG_INFO" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table MAIL_SET
-- ----------------------------
ALTER TABLE "MAIL_SET" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table MEM_STATE
-- ----------------------------
CREATE INDEX "MEM_ACC_HOST_INDEX" ON "MEM_STATE" ("HOST_NAME" ASC, "CREATE_TIME" ASC);


-- ----------------------------
-- Primary Key structure for table MEM_STATE
-- ----------------------------
ALTER TABLE "MEM_STATE" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table NETIO_STATE
-- ----------------------------
CREATE INDEX "NETIO_ACC_HOST_INDEX" ON "NETIO_STATE" ("HOST_NAME" ASC, "CREATE_TIME" ASC);

-- ----------------------------
-- Primary Key structure for table NETIO_STATE
-- ----------------------------
ALTER TABLE "NETIO_STATE" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table PORT_INFO
-- ----------------------------
CREATE INDEX "PORT_HOST_NAME_INDEX" ON "PORT_INFO" ("HOST_NAME" ASC);


-- ----------------------------
-- Primary Key structure for table PORT_INFO
-- ----------------------------
ALTER TABLE "PORT_INFO" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table SHELL_INFO
-- ----------------------------
ALTER TABLE "SHELL_INFO" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table SHELL_STATE
-- ----------------------------
CREATE INDEX "SHELL_STATE_INDEX1" ON "SHELL_STATE" ("HOST_NAME" ASC);
CREATE INDEX "SHELL_STATE_INDEX2" ON "SHELL_STATE" ("SHELL_ID" ASC);


-- ----------------------------
-- Primary Key structure for table SHELL_STATE
-- ----------------------------
ALTER TABLE "SHELL_STATE" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table SNMP_INFO
-- ----------------------------
ALTER TABLE "SNMP_INFO" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table SNMP_STATE
-- ----------------------------
CREATE INDEX "SNMP_ID_CREATE_TIME" ON "SNMP_STATE" ("SNMP_INFO_ID" ASC, "CREATE_TIME" ASC);


-- ----------------------------
-- Primary Key structure for table SNMP_STATE
-- ----------------------------
ALTER TABLE "SNMP_STATE" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table SYS_LOAD_STATE
-- ----------------------------
CREATE INDEX "LOAD_ACC_HOST_INDEX" ON "SYS_LOAD_STATE" ("HOST_NAME" ASC, "CREATE_TIME" ASC);


-- ----------------------------
-- Primary Key structure for table SYS_LOAD_STATE
-- ----------------------------
ALTER TABLE "SYS_LOAD_STATE" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table SYSTEM_INFO
-- ----------------------------
ALTER TABLE "SYSTEM_INFO" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table TCP_STATE
-- ----------------------------
CREATE INDEX "TCP_ACC_HOST_INDEX" ON "TCP_STATE" ("HOST_NAME" ASC, "CREATE_TIME" ASC);

-- ----------------------------
-- Primary Key structure for table TCP_STATE
-- ----------------------------
ALTER TABLE "TCP_STATE" ADD PRIMARY KEY ("ID");

ALTER TABLE "CUSTOM_INFO" ADD PRIMARY KEY ("ID");
ALTER TABLE "CUSTOM_STATE" ADD PRIMARY KEY ("ID");
CREATE INDEX "CUSTOM_STAT_INDEX" ON "CUSTOM_STATE" ("CUSTOM_INFO_ID" ASC, "CREATE_TIME" ASC);

ALTER TABLE "FTP_INFO" ADD PRIMARY KEY ("ID");

ALTER TABLE "REPORT_INFO" ADD PRIMARY KEY ("ID");
ALTER TABLE "REPORT_INSTANCE" ADD PRIMARY KEY ("ID");