/*
Navicat PGSQL Data Transfer

Source Server         : telnet
Source Server Version : 101600
Source Host           : localhost:5432
Source Database       : wgcloud
Source Schema         : public

Target Server Type    : PGSQL
Target Server Version : 101600
File Encoding         : 65001

Date: 2021-12-22 14:13:37
*/


-- ----------------------------
-- Table structure for app_info
-- ----------------------------
CREATE TABLE APP_INFO (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(50) COLLATE "default",
APP_PID varchar(200) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
APP_NAME varchar(50) COLLATE "default",
CPU_PER float8,
MEM_PER float8,
APP_TYPE char(1) COLLATE "default",
STATE char(1) COLLATE "default",
ACTIVE char(1) COLLATE "default",
READ_BYTES varchar(20) COLLATE "default",
WRITES_BYTES varchar(20) COLLATE "default",
THREADS_NUM varchar(20) COLLATE "default",
GATHER_PID varchar(20) COLLATE "default",
APP_TIMES varchar(50) COLLATE "default",
PRO_USERNAME varchar(100) COLLATE "default",
CUSTOM_SHELL varchar(500) COLLATE "default",
WARN_LEVEL varchar(10) COLLATE "default",
NET_CONNECTIONS varchar(8) COLLATE "default",
APP_CMD_LINE varchar(200) COLLATE "default",
GROUP_ID varchar(500) COLLATE "default"
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for app_state
-- ----------------------------
CREATE TABLE APP_STATE (
ID varchar(32) COLLATE "default" NOT NULL,
APP_INFO_ID varchar(32) COLLATE "default",
CPU_PER float8,
MEM_PER float8,
THREADS_NUM varchar(10) COLLATE "default",
NET_CONNECTIONS varchar(8) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for cpu_state
-- ----------------------------
CREATE TABLE CPU_STATE (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(50) COLLATE "default",
SYS float8,
PROCS_NUM integer,
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for cpu_temperatures
-- ----------------------------
CREATE TABLE CPU_TEMPERATURES (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(50) COLLATE "default",
CORE_INDEX varchar(50) COLLATE "default",
CRIT varchar(10) COLLATE "default",
INPUT varchar(10) COLLATE "default",
MAX varchar(10) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for db_info
-- ----------------------------
CREATE TABLE DB_INFO (
ID varchar(32) COLLATE "default" NOT NULL,
DBTYPE varchar(32) COLLATE "default",
USER_NAME varchar(50) COLLATE "default",
PASSWD varchar(100) COLLATE "default",
DBURL varchar(500) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
DB_STATE char(1) COLLATE "default",
ACCOUNT varchar(50) COLLATE "default",
WARN_LEVEL varchar(10) COLLATE "default",
ACTIVE varchar(1) COLLATE "default",
DRIVER_NAME varchar(100) COLLATE "default",
TEST_QUERY_SQL varchar(100) COLLATE "default",
GROUP_ID varchar(500) COLLATE "default",
RES_TIMES int4,
ALIAS_NAME varchar(50) COLLATE "default"
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for db_table
-- ----------------------------
CREATE TABLE DB_TABLE (
ID varchar(32) COLLATE "default" NOT NULL,
TABLE_NAME varchar(100) COLLATE "default",
WHERE_VAL varchar(2000) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
REMARK varchar(50) COLLATE "default",
TABLE_COUNT varchar(100) COLLATE "default",
DBINFO_ID varchar(32) COLLATE "default",
RESULT_EXP varchar(100) COLLATE "default",
STATE varchar(1) COLLATE "default",
WARN_LEVEL varchar(10) COLLATE "default",
REMARK_EXT varchar(100) COLLATE "default",
RES_TIMES int4,
ACTIVE char(1) COLLATE "default"
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for db_table_count
-- ----------------------------
CREATE TABLE DB_TABLE_COUNT (
ID varchar(32) COLLATE "default" NOT NULL,
DB_TABLE_ID varchar(32) COLLATE "default",
TABLE_COUNT varchar(100) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for dce_info
-- ----------------------------
CREATE TABLE DCE_INFO (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(50) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
ACTIVE char(1) COLLATE "default",
RES_TIMES int4,
GROUP_ID varchar(500) COLLATE "default",
ACCOUNT varchar(50) COLLATE "default",
WARN_LEVEL varchar(10) COLLATE "default",
ORDER_NUM int8,
REMARK varchar(50) COLLATE "default"
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for dce_state
-- ----------------------------
CREATE TABLE DCE_STATE (
ID varchar(32) COLLATE "default" NOT NULL,
DCE_ID varchar(32) COLLATE "default",
RES_TIMES int4,
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for desk_io
-- ----------------------------
CREATE TABLE DESK_IO (
ID varchar(32) COLLATE "default" NOT NULL,
FILE_STSTEM varchar(200) COLLATE "default",
READ_COUNT varchar(20) COLLATE "default",
WRITE_OUNT varchar(20) COLLATE "default",
READ_BYTES varchar(20) COLLATE "default",
WRITE_BYTES varchar(20) COLLATE "default",
READ_TIME varchar(20) COLLATE "default",
WRITE_TIME varchar(20) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
HOST_NAME varchar(50) COLLATE "default"
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for DISK_STATE
-- ----------------------------
CREATE TABLE DISK_STATE (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(50) COLLATE "default",
FILE_STSTEM varchar(200) COLLATE "default",
DISK_SIZE varchar(30) COLLATE "default",
USED varchar(30) COLLATE "default",
AVAIL varchar(30) COLLATE "default",
USE_PER varchar(10) COLLATE "default",
DATE_STR varchar(30) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for disk_smart
-- ----------------------------
CREATE TABLE DISK_SMART (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(50) COLLATE "default",
FILE_STSTEM varchar(255) COLLATE "default",
DISK_STATE varchar(50) COLLATE "default",
POWER_HOURS varchar(50) COLLATE "default",
POWER_COUNT varchar(50) COLLATE "default",
TEMPERATURE varchar(50) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for docker_info
-- ----------------------------
CREATE TABLE DOCKER_INFO (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(50) COLLATE "default",
DOCKER_ID varchar(200) COLLATE "default",
DOCKER_NAME varchar(100) COLLATE "default",
DOCKER_STATE varchar(50) COLLATE "default",
MEM_PER float8,
STATE char(1) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
USER_TIME varchar(20) COLLATE "default",
ACTIVE char(1) COLLATE "default",
APP_TYPE char(1) COLLATE "default",
DOCKER_IMAGE varchar(200) COLLATE "default",
DOCKER_PORT varchar(200) COLLATE "default",
DOCKER_COMMAND varchar(500) COLLATE "default",
DOCKER_CREATED varchar(50) COLLATE "default",
DOCKER_SIZE varchar(20) COLLATE "default",
DOCKER_STATUS varchar(100) COLLATE "default",
GATHER_DOCKER_NAMES varchar(150) COLLATE "default",
WARN_LEVEL varchar(10) COLLATE "default",
GROUP_ID varchar(500) COLLATE "default"
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for docker_state
-- ----------------------------
CREATE TABLE DOCKER_STATE (
ID varchar(32) COLLATE "default" NOT NULL,
DOCKER_INFO_ID varchar(32) COLLATE "default",
CPU_PER float8,
MEM_PER float8,
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for equipment
-- ----------------------------
CREATE TABLE EQUIPMENT (
ID varchar(32) COLLATE "default" NOT NULL,
EQ_NAME varchar(50) COLLATE "default",
XINGHAO varchar(50) COLLATE "default",
PERSON varchar(50) COLLATE "default",
DEPT varchar(50) COLLATE "default",
CODE varchar(50) COLLATE "default",
PRICE float8,
GONGYINGSHANG varchar(50) COLLATE "default",
CAIGOU_DATE varchar(50) COLLATE "default",
WEIBAO_DATE varchar(50) COLLATE "default",
REMARK varchar(255) COLLATE "default",
ACCOUNT varchar(50) COLLATE "default",
GROUP_ID varchar(500) COLLATE "default",
HOST_NAME varchar(50) COLLATE "default",
FILE_NAME varchar(50) COLLATE "default",
FILE_PATH varchar(150) COLLATE "default",
FILE_SIZE varchar(20) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for FILE_SAFE
-- ----------------------------
CREATE TABLE FILE_SAFE (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(50) COLLATE "default",
FILE_NAME varchar(50) COLLATE "default",
STATE char(1) COLLATE "default",
FILE_PATH varchar(255) COLLATE "default",
ACTIVE char(1) COLLATE "default",
FILE_SIGN varchar(50) COLLATE "default",
FILE_MODTIME varchar(50) COLLATE "default",
WARN_LEVEL varchar(10) COLLATE "default",
GROUP_ID varchar(500) COLLATE "default",
FILE_IS_DIR varchar(10) COLLATE "default",
CUSTOM_SHELL varchar(500) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for file_warn
-- ----------------------------
CREATE TABLE FILE_WARN (
ID varchar(32) COLLATE "default" NOT NULL,
FILE_PATH varchar(255) COLLATE "default",
FILE_SIZE varchar(32) COLLATE "default",
WARN_CHARS varchar(500) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
WARN_ROWS varchar(20) COLLATE "default",
HOST_NAME varchar(50) COLLATE "default",
REMARK varchar(255) COLLATE "default",
ACTIVE char(1) COLLATE "default",
FILE_TYPE varchar(1) COLLATE "default",
WARN_LEVEL varchar(10) COLLATE "default",
CUSTOM_SHELL varchar(500) COLLATE "default",
FILE_NAME_PREFIX varchar(50) COLLATE "default"
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for file_warn_state
-- ----------------------------
CREATE TABLE FILE_WARN_STATE (
ID varchar(32) COLLATE "default" NOT NULL,
WAR_CONTENT text COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
FILE_WARN_ID varchar(32) COLLATE "default",
ROWS_GATHER_COUNT varchar(10) COLLATE "default",
ROWS_COUNT varchar(10) COLLATE "default",
FILE_PATH varchar(255) COLLATE "default"
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for heath_monitor
-- ----------------------------
CREATE TABLE HEATH_MONITOR (
ID varchar(32) COLLATE "default" NOT NULL,
APP_NAME varchar(50) COLLATE "default",
HEATH_URL varchar(255) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
HEATH_STATUS varchar(10) COLLATE "default",
RES_TIMES int4,
ACTIVE char(1) COLLATE "default",
RES_KEYWORD varchar(255) COLLATE "default",
METHOD varchar(5) COLLATE "default",
POST_STR varchar(2000) COLLATE "default",
RES_NO_KEYWORD varchar(255) COLLATE "default",
ACCOUNT varchar(50) COLLATE "default",
RESPONSE_BODY_SIZE varchar(20) COLLATE "default",
FORM_JSON varchar(1500) COLLATE "default",
ERROR_MSG varchar(200) COLLATE "default",
WARN_LEVEL varchar(10) COLLATE "default",
GROUP_ID varchar(500) COLLATE "default",
HEADER_JSON varchar(1500) COLLATE "default"
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for heath_state
-- ----------------------------
CREATE TABLE HEATH_STATE (
ID varchar(32) COLLATE "default" NOT NULL,
HEATH_ID varchar(32) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
RES_TIMES int4
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for HOST_DISK_PER
-- ----------------------------
CREATE TABLE HOST_DISK_PER (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(50) COLLATE "default",
DISK_SUM_PER float8,
CREATE_TIME timestamp(6)
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for host_group
-- ----------------------------
CREATE TABLE HOST_GROUP (
ID varchar(32) COLLATE "default" NOT NULL,
GROUP_NAME varchar(100) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
REMARK varchar(255) COLLATE "default",
ACCOUNT varchar(50) COLLATE "default",
GROUP_TYPE varchar(5) COLLATE "default"
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for intrusion_info
-- ----------------------------
CREATE TABLE INTRUSION_INFO (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME char(30) COLLATE "default",
LSMOD text COLLATE "default",
PASSWD_INFO varchar(100) COLLATE "default",
CRONTAB text COLLATE "default",
PROMISC varchar(100) COLLATE "default",
RPCINFO text COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for log_info
-- ----------------------------
CREATE TABLE LOG_INFO (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(200) COLLATE "default",
INFO_CONTENT text COLLATE "default",
STATE char(1) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT CURRENT_TIMESTAMP NOT NULL
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for mail_set
-- ----------------------------
CREATE TABLE MAIL_SET (
ID varchar(32) COLLATE "default" NOT NULL,
SEND_MAIL varchar(60) COLLATE "default",
FROM_MAIL_NAME varchar(60) COLLATE "default",
FROM_PWD varchar(100) COLLATE "default",
SMTP_HOST varchar(50) COLLATE "default",
SMTP_PORT varchar(30) COLLATE "default",
SMTP_SSL varchar(30) COLLATE "default",
TO_MAIL varchar(300) COLLATE "default",
CPU_PER varchar(30) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
ACTIVE varchar(30) COLLATE "default",
JAVAX_MAIL varchar(30) COLLATE "default"
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for mem_state
-- ----------------------------
CREATE TABLE MEM_STATE (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(50) COLLATE "default",
USE_PER float8,
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for netio_state
-- ----------------------------
CREATE TABLE NETIO_STATE (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(50) COLLATE "default",
RXPCK varchar(15) COLLATE "default",
TXPCK varchar(15) COLLATE "default",
RXBYT varchar(15) COLLATE "default",
TXBYT varchar(15) COLLATE "default",
DROPIN varchar(15) COLLATE "default",
DROPOUT varchar(15) COLLATE "default",
NET_CONNECTIONS varchar(10) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for port_info
-- ----------------------------
CREATE TABLE PORT_INFO (
ID varchar(32) COLLATE "default" NOT NULL,
PORT varchar(30) COLLATE "default",
PORT_NAME varchar(30) COLLATE "default",
STATE char(1) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
HOST_NAME varchar(50) COLLATE "default",
ACTIVE char(1) COLLATE "default",
TELNET_IP varchar(300) COLLATE "default",
WARN_LEVEL varchar(10) COLLATE "default",
PORT_TYPE varchar(5) COLLATE "default",
GROUP_ID varchar(500) COLLATE "default"
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for SHELL_INFO
-- ----------------------------
CREATE TABLE SHELL_INFO (
ID varchar(32) COLLATE "default" NOT NULL,
SHELL_NAME varchar(100) COLLATE "default",
SHELL varchar(2000) COLLATE "default",
STATE char(1) COLLATE "default",
CREATE_TIME timestamp(6),
SHELL_TYPE varchar(5) COLLATE "default",
SHELL_TIME varchar(20) COLLATE "default",
ACCOUNT varchar(50) COLLATE "default",
SHELL_DAY varchar(5) COLLATE "default"
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for SHELL_STATE
-- ----------------------------
CREATE TABLE SHELL_STATE (
ID varchar(32) COLLATE "default" NOT NULL,
SHELL_ID varchar(32) COLLATE "default",
HOST_NAME varchar(50) COLLATE "default",
STATE varchar(50) COLLATE "default",
SHELL varchar(2000) COLLATE "default",
SHELL_RESULT varchar(4000) COLLATE "default",
CREATE_TIME timestamp(6),
SHELL_TIME varchar(20) COLLATE "default"
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for sys_load_state
-- ----------------------------
CREATE TABLE SYS_LOAD_STATE (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(50) COLLATE "default",
ONE_LOAD numeric(18,2),
FIVE_LOAD numeric(18,2),
FIFTEEN_LOAD numeric(18,2),
USERS varchar(10) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for system_info
-- ----------------------------
CREATE TABLE SYSTEM_INFO (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(50) COLLATE "default",
CPU_PER float8,
MEM_PER float8,
CPU_CORE_NUM varchar(10) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
STATE char(1) COLLATE "default",
PROCS varchar(11) COLLATE "default",
GROUP_ID varchar(500) COLLATE "default",
REMARK varchar(100) COLLATE "default",
TOTAL_MEM varchar(50) COLLATE "default",
RXBYT varchar(15) COLLATE "default",
TXBYT varchar(15) COLLATE "default",
WIN_CONSOLE varchar(255) COLLATE "default",
NET_CONNECTIONS varchar(10) COLLATE "default",
ACCOUNT varchar(50) COLLATE "default",
ACTIVE varchar(1) COLLATE "default",
COUNT_BLOCK varchar(1) COLLATE "default",
ORDER_NUM int8,
DISK_PER float8,
DISK_SUM_SIZE varchar(20) COLLATE "default",
FIVE_LOAD float8,
FIFTEEN_LOAD float8
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for tcp_state
-- ----------------------------
CREATE TABLE TCP_STATE (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(30) COLLATE "default",
ACTIVE varchar(30) COLLATE "default",
PASSIVE varchar(30) COLLATE "default",
RETRANS varchar(30) COLLATE "default",
DATE_STR varchar(30) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for SNMP_INFO
-- ----------------------------
CREATE TABLE SNMP_INFO (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(50) COLLATE "default",
BYTES_RECV varchar(30) COLLATE "default",
BYTES_SENT varchar(30) COLLATE "default",
RECV_AVG varchar(2000) COLLATE "default",
SENT_AVG varchar(2000) COLLATE "default",
STATE char(1) COLLATE "default",
ACTIVE char(1) COLLATE "default",
SNMP_UNIT varchar(20) COLLATE "default",
REMARK varchar(50) COLLATE "default",
RECV_OID varchar(2000) COLLATE "default",
SENT_OID varchar(2000) COLLATE "default",
SNMP_COMMUNITY varchar(50) COLLATE "default",
SNMP_PORT varchar(10) COLLATE "default",
SNMP_VERSION varchar(10) COLLATE "default",
ACCOUNT varchar(50) COLLATE "default",
CPU_PER_OID varchar(300) COLLATE "default",
MEM_SIZE_OID varchar(300) COLLATE "default",
TEMPERATURE_OID varchar(100) COLLATE "default",
CPU_PER varchar(10) COLLATE "default",
MEM_PER varchar(10) COLLATE "default",
DISK_PER_OID varchar(300) COLLATE "default",
DISK_PER varchar(10) COLLATE "default",
SYS_DESC_VAL varchar(200) COLLATE "default",
SYS_DESC_OID varchar(100) COLLATE "default",
WARN_LEVEL varchar(10) COLLATE "default",
GROUP_ID varchar(500) COLLATE "default",
TEMPERATURE_VALUE varchar(10) COLLATE "default",
VOLTAGE_OID varchar(100) COLLATE "default",
VOLTAGE_VALUE varchar(30) COLLATE "default",
VOLTAGE_UNIT varchar(10) COLLATE "default",
IFOPERSTATUS_OID varchar(100) COLLATE "default",
IFOPERSTATUS_VALUE varchar(1500) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);


-- ----------------------------
-- Table structure for SNMP_STATE
-- ----------------------------
CREATE TABLE SNMP_STATE (
ID varchar(32) COLLATE "default" NOT NULL,
SNMP_INFO_ID varchar(32) COLLATE "default",
RECV_AVG varchar(20) COLLATE "default",
SENT_AVG varchar(20) COLLATE "default",
CPU_PER varchar(10) COLLATE "default",
MEM_PER varchar(10) COLLATE "default",
VOLTAGE_VALUE varchar(10) COLLATE "default",
TEMPERATURE_VALUE varchar(10) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for ACCOUNT_INFO
-- ----------------------------
CREATE TABLE ACCOUNT_INFO (
ID varchar(32) COLLATE "default" NOT NULL,
ACCOUNT varchar(50) COLLATE "default",
EMAIL varchar(200) COLLATE "default",
PASSWD varchar(50) COLLATE "default",
ACCOUNT_KEY varchar(50) COLLATE "default",
REMARK varchar(50) COLLATE "default",
MENU_IDS varchar(200) COLLATE "default",
ACCOUNT_ROLE varchar(10) COLLATE "default",
ACCOUNT_PHONE varchar(50) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for custom_info
-- ----------------------------
CREATE TABLE CUSTOM_INFO (
  ID varchar(32) COLLATE "default" NOT NULL,
  CUSTOM_NAME varchar(200) COLLATE "default",
  CUSTOM_SHELL varchar(2000) COLLATE "default",
  CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
  HOST_NAME varchar(50) COLLATE "default",
  ACTIVE char(1) COLLATE "default",
  STATE char(1) COLLATE "default",
  RESULT_EXP varchar(100) COLLATE "default",
  GROUP_ID varchar(500) COLLATE "default",
  WARN_LEVEL varchar(10) COLLATE "default",
  CUSTOM_VALUE varchar(50) COLLATE "default"
) WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for custom_state
-- ----------------------------
CREATE TABLE CUSTOM_STATE (
  ID varchar(32) COLLATE "default" NOT NULL,
  CUSTOM_INFO_ID varchar(32) COLLATE "default",
  CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
  CUSTOM_VALUE varchar(50) COLLATE "default"
) WITH (OIDS=FALSE);

-- ----------------------------
-- Table structure for FTP_INFO
-- ----------------------------
CREATE TABLE FTP_INFO (
  ID varchar(32)  COLLATE "default" NOT NULL,
  FTP_HOST varchar(100) COLLATE "default",
  USER_NAME varchar(50) COLLATE "default",
  PASSWD varchar(100) COLLATE "default",
  PORT varchar(50) COLLATE "default",
  ACTIVE char(1) COLLATE "default",
  WARN_TYPE varchar(10) COLLATE "default",
  STATE char(1) COLLATE "default",
  FTP_TYPE varchar(10) COLLATE "default",
  CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
  ACCOUNT varchar(50) COLLATE "default",
  FTP_NAME varchar(50) COLLATE "default",
  WARN_LEVEL varchar(10) COLLATE "default",
  GROUP_ID varchar(500) COLLATE "default",
  RES_TIMES int8
) WITH (OIDS=FALSE);

CREATE TABLE REPORT_INFO (
  ID varchar(32) COLLATE "default" NOT NULL,
  TIME_PART varchar(100) COLLATE "default",
  REPORT_TYPE varchar(1) COLLATE "default",
  GROUP_NAME varchar(50) COLLATE "default",
  CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);

CREATE TABLE REPORT_INSTANCE (
  ID varchar(32) COLLATE "default" NOT NULL,
  INFO_KEY varchar(100) COLLATE "default",
  INFO_CONTENT varchar(200) COLLATE "default",
  REPORT_INFO_ID varchar(32) COLLATE "default",
  CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);

CREATE TABLE HOST_USERS (
  ID varchar(32) COLLATE "default" NOT NULL,
  HOST_NAME varchar(50) COLLATE "default",
  HOST_USER varchar(50) COLLATE "default",
  LAST_LOGIN_IP varchar(50) COLLATE "default",
  LAST_LOGIN_TIME varchar(50) COLLATE "default",
  TERMINAL varchar(50) COLLATE "default",
  CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);
ALTER TABLE HOST_USERS ADD PRIMARY KEY (ID);

CREATE TABLE PASSWD_INFO (
  ID varchar(32) COLLATE "default" NOT NULL,
  HOST_NAME varchar(100) COLLATE "default",
  HOST_ACCOUNT varchar(50) COLLATE "default",
  HOST_PASSWD varchar(100) COLLATE "default",
  HOST_REMARK varchar(300) COLLATE "default",
  ACCOUNT varchar(50) COLLATE "default",
  GROUP_ID varchar(500) COLLATE "default",
  HOST_MARK varchar(100) COLLATE "default",
  CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);
ALTER TABLE PASSWD_INFO ADD PRIMARY KEY (ID);

CREATE TABLE HOST_WARN_DIY  (
  ID varchar(32) COLLATE "default"  NOT NULL,
  HOST_NAME varchar(50) COLLATE "default",
  MEM_WARN_VAL float8,
  CPU_WARN_VAL float8,
  UPSPEED_VAL float8,
  UPSPEED_MIN_VAL float8,
  DOWNSPEED_VAL float8,
  DOWNSPEED_MIN_VAL float8,
  CPUTEMPERATURE_WARN_VAL float8,
  MEM_WARN_MAIL varchar(10) COLLATE "default",
  UPSPEED_MAIL varchar(10) COLLATE "default",
  DOWNSPEED_MAIL varchar(10) COLLATE "default",
  CPU_WARN_MAIL varchar(10) COLLATE "default",
  CPUTEMPERATURE_WARN_MAIL varchar(10) COLLATE "default",
  DISK_WARN_MAIL varchar(10)  COLLATE "default",
  SMART_WARN_MAIL varchar(10)  COLLATE "default",
  DISK_BLOCK varchar(200) COLLATE "default",
  DISK_WARN_VAL float8,
  SYSLOAD_WARN_MAIL varchar(10)  COLLATE "default",
  SYSLOAD_WARN_VAL float8,
  HOST_DOWN_WARN_MAIL varchar(10) COLLATE "default",
  HOST_LOGIN_WARN_MAIL varchar(10) COLLATE "default",
  CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
  ACCOUNT varchar(50) COLLATE "default",
  ACTIVE varchar(1) COLLATE "default",
  HOST_BLOCK_ALL_WARN varchar(10) COLLATE "default",
  SPEED_WARN_LEVEL varchar(10)  COLLATE "default",
  MEM_WARN_LEVEL varchar(10)  COLLATE "default",
  SYSLOAD_WARN_LEVEL varchar(10)  COLLATE "default",
  CPU_WARN_LEVEL varchar(10)  COLLATE "default",
  CPUTEMPERATURE_WARN_LEVEL varchar(10)  COLLATE "default",
  DISK_WARN_LEVEL varchar(10)  COLLATE "default",
  SMART_WARN_LEVEL varchar(10)  COLLATE "default",
  HOST_DOWN_WARN_LEVEL varchar(10)  COLLATE "default",
  HOST_LOGIN_WARN_LEVEL varchar(10)  COLLATE "default",
  NETCONNECTIONS_WARN_MAIL varchar(10)  COLLATE "default",
  NETCONNECTIONS_WARN_VAL float8,
  NETCONNECTIONS_WARN_LEVEL varchar(10)  COLLATE "default",
  DISK_BLOCK_SAVE varchar(200)  COLLATE "default",
  HOST_DOWN_WARN_COUNT varchar(2)  COLLATE "default",
  CUSTOM_WARN_MAIL varchar(100)  COLLATE "default",
  CUSTOM_WARN_ACCOUNT_KEY varchar(100)  COLLATE "default",
  DISKIO_SPEED_WARN_MAIL varchar(10)  COLLATE "default",
  DISKIO_SPEED_WARN_VAL float8,
  REMARK varchar(255) COLLATE "default"
)
WITH (OIDS=FALSE);
ALTER TABLE HOST_WARN_DIY ADD PRIMARY KEY (ID);

CREATE TABLE APP_EXCEPTION_INFO (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(50) COLLATE "default",
APP_PID varchar(200) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
APP_NAME varchar(100) COLLATE "default",
CPU_PER float8,
MEM_PER float8,
APP_TYPE char(1) COLLATE "default",
STATE char(1) COLLATE "default",
ACTIVE char(1) COLLATE "default",
READ_BYTES varchar(20) COLLATE "default",
WRITES_BYTES varchar(20) COLLATE "default",
THREADS_NUM varchar(20) COLLATE "default",
GATHER_PID varchar(20) COLLATE "default",
APP_TIMES varchar(50) COLLATE "default",
PRO_USERNAME varchar(100) COLLATE "default",
CUSTOM_SHELL varchar(500) COLLATE "default",
WARN_LEVEL varchar(10) COLLATE "default",
NET_CONNECTIONS varchar(8) COLLATE "default",
APP_CMD_LINE varchar(200) COLLATE "default",
GROUP_ID varchar(500) COLLATE "default"
)
WITH (OIDS=FALSE);
ALTER TABLE APP_EXCEPTION_INFO ADD PRIMARY KEY (ID);

CREATE TABLE K8S_MONITOR (
ID varchar(32) COLLATE "default" NOT NULL,
DATA_TYPE varchar(20) COLLATE "default",
K8S_NAME varchar(50) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
DATA_JSON varchar(500) COLLATE "default"
)
WITH (OIDS=FALSE);
ALTER TABLE K8S_MONITOR ADD PRIMARY KEY (ID);

CREATE TABLE SYSTEM_INFO_EXT  (
  ID varchar(32) COLLATE "default" NOT NULL,
  HOST_NAME varchar(50) COLLATE "default",
  PLATFORM varchar(200)  COLLATE "default",
  CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
  CPU_XH varchar(200)  COLLATE "default",
  BOOT_TIME int8,
  PLATFORM_VERSION varchar(100) COLLATE "default",
  UPTIME int8,
  SUBMIT_SECONDS varchar(10) COLLATE "default",
  AGENT_VER varchar(50) COLLATE "default",
  BYTES_RECV varchar(20) COLLATE "default",
  BYTES_SENT varchar(20) COLLATE "default",
  HOST_NAME_EXT varchar(100) COLLATE "default",
  SWAP_MEM_PER varchar(20) COLLATE "default",
  TOTAL_SWAP_MEM varchar(50) COLLATE "default",
  CPU_PHYSICALID varchar(50) COLLATE "default",
  CPU_FAMILY varchar(50) COLLATE "default",
  CPU_MHZ varchar(50) COLLATE "default",
  NET_INTERFACE_NAME varchar(150) COLLATE "default",
  KERNEL_ARCH varchar(50) COLLATE "default"
)
WITH (OIDS=FALSE);
ALTER TABLE SYSTEM_INFO_EXT ADD PRIMARY KEY (ID);

CREATE TABLE SHELL_NOTE_INFO (
ID varchar(32) COLLATE "default" NOT NULL,
SHELL_TITLE varchar(100) COLLATE "default",
SHELL_CONTENT text COLLATE "default",
ACCOUNT varchar(50) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);
ALTER TABLE SHELL_NOTE_INFO ADD PRIMARY KEY (ID);

CREATE TABLE HOST_MAC_INFO (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(50) COLLATE "default",
MAC_NAME varchar(100) COLLATE "default",
MAC_ADDRESS varchar(100) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);
ALTER TABLE HOST_MAC_INFO ADD PRIMARY KEY (ID);

CREATE TABLE KAFKA_MONITOR (
  ID varchar(32) COLLATE "default" NOT NULL,
  KAFKA_NAME varchar(50)   COLLATE "default",
  GROUP_ID varchar(100)   COLLATE "default",
  TOPIC_NAME varchar(100)   COLLATE "default",
  KAFKA_PARTITION varchar(50)   COLLATE "default",
  KAFKA_OFFSET varchar(50)   COLLATE "default",
  LAG_COUNT varchar(50)   COLLATE "default",
  STATE varchar(1) COLLATE "default",
  CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);
ALTER TABLE KAFKA_MONITOR ADD PRIMARY KEY (ID);

CREATE TABLE REDIS_MONITOR  (
  ID varchar(32) COLLATE "default" NOT NULL,
  REDIS_NAME varchar(50)  COLLATE "default",
  REDIS_VERSION varchar(50)  COLLATE "default",
  REDIS_MODE varchar(50)  COLLATE "default",
  PROCESS_ID varchar(20)  COLLATE "default",
  TCP_PORT varchar(10)  COLLATE "default",
  UPTIME_IN_DAYS varchar(10)  COLLATE "default",
  EXECUTABLE varchar(100)  COLLATE "default",
  CONFIG_FILE varchar(100)  COLLATE "default",
  CONNECTED_CLIENTS varchar(10)  COLLATE "default",
  BLOCKED_CLIENTS varchar(10)  COLLATE "default",
  USED_MEMORY_HUMAN varchar(30)  COLLATE "default",
  USED_MEMORY_PEAK_HUMAN varchar(30)  COLLATE "default",
  MAXMEMORY_HUMAN varchar(30)  COLLATE "default",
  AOF_ENABLED varchar(5)  COLLATE "default",
  RDB_LAST_BGSAVE_STATUS varchar(10)  COLLATE "default",
  RDB_LAST_BGSAVE_TIME_SEC varchar(20)  COLLATE "default",
  INSTANTANEOUS_OPS_PER_SEC varchar(20)  COLLATE "default",
  TOTAL_NET_INPUT_BYTES varchar(50)  COLLATE "default",
  TOTAL_NET_OUTPUT_BYTES varchar(50)  COLLATE "default",
  REJECTED_CONNECTIONS varchar(10)  COLLATE "default",
  REDIS_ROLE varchar(20)  COLLATE "default",
  CONNECTED_SLAVES varchar(10)  COLLATE "default",
  USED_CPU_SYS varchar(20)  COLLATE "default",
  EXPIRED_KEYS varchar(20)  COLLATE "default",
  EVICTED_KEYS varchar(20)  COLLATE "default",
  KEYSPACE_HITS varchar(20)  COLLATE "default",
  KEYSPACE_MISSES varchar(20)  COLLATE "default",
  PUBSUB_CHANNELS varchar(10)  COLLATE "default",
  PUBSUB_PATTERNS varchar(10)  COLLATE "default",
  CLUSTER_ENABLED varchar(10)  COLLATE "default",
  STATE varchar(1) COLLATE "default",
  REDIS_NODE_INFO varchar(50) COLLATE "default",
  CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);
ALTER TABLE REDIS_MONITOR ADD PRIMARY KEY (ID);


CREATE TABLE DISK_IO_STATE (
  ID varchar(32) COLLATE "default" NOT NULL,
  READ_IO_AVG varchar(10)   COLLATE "default",
  WRITE_IO_AVG varchar(10)   COLLATE "default",
  HOST_NAME varchar(50)   COLLATE "default",
  CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);
ALTER TABLE DISK_IO_STATE ADD PRIMARY KEY (ID);
CREATE INDEX DISK_IO_STATE_INDEX ON DISK_IO_STATE USING btree (HOST_NAME);

CREATE TABLE TASK_JOB_INFO (
  ID varchar(32) COLLATE "default" NOT NULL,
  HOST_NAME varchar(50)   COLLATE "default",
  JOB_NAME varchar(50)   COLLATE "default",
  JOB_REMARK varchar(200)   COLLATE "default",
  CRON_VALUE varchar(100)   COLLATE "default",
  ACTIVE varchar(1)   COLLATE "default",
  ACCOUNT varchar(50)   COLLATE "default",
  GROUP_ID varchar(500)   COLLATE "default",
  CALL_BACK_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
  CALL_BACK_STATE varchar(50)   COLLATE "default",
  CALL_BACK_RESULT varchar(1000)   COLLATE "default",
  SHELL varchar(2000)   COLLATE "default",
  CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);
ALTER TABLE TASK_JOB_INFO ADD PRIMARY KEY (ID);


CREATE TABLE AGENT_RUN_STATE (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(50) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
ONLINE_TIME int4,
DOWN_TIME int4,
LAST_TIME timestamp(0) DEFAULT NULL::timestamp without time zone
)
WITH (OIDS=FALSE);
ALTER TABLE AGENT_RUN_STATE ADD PRIMARY KEY (ID);

CREATE TABLE SNMP_DEEP_INFO (
ID varchar(32) COLLATE "default" NOT NULL,
HOST_NAME varchar(50) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
STATE varchar(1) COLLATE "default",
ACTIVE varchar(1) COLLATE "default",
REMARK varchar(100) COLLATE "default",
SNMP_COMMUNITY varchar(50) COLLATE "default",
SNMP_PORT varchar(10) COLLATE "default",
SNMP_VERSION varchar(50) COLLATE "default",
ACCOUNT varchar(50) COLLATE "default",
GROUP_ID varchar(500) COLLATE "default",
WARN_LEVEL varchar(10) COLLATE "default"
)
WITH (OIDS=FALSE);
ALTER TABLE SNMP_DEEP_INFO ADD PRIMARY KEY (ID);
CREATE TABLE SNMP_DEEP_STATE (
ID varchar(32) COLLATE "default" NOT NULL,
SNMP_DEEP_INFO_ID varchar(32) COLLATE "default",
CREATE_TIME timestamp(0) DEFAULT NULL::timestamp without time zone,
OID_VALUE varchar(100) COLLATE "default",
OID_TYPE varchar(50) COLLATE "default",
OID_NAME varchar(100) COLLATE "default",
OID_ORDER_NUM int4
)
WITH (OIDS=FALSE);
ALTER TABLE SNMP_DEEP_STATE ADD PRIMARY KEY (ID);

-- ----------------------------
-- Alter Sequences Owned By 
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table app_info
-- ----------------------------
ALTER TABLE APP_INFO ADD PRIMARY KEY (ID);

-- ----------------------------
-- Indexes structure for table app_state
-- ----------------------------
CREATE INDEX APP_STAT_INDEX ON APP_STATE USING btree (APP_INFO_ID, CREATE_TIME);

-- ----------------------------
-- Primary Key structure for table app_state
-- ----------------------------
ALTER TABLE APP_STATE ADD PRIMARY KEY (ID);

-- ----------------------------
-- Indexes structure for table cpu_state
-- ----------------------------
CREATE INDEX CPU_ACC_HOST_INDEX ON CPU_STATE USING btree (HOST_NAME, CREATE_TIME);

-- ----------------------------
-- Primary Key structure for table cpu_state
-- ----------------------------
ALTER TABLE CPU_STATE ADD PRIMARY KEY (ID);


-- ----------------------------
-- Primary Key structure for table cpu_temperatures
-- ----------------------------
ALTER TABLE CPU_TEMPERATURES ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table db_info
-- ----------------------------
ALTER TABLE DB_INFO ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table db_table
-- ----------------------------
ALTER TABLE DB_TABLE ADD PRIMARY KEY (ID);

-- ----------------------------
-- Indexes structure for table db_table_count
-- ----------------------------
CREATE INDEX DBTABLE_ID_CREATE_TIME ON DB_TABLE_COUNT USING btree (DB_TABLE_ID, CREATE_TIME);

-- ----------------------------
-- Primary Key structure for table db_table_count
-- ----------------------------
ALTER TABLE DB_TABLE_COUNT ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table dce_info
-- ----------------------------
ALTER TABLE DCE_INFO ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table dce_state
-- ----------------------------
ALTER TABLE DCE_STATE ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table desk_io
-- ----------------------------
ALTER TABLE DESK_IO ADD PRIMARY KEY (ID);


-- ----------------------------
-- Primary Key structure for table DISK_STATE
-- ----------------------------
ALTER TABLE DISK_STATE ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table disk_smart
-- ----------------------------
ALTER TABLE DISK_SMART ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table docker_info
-- ----------------------------
ALTER TABLE DOCKER_INFO ADD PRIMARY KEY (ID);

-- ----------------------------
-- Indexes structure for table docker_state
-- ----------------------------
CREATE INDEX DOCKER_STATE_INDEX ON DOCKER_STATE USING btree (DOCKER_INFO_ID, CREATE_TIME);

-- ----------------------------
-- Primary Key structure for table docker_state
-- ----------------------------
ALTER TABLE DOCKER_STATE ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table equipment
-- ----------------------------
ALTER TABLE EQUIPMENT ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table FILE_SAFE
-- ----------------------------
ALTER TABLE FILE_SAFE ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table file_warn
-- ----------------------------
ALTER TABLE FILE_WARN ADD PRIMARY KEY (ID);

-- ----------------------------
-- Indexes structure for table file_warn_state
-- ----------------------------
CREATE INDEX FILE_WARN_ID_INDEX ON FILE_WARN_STATE USING btree (FILE_WARN_ID);

-- ----------------------------
-- Primary Key structure for table file_warn_state
-- ----------------------------
ALTER TABLE FILE_WARN_STATE ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table heath_monitor
-- ----------------------------
ALTER TABLE HEATH_MONITOR ADD PRIMARY KEY (ID);

-- ----------------------------
-- Indexes structure for table heath_state
-- ----------------------------
CREATE INDEX HEATH_ID_CREATE_TIME ON HEATH_STATE USING btree (HEATH_ID, CREATE_TIME);

-- ----------------------------
-- Primary Key structure for table heath_state
-- ----------------------------
ALTER TABLE HEATH_STATE ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table HOST_DISK_PER
-- ----------------------------
ALTER TABLE HOST_DISK_PER ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table host_group
-- ----------------------------
ALTER TABLE HOST_GROUP ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table intrusion_info
-- ----------------------------
ALTER TABLE INTRUSION_INFO ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table log_info
-- ----------------------------
ALTER TABLE LOG_INFO ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table mail_set
-- ----------------------------
ALTER TABLE MAIL_SET ADD PRIMARY KEY (ID);

-- ----------------------------
-- Indexes structure for table mem_state
-- ----------------------------
CREATE INDEX MEM_ACC_HOST_INDEX ON MEM_STATE USING btree (HOST_NAME, CREATE_TIME);

-- ----------------------------
-- Primary Key structure for table mem_state
-- ----------------------------
ALTER TABLE MEM_STATE ADD PRIMARY KEY (ID);

-- ----------------------------
-- Indexes structure for table netio_state
-- ----------------------------
CREATE INDEX NETIO_ACC_HOST_INDEX ON NETIO_STATE USING btree (HOST_NAME, CREATE_TIME);

-- ----------------------------
-- Primary Key structure for table netio_state
-- ----------------------------
ALTER TABLE NETIO_STATE ADD PRIMARY KEY (ID);

-- ----------------------------
-- Indexes structure for table port_info
-- ----------------------------
CREATE INDEX PORT_HOST_NAME_INDEX ON PORT_INFO USING btree (HOST_NAME);

-- ----------------------------
-- Primary Key structure for table port_info
-- ----------------------------
ALTER TABLE PORT_INFO ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table SHELL_INFO
-- ----------------------------
ALTER TABLE SHELL_INFO ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table SHELL_STATE
-- ----------------------------
ALTER TABLE SHELL_STATE ADD PRIMARY KEY (ID);

-- ----------------------------
-- Indexes structure for table sys_load_state
-- ----------------------------
CREATE INDEX LOAD_ACC_HOST_INDEX ON SYS_LOAD_STATE USING btree (HOST_NAME, CREATE_TIME);

-- ----------------------------
-- Primary Key structure for table sys_load_state
-- ----------------------------
ALTER TABLE SYS_LOAD_STATE ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table system_info
-- ----------------------------
ALTER TABLE SYSTEM_INFO ADD PRIMARY KEY (ID);

-- ----------------------------
-- Indexes structure for table tcp_state
-- ----------------------------
CREATE INDEX TCP_ACC_HOST_INDEX ON TCP_STATE USING btree (HOST_NAME, CREATE_TIME);

-- ----------------------------
-- Primary Key structure for table tcp_state
-- ----------------------------
ALTER TABLE TCP_STATE ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table SNMP_INFO
-- ----------------------------
ALTER TABLE SNMP_INFO ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table SNMP_STATE
-- ----------------------------
ALTER TABLE SNMP_STATE ADD PRIMARY KEY (ID);

-- ----------------------------
-- Indexes structure for table SNMP_STATE
-- ----------------------------
CREATE INDEX SNMP_ID_CREATE_TIME ON SNMP_STATE USING btree (SNMP_INFO_ID, CREATE_TIME);

-- ----------------------------
-- Primary Key structure for table ACCOUNT_INFO
-- ----------------------------
ALTER TABLE ACCOUNT_INFO ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table SNMP_STATE
-- ----------------------------
ALTER TABLE CUSTOM_INFO ADD PRIMARY KEY (ID);

-- ----------------------------
-- Primary Key structure for table SNMP_STATE
-- ----------------------------
ALTER TABLE CUSTOM_STATE ADD PRIMARY KEY (ID);

-- ----------------------------
-- Indexes structure for table SNMP_STATE
-- ----------------------------
CREATE INDEX CUSTOM_STAT_INDEX ON CUSTOM_STATE USING btree (CUSTOM_INFO_ID, CREATE_TIME);

ALTER TABLE FTP_INFO ADD PRIMARY KEY (ID);

ALTER TABLE REPORT_INFO ADD PRIMARY KEY (ID);
ALTER TABLE REPORT_INSTANCE ADD PRIMARY KEY (ID);