/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud;

import cn.hutool.json.JSON;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.wgcloud.CommonConfig;
import com.wgcloud.RestUtil;
import com.wgcloud.entity.DbInfo;
import com.wgcloud.entity.DceInfo;
import com.wgcloud.entity.FtpInfo;
import com.wgcloud.entity.HeathMonitor;
import com.wgcloud.entity.SnmpDeepInfo;
import com.wgcloud.entity.SnmpInfo;
import com.wgcloud.service.K8sService;
import com.wgcloud.service.KafkaService;
import com.wgcloud.service.TaskService;
import com.wgcloud.util.ActivemqUtil;
import com.wgcloud.util.BatchData;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.PowerEnvUtil;
import com.wgcloud.util.RabbitmqUtil;
import com.wgcloud.util.RedisUtil;
import com.wgcloud.util.SnmpDeepUtil;
import com.wgcloud.util.SnmpUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ScheduledTask {
    private Logger logger = LoggerFactory.getLogger(ScheduledTask.class);
    @Autowired
    private RestUtil restUtil;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private K8sService k8sService;
    @Autowired
    private KafkaService kafkaService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private PowerEnvUtil powerEnvUtil;
    @Autowired
    private RabbitmqUtil rabbitmqUtil;
    @Autowired
    private ActivemqUtil activemqUtil;
    @Value(value="${k8s.base-url:}")
    private String baseUrl;
    @Value(value="${k8s.name:}")
    private String k8sName;
    @Value(value="${kafka.bootstrap-servers:}")
    private String bootstrapServers;
    @Value(value="${redis.names:}")
    private String redisNames;
    @Value(value="${redis.nodes:}")
    private String redisNodes;

    @Scheduled(initialDelay=30000L, fixedRateString="${base.dceTimes}000")
    public void dceInfoTask() {
        block6: {
            this.logger.info("ping\u8bbe\u5907\u76d1\u63a7\u4efb\u52a1------------" + DateUtil.getDateTimeString((Date)new Date()));
            JSONObject jsonObject = new JSONObject();
            ThreadPoolExecutor executorDceInfo = new ThreadPoolExecutor(10, 30, 2L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>());
            List dceInfosUpdate = Collections.synchronizedList(new ArrayList());
            try {
                if (BatchData.dceInfoList.size() > 0) {
                    for (DceInfo h : BatchData.dceInfoList) {
                        Runnable runnable = () -> this.taskService.dceInfoTask(h, dceInfosUpdate);
                        executorDceInfo.execute(runnable);
                    }
                    executorDceInfo.shutdown();
                    while (true) {
                        if (executorDceInfo.isTerminated()) {
                            this.logger.info("ping\u6240\u6709\u7ebf\u7a0b\u90fd\u6267\u884c\u5b8c\u6210\u4e86" + dceInfosUpdate.size());
                            this.logger.info(JSONUtil.toJsonStr(dceInfosUpdate));
                            jsonObject.set("dceInfosUpdate", dceInfosUpdate);
                            this.restUtil.post(this.commonConfig.getServerPostUrl() + "" + "/agentDceInfoGo/minTask", jsonObject);
                            break block6;
                        }
                        Thread.sleep(500L);
                    }
                }
                this.logger.info("ping\u6ca1\u6709\u914d\u7f6e\u6570\u636e\uff0c\u65e0\u9700\u8fdb\u884c\u76d1\u6d4b");
            }
            catch (Exception e) {
                this.logger.error("\u6570\u901a\u8bbe\u5907PING\u68c0\u6d4b\u4efb\u52a1\u9519\u8bef", (Throwable)e);
            }
        }
    }

    @Scheduled(initialDelay=50000L, fixedRateString="${base.heathTimes}000")
    public void heathMonitorTask() {
        block6: {
            this.logger.info("\u670d\u52a1\u63a5\u53e3\u76d1\u63a7\u4efb\u52a1------------" + DateUtil.getDateTimeString((Date)new Date()));
            JSONObject jsonObject = new JSONObject();
            ThreadPoolExecutor executorHeath = new ThreadPoolExecutor(10, 30, 2L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>());
            List heathMonitorsUpdate = Collections.synchronizedList(new ArrayList());
            try {
                if (BatchData.heathMonitorList.size() > 0) {
                    for (HeathMonitor h : BatchData.heathMonitorList) {
                        Runnable runnable = () -> this.taskService.heathMonitorTask(h, heathMonitorsUpdate);
                        executorHeath.execute(runnable);
                    }
                    executorHeath.shutdown();
                    while (true) {
                        if (executorHeath.isTerminated()) {
                            this.logger.info("\u670d\u52a1\u63a5\u53e3\u76d1\u63a7\u6240\u6709\u7ebf\u7a0b\u90fd\u6267\u884c\u5b8c\u6210\u4e86" + heathMonitorsUpdate.size());
                            jsonObject.set("heathMonitorsUpdate", heathMonitorsUpdate);
                            this.restUtil.post(this.commonConfig.getServerPostUrl() + "" + "/agentHeathMonitorGo/minTask", jsonObject);
                            break block6;
                        }
                        Thread.sleep(500L);
                    }
                }
                this.logger.info("\u670d\u52a1\u63a5\u53e3\u6ca1\u6709\u914d\u7f6e\u6570\u636e\uff0c\u65e0\u9700\u8fdb\u884c\u76d1\u6d4b");
            }
            catch (Exception e) {
                this.logger.error("\u670d\u52a1\u63a5\u53e3\u68c0\u6d4b\u4efb\u52a1\u9519\u8bef", (Throwable)e);
            }
        }
    }

    @Scheduled(initialDelay=60000L, fixedRateString="${base.dbTableTimes}000")
    public void tableCountTask() {
        this.logger.info("\u6570\u636e\u8868\u76d1\u63a7\u4efb\u52a1------------" + DateUtil.getDateTimeString((Date)new Date()));
        JSONObject jsonObject = new JSONObject();
        List dbTablesUpdate = Collections.synchronizedList(new ArrayList());
        List dbInfosUpdate = Collections.synchronizedList(new ArrayList());
        try {
            if (BatchData.dbInfoList.size() > 0) {
                for (DbInfo dbInfo : BatchData.dbInfoList) {
                    this.taskService.tableCountTask(dbInfo, dbInfosUpdate, dbTablesUpdate);
                }
                this.logger.info("\u6570\u636e\u8868\u76d1\u63a7\u4efb\u52a1\u6240\u6709\u7ebf\u7a0b\u90fd\u6267\u884c\u5b8c\u6210\u4e86" + BatchData.dbInfoList.size());
                jsonObject.set("dbTablesUpdate", dbTablesUpdate);
                jsonObject.set("dbInfosUpdate", dbInfosUpdate);
                this.restUtil.post(this.commonConfig.getServerPostUrl() + "" + "/agentDbTableGo/minTask", jsonObject);
            } else {
                this.logger.info("\u6570\u636e\u8868\u6ca1\u6709\u914d\u7f6e\u6570\u636e\uff0c\u65e0\u9700\u8fdb\u884c\u76d1\u6d4b");
            }
        }
        catch (Exception e) {
            this.logger.error("\u6570\u636e\u8868\u76d1\u63a7\u4efb\u52a1\u9519\u8bef", (Throwable)e);
        }
    }

    @Scheduled(initialDelay=90000L, fixedRateString="${base.snmpTimes}000")
    public void snmpInfoTask() {
        block6: {
            this.logger.info("snmp\u76d1\u63a7\u4efb\u52a1------------" + DateUtil.getDateTimeString((Date)new Date()));
            JSONObject jsonObject = new JSONObject();
            List snmpInfosUpdate = Collections.synchronizedList(new ArrayList());
            ThreadPoolExecutor executorSnmp = new ThreadPoolExecutor(10, 30, 2L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>());
            try {
                if (BatchData.snmpInfoList.size() > 0) {
                    Map snmpMap = SnmpUtil.getOnLineList((List)BatchData.snmpInfoList);
                    for (SnmpInfo h : BatchData.snmpInfoList) {
                        Runnable runnable = () -> this.taskService.snmpInfoTask(snmpMap, h, snmpInfosUpdate);
                        executorSnmp.execute(runnable);
                    }
                    executorSnmp.shutdown();
                    while (true) {
                        if (executorSnmp.isTerminated()) {
                            this.logger.info("snmp\u76d1\u63a7\u4efb\u52a1\u6240\u6709\u7ebf\u7a0b\u90fd\u6267\u884c\u5b8c\u6210\u4e86" + BatchData.snmpInfoList.size());
                            jsonObject.set("snmpInfosUpdate", snmpInfosUpdate);
                            this.logger.info("snmp\u63d0\u4ea4\u6570\u636e------------" + jsonObject.toString());
                            this.restUtil.post(this.commonConfig.getServerPostUrl() + "" + "/agentSnmpInfoGo/minTask", jsonObject);
                            break block6;
                        }
                        Thread.sleep(500L);
                    }
                }
                this.logger.info("snmp\u6ca1\u6709\u914d\u7f6e\u6570\u636e\uff0c\u65e0\u9700\u8fdb\u884c\u76d1\u6d4b");
            }
            catch (Exception e) {
                this.logger.error("\u6570\u901a\u8bbe\u5907SNMP\u68c0\u6d4b\u4efb\u52a1\u9519\u8bef", (Throwable)e);
            }
        }
    }

    @Scheduled(initialDelay=120000L, fixedRateString="${base.ftpTimes}000")
    public void ftpInfoTask() {
        block6: {
            this.logger.info("ftp\u76d1\u63a7\u4efb\u52a1------------" + DateUtil.getDateTimeString((Date)new Date()));
            JSONObject jsonObject = new JSONObject();
            List ftpInfosUpdate = Collections.synchronizedList(new ArrayList());
            ThreadPoolExecutor executorFtp = new ThreadPoolExecutor(10, 30, 2L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>());
            try {
                if (BatchData.ftpInfoList.size() > 0) {
                    for (FtpInfo f : BatchData.ftpInfoList) {
                        Runnable runnable = () -> this.taskService.ftpInfoTask(f, ftpInfosUpdate);
                        executorFtp.execute(runnable);
                    }
                    executorFtp.shutdown();
                    while (true) {
                        if (executorFtp.isTerminated()) {
                            this.logger.info("ftp\u76d1\u63a7\u4efb\u52a1\u6240\u6709\u7ebf\u7a0b\u90fd\u6267\u884c\u5b8c\u6210\u4e86" + BatchData.snmpInfoList.size());
                            jsonObject.set("ftpInfosUpdate", ftpInfosUpdate);
                            this.restUtil.post(this.commonConfig.getServerPostUrl() + "" + "/agentFtpInfoGo/minTask", jsonObject);
                            break block6;
                        }
                        Thread.sleep(500L);
                    }
                }
                this.logger.info("ftp\u6ca1\u6709\u914d\u7f6e\u6570\u636e\uff0c\u65e0\u9700\u8fdb\u884c\u76d1\u6d4b");
            }
            catch (Exception e) {
                this.logger.error("ftpInfoTask\u68c0\u6d4b\u4efb\u52a1\u9519\u8bef", (Throwable)e);
            }
        }
    }

    @Scheduled(initialDelay=150000L, fixedRateString="${k8s.submitTimes}000")
    public void k8sTask() {
        this.logger.info("k8s\u76d1\u63a7\u4efb\u52a1------------" + DateUtil.getDateTimeString((Date)new Date()));
        if (StringUtils.isEmpty((CharSequence)this.baseUrl)) {
            this.logger.info("k8s\u6ca1\u6709\u914d\u7f6e\u6570\u636e\uff0c\u65e0\u9700\u8fdb\u884c\u76d1\u6d4b");
            return;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            List namespaceDtoList = this.k8sService.listK8sNamespaces();
            jsonObject.set("namespace", (Object)namespaceDtoList);
            jsonObject.set("pod", (Object)this.k8sService.listK8sPod());
            jsonObject.set("service", (Object)this.k8sService.listK8sServices());
            jsonObject.set("container", (Object)this.k8sService.listK8sContainers());
            jsonObject.set("node", (Object)this.k8sService.listK8sNode());
            jsonObject.set("deployment", (Object)this.k8sService.listK8sDeployment(namespaceDtoList));
            jsonObject.set("k8sName", (Object)this.k8sName);
            this.logger.info("k8s jsonObject--------" + jsonObject.toString());
            this.restUtil.post(this.commonConfig.getServerPostUrl() + "" + "/agentK8sGo/minTask", jsonObject);
        }
        catch (Exception e) {
            this.logger.error("k8s\u76d1\u63a7\u4efb\u52a1\u9519\u8bef", (Throwable)e);
        }
    }

    @Scheduled(initialDelay=160000L, fixedRateString="${kafka.submitTimes}000")
    public void kafkaTask() {
        this.logger.info("kafka\u76d1\u63a7\u4efb\u52a1------------" + DateUtil.getDateTimeString((Date)new Date()));
        if (StringUtils.isEmpty((CharSequence)this.bootstrapServers)) {
            this.logger.info("kafka\u6ca1\u6709\u914d\u7f6e\u6570\u636e\uff0c\u65e0\u9700\u8fdb\u884c\u76d1\u6d4b");
            return;
        }
        try {
            this.kafkaService.countConsumerOffset();
        }
        catch (Exception e) {
            this.logger.error("kafka\u76d1\u63a7\u4efb\u52a1\u9519\u8bef", (Throwable)e);
        }
    }

    @Scheduled(initialDelay=170000L, fixedRateString="${redis.submitTimes}000")
    public void redisTask() {
        this.logger.info("redis\u6027\u80fd\u53c2\u6570\u76d1\u63a7\u4efb\u52a1------------" + DateUtil.getDateTimeString((Date)new Date()));
        if (StringUtils.isEmpty((CharSequence)this.redisNodes)) {
            this.logger.info("redis\u6ca1\u6709\u914d\u7f6e\u6570\u636e\uff0c\u65e0\u9700\u8fdb\u884c\u76d1\u6d4b");
            return;
        }
        try {
            List resultList = RedisUtil.redisTask((String)this.redisNames, (String)this.redisNodes);
            if (null != resultList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.set("data", (Object)resultList);
                this.logger.info("redis\u68c0\u6d4b\u8fd0\u884c\u6027\u80fd\u6570\u636e------" + JSONUtil.toJsonStr((JSON)jsonObject));
                this.restUtil.post(this.commonConfig.getServerPostUrl() + "" + "/agentRedisGo/minTask", jsonObject);
            }
        }
        catch (Exception e) {
            this.logger.error("redis\u6027\u80fd\u53c2\u6570\u76d1\u63a7\u4efb\u52a1\u9519\u8bef", (Throwable)e);
        }
    }

    @Scheduled(initialDelay=180000L, fixedRateString="${powerEnv.submitTimes}000")
    public void powerEnvTask() {
        this.logger.info("\u52a8\u73af\u4fe1\u606f\u76d1\u63a7\u4efb\u52a1------------" + DateUtil.getDateTimeString((Date)new Date()));
        try {
            JSONObject jsonObject = this.powerEnvUtil.gatherInfo();
            if (null != jsonObject) {
                this.logger.info("\u52a8\u73af\u4fe1\u606f\u76d1\u63a7\u6570\u636e------" + JSONUtil.toJsonStr((JSON)jsonObject));
                this.restUtil.post(this.commonConfig.getServerPostUrl() + "" + "/agentPowerEnvGo/minTask", jsonObject);
            }
        }
        catch (Exception e) {
            this.logger.error("\u52a8\u73af\u4fe1\u606f\u76d1\u63a7\u4efb\u52a1\u9519\u8bef", (Throwable)e);
        }
    }

    @Scheduled(initialDelay=190000L, fixedRateString="${rabbitmq.submitTimes}000")
    public void rabbitmqTask() {
        this.logger.info("rabbitmq\u76d1\u63a7\u4efb\u52a1------------" + DateUtil.getDateTimeString((Date)new Date()));
        try {
            JSONObject jsonObject = new JSONObject();
            List resultList = this.rabbitmqUtil.gatherInfo();
            if (null != resultList) {
                jsonObject.set("data", (Object)resultList);
                this.logger.info("rabbitmq\u76d1\u63a7\u6570\u636e------" + JSONUtil.toJsonStr((JSON)jsonObject));
                this.restUtil.post(this.commonConfig.getServerPostUrl() + "" + "/agentKafkaGo/minTaskRabbitmq", jsonObject);
            }
        }
        catch (Exception e) {
            this.logger.error("rabbitmq\u4fe1\u606f\u76d1\u63a7\u4efb\u52a1\u9519\u8bef", (Throwable)e);
        }
    }

    @Scheduled(initialDelay=200000L, fixedRateString="${activemq.submitTimes}000")
    public void activemqTask() {
        this.logger.info("activemq\u76d1\u63a7\u4efb\u52a1------------" + DateUtil.getDateTimeString((Date)new Date()));
        try {
            JSONObject jsonObject = new JSONObject();
            List resultList = this.activemqUtil.gatherInfo();
            if (null != resultList) {
                jsonObject.set("data", (Object)resultList);
                this.logger.info("activemq\u76d1\u63a7\u6570\u636e------" + JSONUtil.toJsonStr((JSON)jsonObject));
                this.restUtil.post(this.commonConfig.getServerPostUrl() + "" + "/agentKafkaGo/minTaskActivemq", jsonObject);
            }
        }
        catch (Exception e) {
            this.logger.error("activemq\u4fe1\u606f\u76d1\u63a7\u4efb\u52a1\u9519\u8bef", (Throwable)e);
        }
    }

    @Scheduled(initialDelay=210000L, fixedRateString="${base.snmpDeepTimes}000")
    public void snmpDeepInfoTask() {
        block6: {
            this.logger.info("snmp\u6df1\u5ea6\u76d1\u63a7\u4efb\u52a1------------" + DateUtil.getDateTimeString((Date)new Date()));
            JSONObject jsonObject = new JSONObject();
            List snmpDeepInfosUpdate = Collections.synchronizedList(new ArrayList());
            List statesUpdate = Collections.synchronizedList(new ArrayList());
            ThreadPoolExecutor executorDb = new ThreadPoolExecutor(10, 30, 2L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>());
            try {
                if (BatchData.snmpDeepInfoList.size() > 0) {
                    Map snmpMap = SnmpDeepUtil.getOnLineList((List)BatchData.snmpDeepInfoList);
                    for (SnmpDeepInfo snmpDeepInfo : BatchData.snmpDeepInfoList) {
                        Runnable runnable = () -> this.taskService.snmpDeepTask(snmpMap, snmpDeepInfo, snmpDeepInfosUpdate, statesUpdate);
                        executorDb.execute(runnable);
                    }
                    executorDb.shutdown();
                    while (true) {
                        if (executorDb.isTerminated()) {
                            this.logger.info("snmp\u6df1\u5ea6\u76d1\u63a7\u4efb\u52a1\u6240\u6709\u7ebf\u7a0b\u90fd\u6267\u884c\u5b8c\u6210\u4e86" + BatchData.snmpDeepInfoList.size());
                            jsonObject.set("snmpInfosUpdate", snmpDeepInfosUpdate);
                            jsonObject.set("snmpDeepStateList", statesUpdate);
                            this.restUtil.post(this.commonConfig.getServerPostUrl() + "" + "/agentSnmpInfoGo/minTaskDeep", jsonObject);
                            break block6;
                        }
                        Thread.sleep(500L);
                    }
                }
                this.logger.info("snmp\u6df1\u5ea6\u76d1\u63a7\u6ca1\u6709\u914d\u7f6e\u6570\u636e\uff0c\u65e0\u9700\u8fdb\u884c\u76d1\u6d4b");
            }
            catch (Exception e) {
                this.logger.error("snmp\u6df1\u5ea6\u76d1\u63a7\u4efb\u52a1\u9519\u8bef", (Throwable)e);
            }
        }
    }

    @Scheduled(initialDelay=220000L, fixedRate=0x6DDD00L)
    public void submitServerBackupIPTask() {
        try {
            JSONObject paramsJson = new JSONObject();
            paramsJson.set("bindIp", (Object)this.commonConfig.getBindIp());
            paramsJson.set("version", (Object)"v3.6.2");
            this.restUtil.post(this.commonConfig.getServerUrl() + "" + "/serverBackupMonitor/agentList", paramsJson);
        }
        catch (Exception e) {
            this.logger.error("\u5411server\u4e0a\u62a5\u672c\u673abindIp\u9519\u8bef", (Throwable)e);
        }
    }

    @Scheduled(initialDelay=10000L, fixedRate=600000L)
    public void getServerListTask() {
        this.logger.info("wgcloud-server-backup v3.6.2 getServerListTask------------" + DateUtil.getDateTimeString((Date)new Date()));
        this.taskService.getServerListTask();
    }
}

