/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.wgcloud.CommonConfig;
import com.wgcloud.RestUtil;
import com.wgcloud.ScheduledTask;
import com.wgcloud.dto.HeathMonitorResDto;
import com.wgcloud.entity.DbInfo;
import com.wgcloud.entity.DbTable;
import com.wgcloud.entity.DceInfo;
import com.wgcloud.entity.FtpInfo;
import com.wgcloud.entity.HeathMonitor;
import com.wgcloud.entity.SnmpDeepInfo;
import com.wgcloud.entity.SnmpDeepState;
import com.wgcloud.entity.SnmpInfo;
import com.wgcloud.util.BatchData;
import com.wgcloud.util.DESUtil;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.JschUtil;
import com.wgcloud.util.MongoDbUtil;
import com.wgcloud.util.PingUtil;
import com.wgcloud.util.RedisUtil;
import com.wgcloud.util.SnmpDeepUtil;
import com.wgcloud.util.SnmpUtil;
import com.wgcloud.util.jdbc.ConnectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class TaskService {
    private Logger logger = LoggerFactory.getLogger(ScheduledTask.class);
    @Autowired
    private RestUtil restUtil;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private ConnectionUtil connectionUtil;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private MongoDbUtil mongoDbUtil;

    private void testThread() {
        new Thread(() -> this.logger.info("\u542f\u52a8\u5b50\u7ebf\u7a0b\u6d4b\u8bd5")).start();
    }

    public void dceInfoTask(DceInfo h, List<DceInfo> dceInfosUpdate) {
        long resTimes = PingUtil.pingDceInfo((DceInfo)h, (String)h.getHostname(), (int)1, (int)4);
        h.setResTimes(Integer.valueOf(resTimes + ""));
        DceInfo dceInfo = new DceInfo();
        dceInfo.setId(h.getId());
        dceInfo.setResTimes(h.getResTimes());
        dceInfo.setTestErrorMsg(h.getTestErrorMsg());
        dceInfosUpdate.add(dceInfo);
        this.logger.info("ping---------" + h.getHostname());
    }

    public void heathMonitorTask(HeathMonitor h, List<HeathMonitorResDto> heathMonitorsUpdate) {
        HeathMonitorResDto heathMonitorResDto = new HeathMonitorResDto();
        HashMap headerMap = FormatUtil.displayHeaderJson((HeathMonitor)h);
        HashMap formMap = FormatUtil.displayFormJson((HeathMonitor)h);
        heathMonitorResDto = "POST".equals(h.getMethod()) ? (formMap.isEmpty() ? this.restUtil.post(h, headerMap) : this.restUtil.postFormData(h, headerMap, formMap)) : this.restUtil.get(h, headerMap);
        heathMonitorResDto.setId(h.getId());
        heathMonitorResDto.setResponseBodySize(h.getResponseBodySize());
        heathMonitorsUpdate.add(heathMonitorResDto);
    }

    public void tableCountTask(DbInfo dbInfo, List<DbInfo> dbInfosUpdate, List<DbTable> dbTablesUpdate) {
        try {
            if ("redis".equals(dbInfo.getDbType())) {
                this.redisUtil.connectRedis(dbInfo);
                DbInfo dbInfoResult = new DbInfo();
                dbInfoResult.setId(dbInfo.getId());
                dbInfoResult.setDbState(dbInfo.getDbState());
                dbInfoResult.setTestErrorMsg(dbInfo.getTestErrorMsg());
                dbInfoResult.setResTimes(dbInfo.getResTimes());
                dbInfosUpdate.add(dbInfoResult);
                return;
            }
            if ("mongodb".equals(dbInfo.getDbType())) {
                this.mongoDbUtil.connectMongoDb(dbInfo);
                DbInfo dbInfoResult = new DbInfo();
                dbInfoResult.setId(dbInfo.getId());
                dbInfoResult.setDbState(dbInfo.getDbState());
                dbInfoResult.setTestErrorMsg(dbInfo.getTestErrorMsg());
                dbInfoResult.setResTimes(dbInfo.getResTimes());
                dbInfosUpdate.add(dbInfoResult);
                return;
            }
            String tableCount = "";
            JdbcTemplate jdbcTemplate = this.connectionUtil.getJdbcTemplate(dbInfo);
            DbInfo dbInfoResult = new DbInfo();
            dbInfoResult.setId(dbInfo.getId());
            dbInfoResult.setDbState(dbInfo.getDbState());
            dbInfoResult.setResTimes(dbInfo.getResTimes());
            dbInfoResult.setTestErrorMsg(dbInfo.getTestErrorMsg());
            dbInfosUpdate.add(dbInfoResult);
            for (DbTable dbTable : BatchData.dbTableList) {
                if (StringUtils.isEmpty((CharSequence)dbTable.getWhereVal()) || !dbTable.getDbInfoId().equals(dbInfo.getId())) continue;
                tableCount = this.connectionUtil.queryTableCount(jdbcTemplate, dbTable);
                DbTable dbTableResult = new DbTable();
                dbTableResult.setId(dbTable.getId());
                dbTableResult.setTableCount(tableCount);
                dbTableResult.setRemark(dbTable.getRemark());
                dbTableResult.setResultExp(dbTable.getResultExp());
                dbTableResult.setState(dbTable.getState());
                dbTableResult.setResTimes(dbTable.getResTimes());
                dbTableResult.setTestErrorMsg(dbTable.getTestErrorMsg());
                dbTableResult.setWarnLevel(dbTable.getWarnLevel());
                dbTableResult.setDbInfoId(dbInfo.getId());
                dbTablesUpdate.add(dbTableResult);
            }
        }
        catch (Exception e) {
            this.logger.error("\u6570\u636e\u8868\u76d1\u63a7\u4efb\u52a1\u9519\u8bef", (Throwable)e);
        }
    }

    public void snmpInfoTask(Map<String, String> snmpMap, SnmpInfo h, List<SnmpInfo> snmpInfosUpdate) {
        try {
            SnmpInfo snmpInfoNew = new SnmpInfo();
            SnmpInfo snmpInfo = null;
            if ("1".equals(snmpMap.get(h.getHostname()))) {
                snmpInfo = SnmpUtil.getAvgSnmpInfo((SnmpInfo)h);
            }
            snmpInfoNew.setId(h.getId());
            snmpInfoNew.setState("1");
            if (null != snmpInfo) {
                snmpInfoNew.setRecvAvg(snmpInfo.getRecvAvg());
                snmpInfoNew.setSentAvg(snmpInfo.getSentAvg());
                snmpInfoNew.setBytesSent(snmpInfo.getBytesSent());
                snmpInfoNew.setBytesRecv(snmpInfo.getBytesRecv());
                snmpInfoNew.setMemPer(snmpInfo.getMemPer());
                snmpInfoNew.setCpuPer(snmpInfo.getCpuPer());
                snmpInfoNew.setDiskPer(snmpInfo.getDiskPer());
                snmpInfoNew.setTemperatureValue(snmpInfo.getTemperatureValue());
                snmpInfoNew.setVoltageValue(snmpInfo.getVoltageValue());
                snmpInfoNew.setIfOperStatusValue(snmpInfo.getIfOperStatusValue());
                snmpInfoNew.setSysDescVal(snmpInfo.getSysDescVal());
                if (!StringUtils.isEmpty((CharSequence)snmpInfo.getRecvAvgSum())) {
                    snmpInfoNew.setRecvAvgSum(snmpInfo.getRecvAvgSum());
                } else {
                    snmpInfoNew.setRecvAvgSum("0");
                }
                if (!StringUtils.isEmpty((CharSequence)snmpInfo.getSentAvgSum())) {
                    snmpInfoNew.setSentAvgSum(snmpInfo.getSentAvgSum());
                } else {
                    snmpInfoNew.setSentAvgSum("0");
                }
            }
            if (null == snmpInfo) {
                snmpInfoNew.setState("2");
            }
            if (null != snmpInfo) {
                snmpInfoNew.setTestErrorMsg(snmpInfo.getTestErrorMsg());
            }
            snmpInfosUpdate.add(snmpInfoNew);
        }
        catch (Exception e) {
            this.logger.error("snmp\u76d1\u63a7\u4efb\u52a1\u9519\u8bef", (Throwable)e);
        }
    }

    public void ftpInfoTask(FtpInfo f, List<FtpInfo> ftpInfosUpdate) {
        if ("SFTP".equals(f.getFtpType())) {
            JschUtil.testSFtpSession((FtpInfo)f);
        } else {
            JschUtil.testFTPClient((FtpInfo)f);
        }
        FtpInfo ftpInfo = new FtpInfo();
        ftpInfo.setId(f.getId());
        ftpInfo.setState(f.getState());
        ftpInfo.setResTimes(f.getResTimes());
        ftpInfo.setTestErrorMsg(f.getTestErrorMsg());
        ftpInfosUpdate.add(ftpInfo);
    }

    public void snmpDeepTask(Map<String, String> snmpMap, SnmpDeepInfo snmpDeepInfo, List<SnmpDeepInfo> snmpDeepInfosUpdate, List<JSONObject> statesUpdate) {
        try {
            SnmpDeepInfo snmpInfoForUpdate = new SnmpDeepInfo();
            snmpInfoForUpdate.setId(snmpDeepInfo.getId());
            ArrayList<SnmpDeepState> snmpDeepStateList = new ArrayList<SnmpDeepState>();
            if ("1".equals(snmpMap.get(snmpDeepInfo.getHostname()))) {
                for (SnmpDeepState snmpDeepState : BatchData.snmpDeepStateList) {
                    if (!snmpDeepState.getSnmpDeepInfoId().equals(snmpDeepInfo.getId())) continue;
                    snmpDeepStateList.add(snmpDeepState);
                }
                ArrayList<SnmpDeepState> getList = new ArrayList<SnmpDeepState>();
                ArrayList<SnmpDeepState> walkList = new ArrayList<SnmpDeepState>();
                for (SnmpDeepState snmpDeepState : snmpDeepStateList) {
                    if ("SNMPGET".equals(snmpDeepState.getOidType())) {
                        getList.add(snmpDeepState);
                        continue;
                    }
                    walkList.add(snmpDeepState);
                }
                String errorMsgGet = SnmpDeepUtil.snmpGet((SnmpDeepInfo)snmpDeepInfo, getList, statesUpdate);
                String errorMsgWalk = SnmpDeepUtil.walkSnmp((SnmpDeepInfo)snmpDeepInfo, walkList, statesUpdate);
                if (!StringUtils.isEmpty((CharSequence)errorMsgGet) || !StringUtils.isEmpty((CharSequence)errorMsgWalk)) {
                    snmpInfoForUpdate.setTestErrorMsg(errorMsgGet + errorMsgWalk);
                }
                snmpInfoForUpdate.setState("1");
            } else {
                snmpInfoForUpdate.setState("2");
                snmpInfoForUpdate.setTestErrorMsg("Cannot ping device");
            }
            snmpDeepInfosUpdate.add(snmpInfoForUpdate);
        }
        catch (Exception e) {
            this.logger.error("snmp\u6df1\u5ea6\u76d1\u63a7\u4efb\u52a1\u9519\u8bef", (Throwable)e);
        }
    }

    public void getServerListTask() {
        BatchData.dbInfoList.clear();
        BatchData.dbTableList.clear();
        BatchData.dceInfoList.clear();
        BatchData.snmpInfoList.clear();
        BatchData.heathMonitorList.clear();
        BatchData.ftpInfoList.clear();
        BatchData.snmpDeepInfoList.clear();
        BatchData.snmpDeepStateList.clear();
        try {
            JSONObject paramsJson = new JSONObject();
            paramsJson.set("dbInfoNames", (Object)this.commonConfig.getDbInfoNames());
            paramsJson.set("SERVER_BACKUP_FLAG", (Object)"SERVER_BACKUP_FLAG");
            String resultJson = "";
            if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getDbInfoNames())) {
                if ("all".equals(this.commonConfig.getDbInfoNames())) {
                    paramsJson.set("dbInfoNames", (Object)"");
                }
                resultJson = this.restUtil.post(this.commonConfig.getServerUrl() + "" + "/dbInfo/agentList", paramsJson);
            }
            if (!StringUtils.isEmpty((CharSequence)resultJson)) {
                this.logger.info("\u76d1\u63a7\u6570\u636e\u5e93\u8fd4\u56de\u6570\u636eresultJson------------" + resultJson);
                JSONObject resultJsonObj = JSONUtil.parseObj((String)resultJson);
                if ("0".equals(resultJsonObj.getStr((Object)"code"))) {
                    JSONArray resultArray = JSONUtil.parseArray((String)resultJsonObj.getStr((Object)"data"));
                    if (resultArray.size() > 0) {
                        BatchData.dbInfoList = JSONUtil.toList((JSONArray)resultArray, DbInfo.class);
                        for (DbInfo dbInfo : BatchData.dbInfoList) {
                            dbInfo.setUserName(DESUtil.decrypt((String)dbInfo.getUserName()));
                            dbInfo.setDbUrl(DESUtil.decrypt((String)dbInfo.getDbUrl()));
                            dbInfo.setPasswd(DESUtil.decrypt((String)dbInfo.getPasswd()));
                        }
                    }
                    this.logger.debug("\u76d1\u63a7\u6570\u636e\u5e93\u6570\u91cf------------" + BatchData.dbInfoList.size());
                }
            }
            if (BatchData.dbInfoList.size() > 0) {
                String dbInfoIdsStr = "";
                for (DbInfo dbInfo : BatchData.dbInfoList) {
                    dbInfoIdsStr = dbInfoIdsStr + dbInfo.getId() + ",";
                }
                dbInfoIdsStr = dbInfoIdsStr.substring(0, dbInfoIdsStr.length() - 1);
                paramsJson.clear();
                paramsJson.set("dbInfoIds", (Object)dbInfoIdsStr);
                paramsJson.set("SERVER_BACKUP_FLAG", (Object)"SERVER_BACKUP_FLAG");
                String resultDbTableJson = this.restUtil.post(this.commonConfig.getServerUrl() + "" + "/dbTable/agentList", paramsJson);
                if (!StringUtils.isEmpty((CharSequence)resultDbTableJson)) {
                    this.logger.info("\u6570\u636e\u8868\u8fd4\u56de\u6570\u636eresultDbTableJson------------" + resultDbTableJson);
                    JSONObject resultJsonObj = JSONUtil.parseObj((String)resultDbTableJson);
                    if ("0".equals(resultJsonObj.getStr((Object)"code"))) {
                        JSONArray resultDbTableArray = JSONUtil.parseArray((String)resultJsonObj.getStr((Object)"data"));
                        if (resultDbTableArray.size() > 0) {
                            BatchData.dbTableList = JSONUtil.toList((JSONArray)resultDbTableArray, DbTable.class);
                            for (DbTable dbTable : BatchData.dbTableList) {
                                dbTable.setWhereVal(DESUtil.decrypt((String)dbTable.getWhereVal()));
                            }
                        }
                        this.logger.debug("\u6570\u636e\u8868\u6570\u91cf------------" + BatchData.dbTableList.size());
                    }
                }
            }
            JSONObject paramsPingJson = new JSONObject();
            if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getPingHostNames()) || !StringUtils.isEmpty((CharSequence)this.commonConfig.getPingHostGroupName())) {
                if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getPingHostNames())) {
                    paramsPingJson.set("dceHostNames", (Object)this.commonConfig.getPingHostNames());
                }
                if ("all".equals(this.commonConfig.getPingHostNames()) || "all".equals(this.commonConfig.getPingHostGroupName())) {
                    paramsPingJson.set("dceHostNames", (Object)"");
                    paramsPingJson.set("groupName", (Object)"");
                    this.pingRequestServerHandler(paramsPingJson);
                } else if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getPingHostGroupName())) {
                    JSONObject groupNames;
                    for (String groupName : groupNames = this.commonConfig.getPingHostGroupName().split(",")) {
                        paramsPingJson.set("groupName", (Object)groupName);
                        this.pingRequestServerHandler(paramsPingJson);
                    }
                } else {
                    this.pingRequestServerHandler(paramsPingJson);
                }
            }
            JSONObject paramsSnmpJson = new JSONObject();
            paramsSnmpJson.set("snmpHostNames", (Object)this.commonConfig.getSnmpHostNames());
            paramsSnmpJson.set("SERVER_BACKUP_FLAG", (Object)"SERVER_BACKUP_FLAG");
            String resultSnmpJson = "";
            if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getSnmpHostNames())) {
                if ("all".equals(this.commonConfig.getSnmpHostNames())) {
                    paramsSnmpJson.set("snmpHostNames", (Object)"");
                }
                resultSnmpJson = this.restUtil.post(this.commonConfig.getServerUrl() + "" + "/snmpInfo/agentList", paramsSnmpJson);
            }
            if (!StringUtils.isEmpty((CharSequence)resultSnmpJson)) {
                this.logger.info("\u6570\u901a\u8bbe\u5907SNMP\u8fd4\u56de\u6570\u636eresultSnmpJson------------" + resultSnmpJson);
                JSONObject resultSnmpJsonObj = JSONUtil.parseObj((String)resultSnmpJson);
                if ("0".equals(resultSnmpJsonObj.getStr((Object)"code"))) {
                    JSONArray resultArray = JSONUtil.parseArray((String)resultSnmpJsonObj.getStr((Object)"data"));
                    if (resultArray.size() > 0) {
                        BatchData.snmpInfoList = JSONUtil.toList((JSONArray)resultArray, SnmpInfo.class);
                    }
                    this.logger.debug("\u6570\u901a\u8bbe\u5907SNMP\u6570\u91cf------------" + BatchData.snmpInfoList.size());
                }
            }
            JSONObject paramsHeathJson = new JSONObject();
            paramsHeathJson.set("heathNames", (Object)this.commonConfig.getHeathNames());
            paramsHeathJson.set("SERVER_BACKUP_FLAG", (Object)"SERVER_BACKUP_FLAG");
            String resultHeathJson = "";
            if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getHeathNames())) {
                if ("all".equals(this.commonConfig.getHeathNames())) {
                    paramsHeathJson.set("heathNames", (Object)"");
                }
                resultHeathJson = this.restUtil.post(this.commonConfig.getServerUrl() + "" + "/heathMonitor/agentList", paramsHeathJson);
            }
            if (!StringUtils.isEmpty((CharSequence)resultHeathJson)) {
                this.logger.info("\u670d\u52a1\u63a5\u53e3\u8fd4\u56de\u6570\u636eresultHeathJson------------" + resultHeathJson);
                JSONObject resultHeathJsonObj = JSONUtil.parseObj((String)resultHeathJson);
                if ("0".equals(resultHeathJsonObj.getStr((Object)"code"))) {
                    JSONArray resultArray = JSONUtil.parseArray((String)resultHeathJsonObj.getStr((Object)"data"));
                    if (resultArray.size() > 0) {
                        BatchData.heathMonitorList = JSONUtil.toList((JSONArray)resultArray, HeathMonitor.class);
                    }
                    this.logger.debug("\u670d\u52a1\u63a5\u53e3\u6570\u91cf------------" + BatchData.heathMonitorList.size());
                }
            }
            JSONObject paramsFtpJson = new JSONObject();
            paramsFtpJson.set("ftpNames", (Object)this.commonConfig.getFtpNames());
            paramsFtpJson.set("SERVER_BACKUP_FLAG", (Object)"SERVER_BACKUP_FLAG");
            String resulFtpJson = "";
            if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getFtpNames())) {
                if ("all".equals(this.commonConfig.getFtpNames())) {
                    paramsFtpJson.set("ftpNames", (Object)"");
                }
                resulFtpJson = this.restUtil.post(this.commonConfig.getServerUrl() + "" + "/ftpInfo/agentList", paramsFtpJson);
            }
            if (!StringUtils.isEmpty((CharSequence)resulFtpJson)) {
                this.logger.info("ftp/sftp\u8fd4\u56de\u6570\u636eresulFtpJson------------" + resulFtpJson);
                JSONObject resultlFtpJsonObj = JSONUtil.parseObj((String)resulFtpJson);
                if ("0".equals(resultlFtpJsonObj.getStr((Object)"code"))) {
                    JSONArray resultArray = JSONUtil.parseArray((String)resultlFtpJsonObj.getStr((Object)"data"));
                    if (resultArray.size() > 0) {
                        BatchData.ftpInfoList = JSONUtil.toList((JSONArray)resultArray, FtpInfo.class);
                        for (FtpInfo ftpInfo : BatchData.ftpInfoList) {
                            ftpInfo.setUserName(DESUtil.decrypt((String)ftpInfo.getUserName()));
                            ftpInfo.setPasswd(DESUtil.decrypt((String)ftpInfo.getPasswd()));
                        }
                    }
                    this.logger.debug("ftp/sftp\u6570\u91cf------------" + BatchData.ftpInfoList.size());
                }
            }
            JSONObject paramsSnmpDeepJson = new JSONObject();
            paramsSnmpDeepJson.set("snmpHostNames", (Object)this.commonConfig.getSnmpDeepHostNames());
            paramsSnmpDeepJson.set("SERVER_BACKUP_FLAG", (Object)"SERVER_BACKUP_FLAG");
            String resultSnmpDeepJson = "";
            if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getSnmpDeepHostNames())) {
                if ("all".equals(this.commonConfig.getSnmpDeepHostNames())) {
                    paramsSnmpDeepJson.set("snmpHostNames", (Object)"");
                }
                resultSnmpDeepJson = this.restUtil.post(this.commonConfig.getServerUrl() + "" + "/snmpDeepInfo/agentList", paramsSnmpDeepJson);
            }
            if (!StringUtils.isEmpty((CharSequence)resultSnmpDeepJson)) {
                this.logger.info("snnmp\u6df1\u5ea6\u76d1\u63a7\u8fd4\u56de\u6570\u636eresultJson------------" + resultSnmpDeepJson);
                JSONObject resultSnmpDeepJsonObj = JSONUtil.parseObj((String)resultSnmpDeepJson);
                if ("0".equals(resultSnmpDeepJsonObj.getStr((Object)"code"))) {
                    JSONArray resultArray = JSONUtil.parseArray((String)resultSnmpDeepJsonObj.getStr((Object)"data"));
                    if (resultArray.size() > 0) {
                        BatchData.snmpDeepInfoList = JSONUtil.toList((JSONArray)resultArray, SnmpDeepInfo.class);
                    }
                    this.logger.debug("snmp\u6df1\u5ea6\u76d1\u63a7\u6570\u91cf------------" + BatchData.snmpDeepInfoList.size());
                }
            }
            if (BatchData.snmpDeepInfoList.size() > 0) {
                String snmpDeepInfoIdsStr = "";
                for (SnmpDeepInfo snmpDeepInfo : BatchData.snmpDeepInfoList) {
                    snmpDeepInfoIdsStr = snmpDeepInfoIdsStr + snmpDeepInfo.getId() + ",";
                }
                snmpDeepInfoIdsStr = snmpDeepInfoIdsStr.substring(0, snmpDeepInfoIdsStr.length() - 1);
                paramsJson.clear();
                paramsJson.set("snmpDeepInfoIds", (Object)snmpDeepInfoIdsStr);
                paramsJson.set("SERVER_BACKUP_FLAG", (Object)"SERVER_BACKUP_FLAG");
                String resultSnmpDeepStateJson = this.restUtil.post(this.commonConfig.getServerUrl() + "" + "/snmpDeepInfo/agentListState", paramsJson);
                if (!StringUtils.isEmpty((CharSequence)resultSnmpDeepStateJson)) {
                    this.logger.info("snmp\u6df1\u5ea6\u76d1\u63a7oid\u8fd4\u56de\u6570\u636eresultSnmpDeepStateJson------------" + resultSnmpDeepStateJson);
                    JSONObject resultSnmpDeepStateJsonObj = JSONUtil.parseObj((String)resultSnmpDeepStateJson);
                    if ("0".equals(resultSnmpDeepStateJsonObj.getStr((Object)"code"))) {
                        JSONArray resultSnmpDeepStateArray = JSONUtil.parseArray((String)resultSnmpDeepStateJsonObj.getStr((Object)"data"));
                        if (resultSnmpDeepStateArray.size() > 0) {
                            BatchData.snmpDeepStateList = JSONUtil.toList((JSONArray)resultSnmpDeepStateArray, SnmpDeepState.class);
                        }
                        this.logger.debug("snmp\u6df1\u5ea6\u76d1\u63a7oid\u6570\u91cf------------" + BatchData.snmpDeepStateList.size());
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u4eceserver\u8bf7\u6c42\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
    }

    private void pingRequestServerHandler(JSONObject paramsPingJson) {
        List dceInfoResultList = new ArrayList();
        paramsPingJson.set("SERVER_BACKUP_FLAG", (Object)"SERVER_BACKUP_FLAG");
        String resultPingJson = "";
        resultPingJson = this.restUtil.post(this.commonConfig.getServerUrl() + "" + "/dceInfo/agentList", paramsPingJson);
        if (!StringUtils.isEmpty((CharSequence)resultPingJson)) {
            this.logger.info("\u6570\u901a\u8bbe\u5907PING\u8fd4\u56de\u6570\u636eresultPingJson------------" + resultPingJson);
            JSONObject resultPingJsonObj = JSONUtil.parseObj((String)resultPingJson);
            if ("0".equals(resultPingJsonObj.getStr((Object)"code"))) {
                JSONArray resultArray = JSONUtil.parseArray((String)resultPingJsonObj.getStr((Object)"data"));
                if (resultArray.size() > 0) {
                    dceInfoResultList = JSONUtil.toList((JSONArray)resultArray, DceInfo.class);
                    BatchData.dceInfoList.addAll(dceInfoResultList);
                }
                this.logger.debug("\u6570\u901a\u8bbe\u5907PING\u6570\u91cf------------" + BatchData.dceInfoList.size());
            }
        }
    }
}

