/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtil {
    private static final Logger logger = LoggerFactory.getLogger(DateUtil.class);
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String DATETIME_PATTERN_ZH = "yyyy\u5e74MM\u6708dd\u65e5HH:mm:ss";

    public static Timestamp getNowTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp nowTime = Timestamp.valueOf(dateFormat.format(new Date()));
        return nowTime;
    }

    public static String getCurrentDateTime() {
        return DateUtil.getCurrentDateTime((String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String getCurrentDate() {
        return DateUtil.getCurrentDateTime((String)"yyyy-MM-dd");
    }

    public static String getCurrentDateTime(String pattern) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(cal.getTime());
    }

    public static Date getDate(String dateStr) throws ParseException {
        return DateUtil.getDate((String)dateStr, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static Date getDate(String dateStr, String pattern) throws ParseException {
        Date date = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        date = dateFormat.parse(dateStr);
        return date;
    }

    public static String getDateString(Date date) {
        return DateUtil.getString((Date)date, (String)"yyyy-MM-dd");
    }

    public static String getDateTimeString(Date date) {
        return DateUtil.getString((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String getDateTimeZhString(Date date) {
        return DateUtil.getString((Date)date, (String)"yyyy\u5e74MM\u6708dd\u65e5HH:mm:ss");
    }

    public static String getString(Date date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date);
    }

    public static int getHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int hour = calendar.get(11);
        return hour;
    }

    public static boolean isClearTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int hour = calendar.get(11);
        int mins = calendar.get(12);
        return 8 == hour && mins >= 10 && mins <= 25;
    }

    public static String getDateBefore(int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(new Date());
        now.set(5, now.get(5) - day);
        return DateUtil.getString((Date)now.getTime(), (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String secondToDate(Long second, String patten) {
        if (second == null) {
            return "";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(second * 1000L);
        Date date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat(patten);
        String dateString = format.format(date);
        return dateString;
    }

    public static String millisToDate(String millisStr, String patten) {
        if (StringUtils.isEmpty((CharSequence)millisStr)) {
            return "";
        }
        try {
            Long millis = Long.valueOf(millisStr);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(millis);
            Date date = calendar.getTime();
            SimpleDateFormat format = new SimpleDateFormat(patten);
            String dateString = format.format(date);
            return dateString;
        }
        catch (Exception e) {
            logger.error("millisToDate\u9519\u8bef", (Throwable)e);
            return "";
        }
    }

    public static String beforeHourToNowDate(Integer hours) {
        if (null == hours || 0 == hours) {
            hours = 1;
        }
        Calendar c = Calendar.getInstance();
        long diffTimes = 3600000L;
        long nowTimes = c.getTimeInMillis();
        c.setTimeInMillis(nowTimes - (long)hours.intValue() * diffTimes);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(c.getTime());
    }

    public static String OffsetDateTimeFormat(OffsetDateTime time) {
        if (null == time) {
            return "";
        }
        return time.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }
}

