/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util.jdbc;

import cn.hutool.core.collection.CollectionUtil;
import com.wgcloud.entity.DbInfo;
import com.wgcloud.entity.DbTable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.stereotype.Component;

@Component
public class ConnectionUtil {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionUtil.class);

    public JdbcTemplate getJdbcTemplate(DbInfo dbInfo) throws Exception {
        JdbcTemplate jdbcTemplate = null;
        String driver = "";
        String url = dbInfo.getDbUrl();
        driver = "mysql".equals(dbInfo.getDbType()) ? "com.mysql.jdbc.Driver" : ("mariadb".equals(dbInfo.getDbType()) ? "org.mariadb.jdbc.Driver" : ("postgresql".equals(dbInfo.getDbType()) ? "org.postgresql.Driver" : ("sqlserver".equals(dbInfo.getDbType()) ? "com.microsoft.sqlserver.jdbc.SQLServerDriver" : ("db2".equals(dbInfo.getDbType()) ? "com.ibm.db2.jdbc.app.DB2Driver" : ("sqlite".equals(dbInfo.getDbType()) ? "org.sqlite.JDBC" : ("clickhouse".equals(dbInfo.getDbType()) ? dbInfo.getDriverName() : ("other".equals(dbInfo.getDbType()) ? dbInfo.getDriverName() : "oracle.jdbc.driver.OracleDriver")))))));
        try {
            long startTimes = System.currentTimeMillis();
            logger.info("\u6b63\u5728\u8fde\u63a5\u6570\u636e\u5e93----------------" + dbInfo.getAliasName());
            DriverManagerDataSource dataSource = new DriverManagerDataSource();
            dataSource.setDriverClassName(driver);
            dataSource.setUrl(url);
            dataSource.setUsername(dbInfo.getUserName());
            dataSource.setPassword(dbInfo.getPasswd());
            jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
            jdbcTemplate.setQueryTimeout(300);
            if ("mysql".equals(dbInfo.getDbType())) {
                jdbcTemplate.queryForRowSet("select version()");
            } else if ("mariadb".equals(dbInfo.getDbType())) {
                jdbcTemplate.queryForRowSet("select version()");
            } else if ("postgresql".equals(dbInfo.getDbType())) {
                jdbcTemplate.queryForRowSet("select version()");
            } else if ("sqlserver".equals(dbInfo.getDbType())) {
                jdbcTemplate.queryForRowSet("SELECT @@VERSION");
            } else if ("db2".equals(dbInfo.getDbType())) {
                jdbcTemplate.queryForRowSet("SELECT SERVICE_LEVEL FROM SYSIBMADM.ENV_INST_INFO");
            } else if ("sqlite".equals(dbInfo.getDbType())) {
                jdbcTemplate.queryForRowSet("select sqlite_version()");
            } else if ("clickhouse".equals(dbInfo.getDbType())) {
                jdbcTemplate.queryForRowSet("select version()");
            } else if ("other".equals(dbInfo.getDbType())) {
                jdbcTemplate.queryForRowSet(dbInfo.getTestQuerySql());
            } else {
                jdbcTemplate.queryForRowSet("select * from v$version");
            }
            long endTimes = System.currentTimeMillis();
            String resTimes = endTimes - startTimes + "";
            dbInfo.setResTimes(Integer.valueOf(resTimes));
            dbInfo.setDbState("1");
            logger.info("\u8fde\u63a5\u6570\u636e\u5e93\u6210\u529f----------------" + dbInfo.getAliasName());
            return jdbcTemplate;
        }
        catch (Exception e) {
            jdbcTemplate = null;
            logger.error("\u76d1\u63a7\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef", (Throwable)e);
            dbInfo.setDbState("2");
            dbInfo.setTestErrorMsg(e.toString());
            return null;
        }
    }

    public String queryTableCount(JdbcTemplate jdbcTemplate, DbTable dbTable) {
        try {
            dbTable.setState("1");
            if (null == jdbcTemplate) {
                dbTable.setState("2");
                return "";
            }
            long startTimes = System.currentTimeMillis();
            List list = jdbcTemplate.queryForList(dbTable.getWhereVal());
            long endTimes = System.currentTimeMillis();
            String resTimes = endTimes - startTimes + "";
            dbTable.setResTimes(Integer.valueOf(resTimes));
            if (CollectionUtil.isEmpty((Collection)list)) {
                return "";
            }
            String resultData = this.getDataFromQueryResult(list, dbTable);
            return resultData;
        }
        catch (Exception e) {
            dbTable.setState("2");
            logger.error("\u6570\u636e\u8868\u76d1\u63a7\u9519\u8bef", (Throwable)e);
            dbTable.setTestErrorMsg(e.toString());
            return "";
        }
    }

    public String getDataFromQueryResult(List<Map<String, Object>> list, DbTable dbTable) {
        Map<String, Object> mapResult = list.get(0);
        String resultData = "";
        if (StringUtils.isEmpty((CharSequence)dbTable.getTableName())) {
            Iterator<String> iterator = mapResult.keySet().iterator();
            if (iterator.hasNext()) {
                String key = iterator.next();
                resultData = mapResult.get(key).toString();
            }
        } else {
            String[] colNameArr = this.getColNameArray(dbTable.getTableName());
            for (int i = 0; i < colNameArr.length; ++i) {
                resultData = i != colNameArr.length - 1 ? resultData + mapResult.get(colNameArr[i]).toString() + "," : resultData + mapResult.get(colNameArr[i]).toString();
            }
        }
        return resultData;
    }

    public String[] getColNameArray(String dbTableCols) {
        String[] colNameArr = new String[]{};
        if (!StringUtils.isEmpty((CharSequence)dbTableCols)) {
            colNameArr = dbTableCols.split(",");
        }
        return colNameArr;
    }
}

