/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.wgcloud.ScheduledTask;
import com.wgcloud.dto.k8s.K8sContainerDto;
import com.wgcloud.dto.k8s.K8sDeploymentDto;
import com.wgcloud.dto.k8s.K8sNamespaceDto;
import com.wgcloud.dto.k8s.K8sNodeDto;
import com.wgcloud.dto.k8s.K8sPodDto;
import com.wgcloud.dto.k8s.K8sServiceAccountDto;
import com.wgcloud.dto.k8s.K8sServiceDto;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.FormatUtil;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ContainerPort;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1DeploymentList;
import io.kubernetes.client.openapi.models.V1Namespace;
import io.kubernetes.client.openapi.models.V1NamespaceList;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1NodeAddress;
import io.kubernetes.client.openapi.models.V1NodeList;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodCondition;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceAccount;
import io.kubernetes.client.openapi.models.V1ServiceAccountList;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.util.ClientBuilder;
import io.kubernetes.client.util.credentials.AccessTokenAuthentication;
import io.kubernetes.client.util.credentials.Authentication;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class K8sService {
    private Logger logger = LoggerFactory.getLogger(ScheduledTask.class);
    @Value(value="${k8s.base-url:}")
    private String baseUrl;
    @Value(value="${k8s.token:}")
    private String token;
    @Value(value="${k8s.name:}")
    private String k8sName;
    private static ApiClient client = null;

    private void testThread() {
        new Thread(() -> this.logger.info("\u542f\u52a8\u5b50\u7ebf\u7a0b\u6d4b\u8bd5")).start();
    }

    public ApiClient getConnection() {
        if (null == client) {
            client = new ClientBuilder().setBasePath(this.baseUrl).setVerifyingSsl(false).setAuthentication((Authentication)new AccessTokenAuthentication(this.token)).build();
        }
        Configuration.setDefaultApiClient((ApiClient)client);
        return client;
    }

    private CoreV1Api getCoreApiInstance() {
        if (null == client) {
            client = new ClientBuilder().setBasePath(this.baseUrl).setVerifyingSsl(false).setAuthentication((Authentication)new AccessTokenAuthentication(this.token)).build();
        }
        Configuration.setDefaultApiClient((ApiClient)client);
        return new CoreV1Api(client);
    }

    private AppsV1Api getApiInstance() {
        if (null == client) {
            client = new ClientBuilder().setBasePath(this.baseUrl).setVerifyingSsl(false).setAuthentication((Authentication)new AccessTokenAuthentication(this.token)).build();
        }
        Configuration.setDefaultApiClient((ApiClient)client);
        return new AppsV1Api(client);
    }

    public List<K8sPodDto> listK8sPod() {
        ArrayList<K8sPodDto> list = new ArrayList<K8sPodDto>();
        try {
            CoreV1Api apiCore = this.getCoreApiInstance();
            V1PodList podList = apiCore.listPodForAllNamespaces(null, null, null, null, null, null, null, null, null, null);
            for (V1Pod item : podList.getItems()) {
                K8sPodDto dto = new K8sPodDto();
                dto.setName(item.getMetadata().getName());
                OffsetDateTime pod_creatime = item.getMetadata().getCreationTimestamp();
                dto.setStartedTime(DateUtil.OffsetDateTimeFormat((OffsetDateTime)pod_creatime));
                dto.setNamespace(item.getMetadata().getNamespace());
                if (null != item.getStatus().getHostIP()) {
                    dto.setHostIp(item.getStatus().getHostIP());
                } else {
                    dto.setHostIp("");
                }
                String nodeName = item.getSpec().getNodeName();
                if (StringUtils.isEmpty((CharSequence)nodeName)) {
                    dto.setNodeName("");
                } else {
                    dto.setNodeName(nodeName);
                }
                if (null != item.getStatus().getConditions()) {
                    for (V1PodCondition condition : item.getStatus().getConditions()) {
                        dto.setStatus("Type:" + condition.getType() + ",Status:" + condition.getStatus());
                    }
                } else {
                    dto.setStatus("");
                }
                list.add(dto);
            }
        }
        catch (Exception e) {
            this.logger.error("listK8sPod\u9519\u8bef", (Throwable)e);
        }
        return list;
    }

    public List<K8sNamespaceDto> listK8sNamespaces() {
        ArrayList<K8sNamespaceDto> list = new ArrayList<K8sNamespaceDto>();
        try {
            CoreV1Api apiCore = this.getCoreApiInstance();
            V1NamespaceList namespaceList = apiCore.listNamespace(null, null, null, null, null, null, null, null, null, null);
            for (V1Namespace namespace : namespaceList.getItems()) {
                this.logger.info("--------namespace----------------");
                this.logger.info("namespace------" + namespace.getMetadata().getName());
                K8sNamespaceDto dto = new K8sNamespaceDto();
                dto.setName(namespace.getMetadata().getName());
                OffsetDateTime pod_creatime = namespace.getMetadata().getCreationTimestamp();
                dto.setStartedTime(DateUtil.OffsetDateTimeFormat((OffsetDateTime)pod_creatime));
                dto.setK8sName(this.k8sName);
                list.add(dto);
            }
        }
        catch (Exception e) {
            this.logger.error("listK8sNamespaces\u9519\u8bef", (Throwable)e);
        }
        return list;
    }

    public List<K8sServiceDto> listK8sServices() {
        ArrayList<K8sServiceDto> list = new ArrayList<K8sServiceDto>();
        try {
            CoreV1Api apiCore = this.getCoreApiInstance();
            V1ServiceList services = apiCore.listServiceForAllNamespaces(null, null, null, null, null, null, null, null, null, null);
            for (V1Service item : services.getItems()) {
                K8sServiceDto dto = new K8sServiceDto();
                dto.setName(item.getMetadata().getName());
                OffsetDateTime pod_creatime = item.getMetadata().getCreationTimestamp();
                dto.setStartedTime(DateUtil.OffsetDateTimeFormat((OffsetDateTime)pod_creatime));
                dto.setNamespace(item.getMetadata().getNamespace());
                list.add(dto);
            }
        }
        catch (Exception e) {
            this.logger.error("listK8sServices\u9519\u8bef", (Throwable)e);
        }
        return list;
    }

    public List<K8sContainerDto> listK8sContainers() {
        ArrayList<K8sContainerDto> list = new ArrayList<K8sContainerDto>();
        try {
            CoreV1Api apiCore = this.getCoreApiInstance();
            V1PodList podList = apiCore.listPodForAllNamespaces(null, null, null, null, null, null, null, null, null, null);
            for (V1Pod item : podList.getItems()) {
                String podName = item.getMetadata().getName();
                String namespace = item.getMetadata().getNamespace();
                String nodeName = item.getSpec().getNodeName();
                if (StringUtils.isEmpty((CharSequence)nodeName)) {
                    nodeName = "";
                }
                List containers = item.getSpec().getContainers();
                List container_status = item.getStatus().getContainerStatuses();
                for (V1ContainerStatus containerStatus : container_status) {
                    K8sContainerDto dto = new K8sContainerDto();
                    dto.setPodName(podName);
                    dto.setNamespace(namespace);
                    dto.setContainerName(containerStatus.getName());
                    dto.setImage(containerStatus.getImage());
                    dto.setNodeName(nodeName);
                    if (null != containerStatus.getState().getRunning()) {
                        dto.setStartedTime(DateUtil.OffsetDateTimeFormat((OffsetDateTime)containerStatus.getState().getRunning().getStartedAt()));
                    } else {
                        dto.setStartedTime("Stopped");
                    }
                    dto.setRestartCount(containerStatus.getRestartCount());
                    for (V1Container container : containers) {
                        if (!item.getMetadata().getName().equals(podName) || !containerStatus.getName().equals(container.getName()) || !containerStatus.getImage().equals(container.getImage())) continue;
                        V1ResourceRequirements resources = container.getResources();
                        Map limits = resources.getLimits();
                        Map requests = resources.getRequests();
                        if (limits != null) {
                            Quantity limitCpu = (Quantity)limits.get("cpu");
                            if (null != limitCpu) {
                                dto.setLimitCpu(limitCpu.getNumber().toString());
                            } else {
                                dto.setLimitCpu("");
                            }
                            Quantity limitMemory = (Quantity)limits.get("memory");
                            if (null != limitMemory) {
                                double limitMemoryMb = FormatUtil.formatDouble((Double)(limitMemory.getNumber().doubleValue() / 1024.0 / 1024.0), (int)2);
                                dto.setLimitMemory(limitMemoryMb + "MB");
                            } else {
                                dto.setLimitMemory("");
                            }
                        } else {
                            dto.setLimitMemory("");
                            dto.setLimitCpu("");
                        }
                        if (requests != null) {
                            Quantity requestCpu = (Quantity)requests.get("cpu");
                            if (null != requestCpu) {
                                dto.setRequestCpu(requestCpu.getNumber().toString());
                            } else {
                                dto.setRequestCpu("");
                            }
                            Quantity requestMemory = (Quantity)requests.get("memory");
                            if (null != requestMemory) {
                                double requestMemoryMb = FormatUtil.formatDouble((Double)(requestMemory.getNumber().doubleValue() / 1024.0 / 1024.0), (int)2);
                                dto.setRequestMemory(requestMemoryMb + "MB");
                            } else {
                                dto.setRequestMemory("");
                            }
                        } else {
                            dto.setRequestCpu("");
                            dto.setRequestMemory("");
                        }
                        dto.setPorts(this.getPortsStr(container.getPorts()));
                    }
                    list.add(dto);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("listK8sContainers\u9519\u8bef", (Throwable)e);
        }
        return list;
    }

    private String getPortsStr(List<V1ContainerPort> portList) {
        String portStr = "";
        if (null == portList) {
            return portStr;
        }
        for (V1ContainerPort containerPort : portList) {
            portStr = portStr + containerPort.getHostPort() + ":" + containerPort.getContainerPort() + ",";
        }
        return portStr;
    }

    public List<K8sServiceAccountDto> listK8sServiceAccount() {
        ArrayList<K8sServiceAccountDto> list = new ArrayList<K8sServiceAccountDto>();
        try {
            CoreV1Api apiCore = this.getCoreApiInstance();
            V1ServiceAccountList accountList = apiCore.listServiceAccountForAllNamespaces(null, null, null, null, null, null, null, null, null, null);
            for (V1ServiceAccount account : accountList.getItems()) {
                K8sServiceAccountDto dto = new K8sServiceAccountDto();
                dto.setAccount(account.getMetadata().getName());
                dto.setNamespace(account.getMetadata().getNamespace());
                dto.setK8sName(this.k8sName);
                list.add(dto);
            }
        }
        catch (Exception e) {
            this.logger.error("listK8sServiceAccount\u9519\u8bef", (Throwable)e);
        }
        return list;
    }

    public List<K8sNodeDto> listK8sNode() {
        ArrayList<K8sNodeDto> list = new ArrayList<K8sNodeDto>();
        try {
            CoreV1Api apiCore = this.getCoreApiInstance();
            V1NodeList nodeList = apiCore.listNode(null, null, null, null, null, null, null, null, null, null);
            for (V1Node node : nodeList.getItems()) {
                K8sNodeDto dto = new K8sNodeDto();
                dto.setName(node.getMetadata().getName());
                if (null != node.getStatus().getAddresses() && node.getStatus().getAddresses().size() > 0) {
                    dto.setAddress(((V1NodeAddress)node.getStatus().getAddresses().get(0)).getAddress());
                }
                dto.setK8sName(this.k8sName);
                list.add(dto);
            }
        }
        catch (Exception e) {
            this.logger.error("listK8sNode\u9519\u8bef", (Throwable)e);
        }
        return list;
    }

    public List<K8sDeploymentDto> listK8sDeployment(List<K8sNamespaceDto> namespaceDtoList) {
        ArrayList<K8sDeploymentDto> list = new ArrayList<K8sDeploymentDto>();
        try {
            AppsV1Api apiInstance = this.getApiInstance();
            for (K8sNamespaceDto k8sNamespaceDto : namespaceDtoList) {
                V1DeploymentList deploymentLis = apiInstance.listNamespacedDeployment(k8sNamespaceDto.getName(), null, null, null, null, null, null, null, null, null, null);
                for (V1Deployment deployment : deploymentLis.getItems()) {
                    K8sDeploymentDto dto = new K8sDeploymentDto();
                    dto.setName(deployment.getMetadata().getName());
                    OffsetDateTime pod_creatime = deployment.getMetadata().getCreationTimestamp();
                    dto.setStartedTime(DateUtil.OffsetDateTimeFormat((OffsetDateTime)pod_creatime));
                    dto.setK8sName(this.k8sName);
                    dto.setNamespace(k8sNamespaceDto.getName());
                    list.add(dto);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("listK8sDeployment\u9519\u8bef", (Throwable)e);
        }
        return list;
    }
}

