/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import cn.hutool.json.JSON;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.wgcloud.CommonConfig;
import com.wgcloud.RestUtil;
import com.wgcloud.dto.KafkaInfoDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class KafkaService {
    private static Logger logger = LoggerFactory.getLogger(KafkaService.class);
    @Value(value="${kafka.bootstrap-servers:}")
    private String bootstrapServers;
    @Value(value="${kafka.name:}")
    private String kafkaName;
    @Autowired
    private RestUtil restUtil;
    @Autowired
    private CommonConfig commonConfig;
    private static AdminClient adminClient = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalBacklog(String topic, String groupId) {
        KafkaConsumer consumer = null;
        try {
            Properties props = new Properties();
            props.put("bootstrap.servers", this.bootstrapServers);
            props.put("group.id", groupId);
            props.put("key.deserializer", StringDeserializer.class.getName());
            props.put("value.deserializer", StringDeserializer.class.getName());
            consumer = new KafkaConsumer(props);
            List partitions = consumer.partitionsFor(topic);
            ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
            for (PartitionInfo partition : partitions) {
                topicPartitions.add(new TopicPartition(partition.topic(), partition.partition()));
            }
            consumer.assign(topicPartitions);
            int totalBacklog = 0;
            for (PartitionInfo partition : partitions) {
                TopicPartition tp = new TopicPartition(partition.topic(), partition.partition());
                long latestOffset = consumer.position(tp);
                long endOffset = (Long)consumer.endOffsets(Collections.singleton(tp)).get(tp);
                int backlog = Math.toIntExact(endOffset - latestOffset);
                totalBacklog += backlog;
            }
            int n = totalBacklog;
            return n;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u672a\u6d88\u8d39\u6d88\u606f\u603b\u6570\u9519\u8bef", (Throwable)e);
        }
        finally {
            if (null != consumer) {
                consumer.close();
            }
        }
        return 0;
    }

    public AdminClient getAdminClient() {
        if (null == adminClient) {
            Properties props = new Properties();
            props.put("bootstrap.servers", this.bootstrapServers);
            props.put("request.timeout.ms", (Object)30000);
            AdminClient adminClient = AdminClient.create((Properties)props);
            return adminClient;
        }
        return adminClient;
    }

    public void countConsumerOffset() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.set("kafkaName", (Object)this.kafkaName);
        try {
            ArrayList<KafkaInfoDto> kafkaInfoDtoList = new ArrayList<KafkaInfoDto>();
            AdminClient adminClient = this.getAdminClient();
            Collection consumerGroupListing = (Collection)adminClient.listConsumerGroups().all().get();
            for (ConsumerGroupListing consumerGroup : consumerGroupListing) {
                String groupId = consumerGroup.groupId();
                ListConsumerGroupOffsetsResult offsetsResult = adminClient.listConsumerGroupOffsets(groupId);
                Map offsets = (Map)offsetsResult.partitionsToOffsetAndMetadata().get();
                for (Map.Entry entry : offsets.entrySet()) {
                    TopicPartition topicPartition = (TopicPartition)entry.getKey();
                    OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)entry.getValue();
                    long offset = offsetAndMetadata.offset();
                    Integer lagCount = this.getTotalBacklog(topicPartition.topic(), groupId);
                    KafkaInfoDto kafkaInfoDto = new KafkaInfoDto();
                    kafkaInfoDto.setPartition(topicPartition.partition() + "");
                    kafkaInfoDto.setOffset(offset + "");
                    kafkaInfoDto.setLagCount(lagCount + "");
                    kafkaInfoDto.setTopicName(topicPartition.topic());
                    kafkaInfoDto.setGroupId(groupId);
                    kafkaInfoDto.setKafkaName(this.kafkaName);
                    kafkaInfoDtoList.add(kafkaInfoDto);
                }
            }
            jsonObject.set("data", kafkaInfoDtoList);
            jsonObject.set("code", (Object)"1");
        }
        catch (Exception e) {
            logger.error("countConsumerOffset\u9519\u8bef", (Throwable)e);
            jsonObject.set("code", (Object)"2");
            jsonObject.set("testErrorMsg", (Object)e.toString());
        }
        logger.info("kafka\u76d1\u63a7\u6570\u636e------" + JSONUtil.toJsonStr((JSON)jsonObject));
        this.restUtil.post(this.commonConfig.getServerPostUrl() + "" + "/agentKafkaGo/minTask", jsonObject);
    }
}

