/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util;

import cn.hutool.json.JSONObject;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ActivemqUtil {
    private static final Logger logger = LoggerFactory.getLogger(ActivemqUtil.class);
    @Value(value="${activemq.name:}")
    private String name;
    @Value(value="${activemq.brokerUrl:}")
    private String brokerUrl;
    @Value(value="${activemq.queueNames:}")
    private String queueNames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JSONObject> gatherInfo() {
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>();
        Connection connection = null;
        Session session = null;
        try {
            String[] queueNameArr;
            if (StringUtils.isEmpty((CharSequence)this.brokerUrl)) {
                logger.info("\u6ca1\u6709\u914d\u7f6eActivemq\u4fe1\u606f\uff0c\u65e0\u9700\u8fdb\u884c\u76d1\u6d4b");
                List<JSONObject> list = null;
                return list;
            }
            connection = this.createConnection(this.brokerUrl);
            session = connection.createSession(false, 1);
            for (String queueName : queueNameArr = this.queueNames.split(",")) {
                Queue queue = this.getQueue(session, queueName);
                int messageCount = this.getMessageCount(session, queue);
                JSONObject jsonObject = new JSONObject();
                jsonObject.set("brokerUrl", (Object)this.brokerUrl);
                jsonObject.set("queueName", (Object)queueName);
                jsonObject.set("name", (Object)this.name);
                jsonObject.set("messageCount", (Object)messageCount);
                jsonObject.set("providerVersion", (Object)connection.getMetaData().getProviderVersion());
                jsonObject.set("code", (Object)"1");
                resultList.add(jsonObject);
                logger.info("\u961f\u5217\u4e2d\u7684\u6d88\u606f\u4e2a\u6570: " + messageCount);
            }
        }
        catch (Exception e) {
            logger.error("\u6267\u884cactivemq\u76d1\u63a7\u9519\u8bef", (Throwable)e);
            JSONObject jsonObject = new JSONObject();
            jsonObject.set("brokerUrl", (Object)this.brokerUrl);
            jsonObject.set("queueName", (Object)e.toString());
            jsonObject.set("name", (Object)this.name);
            jsonObject.set("messageCount", (Object)"");
            jsonObject.set("providerVersion", (Object)"");
            jsonObject.set("code", (Object)"2");
            resultList.add(jsonObject);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }
        return resultList;
    }

    public Connection createConnection(String brokerUrl) throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(brokerUrl);
        Connection connection = factory.createConnection();
        connection.start();
        return connection;
    }

    public Queue getQueue(Session session, String queueName) throws Exception {
        Queue queue = session.createQueue(queueName);
        return queue;
    }

    public int getMessageCount(Session session, Queue queue) throws Exception {
        int count = 0;
        QueueBrowser browser = session.createBrowser(queue);
        Enumeration messages = browser.getEnumeration();
        while (messages.hasMoreElements()) {
            messages.nextElement();
            ++count;
        }
        browser.close();
        return count;
    }
}

