/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util;

import cn.hutool.json.JSONObject;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RabbitmqUtil {
    private static final Logger logger = LoggerFactory.getLogger(RabbitmqUtil.class);
    @Value(value="${rabbitmq.name:}")
    private String name;
    @Value(value="${rabbitmq.host:}")
    private String host;
    @Value(value="${rabbitmq.port:}")
    private Integer port;
    @Value(value="${rabbitmq.virtualHost:}")
    private String virtualHost;
    @Value(value="${rabbitmq.username:}")
    private String username;
    @Value(value="${rabbitmq.password:}")
    private String password;
    @Value(value="${rabbitmq.queueNames:}")
    private String queueNames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JSONObject> gatherInfo() {
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>();
        Connection connection = null;
        Channel channel = null;
        try {
            String[] queueNameArr;
            if (StringUtils.isEmpty((CharSequence)this.host)) {
                logger.info("\u6ca1\u6709\u914d\u7f6erabbit\u4fe1\u606f\uff0c\u65e0\u9700\u8fdb\u884c\u76d1\u6d4b");
                List<JSONObject> list = null;
                return list;
            }
            ConnectionFactory factory = new ConnectionFactory();
            factory.setHost(this.host);
            factory.setPort(this.port.intValue());
            factory.setUsername(this.username);
            factory.setPassword(this.password);
            if (!StringUtils.isEmpty((CharSequence)this.virtualHost)) {
                factory.setVirtualHost(this.virtualHost);
            }
            connection = factory.newConnection();
            channel = connection.createChannel();
            for (String queueName : queueNameArr = this.queueNames.split(",")) {
                long messageCount = channel.messageCount(queueName);
                long consumerCount = channel.consumerCount(queueName);
                JSONObject jsonObject = new JSONObject();
                jsonObject.set("host", (Object)this.host);
                jsonObject.set("port", (Object)this.port);
                jsonObject.set("virtualHost", (Object)this.virtualHost);
                jsonObject.set("queueName", (Object)queueName);
                jsonObject.set("name", (Object)this.name);
                jsonObject.set("messageCount", (Object)messageCount);
                jsonObject.set("consumerCount", (Object)consumerCount);
                jsonObject.set("code", (Object)"1");
                resultList.add(jsonObject);
            }
        }
        catch (Exception e) {
            logger.error("\u6267\u884crabbit\u76d1\u63a7\u9519\u8bef", (Throwable)e);
            JSONObject jsonObject = new JSONObject();
            jsonObject.set("host", (Object)this.host);
            jsonObject.set("port", (Object)this.port);
            jsonObject.set("virtualHost", (Object)this.virtualHost);
            jsonObject.set("queueName", (Object)e.toString());
            jsonObject.set("name", (Object)this.name);
            jsonObject.set("messageCount", (Object)"");
            jsonObject.set("consumerCount", (Object)"");
            jsonObject.set("code", (Object)"2");
            resultList.add(jsonObject);
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return resultList;
    }
}

