/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.agentController;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.wgcloud.config.MailConfig;
import com.wgcloud.entity.AppExceptionInfo;
import com.wgcloud.entity.CpuTemperatures;
import com.wgcloud.entity.DeskIo;
import com.wgcloud.entity.DiskIoState;
import com.wgcloud.entity.DiskSmart;
import com.wgcloud.entity.DiskState;
import com.wgcloud.entity.FileSafe;
import com.wgcloud.entity.HostUsers;
import com.wgcloud.entity.HostWarnDiy;
import com.wgcloud.service.DiskIoStateService;
import com.wgcloud.service.DockerInfoService;
import com.wgcloud.service.FileSafeService;
import com.wgcloud.util.AgentUtils;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.MessageErrorUtils;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.TokenUtils;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.msg.WarnMailUtil;
import com.wgcloud.util.staticvar.BatchData;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/agentDiskGo"})
public class AgentDiskController {
    private static final Logger logger = LoggerFactory.getLogger(AgentDiskController.class);
    @Autowired
    private DockerInfoService dockerInfoService;
    @Autowired
    private DiskIoStateService diskIoStateService;
    @Autowired
    private FileSafeService fileSafeService;
    @Autowired
    private TokenUtils tokenUtils;
    @Autowired
    private MailConfig mailConfig;
    @Autowired
    private AgentUtils agentUtils;
    @Autowired
    private MessageErrorUtils messageErrorUtils;

    @ResponseBody
    @RequestMapping(value={"/minTask"})
    public JSONObject minTask(@RequestBody String paramBean) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        logger.debug("agent\u4e0a\u62a5\u78c1\u76d8\u6570\u636e-------------" + agentJsonObject.toString());
        JSONObject resultJson = new JSONObject();
        if (!this.tokenUtils.checkAgentToken(agentJsonObject)) {
            logger.error("Token is error");
            resultJson.set("result", (Object)"Token is error");
            return resultJson;
        }
        String bindIp = agentJsonObject.getStr((Object)"bindIp");
        if (DateUtil.isClearTime()) {
            logger.info("Clearing historical trend chart data without submitting monitor data----------" + bindIp);
            resultJson.set("result", (Object)"Not save data in this time");
            return resultJson;
        }
        if (this.isExists(bindIp)) {
            logger.error("agentDisk multiple times at the same time: " + bindIp);
            resultJson.set("result", (Object)("agentDisk multiple times at the same time: " + bindIp));
            return resultJson;
        }
        JSONObject diskInfoListJson = agentJsonObject.getJSONObject((Object)"diskInfoList");
        JSONObject diskIoJson = agentJsonObject.getJSONObject((Object)"diskIo");
        JSONObject diskIoJsonEnd = agentJsonObject.getJSONObject((Object)"diskIoEnd");
        JSONObject fileSafesJson = agentJsonObject.getJSONObject((Object)"fileSafes");
        JSONArray temperaturesJsonArray = agentJsonObject.getJSONArray((Object)"temperatures");
        JSONArray hostUsersJsonArray = agentJsonObject.getJSONArray((Object)"hostUsers");
        JSONObject processListJson = agentJsonObject.getJSONObject((Object)"processList");
        JSONObject processListAllJson = agentJsonObject.getJSONObject((Object)"processListAll");
        String gpuDataJson = agentJsonObject.getStr((Object)"gpuData");
        String fireWallDataJson = agentJsonObject.getStr((Object)"fireWallData");
        String portAllDataJson = agentJsonObject.getStr((Object)"portListAll");
        String crontabDataJson = agentJsonObject.getStr((Object)"crontabData");
        String likeShellDataJson = agentJsonObject.getStr((Object)"likeShell");
        String dockerAllListDataJson = agentJsonObject.getStr((Object)"dockerAllList");
        String hostName = agentJsonObject.getStr((Object)"hostName");
        Date nowTime = new Date();
        if (StringUtils.isEmpty((CharSequence)(bindIp = this.agentUtils.checkBindIP(bindIp, hostName)))) {
            resultJson.set("result", (Object)"error: bindIp is null");
            return resultJson;
        }
        try {
            if (diskInfoListJson != null) {
                this.addDeskState(diskInfoListJson, nowTime, bindIp);
            }
            if (diskIoJson != null) {
                this.addDeskIo(diskIoJson, nowTime, bindIp, diskIoJsonEnd);
            }
            if (fileSafesJson != null) {
                this.addFileSafes(fileSafesJson, nowTime, bindIp);
            }
            if (temperaturesJsonArray != null) {
                this.addCpuTemperatures(temperaturesJsonArray, nowTime, bindIp);
            }
            if (hostUsersJsonArray != null) {
                this.addHostUsers(hostUsersJsonArray, nowTime, bindIp);
            }
            if (processListJson != null) {
                this.addAppException(processListJson, nowTime, bindIp);
            }
            if (processListAllJson != null) {
                this.addCacheHostAllProcess(processListAllJson, nowTime, bindIp);
            }
            if (gpuDataJson != null) {
                this.addCacheHostGpuInfo(gpuDataJson, nowTime, bindIp);
            }
            if (fireWallDataJson != null) {
                this.addCacheHostFireWall(fireWallDataJson, nowTime, bindIp);
            }
            if (portAllDataJson != null) {
                this.addCacheHostPortAll(portAllDataJson, nowTime, bindIp);
            }
            if (crontabDataJson != null) {
                this.addCacheHostCrontab(crontabDataJson, nowTime, bindIp);
            }
            if (likeShellDataJson != null) {
                this.addCacheHostLikeShell(likeShellDataJson, nowTime, bindIp);
            }
            if (dockerAllListDataJson != null) {
                this.addCacheHostDockerAllList(dockerAllListDataJson, nowTime, bindIp);
            }
            resultJson.set("result", (Object)"success");
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u78c1\u76d8\u4e0a\u62a5\u6570\u636e\u9519\u8bef", (Throwable)e);
            resultJson.set("result", (Object)("error: " + e.toString()));
        }
        return resultJson;
    }

    @ResponseBody
    @RequestMapping(value={"/minTaskSmart"})
    public JSONObject minTaskSmart(@RequestBody String paramBean) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        logger.debug("agent\u4e0a\u62a5\u78c1\u76d8smart\u6570\u636e-------------" + agentJsonObject.toString());
        JSONObject resultJson = new JSONObject();
        if (!this.tokenUtils.checkAgentToken(agentJsonObject)) {
            logger.error("Token is error");
            resultJson.set("result", (Object)"Token is error");
            return resultJson;
        }
        String bindIp = agentJsonObject.getStr((Object)"bindIp");
        JSONObject diskSmartJson = agentJsonObject.getJSONObject((Object)"diskSmart");
        String hostName = agentJsonObject.getStr((Object)"hostName");
        Date nowTime = new Date();
        if (StringUtils.isEmpty((CharSequence)(bindIp = this.agentUtils.checkBindIP(bindIp, hostName)))) {
            resultJson.set("result", (Object)"error: bindIp is null");
            return resultJson;
        }
        try {
            if (diskSmartJson != null) {
                this.addDiskSmart(diskSmartJson, nowTime, bindIp);
            }
            resultJson.set("result", (Object)"success");
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u78c1\u76d8\u4e0a\u62a5smart\u6570\u636e\u9519\u8bef", (Throwable)e);
            resultJson.set("result", (Object)("error\uff1a" + e.toString()));
        }
        return resultJson;
    }

    private void addDeskState(JSONObject diskInfoListJson, Date nowTime, String bindIp) {
        try {
            ArrayList keys = new ArrayList(diskInfoListJson.keySet());
            ArrayList<DiskState> willSaveList = new ArrayList<DiskState>();
            for (String diskname : keys) {
                JSONObject diskJson = diskInfoListJson.getJSONObject((Object)diskname);
                DiskState bean = new DiskState();
                bean.setFileSystem(diskname);
                bean.setHostname(bindIp);
                if (this.blockDisk(bean)) continue;
                bean.setCreateTime(nowTime);
                bean.setUsed(FormatUtil.formatDouble((Double)((double)diskJson.getLong((Object)"used").longValue() / 1024.0 / 1024.0 / 1024.0), (int)2) + "G");
                bean.setAvail(FormatUtil.formatDouble((Double)((double)diskJson.getLong((Object)"free").longValue() / 1024.0 / 1024.0 / 1024.0), (int)2) + "G");
                bean.setDiskSize(FormatUtil.formatDouble((Double)((double)diskJson.getLong((Object)"total").longValue() / 1024.0 / 1024.0 / 1024.0), (int)2) + "G");
                bean.setUsePer(FormatUtil.formatDouble((Double)diskJson.getDouble((Object)"usedPercent"), (int)2) + "%");
                willSaveList.add(bean);
                Runnable runnable = () -> WarnMailUtil.sendDiskWarnInfo((DiskState)bean);
                ThreadPoolUtil.executor.execute(runnable);
            }
            if (!CollectionUtil.isEmpty(willSaveList)) {
                BatchData.DISK_STATE_LIST.addAll(willSaveList);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u78c1\u76d8\u4e0a\u62a5\u6570\u636e\u9519\u8bef", (Throwable)e);
        }
    }

    private boolean blockDisk(DiskState diskState) {
        try {
            String diskBlock = this.mailConfig.getDiskBlockSave();
            HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(diskState.getHostname());
            if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive()) && !StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getDiskBlockSave())) {
                diskBlock = hostWarnDiyDto.getDiskBlockSave();
            }
            if (!StringUtils.isEmpty((CharSequence)diskBlock) && !StringUtils.isEmpty((CharSequence)diskState.getFileSystem())) {
                String[] blocks = diskBlock.split(",");
                AntPathMatcher pm = new AntPathMatcher();
                for (String diskBlcok : blocks) {
                    diskBlcok = diskBlcok.replace("'", "");
                    if ("/".equals(diskState.getFileSystem())) {
                        if (!diskBlcok.equals(diskState.getFileSystem())) continue;
                        return true;
                    }
                    boolean matchStart = pm.matchStart(diskBlcok, diskState.getFileSystem());
                    if (!matchStart) continue;
                    return matchStart;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5224\u65ad\u662f\u5426\u662f\u4e0d\u9700\u8981\u4fdd\u5b58\u7684\u78c1\u76d8\u9519\u8bef", (Throwable)e);
        }
        return false;
    }

    private void addDeskIo(JSONObject diskIoListJson, Date nowTime, String bindIp, JSONObject diskIoListJsonEnd) {
        try {
            JSONObject deskIoJsonObj;
            long startSumReadBytes = 0L;
            long startSumWriteBytes = 0L;
            long endSumReadBytes = 0L;
            long endSumWriteBytes = 0L;
            ArrayList keys = new ArrayList(diskIoListJson.keySet());
            ArrayList<DeskIo> willSaveList = new ArrayList<DeskIo>();
            for (Object diskname : keys) {
                DeskIo ioBean = new DeskIo();
                deskIoJsonObj = diskIoListJson.getJSONObject(diskname);
                if (null == deskIoJsonObj) continue;
                ioBean.setFileSystem((String)diskname);
                ioBean.setHostname(bindIp);
                ioBean.setCreateTime(nowTime);
                ioBean.setReadCount(deskIoJsonObj.getLong((Object)"readCount") + "");
                ioBean.setWriteCount(deskIoJsonObj.getLong((Object)"writeCount") + "");
                ioBean.setReadBytes(deskIoJsonObj.getLong((Object)"readBytes") / 1024L / 1024L / 1024L + "G");
                startSumReadBytes += deskIoJsonObj.getLong((Object)"readBytes").longValue();
                ioBean.setWriteBytes(deskIoJsonObj.getLong((Object)"writeBytes") / 1024L / 1024L / 1024L + "G");
                startSumWriteBytes += deskIoJsonObj.getLong((Object)"writeBytes").longValue();
                ioBean.setReadTime(deskIoJsonObj.getLong((Object)"readTime") + "");
                ioBean.setWriteTime(deskIoJsonObj.getLong((Object)"writeTime") + "");
                String serialNumber = deskIoJsonObj.getStr((Object)"serialNumber");
                if (!StringUtils.isEmpty((CharSequence)serialNumber)) {
                    ioBean.setFileSystem((String)diskname + " [" + serialNumber + "]");
                }
                willSaveList.add(ioBean);
            }
            if (!CollectionUtil.isEmpty(willSaveList)) {
                BatchData.DESK_IO_LIST.addAll(willSaveList);
            }
            if (!StaticKeys.LICENSE_STATE.equals("1")) {
                return;
            }
            ArrayList keysEnd = new ArrayList(diskIoListJsonEnd.keySet());
            for (String diskname : keysEnd) {
                deskIoJsonObj = diskIoListJsonEnd.getJSONObject((Object)diskname);
                if (null == deskIoJsonObj) continue;
                endSumReadBytes += deskIoJsonObj.getLong((Object)"readBytes").longValue();
                endSumWriteBytes += deskIoJsonObj.getLong((Object)"writeBytes").longValue();
            }
            double readMbAvg = FormatUtil.formatDouble((Double)((double)((endSumReadBytes - startSumReadBytes) / 2L) / 1024.0 / 1024.0), (int)2);
            double writeMbAvg = FormatUtil.formatDouble((Double)((double)((endSumWriteBytes - startSumWriteBytes) / 2L) / 1024.0 / 1024.0), (int)2);
            DiskIoState diskIoState = new DiskIoState();
            diskIoState.setHostname(bindIp);
            diskIoState.setReadIoAvg(readMbAvg + "");
            diskIoState.setWriteIoAvg(writeMbAvg + "");
            BatchData.DISK_IO_STATE_LIST.add(diskIoState);
            Runnable runnable = () -> WarnMailUtil.sendDiskIoSpeedWarnInfo((DiskIoState)diskIoState);
            ThreadPoolUtil.executor.execute(runnable);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u78c1\u76d8IO\u6570\u636e\u9519\u8bef", (Throwable)e);
        }
    }

    private void addDiskSmart(JSONObject diskSmartListJson, Date nowTime, String bindIp) {
        ArrayList keys = new ArrayList(diskSmartListJson.keySet());
        ArrayList<DiskSmart> willSaveList = new ArrayList<DiskSmart>();
        for (String diskname : keys) {
            try {
                DiskSmart smartBean = new DiskSmart();
                smartBean.setFileSystem(diskname);
                smartBean.setHostname(bindIp);
                smartBean.setCreateTime(nowTime);
                String[] smartStrs = diskSmartListJson.getStr((Object)diskname).split(",");
                smartBean.setDiskState(smartStrs[0]);
                smartBean.setPowerHours(smartStrs[1]);
                smartBean.setPowerCount(smartStrs[2]);
                smartBean.setTemperature(smartStrs[3]);
                willSaveList.add(smartBean);
                Runnable runnable = () -> WarnMailUtil.sendDiskSmartWarnInfo((DiskSmart)smartBean);
                ThreadPoolUtil.executor.execute(runnable);
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790\u78c1\u76d8smart\u6570\u636e\u9519\u8bef", (Throwable)e);
            }
        }
        if (!CollectionUtil.isEmpty(willSaveList)) {
            BatchData.DISK_SMART_LIST.addAll(willSaveList);
        }
    }

    private void addHostUsers(JSONArray hostUsersListJson, Date nowTime, String bindIp) {
        ArrayList<HostUsers> willSaveList = new ArrayList<HostUsers>();
        for (Object hostUserObj : hostUsersListJson) {
            try {
                HostUsers hostUser = new HostUsers();
                hostUser.setHostname(bindIp);
                hostUser.setCreateTime(nowTime);
                JSONObject hostUserJson = JSONUtil.parseObj(hostUserObj);
                String user = hostUserJson.getStr((Object)"user");
                hostUser.setHostUser(user);
                String lastLoginIp = hostUserJson.getStr((Object)"host");
                hostUser.setLastLoginIp(lastLoginIp);
                String terminal = hostUserJson.getStr((Object)"terminal");
                hostUser.setTerminal(terminal);
                String lastLoginTime = hostUserJson.getStr((Object)"started");
                String timeFormat = DateUtil.secondToDate((Long)Long.valueOf(lastLoginTime), (String)"yyyy-MM-dd HH:mm:ss");
                hostUser.setLastLoginTime(timeFormat);
                willSaveList.add(hostUser);
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790\u76d1\u63a7\u4e3b\u673a\u7684\u7cfb\u7edf\u7528\u6237\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            }
        }
        if (!CollectionUtil.isEmpty(willSaveList)) {
            BatchData.HOST_USERS_LIST.addAll(willSaveList);
        }
    }

    private void addFileSafes(JSONObject fileSafeJson, Date nowTime, String bindIp) {
        ArrayList keys = new ArrayList(fileSafeJson.keySet());
        for (String fileSafeId : keys) {
            try {
                JSONObject jsonObject = fileSafeJson.getJSONObject((Object)fileSafeId);
                String state = jsonObject.getStr((Object)"state");
                String fileModtime = jsonObject.getStr((Object)"fileModtime");
                String errorFileCount = jsonObject.getStr((Object)"errorFileCount");
                FileSafe fileSafe = new FileSafe();
                fileSafe.setId(fileSafeId);
                fileSafe.setCreateTime(nowTime);
                fileSafe.setState(state);
                if (!StringUtils.isEmpty((CharSequence)fileModtime)) {
                    fileSafe.setFileModtime(DateUtil.secondToDate((Long)Long.valueOf(fileModtime), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                String errorFileCountFinal = errorFileCount;
                this.messageErrorUtils.setErrorMsgHandler(fileSafeId, errorFileCountFinal);
                if (!"1".equals(state)) {
                    fileSafe.setState("2");
                    fileSafe.setCreateTime(null);
                    BatchData.FILE_SAFE_LIST.add(fileSafe);
                    Runnable runnable = () -> {
                        try {
                            FileSafe fileSafeOld = this.fileSafeService.selectById(fileSafeId);
                            fileSafeOld.setFileModtime(fileSafe.getFileModtime());
                            if (fileSafeOld != null) {
                                WarnMailUtil.sendFileSafeDown((FileSafe)fileSafeOld, (boolean)true, (String)errorFileCountFinal);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    };
                    ThreadPoolUtil.executor.execute(runnable);
                    continue;
                }
                BatchData.FILE_SAFE_LIST.add(fileSafe);
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790\u6587\u4ef6\u9632\u7be1\u6539\u76d1\u6d4b\u4fe1\u606f\u4e0a\u62a5\u6570\u636e\u9519\u8bef", (Throwable)e);
            }
        }
    }

    private void addCpuTemperatures(JSONArray temperaturesJsonArray, Date nowTime, String bindIp) {
        try {
            logger.debug("addCpuTemperatures--------------" + temperaturesJsonArray.toString());
            ArrayList<CpuTemperatures> willSaveList = new ArrayList<CpuTemperatures>();
            for (Object temperaturesObj : temperaturesJsonArray) {
                CpuTemperatures cpuTemperatures = new CpuTemperatures();
                cpuTemperatures.setHostname(bindIp);
                cpuTemperatures.setCreateTime(nowTime);
                JSONObject temperaturesJson = JSONUtil.parseObj(temperaturesObj);
                String sensor = temperaturesJson.getStr((Object)"sensorKey");
                String sensorTemperature = temperaturesJson.getStr((Object)"temperature");
                String sensorHigh = temperaturesJson.getStr((Object)"sensorHigh");
                String sensorCritical = temperaturesJson.getStr((Object)"sensorCritical");
                cpuTemperatures.setCore_index(sensor);
                cpuTemperatures.setCrit(sensorCritical);
                cpuTemperatures.setInput(sensorTemperature);
                cpuTemperatures.setMax(sensorHigh);
                willSaveList.add(cpuTemperatures);
                Runnable runnable = () -> WarnMailUtil.sendCpuTemperatures((CpuTemperatures)cpuTemperatures);
                ThreadPoolUtil.executor.execute(runnable);
            }
            if (!CollectionUtil.isEmpty(willSaveList)) {
                BatchData.CPU_TEMPERATURES_LIST.addAll(willSaveList);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790cpu\u6e29\u5ea6\u4e0a\u62a5\u6570\u636e\u9519\u8bef", (Throwable)e);
        }
    }

    private void addAppException(JSONObject processListJson, Date nowTime, String bindIp) {
        ArrayList keys = new ArrayList(processListJson.keySet());
        ArrayList<AppExceptionInfo> willSaveList = new ArrayList<AppExceptionInfo>();
        for (String proId : keys) {
            try {
                logger.info("addAppException--------" + processListJson.getStr((Object)proId) + "------------" + bindIp);
                String[] vals = processListJson.getStr((Object)proId).split(",");
                AppExceptionInfo appExceptionInfo = new AppExceptionInfo();
                appExceptionInfo.setHostname(bindIp);
                appExceptionInfo.setCreateTime(nowTime);
                appExceptionInfo.setState("1");
                appExceptionInfo.setMemPer(Double.valueOf(FormatUtil.formatDouble((Double)Double.valueOf(vals[1]), (int)2)));
                appExceptionInfo.setCpuPer(Double.valueOf(FormatUtil.formatDouble((Double)Double.valueOf(vals[0]), (int)2)));
                appExceptionInfo.setReadBytes(FormatUtil.formatDouble((Double)Double.valueOf(vals[2]), (int)2) + "");
                appExceptionInfo.setWritesBytes(FormatUtil.formatDouble((Double)Double.valueOf(vals[3]), (int)2) + "");
                appExceptionInfo.setThreadsNum(vals[4]);
                appExceptionInfo.setGatherPid(vals[5]);
                String appTimes = DateUtil.millisToDate((String)vals[6], (String)"yyyy-MM-dd HH:mm:ss");
                appExceptionInfo.setAppTimes(appTimes);
                appExceptionInfo.setProUsername(vals[7]);
                appExceptionInfo.setAppName(vals[8]);
                appExceptionInfo.setNetConnections(vals[9]);
                appExceptionInfo.setAppCmdLine(vals[10]);
                if (!LicenseUtil.checkEnterpriseVersion()) {
                    appExceptionInfo.setAppCmdLine("Please upgrade to Enterprise Edition to view this data");
                }
                if (null != appExceptionInfo.getAppName() && appExceptionInfo.getAppName().length() > 100) {
                    appExceptionInfo.setAppName(appExceptionInfo.getAppName().substring(0, 100));
                }
                if (null != appExceptionInfo.getAppCmdLine() && appExceptionInfo.getAppCmdLine().length() > 200) {
                    appExceptionInfo.setAppCmdLine(appExceptionInfo.getAppCmdLine().substring(0, 200));
                }
                willSaveList.add(appExceptionInfo);
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790\u5f02\u5e38\u8fdb\u7a0b\u4e0a\u62a5\u6570\u636e\u9519\u8bef", (Throwable)e);
            }
        }
        if (!CollectionUtil.isEmpty(willSaveList)) {
            BatchData.APP_EXCEPTION_INFO_LIST.addAll(willSaveList);
        }
    }

    private void addCacheHostAllProcess(JSONObject processListJson, Date nowTime, String bindIp) {
        ArrayList<AppExceptionInfo> willCacheList = new ArrayList<AppExceptionInfo>();
        if (!LicenseUtil.checkEnterpriseVersion()) {
            AppExceptionInfo appExceptionInfo = new AppExceptionInfo();
            appExceptionInfo.setMemPer(Double.valueOf(0.0));
            appExceptionInfo.setCpuPer(Double.valueOf(0.0));
            appExceptionInfo.setGatherPid("0");
            appExceptionInfo.setAppTimes("1970-01-01 08:00:00");
            appExceptionInfo.setProUsername("nobody");
            appExceptionInfo.setAppName("Please upgrade to Enterprise Edition to view this data");
            appExceptionInfo.setAppCmdLine("");
            willCacheList.add(appExceptionInfo);
            HostUtil.setAllProcessHandler((String)bindIp, willCacheList, (Date)nowTime);
            return;
        }
        ArrayList keys = new ArrayList(processListJson.keySet());
        for (String proId : keys) {
            try {
                logger.debug("addCacheHostAllProcess--------" + processListJson.getStr((Object)proId));
                String[] vals = processListJson.getStr((Object)proId).split(",");
                AppExceptionInfo appExceptionInfo = new AppExceptionInfo();
                appExceptionInfo.setMemPer(Double.valueOf(FormatUtil.formatDouble((Double)Double.valueOf(vals[1]), (int)2)));
                appExceptionInfo.setCpuPer(Double.valueOf(FormatUtil.formatDouble((Double)Double.valueOf(vals[0]), (int)2)));
                appExceptionInfo.setGatherPid(vals[2]);
                String appTimes = DateUtil.millisToDate((String)vals[3], (String)"yyyy-MM-dd HH:mm:ss");
                appExceptionInfo.setAppTimes(appTimes);
                appExceptionInfo.setProUsername(vals[4]);
                appExceptionInfo.setAppName(vals[5]);
                appExceptionInfo.setAppCmdLine(vals[6]);
                willCacheList.add(appExceptionInfo);
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790\u4e3b\u673a\u5168\u91cf\u8fdb\u7a0b\u6570\u636e\u9519\u8bef", (Throwable)e);
            }
        }
        if (!CollectionUtil.isEmpty(willCacheList)) {
            HostUtil.setAllProcessHandler((String)bindIp, willCacheList, (Date)nowTime);
        }
    }

    private void addCacheHostGpuInfo(String gpuJson, Date nowTime, String bindIp) {
        try {
            if (!LicenseUtil.checkEnterpriseVersion()) {
                HostUtil.setImportDataHandler((String)(bindIp + "_GPU"), (String)"Please upgrade to Enterprise Edition to view this data", (Date)nowTime);
                return;
            }
            if (null != gpuJson) {
                HostUtil.setImportDataHandler((String)(bindIp + "_GPU"), (String)gpuJson, (Date)nowTime);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u4e3b\u673aGPU\u91c7\u96c6\u6570\u636e\u9519\u8bef", (Throwable)e);
        }
    }

    private void addCacheHostFireWall(String fireWallJson, Date nowTime, String bindIp) {
        try {
            if (!LicenseUtil.checkEnterpriseVersion()) {
                HostUtil.setImportDataHandler((String)(bindIp + "_FIREWALL"), (String)"Please upgrade to Enterprise Edition to view this data", (Date)nowTime);
                return;
            }
            if (null != fireWallJson) {
                HostUtil.setImportDataHandler((String)(bindIp + "_FIREWALL"), (String)fireWallJson, (Date)nowTime);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u4e3b\u673aFireWall\u91c7\u96c6\u6570\u636e\u9519\u8bef", (Throwable)e);
        }
    }

    private void addCacheHostPortAll(String portAllDataJson, Date nowTime, String bindIp) {
        try {
            if (!LicenseUtil.checkEnterpriseVersion()) {
                HostUtil.setImportDataHandler((String)(bindIp + "_ALLPORT"), (String)"Please upgrade to Enterprise Edition to view this data", (Date)nowTime);
                return;
            }
            if (null != portAllDataJson) {
                HostUtil.setImportDataHandler((String)(bindIp + "_ALLPORT"), (String)portAllDataJson, (Date)nowTime);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u4e3b\u673a\u5168\u91cf\u7aef\u53e3\u91c7\u96c6\u6570\u636e\u9519\u8bef", (Throwable)e);
        }
    }

    private void addCacheHostCrontab(String crontabJson, Date nowTime, String bindIp) {
        try {
            if (!LicenseUtil.checkEnterpriseVersion()) {
                HostUtil.setImportDataHandler((String)(bindIp + "_CRONTAB"), (String)"Please upgrade to Enterprise Edition to view this data", (Date)nowTime);
                return;
            }
            if (null != crontabJson) {
                HostUtil.setImportDataHandler((String)(bindIp + "_CRONTAB"), (String)crontabJson, (Date)nowTime);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u4e3b\u673aCRONTAB\u91c7\u96c6\u6570\u636e\u9519\u8bef", (Throwable)e);
        }
    }

    private void addCacheHostLikeShell(String likeShellDataJson, Date nowTime, String bindIp) {
        try {
            if (!LicenseUtil.checkEnterpriseVersion()) {
                HostUtil.setImportDataHandler((String)(bindIp + "_LIKE_SHELL"), (String)"Please upgrade to Enterprise Edition to view this data", (Date)nowTime);
                return;
            }
            if (null != likeShellDataJson) {
                HostUtil.setImportDataHandler((String)(bindIp + "_LIKE_SHELL"), (String)likeShellDataJson, (Date)nowTime);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u4e3b\u673a\u4e3b\u673a\u4e2a\u6027\u5316\u91c7\u96c6\u547d\u4ee4\u6570\u636e\u9519\u8bef", (Throwable)e);
        }
    }

    private void addCacheHostDockerAllList(String dockerAllListDataJson, Date nowTime, String bindIp) {
        try {
            if (!LicenseUtil.checkEnterpriseVersion()) {
                return;
            }
            if (null != dockerAllListDataJson) {
                HostUtil.setImportDataHandler((String)(bindIp + "_ALL_DOCKER"), (String)dockerAllListDataJson, (Date)nowTime);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u4e3b\u673a\u5168\u91cfdocker\u5217\u8868\u6570\u636e\u9519\u8bef", (Throwable)e);
        }
    }

    private boolean isExists(String bindIp) {
        try {
            if (StringUtils.isEmpty((CharSequence)bindIp)) {
                return true;
            }
            if (CollectionUtil.isEmpty((Collection)BatchData.DISK_STATE_LIST) && CollectionUtil.isEmpty((Collection)BatchData.DESK_IO_LIST) && CollectionUtil.isEmpty((Collection)BatchData.DISK_SMART_LIST)) {
                return false;
            }
            ArrayList diskStateList = new ArrayList();
            diskStateList.addAll(BatchData.DISK_STATE_LIST);
            for (Object diskState : diskStateList) {
                if (!bindIp.equals(diskState.getHostname())) continue;
                return true;
            }
            ArrayList deskIoList = new ArrayList();
            deskIoList.addAll(BatchData.DESK_IO_LIST);
            for (DeskIo deskIo : deskIoList) {
                if (!bindIp.equals(deskIo.getHostname())) continue;
                return true;
            }
            ArrayList diskSmartList = new ArrayList();
            diskSmartList.addAll(BatchData.DISK_SMART_LIST);
            for (DiskSmart diskSmart : diskSmartList) {
                if (!bindIp.equals(diskSmart.getHostname())) continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.error("check bindIp\u9519\u8bef", (Throwable)e);
        }
        return false;
    }
}

