/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.service.AccountInfoService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.IpUtil;
import com.wgcloud.util.MD5Utils;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.msg.WarnOtherUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/login"})
public class LoginController {
    private static final Logger logger = LoggerFactory.getLogger(LoginController.class);
    private static final String USER_BLOCK = "block";
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private AccountInfoService accountInfoService;
    @Resource
    private CommonConfig commonConfig;

    private void testThread() {
        Runnable runnable = () -> logger.info("LoginCotroller----------testThread");
        ThreadPoolUtil.executor.execute(runnable);
    }

    @RequestMapping(value={"toLogin"})
    public String toLogin(Model model, HttpServletRequest request) {
        return "login/login";
    }

    @RequestMapping(value={"loginOut"})
    public String loginOut(Model model, HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.invalidate();
        return "redirect:/login/toLogin";
    }

    @RequestMapping(value={"login"})
    public String login(Model model, HttpServletRequest request) {
        String vercode;
        HttpSession session = request.getSession();
        if ("true".equals(this.commonConfig.getVercodeCheck()) && (StringUtils.isEmpty((CharSequence)(vercode = request.getParameter("validateCode"))) || !vercode.toLowerCase().equals(session.getAttribute("validateCode")))) {
            model.addAttribute("error", (Object)"Verification code error");
            return "login/login";
        }
        if (StaticKeys.PASSWD_EXP_DATE) {
            model.addAttribute("error", (Object)"Password expired");
            return "login/login";
        }
        if ("ERROR".equals(StaticKeys.WGCLOUD_SERVER_RELEASE_MD5STR)) {
            model.addAttribute("error", (Object)"Please restore wgcloud-server-release.jar");
            return "login/login";
        }
        String userName = request.getParameter("userName");
        String userBlock = (String)StaticKeys.LOGIN_BLOCK_MAP.get((Object)userName);
        if (USER_BLOCK.equals(userBlock)) {
            model.addAttribute("error", (Object)"Please login to the account or contact the administrator in 20 minutes");
            return "login/login";
        }
        String passwd = request.getParameter("md5pwd");
        session.setAttribute("sidebarCollapse", (Object)"sidebar-mini sidebar-collapse");
        session.setAttribute("themeNameSign", (Object)"");
        session.setAttribute("themeTableHoverSign", (Object)"table-hover");
        try {
            if (!StringUtils.isEmpty((CharSequence)userName) && !StringUtils.isEmpty((CharSequence)passwd)) {
                passwd = passwd.toLowerCase();
                AccountInfo accountInfo = new AccountInfo();
                if (MD5Utils.GetMD5Code((String)this.commonConfig.getAccountPwd()).equals(passwd) && this.commonConfig.getAccount().equals(userName)) {
                    accountInfo.setAccount(userName);
                    accountInfo.setId(userName);
                    accountInfo.setRole("admin");
                    if (StringUtils.isEmpty((CharSequence)StaticKeys.ADMIN_MENUDIS)) {
                        accountInfo.setMenuIds(this.accountInfoService.getAllMenuIdsStr());
                    } else {
                        accountInfo.setMenuIds(StaticKeys.ADMIN_MENUDIS);
                    }
                    session.setAttribute("LOGIN_KEY", (Object)accountInfo);
                    this.saveLoginData(accountInfo, request);
                    return "redirect:/dash/main";
                }
                if (StaticKeys.LICENSE_STATE.equals("1") && "true".equals(this.commonConfig.getUserInfoManage())) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("account", userName);
                    params.put("passwd", passwd);
                    List userList = this.accountInfoService.selectAllByParams(params);
                    if (userList.size() > 0) {
                        AccountInfo accountInfoFromData = (AccountInfo)userList.get(0);
                        accountInfo.setAccount(userName);
                        accountInfo.setId(userName);
                        if ("guest".equals(accountInfoFromData.getRole())) {
                            accountInfo.setRole("guest");
                        } else {
                            accountInfo.setRole("user");
                        }
                        if (StringUtils.isEmpty((CharSequence)accountInfoFromData.getMenuIds())) {
                            accountInfo.setMenuIds(this.accountInfoService.getAllMenuIdsStr());
                        } else {
                            accountInfo.setMenuIds(accountInfoFromData.getMenuIds());
                        }
                        session.setAttribute("LOGIN_KEY", (Object)accountInfo);
                        this.saveLoginData(accountInfo, request);
                        return "redirect:/dash/main";
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u767b\u5f55\u9519\u8bef", (Throwable)e);
        }
        model.addAttribute("error", (Object)"Account or password error");
        this.loginErrorHandle(request, model);
        return "login/login";
    }

    private void loginErrorHandle(HttpServletRequest request, Model model) {
        String requestIp = IpUtil.getIpAddr((HttpServletRequest)request);
        String userName = request.getParameter("userName");
        Integer errorCount = (Integer)StaticKeys.LOGIN_ERROR_MAP.get((Object)userName);
        if (errorCount != null) {
            StaticKeys.LOGIN_ERROR_MAP.put((Object)userName, (Object)(errorCount + 1));
        } else {
            errorCount = 1;
            StaticKeys.LOGIN_ERROR_MAP.put((Object)userName, (Object)errorCount);
        }
        if (errorCount >= 2) {
            model.addAttribute("error", (Object)"Account or password error. If entered incorrectly 5 times in a row, it will take 20 minutes to log in to the account again");
        }
        if (errorCount >= 5) {
            StaticKeys.LOGIN_BLOCK_MAP.put((Object)userName, (Object)USER_BLOCK);
            String errMsg = userName + "Password entered incorrectly 5 times in a row, login prohibited for 20 minutes, login IP: " + requestIp;
            Runnable runnable = () -> {
                try {
                    WarnOtherUtil.sendUtil((String)errMsg, (String)errMsg, (String)userName, (String)(userName + "_longError"), (boolean)true, (String)"ERROR", (String)"");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            };
            ThreadPoolUtil.executor.execute(runnable);
            model.addAttribute("error", (Object)"The password has been error 5 times. Please log in to this account again in 20 minutes");
            logger.error(errMsg);
        }
    }

    @RequestMapping(value={"sso"})
    public String ssoLogin(Model model, HttpServletRequest request) {
        if ("ERROR".equals(StaticKeys.WGCLOUD_SERVER_RELEASE_MD5STR)) {
            model.addAttribute("error", (Object)"Please restore wgcloud-server-release.jar");
            return "login/login";
        }
        String userName = request.getParameter("userName");
        String userBlock = (String)StaticKeys.LOGIN_BLOCK_MAP.get((Object)userName);
        if (USER_BLOCK.equals(userBlock)) {
            model.addAttribute("error", (Object)"Please log in to this account in 20 minutes");
            return "login/login";
        }
        if (!LicenseUtil.checkEnterpriseVersion()) {
            model.addAttribute("error", (Object)"Please upgrade to Enterprise Edition");
            return "login/login";
        }
        if ("true".equals(this.commonConfig.getOpenSSO())) {
            if (StringUtils.isEmpty((CharSequence)userName)) {
                return "redirect:/login/toLogin";
            }
            AccountInfo accountInfoSso = this.ssoHandle(userName, request);
            if (null == accountInfoSso) {
                return "redirect:/login/toLogin";
            }
            return "redirect:/dash/main";
        }
        model.addAttribute("error", (Object)"sso\u9519\u8bef");
        this.loginErrorHandle(request, model);
        return "login/login";
    }

    private AccountInfo ssoHandle(String userName, HttpServletRequest request) {
        AccountInfo accountInfo = null;
        try {
            if (this.commonConfig.getAccount().equals(userName)) {
                accountInfo = new AccountInfo();
                accountInfo.setAccount(userName);
                accountInfo.setId(userName);
                accountInfo.setRole("admin");
                if (StringUtils.isEmpty((CharSequence)StaticKeys.ADMIN_MENUDIS)) {
                    accountInfo.setMenuIds(this.accountInfoService.getAllMenuIdsStr());
                } else {
                    accountInfo.setMenuIds(StaticKeys.ADMIN_MENUDIS);
                }
                request.getSession().setAttribute("LOGIN_KEY", (Object)accountInfo);
            }
            if ("true".equals(this.commonConfig.getUserInfoManage())) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("account", userName);
                List userList = this.accountInfoService.selectAllByParams(params);
                if (userList.size() > 0) {
                    accountInfo = new AccountInfo();
                    AccountInfo accountInfoFromData = (AccountInfo)userList.get(0);
                    accountInfo.setAccount(userName);
                    accountInfo.setId(userName);
                    if ("guest".equals(accountInfoFromData.getRole())) {
                        accountInfo.setRole("guest");
                    } else {
                        accountInfo.setRole("user");
                    }
                    if (StringUtils.isEmpty((CharSequence)accountInfoFromData.getMenuIds())) {
                        accountInfo.setMenuIds(this.accountInfoService.getAllMenuIdsStr());
                    } else {
                        accountInfo.setMenuIds(accountInfoFromData.getMenuIds());
                    }
                    request.getSession().setAttribute("LOGIN_KEY", (Object)accountInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error("sso\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
        return accountInfo;
    }

    private void saveLoginData(AccountInfo accountInfo, HttpServletRequest request) {
        try {
            String requestIp = IpUtil.getIpAddr((HttpServletRequest)request);
            this.logInfoService.save("Account " + accountInfo.getAccount() + " success logged into the system\uff0cIP\uff1a" + requestIp, "IP\uff1a" + requestIp, "2");
        }
        catch (Exception e) {
            logger.error("saveLoginData\u9519\u8bef", (Throwable)e);
        }
    }

    @ResponseBody
    @RequestMapping(value={"ajaxSwapMenuState"})
    public String ajaxSwapMenuState(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Object object = session.getAttribute("sidebarCollapse");
        if (null != object) {
            if ("sidebar-mini sidebar-collapse".equals(object.toString())) {
                session.setAttribute("sidebarCollapse", (Object)"sidebar-mini");
            } else {
                session.setAttribute("sidebarCollapse", (Object)"sidebar-mini sidebar-collapse");
            }
        } else {
            session.setAttribute("sidebarCollapse", (Object)"sidebar-mini sidebar-collapse");
        }
        return "success";
    }
}

