/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.FileUtils;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.TokenUtils;
import com.wgcloud.util.msg.WarnPools;
import com.wgcloud.util.staticvar.StaticKeys;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/nginxMonitor"})
public class NginxMonitorController {
    private static final Logger logger = LoggerFactory.getLogger(NginxMonitorController.class);
    @Resource
    private LogInfoService logInfoService;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private TokenUtils tokenUtils;
    private static final String sqlChars = "xp_cmdshell,%20xor,%20and,%20AND,%20or,%20OR,select%20,%20and%201=1,%20and%201=2,%20from,%27exec,information_schema.tables,load_file,benchmark,substring,table_name,table_schema,%20where%20,%20union%20,%20UNION%20,concat(,concat_ws(,%20group%20,0x5f,0x7e,0x7c,0x27,%20limit,current_user,%20LIMIT,version%28,version(,database%28,database(,user%28,user(,%20extractvalue,%updatexml,rand(0)*2,%20group%20by%20x,%20NULL%2C,sqlmap";
    private static final String scanChars = "acunetix,by_wvs,nikto,netsparker,HP404,nsfocus,WebCruiser,owasp,nmap,nessus,HEAD /,AppScan,burpsuite,w3af,ZAP,openVAS,.+avij,.+angolin,360webscan,webscan,XSS@HERE,XSS%40HERE,NOSEC.JSky,wwwscan,wscan,antSword,WebVulnScan,WebInspect,ltx71,masscan,python-requests,Python-urllib,WinHttpRequest";
    String spider = "spider,pider,Googlebot";

    @RequestMapping(value={"toAddView"})
    public String toAddView(Model model, HttpServletRequest request) {
        model.addAttribute("NGINX_CHECK_DAY_COUNT", (Object)WarnPools.NGINX_CHECK_DAY_COUNT);
        return "nginx/add";
    }

    @RequestMapping(value={"/uploadLog"})
    public String singleFileUpload(@RequestParam(value="file") MultipartFile file, Model model, HttpServletRequest request) {
        AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
        if ("guest".equals(accountInfo.getRole())) {
            return "redirect:/common/error/guestError";
        }
        model.addAttribute("NGINX_CHECK_DAY_COUNT", (Object)WarnPools.NGINX_CHECK_DAY_COUNT);
        if (!StaticKeys.LICENSE_STATE.equals("1") && WarnPools.NGINX_CHECK_DAY_COUNT > 0) {
            model.addAttribute("msg", (Object)"The personal version can only be tested once a day. Please contact us to upgrade to the professional version");
            return "nginx/add";
        }
        if (StaticKeys.LICENSE_STATE.equals("1") && WarnPools.NGINX_CHECK_DAY_COUNT > StaticKeys.LICENSE_NUM) {
            model.addAttribute("msg", (Object)("This professional version is authorized to be tested up to " + StaticKeys.LICENSE_NUM + " times a day. Please contact us to upgrade the authorization"));
            return "nginx/add";
        }
        if (file.isEmpty()) {
            logger.error("\u6587\u4ef6\u4e3a\u7a7a,\u8bf7\u9009\u62e9Nginx Log\u6587\u4ef6\u4e0a\u4f20");
            model.addAttribute("msg", (Object)"The file is empty, please select your file to upload");
            return "nginx/add";
        }
        if (!file.getOriginalFilename().endsWith(".log")) {
            logger.error("\u8bf7\u4e0a\u4f20.log\u6587\u4ef6");
            model.addAttribute("msg", (Object)"Please upload Nginx's .log file");
            return "nginx/add";
        }
        String sourceFileName = file.getOriginalFilename();
        model.addAttribute("accessLogName", (Object)sourceFileName);
        String saveFolder = StaticKeys.JAR_PATH + "/nginxLog";
        FileUtils.existsFolder((String)saveFolder);
        String newFileName = saveFolder + "/" + DateUtil.getCurrentDateTimeNoChar() + ".log";
        Path path = Paths.get(newFileName, new String[0]);
        try {
            file.transferTo(path);
            this.checkNgingLog(newFileName, model);
            this.logInfoService.save(HostUtil.getAccountByRequest((HttpServletRequest)request).getAccount() + "\u4e0a\u4f20\u5e76\u68c0\u6d4bNingx\u65e5\u5fd7\u6587\u4ef6: " + sourceFileName, newFileName, "2");
            WarnPools.NGINX_CHECK_DAY_COUNT = WarnPools.NGINX_CHECK_DAY_COUNT + 1;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20nginx\u65e5\u5fd7\u6587\u4ef6\u9519\u8bef", (Throwable)e);
            model.addAttribute("msg", (Object)e.toString());
        }
        return "nginx/view";
    }

    private void checkNgingLog(String fileName, Model model) {
        try {
            File file = new File(fileName);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String[] sqlCharArr = sqlChars.split(",");
            String[] scanCharArr = scanChars.split(",");
            String[] spiderCharArr = this.spider.split(",");
            String resultContent = "";
            String strLine = null;
            int code404 = 0;
            int code408 = 0;
            int code413 = 0;
            int code414 = 0;
            int code400 = 0;
            int code401 = 0;
            int code403 = 0;
            int code301 = 0;
            int code500 = 0;
            int code502 = 0;
            int code503 = 0;
            int sqlCount = 0;
            int scanCount = 0;
            int spiderCount = 0;
            HashSet<String> setIp = new HashSet<String>();
            HashMap<String, Integer> ipCountMap = new HashMap<String, Integer>();
            block2: while (null != (strLine = bufferedReader.readLine())) {
                if (StringUtils.isEmpty((CharSequence)strLine)) continue;
                String ip = strLine.substring(0, strLine.indexOf("-"));
                setIp.add(ip.trim());
                if (ipCountMap.get(ip) == null) {
                    ipCountMap.put(ip, 1);
                } else {
                    ipCountMap.put(ip, (Integer)ipCountMap.get(ip) + 1);
                }
                if (strLine.contains(" 400 ")) {
                    ++code400;
                }
                if (strLine.contains(" 401 ")) {
                    ++code401;
                }
                if (strLine.contains(" 403 ")) {
                    ++code403;
                }
                if (strLine.contains(" 404 ")) {
                    ++code404;
                }
                if (strLine.contains(" 408 ")) {
                    ++code408;
                }
                if (strLine.contains(" 413 ")) {
                    ++code413;
                }
                if (strLine.contains(" 414 ")) {
                    ++code414;
                }
                if (strLine.contains(" 301 ")) {
                    ++code301;
                }
                if (strLine.contains(" 500 ")) {
                    ++code500;
                }
                if (strLine.contains(" 502 ")) {
                    ++code502;
                }
                if (strLine.contains(" 503 ")) {
                    ++code503;
                }
                for (String sqlCharTemp : sqlCharArr) {
                    if (!strLine.contains(sqlCharTemp)) continue;
                    ++sqlCount;
                    break;
                }
                for (String scanCharTemp : scanCharArr) {
                    if (!strLine.contains(scanCharTemp)) continue;
                    ++scanCount;
                    break;
                }
                for (String spiderCharTemp : spiderCharArr) {
                    if (!strLine.contains(spiderCharTemp)) continue;
                    ++spiderCount;
                    continue block2;
                }
            }
            resultContent = resultContent + "Total number of IP: " + setIp.size() + "</br>";
            resultContent = resultContent + "Response status code 400 total occurrences: " + code400 + "</br>";
            resultContent = resultContent + "Response status code 401 total occurrences: " + code401 + "</br>";
            resultContent = resultContent + "Response status code 403 total occurrences: " + code403 + "</br>";
            resultContent = resultContent + "Response status code 404 total occurrences: " + code404 + "</br>";
            resultContent = resultContent + "Response status code 408 total occurrences: " + code408 + "</br>";
            resultContent = resultContent + "Response status code 413 total occurrences: " + code413 + "</br>";
            resultContent = resultContent + "Response status code 414 total occurrences: " + code414 + "</br>";
            resultContent = resultContent + "Response status code 301 total occurrences: " + code301 + "</br>";
            resultContent = resultContent + "Response status code 500 total occurrences: " + code500 + "</br>";
            resultContent = resultContent + "Response status code 502 total occurrences: " + code502 + "</br>";
            resultContent = resultContent + "Response status code 503 total occurrences: " + code503 + "</br>";
            resultContent = resultContent + "Total number of SQL injection attacks: " + sqlCount + "</br>";
            resultContent = resultContent + "Total number of scanning attacks detected: " + scanCount + "</br>";
            resultContent = resultContent + "The total number of times search engine spiders crawl: " + spiderCount + "</br>";
            resultContent = resultContent + "</br>The top 20 IP addresses with the highest number of visits are as follows (IP and number of visits)</br>";
            ArrayList ipCountMapIds = new ArrayList(ipCountMap.entrySet());
            Collections.sort(ipCountMapIds, new /* Unavailable Anonymous Inner Class!! */);
            if (ipCountMapIds.size() <= 20) {
                for (int i = 0; i < ipCountMapIds.size(); ++i) {
                    resultContent = resultContent + (String)((Map.Entry)ipCountMapIds.get(i)).getKey() + " visits " + ((Map.Entry)ipCountMapIds.get(i)).getValue() + "</br>";
                }
            } else {
                for (int i = 0; i < 20; ++i) {
                    resultContent = resultContent + (String)((Map.Entry)ipCountMapIds.get(i)).getKey() + " visits " + ((Map.Entry)ipCountMapIds.get(i)).getValue() + "</br>";
                }
            }
            model.addAttribute("nginxMonitorContent", (Object)resultContent);
        }
        catch (Exception e) {
            logger.error("nginx\u65e5\u5fd7\u6587\u4ef6\u89e3\u6790\u9519\u8bef", (Throwable)e);
        }
    }
}

