/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.github.pagehelper.PageInfo;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.RedisMonitor;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.RedisMonitorService;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.MessageErrorUtils;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.TokenUtils;
import com.wgcloud.util.license.LicenseUtil;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/redisMonitor"})
public class RedisMonitorController {
    private static final Logger logger = LoggerFactory.getLogger(RedisMonitorController.class);
    @Resource
    private RedisMonitorService redisMonitorService;
    @Resource
    private LogInfoService logInfoService;
    @Autowired
    private MessageErrorUtils messageErrorUtils;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private TokenUtils tokenUtils;

    @RequestMapping(value={"list"})
    public String kafkaMonitorList(RedisMonitor redisMonitor, Model model, HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            LicenseUtil.maxLicense_10((Model)model, (HttpServletRequest)request, (Object)redisMonitor);
            StringBuffer url = new StringBuffer();
            if (!StringUtils.isEmpty((CharSequence)redisMonitor.getState())) {
                params.put("state", redisMonitor.getState());
                url.append("&state=").append(redisMonitor.getState());
            }
            if (!StringUtils.isEmpty((CharSequence)redisMonitor.getRedisName())) {
                params.put("redisName", redisMonitor.getRedisName());
                url.append("&redisName=").append(redisMonitor.getRedisName());
            }
            PageInfo pageInfo = this.redisMonitorService.selectByParams(params, redisMonitor.getPage().intValue(), redisMonitor.getPageSize().intValue());
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            model.addAttribute("pageUrl", (Object)("/redisMonitor/list?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("redisMonitor", (Object)redisMonitor);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2redis\u76d1\u63a7\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2redis\u76d1\u63a7\u4fe1\u606f\u9519\u8bef", e.toString(), "2");
        }
        return "redis/list";
    }

    @RequestMapping(value={"view"})
    public String viewRedisMonitor(Model model, HttpServletRequest request) {
        String id = request.getParameter("id");
        RedisMonitor redisMonitor = new RedisMonitor();
        try {
            redisMonitor = this.redisMonitorService.selectById(id);
            String content = "";
            content = content + "redis_version: " + redisMonitor.getRedisVersion() + "</br>";
            content = content + "redis_mode: " + redisMonitor.getRedisMode() + "</br>";
            content = content + "process_id: " + redisMonitor.getProcessId() + "</br>";
            content = content + "tcp_port: " + redisMonitor.getTcpPort() + "</br>";
            content = content + "uptime_in_days: " + redisMonitor.getUptimeInDays() + "</br>";
            content = content + "executable: " + redisMonitor.getExecutable() + "</br>";
            content = content + "config_file: " + redisMonitor.getConfigFile() + "</br>";
            content = content + "connected_clients: " + redisMonitor.getConnectedClients() + "</br>";
            content = content + "blocked_clients: " + redisMonitor.getBlockedClients() + "</br>";
            content = content + "used_memory_human: " + redisMonitor.getUsedMemoryHuman() + "</br>";
            content = content + "used_memory_peak_human: " + redisMonitor.getUsedMemoryPeakHuman() + "</br>";
            content = content + "maxmemory_human: " + redisMonitor.getMaxMemoryHuman() + "</br>";
            content = content + "aof_enabled: " + redisMonitor.getAofEnabled() + "</br>";
            content = content + "rdb_last_bgsave_status: " + redisMonitor.getRdbLastBgsaveStatus() + "</br>";
            content = content + "rdb_last_bgsave_time_sec: " + redisMonitor.getRdbLastBgsaveTimeSec() + "</br>";
            content = content + "instantaneous_ops_per_sec: " + redisMonitor.getInstantaneousOpsPerSec() + "</br>";
            content = content + "total_net_input_bytes: " + FormatUtil.bytesFormatUnit((String)redisMonitor.getTotalNetInputBytes(), (String)"byte") + "</br>";
            content = content + "total_net_output_bytes: " + FormatUtil.bytesFormatUnit((String)redisMonitor.getTotalNetOutputBytes(), (String)"byte") + "</br>";
            content = content + "rejected_connections: " + redisMonitor.getRejectedConnections() + "</br>";
            content = content + "role: " + redisMonitor.getRedisRole() + "</br>";
            content = content + "connected_slaves: " + redisMonitor.getConnectedSlaves() + "</br>";
            content = content + "used_cpu_sys: " + redisMonitor.getUsedCpuSys() + "</br>";
            content = content + "expired_keys: " + redisMonitor.getExpiredKeys() + "</br>";
            content = content + "evicted_keys: " + redisMonitor.getEvictedKeys() + "</br>";
            content = content + "keyspace_hits: " + redisMonitor.getKeyspaceHits() + "</br>";
            content = content + "keyspace_misses: " + redisMonitor.getKeyspaceMisses() + "</br>";
            content = content + "pubsub_channels: " + redisMonitor.getPubsubChannels() + "</br>";
            content = content + "pubsub_patterns: " + redisMonitor.getPubsubPatterns() + "</br>";
            content = content + "cluster_enabled: " + redisMonitor.getClusterEnabled() + "</br>";
            model.addAttribute("redisMonitor", (Object)redisMonitor);
            model.addAttribute("redisMonitorContent", (Object)content);
            model.addAttribute("redisMonitorErrorMsg", (Object)this.messageErrorUtils.viewErrorMsgHandler(redisMonitor.getRedisName()));
        }
        catch (Exception e) {
            logger.error("\u67e5\u770bredis\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
        return "redis/view";
    }

    @RequestMapping(value={"del"})
    public String delete(Model model, HttpServletRequest request) {
        String errorMsg = "\u5220\u9664Redis\u4fe1\u606f\u9519\u8bef";
        RedisMonitor redisMonitor = new RedisMonitor();
        try {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                String[] ids;
                for (String id : ids = request.getParameter("id").split(",")) {
                    redisMonitor = this.redisMonitorService.selectById(id);
                    this.redisMonitorService.saveLog(request, " Delete ", redisMonitor);
                }
                this.redisMonitorService.deleteById(ids);
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "redirect:/redisMonitor/list";
    }
}

