/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.github.pagehelper.PageInfo;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.entity.ShellNoteInfo;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.ShellNoteInfoService;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.PageUtil;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/shellNoteInfo"})
public class ShellNoteInfoController {
    private static final Logger logger = LoggerFactory.getLogger(ShellNoteInfoController.class);
    @Resource
    private ShellNoteInfoService shellNoteInfoService;
    @Resource
    private LogInfoService logInfoService;
    @Autowired
    private CommonConfig commonConfig;

    @RequestMapping(value={"list"})
    public String shellNoteInfoList(ShellNoteInfo shellNoteInfo, Model model, HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
            if ("guest".equals(accountInfo.getRole())) {
                return "redirect:/common/error/guestError";
            }
            StringBuffer url = new StringBuffer();
            String shellTitle = null;
            if (!StringUtils.isEmpty((CharSequence)shellNoteInfo.getShellTitle())) {
                shellTitle = shellNoteInfo.getShellTitle();
                params.put("shellTitle", shellTitle.trim());
                url.append("&shellTitle=").append(shellTitle);
            }
            if (!StringUtils.isEmpty((CharSequence)shellNoteInfo.getAccount())) {
                params.put("account", shellNoteInfo.getAccount());
                url.append("&account=").append(shellNoteInfo.getAccount());
            }
            HostUtil.addAccountquery((HttpServletRequest)request, params);
            PageInfo pageInfo = this.shellNoteInfoService.selectByParams(params, shellNoteInfo.getPage().intValue(), shellNoteInfo.getPageSize().intValue());
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            HostUtil.addAccountListModel((Model)model);
            model.addAttribute("pageUrl", (Object)("/shellNoteInfo/list?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("shellNoteInfo", (Object)shellNoteInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6307\u4ee4\u7b14\u8bb0\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u6307\u4ee4\u7b14\u8bb0\u4fe1\u606f\u9519\u8bef", e.toString(), "2");
        }
        return "shellNoteInfo/list";
    }

    @RequestMapping(value={"save"})
    public String saveShellNoteInfo(ShellNoteInfo shellNoteInfo, Model model, HttpServletRequest request) {
        try {
            if (StringUtils.isEmpty((CharSequence)shellNoteInfo.getId())) {
                AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
                if (null != accountInfo && !"admin".equals(accountInfo.getRole())) {
                    shellNoteInfo.setAccount(accountInfo.getAccount());
                }
                this.shellNoteInfoService.save(shellNoteInfo);
                this.shellNoteInfoService.saveLog(request, " Add ", shellNoteInfo);
            } else {
                this.shellNoteInfoService.updateById(shellNoteInfo);
                this.shellNoteInfoService.saveLog(request, " Modify ", shellNoteInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u5de5\u4f5c\u7b14\u8bb0\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58\u5de5\u4f5c\u7b14\u8bb0\u9519\u8bef", e.toString(), "2");
        }
        return "redirect:/shellNoteInfo/list";
    }

    @RequestMapping(value={"edit"})
    public String edit(Model model, HttpServletRequest request) {
        String errorMsg = "\u6dfb\u52a0\u5de5\u4f5c\u7b14\u8bb0";
        String id = request.getParameter("id");
        ShellNoteInfo shellNoteInfo = new ShellNoteInfo();
        try {
            if (StringUtils.isEmpty((CharSequence)id)) {
                model.addAttribute("shellNoteInfo", (Object)shellNoteInfo);
                return "shellNoteInfo/add";
            }
            shellNoteInfo = this.shellNoteInfoService.selectById(id);
            model.addAttribute("shellNoteInfo", (Object)shellNoteInfo);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "shellNoteInfo/add";
    }

    @RequestMapping(value={"view"})
    public String viewChart(Model model, HttpServletRequest request) {
        String errorMsg = "\u67e5\u770b\u5de5\u4f5c\u7b14\u8bb0\u4fe1\u606f\u9519\u8bef";
        String id = request.getParameter("id");
        ShellNoteInfo shellNoteInfo = new ShellNoteInfo();
        try {
            shellNoteInfo = this.shellNoteInfoService.selectById(id);
            model.addAttribute("shellNoteInfo", (Object)shellNoteInfo);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "shellNoteInfo/view";
    }

    @RequestMapping(value={"del"})
    public String delete(Model model, HttpServletRequest request) {
        String errorMsg = "\u5220\u9664\u5de5\u4f5c\u7b14\u8bb0\u4fe1\u606f\u9519\u8bef";
        ShellNoteInfo ShellNoteInfo2 = new ShellNoteInfo();
        try {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                String[] ids;
                for (String id : ids = request.getParameter("id").split(",")) {
                    ShellNoteInfo2 = this.shellNoteInfoService.selectById(id);
                    this.shellNoteInfoService.saveLog(request, " Delete ", ShellNoteInfo2);
                }
                this.shellNoteInfoService.deleteById(ids);
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "redirect:/shellNoteInfo/list";
    }
}

