/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.alibaba.excel.EasyExcel;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.dto.NetworkInfoDto;
import com.wgcloud.dto.llm.AllAppExcelDto;
import com.wgcloud.dto.llm.CpuTemperExcelDto;
import com.wgcloud.dto.llm.DceStateExcelDto;
import com.wgcloud.dto.llm.DiskIoStateExcelDto;
import com.wgcloud.dto.llm.HostCpuStateExcelDto;
import com.wgcloud.dto.llm.HostDiskPerExcelDto;
import com.wgcloud.dto.llm.HostDiskStateExcelDto;
import com.wgcloud.dto.llm.HostLoadStateExcelDto;
import com.wgcloud.dto.llm.HostMacExcelDto;
import com.wgcloud.dto.llm.HostMemStateExcelDto;
import com.wgcloud.dto.llm.HostNetStateExcelDto;
import com.wgcloud.dto.llm.NetworkExcelDto;
import com.wgcloud.entity.AppExceptionInfo;
import com.wgcloud.entity.CpuState;
import com.wgcloud.entity.CpuTemperatures;
import com.wgcloud.entity.DceInfo;
import com.wgcloud.entity.DceState;
import com.wgcloud.entity.DiskIoState;
import com.wgcloud.entity.DiskState;
import com.wgcloud.entity.HostDiskPer;
import com.wgcloud.entity.HostMacInfo;
import com.wgcloud.entity.MemState;
import com.wgcloud.entity.NetIoState;
import com.wgcloud.entity.SysLoadState;
import com.wgcloud.entity.SystemInfo;
import com.wgcloud.service.AppStateService;
import com.wgcloud.service.CpuStateService;
import com.wgcloud.service.CpuTemperaturesService;
import com.wgcloud.service.CustomStateService;
import com.wgcloud.service.DbTableCountService;
import com.wgcloud.service.DceInfoService;
import com.wgcloud.service.DceStateService;
import com.wgcloud.service.DiskIoStateService;
import com.wgcloud.service.DiskSmartService;
import com.wgcloud.service.DiskStateService;
import com.wgcloud.service.DockerStateService;
import com.wgcloud.service.FileWarnStateService;
import com.wgcloud.service.HeathStateService;
import com.wgcloud.service.HostDiskPerService;
import com.wgcloud.service.HostMacInfoService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.MemStateService;
import com.wgcloud.service.NetIoStateService;
import com.wgcloud.service.SnmpStateService;
import com.wgcloud.service.SysLoadStateService;
import com.wgcloud.service.SystemInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.FileUtils;
import com.wgcloud.util.redis.RedisDataUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LargeModelService {
    private static final Logger logger = LoggerFactory.getLogger(LargeModelService.class);
    @Autowired
    CpuStateService cpuStateService;
    @Autowired
    CustomStateService customStateService;
    @Autowired
    MemStateService memStateService;
    @Autowired
    NetIoStateService netIoStateService;
    @Autowired
    SysLoadStateService sysLoadStateService;
    @Autowired
    AppStateService appStateService;
    @Autowired
    DbTableCountService dbTableCountService;
    @Autowired
    DockerStateService dockerStateService;
    @Autowired
    HeathStateService heathStateService;
    @Autowired
    DceStateService dceStateService;
    @Autowired
    SnmpStateService snmpStateService;
    @Autowired
    FileWarnStateService fileWarnStateService;
    @Autowired
    private LogInfoService logInfoService;
    @Resource
    private DiskStateService diskStateService;
    @Autowired
    private HostMacInfoService hostMacInfoService;
    @Resource
    private DiskSmartService diskSmartService;
    @Resource
    private CpuTemperaturesService cpuTemperaturesService;
    @Resource
    private HostDiskPerService hostDiskPerService;
    @Autowired
    private DiskIoStateService diskIoStateService;
    @Resource
    private SystemInfoService systemInfoService;
    @Resource
    private DceInfoService dceInfoService;
    @Autowired
    private CommonConfig commonConfig;

    public void exportHostCpuStateExcel() {
        try {
            Calendar now = Calendar.getInstance();
            now.setTime(new Date());
            now.set(5, now.get(5) - 1);
            String yesterdayDate = DateUtil.getString((Date)now.getTime(), (String)"yyyy-MM-dd");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("startTime", yesterdayDate + " 00:00:00");
            params.put("endTime", yesterdayDate + " 23:59:59");
            List cpuStateList = this.cpuStateService.selectAllByParams(params);
            ArrayList<HostCpuStateExcelDto> cpuStateDtoList = new ArrayList<HostCpuStateExcelDto>();
            for (CpuState cpuState : cpuStateList) {
                HostCpuStateExcelDto dto = new HostCpuStateExcelDto();
                dto.setCpuPer(cpuState.getSys());
                dto.setDatetime(DateUtil.getDateTimeString((Date)cpuState.getCreateTime()));
                dto.setProcsNum(cpuState.getProcsNum());
                dto.setHostName(cpuState.getHostname());
                cpuStateDtoList.add(dto);
            }
            String saveFolderUploadFile = StaticKeys.JAR_PATH + "/uploadFile";
            FileUtils.existsFolder((String)saveFolderUploadFile);
            String saveFolder = StaticKeys.JAR_PATH + "/uploadFile/llm";
            FileUtils.existsFolder((String)saveFolder);
            String fileName = yesterdayDate + "_AllHostCpuUsageData.xlsx";
            EasyExcel.write((String)(StaticKeys.JAR_PATH + "/uploadFile/llm/" + fileName), HostCpuStateExcelDto.class).sheet("sheet").doWrite(cpuStateDtoList);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5168\u91cf\u4e3b\u673aCPU\u4f7f\u7528\u7387\u6570\u636eexcel\u9519\u8bef", (Throwable)e);
        }
    }

    public void exportHostMemStateExcel() {
        try {
            Calendar now = Calendar.getInstance();
            now.setTime(new Date());
            now.set(5, now.get(5) - 1);
            String yesterdayDate = DateUtil.getString((Date)now.getTime(), (String)"yyyy-MM-dd");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("startTime", yesterdayDate + " 00:00:00");
            params.put("endTime", yesterdayDate + " 23:59:59");
            List memStateList = this.memStateService.selectAllByParams(params);
            ArrayList<HostMemStateExcelDto> memStateDtoList = new ArrayList<HostMemStateExcelDto>();
            for (MemState memState : memStateList) {
                HostMemStateExcelDto dto = new HostMemStateExcelDto();
                dto.setMemPer(memState.getUsePer());
                dto.setDatetime(DateUtil.getDateTimeString((Date)memState.getCreateTime()));
                dto.setHostName(memState.getHostname());
                memStateDtoList.add(dto);
            }
            String saveFolderUploadFile = StaticKeys.JAR_PATH + "/uploadFile";
            FileUtils.existsFolder((String)saveFolderUploadFile);
            String saveFolder = StaticKeys.JAR_PATH + "/uploadFile/llm";
            FileUtils.existsFolder((String)saveFolder);
            String fileName = yesterdayDate + "_AllHostMemoryUsageData.xlsx";
            EasyExcel.write((String)(StaticKeys.JAR_PATH + "/uploadFile/llm/" + fileName), HostMemStateExcelDto.class).sheet("sheet").doWrite(memStateDtoList);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5168\u91cf\u4e3b\u673a\u5185\u5b58\u4f7f\u7528\u7387excel\u9519\u8bef", (Throwable)e);
        }
    }

    public void exportHostLoadStateExcel() {
        try {
            Calendar now = Calendar.getInstance();
            now.setTime(new Date());
            now.set(5, now.get(5) - 1);
            String yesterdayDate = DateUtil.getString((Date)now.getTime(), (String)"yyyy-MM-dd");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("startTime", yesterdayDate + " 00:00:00");
            params.put("endTime", yesterdayDate + " 23:59:59");
            List sysLoadStateList = this.sysLoadStateService.selectAllByParams(params);
            ArrayList<HostLoadStateExcelDto> loadStateDtoList = new ArrayList<HostLoadStateExcelDto>();
            for (SysLoadState sysLoadState : sysLoadStateList) {
                HostLoadStateExcelDto dto = new HostLoadStateExcelDto();
                dto.setFifteenLoad(sysLoadState.getFifteenLoad());
                dto.setFiveLoad(sysLoadState.getFiveLoad());
                dto.setOneLoad(sysLoadState.getOneLoad());
                dto.setDatetime(DateUtil.getDateTimeString((Date)sysLoadState.getCreateTime()));
                dto.setHostName(sysLoadState.getHostname());
                loadStateDtoList.add(dto);
            }
            String saveFolderUploadFile = StaticKeys.JAR_PATH + "/uploadFile";
            FileUtils.existsFolder((String)saveFolderUploadFile);
            String saveFolder = StaticKeys.JAR_PATH + "/uploadFile/llm";
            FileUtils.existsFolder((String)saveFolder);
            String fileName = yesterdayDate + "_AllHostSystemLoadData.xlsx";
            EasyExcel.write((String)(StaticKeys.JAR_PATH + "/uploadFile/llm/" + fileName), HostLoadStateExcelDto.class).sheet("sheet").doWrite(loadStateDtoList);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5168\u91cf\u4e3b\u673a\u7cfb\u7edf\u8d1f\u8f7d\u6570\u636eexcel\u9519\u8bef", (Throwable)e);
        }
    }

    public void exportHostNetIoStateExcel() {
        try {
            Calendar now = Calendar.getInstance();
            now.setTime(new Date());
            now.set(5, now.get(5) - 1);
            String yesterdayDate = DateUtil.getString((Date)now.getTime(), (String)"yyyy-MM-dd");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("startTime", yesterdayDate + " 00:00:00");
            params.put("endTime", yesterdayDate + " 23:59:59");
            List netIoStateList = this.netIoStateService.selectAllByParams(params);
            ArrayList<HostNetStateExcelDto> netStateDtoList = new ArrayList<HostNetStateExcelDto>();
            for (NetIoState netIoState : netIoStateList) {
                HostNetStateExcelDto dto = new HostNetStateExcelDto();
                dto.setDropin(netIoState.getDropin());
                dto.setDropout(netIoState.getDropout());
                dto.setRxbyt(netIoState.getRxbyt());
                dto.setTxbyt(netIoState.getTxbyt());
                dto.setRxpck(netIoState.getRxpck());
                dto.setTxpck(netIoState.getTxpck());
                dto.setNetConnections(netIoState.getNetConnections());
                dto.setDatetime(DateUtil.getDateTimeString((Date)netIoState.getCreateTime()));
                dto.setHostName(netIoState.getHostname());
                netStateDtoList.add(dto);
            }
            String saveFolderUploadFile = StaticKeys.JAR_PATH + "/uploadFile";
            FileUtils.existsFolder((String)saveFolderUploadFile);
            String saveFolder = StaticKeys.JAR_PATH + "/uploadFile/llm";
            FileUtils.existsFolder((String)saveFolder);
            String fileName = yesterdayDate + "_AllHostNetSpeedData.xlsx";
            EasyExcel.write((String)(StaticKeys.JAR_PATH + "/uploadFile/llm/" + fileName), HostNetStateExcelDto.class).sheet("sheet").doWrite(netStateDtoList);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5168\u91cf\u4e3b\u673a\u7f51\u7edc\u901f\u7387\u6570\u636eexcel\u9519\u8bef", (Throwable)e);
        }
    }

    public void exportDiskStateExcel() {
        try {
            Calendar now = Calendar.getInstance();
            now.setTime(new Date());
            now.set(5, now.get(5) - 1);
            String yesterdayDate = DateUtil.getString((Date)now.getTime(), (String)"yyyy-MM-dd");
            HashMap params = new HashMap();
            ArrayList<HostDiskStateExcelDto> dtoList = new ArrayList<HostDiskStateExcelDto>();
            List diskStateList = this.diskStateService.selectAllByParams(params);
            for (DiskState diskState : diskStateList) {
                HostDiskStateExcelDto dto = new HostDiskStateExcelDto();
                dto.setHostName(diskState.getHostname());
                dto.setAvail(diskState.getAvail());
                dto.setDiskSize(diskState.getDiskSize());
                dto.setDatetime(DateUtil.getDateTimeString((Date)diskState.getCreateTime()));
                dto.setFileSystem(diskState.getFileSystem());
                dto.setUsePer(diskState.getUsePer());
                dto.setUsed(diskState.getUsed());
                dtoList.add(dto);
            }
            String saveFolderUploadFile = StaticKeys.JAR_PATH + "/uploadFile";
            FileUtils.existsFolder((String)saveFolderUploadFile);
            String saveFolder = StaticKeys.JAR_PATH + "/uploadFile/llm";
            FileUtils.existsFolder((String)saveFolder);
            String fileName = yesterdayDate + "_AllHostDiskUsageData.xlsx";
            EasyExcel.write((String)(StaticKeys.JAR_PATH + "/uploadFile/llm/" + fileName), HostDiskStateExcelDto.class).sheet("sheet").doWrite(dtoList);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6240\u6709\u4e3b\u673a\u78c1\u76d8\u4f7f\u7528\u7387\u6570\u636eexcel\u9519\u8bef", (Throwable)e);
        }
    }

    public void exportMacListExcel(HttpServletResponse response) {
        try {
            HashMap params = new HashMap();
            List hostMacInfoList = this.hostMacInfoService.selectAllByParams(params);
            ArrayList<HostMacExcelDto> excelList = new ArrayList<HostMacExcelDto>();
            for (HostMacInfo hostMacInfo : hostMacInfoList) {
                HostMacExcelDto dto = new HostMacExcelDto();
                dto.setCreateTime(DateUtil.getDateTimeString((Date)hostMacInfo.getCreateTime()));
                dto.setMacAddress(hostMacInfo.getMacAddress());
                dto.setMacName(hostMacInfo.getMacName());
                dto.setHostname(hostMacInfo.getHostname());
                if (!StaticKeys.HOST_MAP.containsKey(hostMacInfo.getHostname())) continue;
                excelList.add(dto);
            }
            String fileName = DateUtil.getCurrentDateTimeNoChar() + "_HostMAC.xlsx";
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            String encodedFileName = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "filename=" + encodedFileName);
            EasyExcel.write((OutputStream)response.getOutputStream(), HostMacExcelDto.class).sheet("sheet").doWrite(excelList);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6240\u6709\u4e3b\u673a\u7684mac\u5730\u5740\u5217\u8868excel\u9519\u8bef", (Throwable)e);
        }
    }

    public void exportNetworkNameListExcel(HttpServletResponse response) {
        try {
            HashMap params = new HashMap();
            List hostInfoList = this.systemInfoService.selectAllByParams(params);
            ArrayList<NetworkExcelDto> excelList = new ArrayList<NetworkExcelDto>();
            for (SystemInfo systemInfo : hostInfoList) {
                List networkList = this.viewAllNetworkHandler(systemInfo.getHostname());
                for (NetworkInfoDto networkInfoDto : networkList) {
                    NetworkExcelDto excelDto = new NetworkExcelDto();
                    excelDto.setName(networkInfoDto.getName());
                    excelDto.setBytesRecv(networkInfoDto.getBytesRecv());
                    excelDto.setBytesSent(networkInfoDto.getBytesSent());
                    excelDto.setHostName(systemInfo.getHostname());
                    excelList.add(excelDto);
                }
            }
            String fileName = DateUtil.getCurrentDateTimeNoChar() + "_HostNetCard.xlsx";
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            String encodedFileName = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "filename=" + encodedFileName);
            EasyExcel.write((OutputStream)response.getOutputStream(), NetworkExcelDto.class).sheet("sheet").doWrite(excelList);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6240\u6709\u4e3b\u673a\u7684\u7f51\u5361\u540d\u79f0\u5217\u8868excel\u9519\u8bef", (Throwable)e);
        }
    }

    public List<NetworkInfoDto> viewAllNetworkHandler(String hostname) {
        List<Object> allNetworkList = new ArrayList<NetworkInfoDto>();
        try {
            String jsonString = "";
            if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getRedisUrl())) {
                jsonString = RedisDataUtil.getValue((String)(hostname + "_ALL_NETWORK"));
            } else if (null != StaticKeys.HOST_IMPORT_DATA.get(hostname + "_ALL_NETWORK")) {
                jsonString = StaticKeys.HOST_IMPORT_DATA.get(hostname + "_ALL_NETWORK").toString();
            }
            if (!StringUtils.isEmpty((CharSequence)jsonString)) {
                JSONArray jsonArray = JSONUtil.parseArray((String)jsonString);
                allNetworkList = JSONUtil.toList((JSONArray)jsonArray, NetworkInfoDto.class);
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636eIP\u67e5\u8be2\u670d\u52a1\u5668\u7684\u5168\u90e8\u7f51\u5361\u540d\u79f0\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
        return allNetworkList;
    }

    public void exportCpuTemperListExcel(HttpServletResponse response) {
        try {
            HashMap params = new HashMap();
            List cpuTemperList = this.cpuTemperaturesService.selectAllByParams(params);
            ArrayList<CpuTemperExcelDto> excelList = new ArrayList<CpuTemperExcelDto>();
            for (CpuTemperatures cpuTemper : cpuTemperList) {
                CpuTemperExcelDto dto = new CpuTemperExcelDto();
                dto.setCreateTime(DateUtil.getDateTimeString((Date)cpuTemper.getCreateTime()));
                dto.setCore_index(cpuTemper.getCore_index());
                dto.setCrit(cpuTemper.getCrit());
                dto.setInput(cpuTemper.getInput());
                dto.setMax(cpuTemper.getMax());
                dto.setHostname(cpuTemper.getHostname());
                if (!StaticKeys.HOST_MAP.containsKey(cpuTemper.getHostname())) continue;
                excelList.add(dto);
            }
            String fileName = DateUtil.getCurrentDateTimeNoChar() + "_HostCpuTemper.xlsx";
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            String encodedFileName = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "filename=" + encodedFileName);
            EasyExcel.write((OutputStream)response.getOutputStream(), CpuTemperExcelDto.class).sheet("sheet").doWrite(excelList);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6240\u6709\u4e3b\u673a\u7684cpu\u6e29\u5ea6excel\u9519\u8bef", (Throwable)e);
        }
    }

    public void exportHostDiskPerExcel(HttpServletResponse response) {
        try {
            HashMap params = new HashMap();
            List hostDiskPerList = this.hostDiskPerService.selectAllByParams(params);
            ArrayList<HostDiskPerExcelDto> excelList = new ArrayList<HostDiskPerExcelDto>();
            for (HostDiskPer hostDiskPer : hostDiskPerList) {
                HostDiskPerExcelDto dto = new HostDiskPerExcelDto();
                dto.setCreateTime(DateUtil.getDateTimeString((Date)hostDiskPer.getCreateTime()));
                dto.setDiskSumPer(hostDiskPer.getDiskSumPer());
                dto.setHostname(hostDiskPer.getHostname());
                if (!StaticKeys.HOST_MAP.containsKey(hostDiskPer.getHostname())) continue;
                excelList.add(dto);
            }
            String fileName = DateUtil.getCurrentDateTimeNoChar() + "_HostDiskUsage.xlsx";
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            String encodedFileName = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "filename=" + encodedFileName);
            EasyExcel.write((OutputStream)response.getOutputStream(), HostDiskPerExcelDto.class).sheet("sheet").doWrite(excelList);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6240\u6709\u4e3b\u673a\u7684\u78c1\u76d8\u603b\u4f7f\u7528\u7387excel\u9519\u8bef", (Throwable)e);
        }
    }

    public void exportHostDiskIoStateExcel(HttpServletResponse response) {
        try {
            HashMap params = new HashMap();
            List diskIoStateList = this.diskIoStateService.selectAllByParams(params);
            ArrayList<DiskIoStateExcelDto> excelList = new ArrayList<DiskIoStateExcelDto>();
            for (DiskIoState diskIoState : diskIoStateList) {
                DiskIoStateExcelDto dto = new DiskIoStateExcelDto();
                dto.setHostname(diskIoState.getHostname());
                dto.setCreateTime(DateUtil.getDateTimeString((Date)diskIoState.getCreateTime()));
                dto.setReadIoAvg(diskIoState.getReadIoAvg() + "MB/s");
                dto.setWriteIoAvg(diskIoState.getWriteIoAvg() + "MB/s");
                if (!StaticKeys.HOST_MAP.containsKey(diskIoState.getHostname())) continue;
                excelList.add(dto);
            }
            String fileName = DateUtil.getCurrentDateTimeNoChar() + "_HostDiskIORate.xlsx";
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            String encodedFileName = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "filename=" + encodedFileName);
            EasyExcel.write((OutputStream)response.getOutputStream(), DiskIoStateExcelDto.class).sheet("sheet").doWrite(excelList);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6240\u6709\u4e3b\u673a\u7684\u78c1\u76d8io\u8bfb\u5199\u901f\u7387excel\u9519\u8bef", (Throwable)e);
        }
    }

    public void exportDceStateExcel() {
        try {
            Calendar now = Calendar.getInstance();
            now.setTime(new Date());
            now.set(5, now.get(5) - 1);
            String yesterdayDate = DateUtil.getString((Date)now.getTime(), (String)"yyyy-MM-dd");
            HashMap params = new HashMap();
            List dceInfoList = this.dceInfoService.selectAllByParams(params);
            HashMap<String, String> dceInfoMap = new HashMap<String, String>();
            for (DceInfo dceInfo : dceInfoList) {
                dceInfoMap.put(dceInfo.getId(), dceInfo.getHostname());
            }
            ArrayList<DceStateExcelDto> dtoList = new ArrayList<DceStateExcelDto>();
            List dceStateList = this.dceStateService.selectAllByParams(params);
            for (DceState dceState : dceStateList) {
                DceStateExcelDto dto = new DceStateExcelDto();
                dto.setHostname((String)dceInfoMap.get(dceState.getDceId()));
                dto.setResTimes(dceState.getResTimes());
                dto.setCreateTime(DateUtil.getDateTimeString((Date)dceState.getCreateTime()));
                dtoList.add(dto);
            }
            String saveFolderUploadFile = StaticKeys.JAR_PATH + "/uploadFile";
            FileUtils.existsFolder((String)saveFolderUploadFile);
            String saveFolder = StaticKeys.JAR_PATH + "/uploadFile/llm";
            FileUtils.existsFolder((String)saveFolder);
            String fileName = yesterdayDate + "_AllPingData.xlsx";
            EasyExcel.write((String)(StaticKeys.JAR_PATH + "/uploadFile/llm/" + fileName), DceStateExcelDto.class).sheet("sheet").doWrite(dtoList);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6240\u6709PING\u76d1\u63a7\u5386\u53f2\u6570\u636eexcel\u9519\u8bef", (Throwable)e);
        }
    }

    public void exportHostAllProcsExcel() {
        try {
            Calendar now = Calendar.getInstance();
            now.setTime(new Date());
            now.set(5, now.get(5) - 1);
            String yesterdayDate = DateUtil.getString((Date)now.getTime(), (String)"yyyy-MM-dd");
            HashMap params = new HashMap();
            List systemInfoList = this.systemInfoService.selectAllByParams(params);
            ArrayList<AllAppExcelDto> dtoList = new ArrayList<AllAppExcelDto>();
            for (SystemInfo systemInfo : systemInfoList) {
                try {
                    List cacheList = new ArrayList();
                    String caijiDateTime = "";
                    if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getRedisUrl())) {
                        String jsonString = RedisDataUtil.getValue((String)(systemInfo.getHostname() + "_ALL_PROCESS"));
                        if (!StringUtils.isEmpty((CharSequence)jsonString)) {
                            JSONArray jsonArray = JSONUtil.parseArray((String)jsonString);
                            cacheList = JSONUtil.toList((JSONArray)jsonArray, AppExceptionInfo.class);
                            caijiDateTime = RedisDataUtil.getValue((String)(systemInfo.getHostname() + "_ALL_PROCESS" + "_DATETIME"));
                        }
                    } else {
                        cacheList = (List)StaticKeys.HOST_ALL_PROCESS.get(systemInfo.getHostname());
                        caijiDateTime = (String)StaticKeys.HOST_ALL_PROCESS.get(systemInfo.getHostname() + "_DATETIME");
                    }
                    if (CollectionUtil.isEmpty(cacheList)) continue;
                    for (AppExceptionInfo appExceptionInfo : cacheList) {
                        AllAppExcelDto dto = new AllAppExcelDto();
                        dto.setAppCmdLine(appExceptionInfo.getAppCmdLine());
                        dto.setAppName(appExceptionInfo.getAppName());
                        dto.setAppTimes(appExceptionInfo.getAppTimes());
                        dto.setCpuPer(appExceptionInfo.getCpuPer());
                        dto.setMemPer(appExceptionInfo.getMemPer());
                        dto.setHostname(systemInfo.getHostname());
                        dto.setDatetime(caijiDateTime);
                        dto.setGatherPid(appExceptionInfo.getGatherPid());
                        dto.setProUsername(appExceptionInfo.getProUsername());
                        dtoList.add(dto);
                    }
                }
                catch (Exception e) {
                    logger.error("LLM\u751f\u6210\u5168\u91cf\u8fdb\u7a0bExcel\u9519\u8bef", (Throwable)e);
                }
            }
            String saveFolderUploadFile = StaticKeys.JAR_PATH + "/uploadFile";
            FileUtils.existsFolder((String)saveFolderUploadFile);
            String saveFolder = StaticKeys.JAR_PATH + "/uploadFile/llm";
            FileUtils.existsFolder((String)saveFolder);
            String fileName = yesterdayDate + "_AllProcessSnap.xlsx";
            EasyExcel.write((String)(StaticKeys.JAR_PATH + "/uploadFile/llm/" + fileName), AllAppExcelDto.class).sheet("sheet").doWrite(dtoList);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6240\u6709\u4e3b\u673a\u5168\u91cf\u8fdb\u7a0b\u5feb\u7167excel\u9519\u8bef", (Throwable)e);
        }
    }
}

