/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import cn.hutool.core.collection.CollectionUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.config.MailConfig;
import com.wgcloud.entity.CpuState;
import com.wgcloud.entity.CpuTemperatures;
import com.wgcloud.entity.DiskIoState;
import com.wgcloud.entity.HostDiskPer;
import com.wgcloud.entity.HostGroup;
import com.wgcloud.entity.MemState;
import com.wgcloud.entity.NetIoState;
import com.wgcloud.entity.ReportInfo;
import com.wgcloud.entity.ReportInstance;
import com.wgcloud.entity.SysLoadState;
import com.wgcloud.entity.SystemInfo;
import com.wgcloud.entity.SystemInfoExt;
import com.wgcloud.mapper.ReportInfoMapper;
import com.wgcloud.service.AccountInfoService;
import com.wgcloud.service.AppExceptionInfoService;
import com.wgcloud.service.AppInfoService;
import com.wgcloud.service.CpuStateService;
import com.wgcloud.service.CpuTemperaturesService;
import com.wgcloud.service.CustomInfoService;
import com.wgcloud.service.DbInfoService;
import com.wgcloud.service.DbTableService;
import com.wgcloud.service.DceInfoService;
import com.wgcloud.service.DiskIoStateService;
import com.wgcloud.service.DockerInfoService;
import com.wgcloud.service.EquipmentService;
import com.wgcloud.service.FileSafeService;
import com.wgcloud.service.FileWarnInfoService;
import com.wgcloud.service.FtpInfoService;
import com.wgcloud.service.HeathMonitorService;
import com.wgcloud.service.HostDiskPerService;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.HostWarnDiyService;
import com.wgcloud.service.K8sMonitorService;
import com.wgcloud.service.KafkaMonitorService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.MemStateService;
import com.wgcloud.service.NetIoStateService;
import com.wgcloud.service.PasswdInfoService;
import com.wgcloud.service.PortInfoService;
import com.wgcloud.service.RedisMonitorService;
import com.wgcloud.service.ReportInstanceService;
import com.wgcloud.service.SnmpDeepInfoService;
import com.wgcloud.service.SnmpInfoService;
import com.wgcloud.service.SysLoadStateService;
import com.wgcloud.service.SystemInfoExtService;
import com.wgcloud.service.SystemInfoService;
import com.wgcloud.service.TaskJobInfoService;
import com.wgcloud.service.TaskUtilService;
import com.wgcloud.util.ActivemqUtil;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.RabbitmqUtil;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.UUIDUtil;
import com.wgcloud.util.msg.WarnOtherUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportInfoService {
    private static final Logger logger = LoggerFactory.getLogger(ReportInfoService.class);
    @Autowired
    private ReportInfoMapper reportInfoMapper;
    @Autowired
    private ReportInstanceService reportInstanceService;
    @Autowired
    private SystemInfoService systemInfoService;
    @Autowired
    private SystemInfoExtService systemInfoExtService;
    @Autowired
    private LogInfoService logInfoService;
    @Autowired
    private AppInfoService appInfoService;
    @Autowired
    private FileSafeService fileSafeService;
    @Autowired
    private DockerInfoService dockerInfoService;
    @Autowired
    private PortInfoService portInfoService;
    @Autowired
    private AppExceptionInfoService appExceptionInfoService;
    @Autowired
    private EquipmentService equipmentService;
    @Autowired
    private AccountInfoService accountInfoService;
    @Resource
    private PasswdInfoService passwdInfoService;
    @Resource
    private HostWarnDiyService hostWarnDiyService;
    @Autowired
    private CustomInfoService customInfoService;
    @Autowired
    CpuStateService cpuStateService;
    @Autowired
    MemStateService memStateService;
    @Autowired
    SysLoadStateService sysLoadStateService;
    @Autowired
    NetIoStateService netIoStateService;
    @Autowired
    private DbTableService dbTableService;
    @Resource
    DbInfoService dbInfoService;
    @Resource
    FileWarnInfoService fileWarnInfoService;
    @Autowired
    private FtpInfoService ftpInfoService;
    @Autowired
    private HostGroupService hostGroupService;
    @Autowired
    private HeathMonitorService heathMonitorService;
    @Autowired
    private DceInfoService dceInfoService;
    @Autowired
    private SnmpInfoService snmpInfoService;
    @Resource
    private HostDiskPerService hostDiskPerService;
    @Autowired
    private ServletContext servletContext;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private TaskUtilService taskUtilService;
    @Resource
    private K8sMonitorService k8sMonitorService;
    @Resource
    private RedisMonitorService redisMonitorService;
    @Resource
    private KafkaMonitorService kafkaMonitorService;
    @Resource
    private CpuTemperaturesService cpuTemperaturesService;
    @Resource
    private TaskJobInfoService taskJobInfoService;
    @Resource
    private DiskIoStateService diskIoStateService;
    @Resource
    private SnmpDeepInfoService snmpDeepInfoService;
    @Autowired
    private MailConfig mailConfig;

    public PageInfo selectByParams(Map<String, Object> params, int currPage, int pageSize) throws Exception {
        PageHelper.startPage((int)currPage, (int)pageSize);
        List list = this.reportInfoMapper.selectByParams(params);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public void save(ReportInfo reportInfo) {
        reportInfo.setId(UUIDUtil.getUUID());
        reportInfo.setCreateTime(new Date());
        try {
            this.reportInfoMapper.save(reportInfo);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u5de1\u68c0\u62a5\u544a\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    public int countByParams(Map<String, Object> params) throws Exception {
        return this.reportInfoMapper.countByParams(params);
    }

    public int deleteById(String[] id) throws Exception {
        return this.reportInfoMapper.deleteById(id);
    }

    public ReportInfo selectById(String id) throws Exception {
        return this.reportInfoMapper.selectById(id);
    }

    public List<ReportInfo> selectAllByParams(Map<String, Object> params) throws Exception {
        return this.reportInfoMapper.selectAllByParams(params);
    }

    public int deleteByDate(Map<String, Object> map) throws Exception {
        return this.reportInfoMapper.deleteByDate(map);
    }

    public void keepLastTenDayForFree() {
        if (StaticKeys.LICENSE_STATE.equals("1")) {
            return;
        }
        try {
            String thrityDayBefore = DateUtil.getDateBefore((int)10);
            HashMap<String, String> paramsDel = new HashMap<String, String>();
            paramsDel.put("endTime", thrityDayBefore);
            this.deleteByDate(paramsDel);
            this.logInfoService.save("The personal version inspection report is scheduled to clear data from 10 days ago, and the task has been completed", "\u4e2a\u4eba\u7248\u5de1\u68c0\u62a5\u544a\u53ea\u80fd\u4fdd\u7559\u6700\u8fd110\u5929(\u5373" + thrityDayBefore + "\u540e)\u7684\u6570\u636e\uff0c\u4e13\u4e1a\u7248\u5219\u65e0\u9650\u5236", "2");
            logger.info("\u4e2a\u4eba\u7248\u5de1\u68c0\u62a5\u544a\u5b9a\u65f6\u6e05\u7a7a10\u5929\u524d\u7684\u6570\u636e\uff0c\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u4e2a\u4eba\u7248\u5de1\u68c0\u62a5\u544a\u4fdd\u7559\u6700\u8fd110\u5929(\u5373" + thrityDayBefore + "\u540e)\u7684\u6570\u636e");
        }
        catch (Exception e) {
            logger.error("\u5de1\u68c0\u62a5\u544a\u6e05\u7a7a\u6570\u636e\u9519\u8bef", (Throwable)e);
        }
    }

    public void taskDayThreadHandler() {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            String todayDate = DateUtil.getCurrentDate();
            params.put("startTime", todayDate + " 00:00:00");
            params.put("endTime", todayDate + " 23:59:59");
            logger.info("\u65e5\u62a5\u67e5\u8be2\u6761\u4ef6--------" + ((Object)params).toString());
            int countAll = this.countResourceByGroupId("");
            this.commonReportHandler(todayDate, "3", params, "ALL", countAll);
            if ("true".equals(this.commonConfig.getHostGroup())) {
                HashMap paramsGroup = new HashMap();
                List hostGroupList = this.hostGroupService.selectAllByParams(paramsGroup, null);
                for (HostGroup hostGroup : hostGroupList) {
                    params.put("groupId", hostGroup.getId());
                    int count = this.countResourceByGroupId(hostGroup.getId());
                    if (count < 1) {
                        logger.info("\u8be5\u6807\u7b7e\u4e0b\u6ca1\u6709\u8d44\u6e90\u4e0d\u751f\u6210\u5de1\u68c0\u62a5\u544a--------" + hostGroup.getId());
                        continue;
                    }
                    this.commonReportHandler(todayDate, "3", params, hostGroup.getGroupName(), count);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5de1\u68c0\u65e5\u62a5\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u5de1\u68c0\u65e5\u62a5\u9519\u8bef", e.toString(), "2");
        }
    }

    public void taskWeekThreadHandler() {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            String timePart = DateUtil.setLastWeekBeginEndTime(params);
            logger.info("\u5468\u62a5\u67e5\u8be2\u6761\u4ef6--------" + ((Object)params).toString());
            HashMap<String, String> paramsTimePart = new HashMap<String, String>();
            paramsTimePart.put("timePart", timePart);
            int reportNum = this.countByParams(paramsTimePart);
            if (reportNum > 0) {
                logger.info("\u5df2\u7ecf\u751f\u6210\u8fc7\u5468\u62a5--------" + timePart);
                return;
            }
            int countAll = this.countResourceByGroupId("");
            this.commonReportHandler(timePart, "1", params, "ALL", countAll);
            if ("true".equals(this.commonConfig.getHostGroup())) {
                HashMap paramsGroup = new HashMap();
                List hostGroupList = this.hostGroupService.selectAllByParams(paramsGroup, null);
                for (HostGroup hostGroup : hostGroupList) {
                    params.put("groupId", hostGroup.getId());
                    int count = this.countResourceByGroupId(hostGroup.getId());
                    if (count < 1) {
                        logger.info("\u8be5\u6807\u7b7e\u4e0b\u6ca1\u6709\u8d44\u6e90\u4e0d\u751f\u6210\u5de1\u68c0\u62a5\u544a--------" + hostGroup.getId());
                        continue;
                    }
                    this.commonReportHandler(timePart, "1", params, hostGroup.getGroupName(), count);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5de1\u68c0\u5468\u62a5\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u5de1\u68c0\u5468\u62a5\u9519\u8bef", e.toString(), "2");
        }
    }

    public void taskMonThreadHandler() {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            String timePart = DateUtil.setLastMonBeginEndTime(params);
            logger.info("\u6708\u62a5\u67e5\u8be2\u6761\u4ef6--------" + ((Object)params).toString());
            HashMap<String, String> paramsTimePart = new HashMap<String, String>();
            paramsTimePart.put("timePart", timePart);
            int reportNum = this.countByParams(paramsTimePart);
            if (reportNum > 0) {
                logger.info("\u5df2\u7ecf\u751f\u6210\u8fc7\u6708\u62a5--------" + timePart);
                return;
            }
            int countAll = this.countResourceByGroupId("");
            this.commonReportHandler(timePart, "2", params, "ALL", countAll);
            if ("true".equals(this.commonConfig.getHostGroup())) {
                HashMap paramsGroup = new HashMap();
                List hostGroupList = this.hostGroupService.selectAllByParams(paramsGroup, null);
                for (HostGroup hostGroup : hostGroupList) {
                    params.put("groupId", hostGroup.getId());
                    int count = this.countResourceByGroupId(hostGroup.getId());
                    if (count < 1) {
                        logger.info("\u8be5\u6807\u7b7e\u4e0b\u6ca1\u6709\u8d44\u6e90\u4e0d\u751f\u6210\u5de1\u68c0\u62a5\u544a--------" + hostGroup.getId());
                        continue;
                    }
                    this.commonReportHandler(timePart, "2", params, hostGroup.getGroupName(), count);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5de1\u68c0\u6708\u62a5\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u5de1\u68c0\u6708\u62a5\u9519\u8bef", e.toString(), "2");
        }
    }

    private void commonReportHandler(String timePart, String reportType, Map<String, Object> params, String groupName, int count) throws Exception {
        Date date = new Date();
        ArrayList reportInstanceList = new ArrayList();
        ReportInfo reportInfo = new ReportInfo();
        reportInfo.setReportType(reportType);
        reportInfo.setTimePart(timePart);
        reportInfo.setGroupName(groupName + " (" + count + ")");
        reportInfo.setCreateTime(date);
        this.save(reportInfo);
        this.monitorDataHandle(reportInstanceList, params, reportInfo);
        this.reportInstanceService.saveRecord(reportInstanceList, date);
    }

    private int countResourceByGroupId(String groupId) {
        int count = 0;
        try {
            HashMap<String, String> paramsGroup = new HashMap<String, String>();
            if (!StringUtils.isEmpty((CharSequence)groupId)) {
                paramsGroup.put("groupId", groupId);
            }
            count += this.systemInfoService.countByParams(paramsGroup);
            count += this.appInfoService.countByParams(paramsGroup);
            count += this.portInfoService.countByParams(paramsGroup);
            count += this.fileSafeService.countByParams(paramsGroup);
            count += this.dockerInfoService.countByParams(paramsGroup);
            count += this.customInfoService.countByParams(paramsGroup);
            count += this.dbInfoService.countByParams(paramsGroup);
            count += this.heathMonitorService.countByParams(paramsGroup);
            count += this.dceInfoService.countByParams(paramsGroup);
            count += this.snmpInfoService.countByParams(paramsGroup);
            count += this.ftpInfoService.countByParams(paramsGroup);
            count += this.taskJobInfoService.countByParams(paramsGroup);
            count += this.equipmentService.countByParams(paramsGroup);
            count += this.passwdInfoService.countByParams(paramsGroup);
        }
        catch (Exception e) {
            logger.error("\u7edf\u8ba1\u6807\u7b7e\u4e0b\u7684\u8d44\u6e90\u6570\u91cf\u9519\u8bef", (Throwable)e);
        }
        return count;
    }

    public void monitorDataHandle(List<ReportInstance> reportInstanceList, Map<String, Object> params, ReportInfo reportInfo) throws Exception {
        SysLoadState sysLoadStateMin;
        SysLoadState sysLoadStateAvg;
        NetIoState netIoStateMin;
        NetIoState netIoStateAvg;
        HashMap<String, Object> paramsDown = new HashMap<String, Object>();
        paramsDown.putAll(params);
        paramsDown.put("state", "2");
        paramsDown.put("active", "1");
        int totalSizeApp = this.appInfoService.countByParams(params);
        int totalSizeAppDown = this.appInfoService.countByParams(paramsDown);
        String appResult = ", Test result: Normal";
        if (totalSizeAppDown > 0) {
            appResult = ", Test result: Exception, offline quantity: " + totalSizeAppDown;
        }
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Monitor process", "Total quantity: " + totalSizeApp + appResult, reportInfo.getId());
        int totalSizeAppException = this.appExceptionInfoService.countByParams(params);
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Host Exception process", "Total quantity: " + totalSizeAppException + "", reportInfo.getId());
        int portSize = this.portInfoService.countByParams(params);
        int totalSizePortDown = this.portInfoService.countByParams(paramsDown);
        String portResult = ", Test result: Normal";
        if (totalSizePortDown > 0) {
            portResult = ", Test result: Exception, offline quantity: " + totalSizePortDown;
        }
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Monitor port", "Total quantity: " + portSize + portResult, reportInfo.getId());
        int heathSize = this.heathMonitorService.countByParams(params);
        paramsDown.put("heathStatus", "200");
        int heath200Size = this.heathMonitorService.countByParams(paramsDown);
        String heathResult = ", Test result: Normal";
        if (heathSize - heath200Size > 0) {
            heathResult = ", Test result: Exception, offline quantity: " + (heathSize - heath200Size);
        }
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Monitor service interface", "Total quantity: " + heathSize + heathResult, reportInfo.getId());
        paramsDown.remove("heathStatus");
        int dockerSize = this.dockerInfoService.countByParams(params);
        int totalSizeDockerDown = this.dockerInfoService.countByParams(paramsDown);
        String dockerResult = ", Test result: Normal";
        if (totalSizeDockerDown > 0) {
            dockerResult = ", Test result: Exception, offline quantity: " + totalSizeDockerDown;
        }
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Monitor Docker", "Total quantity: " + dockerSize + dockerResult, reportInfo.getId());
        int dceSize = this.dceInfoService.countByParams(params);
        paramsDown.put("resTimes", -1);
        int dceDownSize = this.dceInfoService.countByParams(paramsDown);
        String dceResult = ", Test result: Normal";
        if (dceDownSize > 0) {
            dceResult = ", Test result: Exception, offline quantity: " + dceDownSize;
        }
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Monitor PING", "Total quantity: " + dceSize + dceResult, reportInfo.getId());
        paramsDown.remove("resTimes");
        Integer fileWarnSize = this.fileWarnInfoService.countByParams(params);
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Total number of monitor log files", fileWarnSize + "", reportInfo.getId());
        int dbInfoSize = this.dbInfoService.countByParams(params);
        paramsDown.put("dbState", "2");
        int totalSizeDbInfoDown = this.dbInfoService.countByParams(paramsDown);
        String dbInfoResult = ", Test result: Normal";
        if (totalSizeDbInfoDown > 0) {
            dbInfoResult = ", Test result: Exception, offline quantity: " + totalSizeDbInfoDown;
        }
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Monitor DB", "Total quantity: " + dbInfoSize + dbInfoResult, reportInfo.getId());
        paramsDown.remove("dbState");
        int dbTableSize = this.dbTableService.countByParams(params);
        paramsDown.put("dbState", "2");
        int totalSizeDbTableDown = this.dbTableService.countByParams(paramsDown);
        String dbTableResult = ", Test result: Normal";
        if (totalSizeDbTableDown > 0) {
            dbTableResult = ", Test result: Exception, Exception quantity: " + totalSizeDbTableDown;
        }
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Monitor Data Table", "Total quantity: " + dbTableSize + dbTableResult, reportInfo.getId());
        paramsDown.remove("dbState");
        int snmpInfoSize = this.snmpInfoService.countByParams(params);
        int totalSizeSnmpDown = this.snmpInfoService.countByParams(paramsDown);
        String snmpResult = ", Test result: Normal";
        if (totalSizeSnmpDown > 0) {
            snmpResult = ", Test result: Exception, offline quantity: " + totalSizeSnmpDown;
        }
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Monitor SNMP", "Total quantity: " + snmpInfoSize + snmpResult, reportInfo.getId());
        int customInfoSize = this.customInfoService.countByParams(params);
        int totalSizeCustomInfoDown = this.customInfoService.countByParams(paramsDown);
        String customInfoResult = ", Test result: Normal";
        if (totalSizeCustomInfoDown > 0) {
            customInfoResult = ", Test result: Exception, offline quantity: " + totalSizeCustomInfoDown;
        }
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Customize monitor items", "Total quantity: " + customInfoSize + customInfoResult, reportInfo.getId());
        int fileSafeSize = this.fileSafeService.countByParams(params);
        int totalSizeFileSafeDown = this.fileSafeService.countByParams(paramsDown);
        String fileSafeResult = ", Test result: Normal";
        if (totalSizeCustomInfoDown > 0) {
            fileSafeResult = ", Test result: Exception, offline quantity: " + totalSizeFileSafeDown;
        }
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "File Security", "Total quantity: " + fileSafeSize + fileSafeResult, reportInfo.getId());
        int ftpInfoSize = this.ftpInfoService.countByParams(params);
        int totalSizeFtpInfoDown = this.ftpInfoService.countByParams(paramsDown);
        String ftpInfoResult = ", Test result: Normal";
        if (totalSizeFtpInfoDown > 0) {
            ftpInfoResult = ", Test result: Exception, offline quantity: " + totalSizeFtpInfoDown;
        }
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Monitor Ftp/Sftp", "Total quantity: " + ftpInfoSize + ftpInfoResult, reportInfo.getId());
        int equipmentSize = this.equipmentService.countByParams(params);
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Equipment", "Total quantity: " + equipmentSize, reportInfo.getId());
        if (null == params.get("groupId")) {
            HashMap<String, String> paramsAccount = new HashMap<String, String>();
            paramsAccount.put("role", "user");
            int totalSizeAccountUser = this.accountInfoService.countByParams(paramsAccount);
            paramsAccount.put("role", "guest");
            int totalSizeAccountGuest = this.accountInfoService.countByParams(paramsAccount);
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Account", "Number of accounts\uff1a" + totalSizeAccountUser + ", Number of read-only accounts: " + totalSizeAccountGuest, reportInfo.getId());
            int totalSizeHostGroup = this.hostGroupService.countByParams(params);
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Number of tags", totalSizeHostGroup + "", reportInfo.getId());
        }
        HashMap<String, Object> paramsUptime = new HashMap<String, Object>();
        paramsUptime.put("orderBy", "UPTIME");
        paramsUptime.put("orderType", "DESC");
        paramsUptime.put("groupId", params.get("groupId"));
        List systemInfoExtList = this.systemInfoExtService.selectAllByParams(paramsUptime);
        if (systemInfoExtList.size() > 0) {
            SystemInfoExt systemInfoMaxUptime = (SystemInfoExt)systemInfoExtList.get(0);
            String systemInfoMaxUptimeContent = systemInfoMaxUptime.getHostname() + HostUtil.addRemark((String)systemInfoMaxUptime.getHostname()) + ", already running " + systemInfoMaxUptime.getUptimeStr();
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "The host with the longest running time", systemInfoMaxUptimeContent, reportInfo.getId());
        }
        paramsUptime.put("orderType", "ASC");
        systemInfoExtList = this.systemInfoExtService.selectAllByParams(paramsUptime);
        if (systemInfoExtList.size() > 0) {
            SystemInfoExt systemInfoMinUptime = (SystemInfoExt)systemInfoExtList.get(0);
            String systemInfoMinUptimeContent = systemInfoMinUptime.getHostname() + HostUtil.addRemark((String)systemInfoMinUptime.getHostname()) + ", already running " + systemInfoMinUptime.getUptimeStr();
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "The host with the shortest running time", systemInfoMinUptimeContent, reportInfo.getId());
        }
        HashMap<String, Object> paramsSystemInfo = new HashMap<String, Object>();
        paramsSystemInfo.put("groupId", params.get("groupId"));
        List systemInfoList = this.systemInfoService.selectAllByParams(paramsSystemInfo);
        CpuState maxAvgCpuState = this.cpuStateService.selectMaxAvgByHostname(params);
        if (null == maxAvgCpuState) {
            maxAvgCpuState = new CpuState();
            maxAvgCpuState.setSys(Double.valueOf(0.0));
            maxAvgCpuState.setIdle(Double.valueOf(0.0));
            maxAvgCpuState.setIowait(Double.valueOf(0.0));
        }
        String maxCpuHostName = "";
        try {
            params.put("sys", maxAvgCpuState.getSys());
            PageInfo pageInfoCpuState = this.cpuStateService.selectByParams(params, 1, 1);
            if (!CollectionUtil.isEmpty((Collection)pageInfoCpuState.getList())) {
                maxCpuHostName = ((CpuState)pageInfoCpuState.getList().get(0)).getHostname();
                maxCpuHostName = ", " + maxCpuHostName + HostUtil.addRemark((String)maxCpuHostName);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u627eCPU\u4f7f\u7528\u7387\u6700\u9ad8\u503c\u7684\u4e3b\u673aIP\u9519\u8bef", (Throwable)e);
        }
        params.remove("sys");
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "The highest CPU usage rate of the host", maxAvgCpuState.getSys() + "%" + maxCpuHostName, reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Average CPU usage of the host", FormatUtil.formatDouble((Double)maxAvgCpuState.getIdle(), (int)2) + "%", reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Minimum CPU usage of the host", maxAvgCpuState.getIowait() + "%", reportInfo.getId());
        MemState maxAvgMemState = this.memStateService.selectMaxAvgByHostname(params);
        if (null == maxAvgMemState) {
            maxAvgMemState = new MemState();
            maxAvgMemState.setUsePer(Double.valueOf(0.0));
            maxAvgMemState.setUsed("0");
            maxAvgMemState.setFree("0");
        }
        String maxMemHostName = "";
        try {
            params.put("usePer", maxAvgMemState.getUsePer());
            PageInfo pageInfoMemState = this.memStateService.selectByParams(params, 1, 1);
            if (!CollectionUtil.isEmpty((Collection)pageInfoMemState.getList())) {
                maxMemHostName = ((MemState)pageInfoMemState.getList().get(0)).getHostname();
                maxMemHostName = ", " + maxMemHostName + HostUtil.addRemark((String)maxMemHostName);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u627e\u5185\u5b58\u4f7f\u7528\u7387\u6700\u9ad8\u503c\u7684\u4e3b\u673aIP\u9519\u8bef", (Throwable)e);
        }
        params.remove("usePer");
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "The highest value of host memory usage", maxAvgMemState.getUsePer() + "%" + maxMemHostName, reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Average usage of host memory", FormatUtil.formatDouble((Double)Double.valueOf(maxAvgMemState.getUsed()), (int)2) + "%", reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Minimum Host Memory Usage", maxAvgMemState.getFree() + "%", reportInfo.getId());
        NetIoState netIoStateMax = this.netIoStateService.selectMaxByHostname(params);
        if (null == netIoStateMax) {
            netIoStateMax = new NetIoState();
            netIoStateMax.setTxbyt("0");
            netIoStateMax.setRxbyt("0");
            netIoStateMax.setRxpck("0");
            netIoStateMax.setTxpck("0");
        }
        if (null == (netIoStateAvg = this.netIoStateService.selectAvgByHostname(params))) {
            netIoStateAvg = new NetIoState();
            netIoStateAvg.setTxbyt("0");
            netIoStateAvg.setRxbyt("0");
            netIoStateAvg.setRxpck("0");
            netIoStateAvg.setTxpck("0");
        }
        if (null == (netIoStateMin = this.netIoStateService.selectMinByHostname(params))) {
            netIoStateMin = new NetIoState();
            netIoStateMin.setTxbyt("0");
            netIoStateMin.setRxbyt("0");
            netIoStateMin.setRxpck("0");
            netIoStateMin.setTxpck("0");
        }
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Maximum downlink speed of the host", FormatUtil.kbToM((String)netIoStateMax.getRxbyt()) + "/s", reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Minimum downlink speed of the host", FormatUtil.kbToM((String)netIoStateMin.getRxbyt()) + "/s", reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Average downlink speed of the host", FormatUtil.kbToM((String)(FormatUtil.formatDouble((String)netIoStateAvg.getRxbyt(), (int)2) + "")) + "/s", reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Maximum uplink speed of the host", FormatUtil.kbToM((String)netIoStateMax.getTxbyt()) + "/s", reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Minimum uplink speed of the host", FormatUtil.kbToM((String)netIoStateMin.getTxbyt()) + "/s", reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Average uplink speed of the host", FormatUtil.kbToM((String)(FormatUtil.formatDouble((String)netIoStateAvg.getTxbyt(), (int)2) + "")) + "/s", reportInfo.getId());
        SysLoadState sysLoadStateMax = this.sysLoadStateService.selectMaxByHostname(params);
        if (null == sysLoadStateMax) {
            sysLoadStateMax = new SysLoadState();
            sysLoadStateMax.setOneLoad(Double.valueOf(0.0));
            sysLoadStateMax.setFiveLoad(Double.valueOf(0.0));
            sysLoadStateMax.setFifteenLoad(Double.valueOf(0.0));
        }
        if (null == (sysLoadStateAvg = this.sysLoadStateService.selectAvgByHostname(params))) {
            sysLoadStateAvg = new SysLoadState();
            sysLoadStateAvg.setOneLoad(Double.valueOf(0.0));
            sysLoadStateAvg.setFiveLoad(Double.valueOf(0.0));
            sysLoadStateAvg.setFifteenLoad(Double.valueOf(0.0));
        }
        if (null == (sysLoadStateMin = this.sysLoadStateService.selectMinByHostname(params))) {
            sysLoadStateMin = new SysLoadState();
            sysLoadStateMin.setOneLoad(Double.valueOf(0.0));
            sysLoadStateMin.setFiveLoad(Double.valueOf(0.0));
            sysLoadStateMin.setFifteenLoad(Double.valueOf(0.0));
        }
        String maxOneLoadHostName = "";
        PageInfo pageInfoSysLoad = new PageInfo();
        try {
            params.put("oneLoad", sysLoadStateMax.getOneLoad());
            pageInfoSysLoad = this.sysLoadStateService.selectByParams(params, 1, 1);
            if (!CollectionUtil.isEmpty((Collection)pageInfoSysLoad.getList())) {
                maxOneLoadHostName = ((SysLoadState)pageInfoSysLoad.getList().get(0)).getHostname();
                maxOneLoadHostName = ", " + maxOneLoadHostName + HostUtil.addRemark((String)maxOneLoadHostName);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u627e1\u5206\u949f\u7cfb\u7edf\u8d1f\u8f7d\u6700\u9ad8\u503c\u7684\u4e3b\u673aIP\u9519\u8bef", (Throwable)e);
        }
        params.remove("oneLoad");
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "The highest system load of the host in 1 minute", sysLoadStateMax.getOneLoad() + maxOneLoadHostName, reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "The lowest system load of the host in 1 minute", sysLoadStateMin.getOneLoad() + "", reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "1-minute average system load of the host", FormatUtil.formatDouble((Double)sysLoadStateAvg.getOneLoad(), (int)2) + "", reportInfo.getId());
        String maxFiveLoadHostName = "";
        try {
            params.put("fiveLoad", sysLoadStateMax.getFiveLoad());
            pageInfoSysLoad = this.sysLoadStateService.selectByParams(params, 1, 1);
            if (!CollectionUtil.isEmpty((Collection)pageInfoSysLoad.getList())) {
                maxFiveLoadHostName = ((SysLoadState)pageInfoSysLoad.getList().get(0)).getHostname();
                maxFiveLoadHostName = ", " + maxFiveLoadHostName + HostUtil.addRemark((String)maxFiveLoadHostName);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u627e5\u5206\u949f\u7cfb\u7edf\u8d1f\u8f7d\u6700\u9ad8\u503c\u7684\u4e3b\u673aIP\u9519\u8bef", (Throwable)e);
        }
        params.remove("fiveLoad");
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "The highest system load of the host in 5 minutes", sysLoadStateMax.getFiveLoad() + maxFiveLoadHostName, reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "The lowest system load of the host in 5 minutes", sysLoadStateMin.getFiveLoad() + "", reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "5-minute average system load of the host", FormatUtil.formatDouble((Double)sysLoadStateAvg.getFiveLoad(), (int)2) + "", reportInfo.getId());
        String maxFifteenLoadHostName = "";
        try {
            params.put("fifteenLoad", sysLoadStateMax.getFifteenLoad());
            pageInfoSysLoad = this.sysLoadStateService.selectByParams(params, 1, 1);
            if (!CollectionUtil.isEmpty((Collection)pageInfoSysLoad.getList())) {
                maxFifteenLoadHostName = ((SysLoadState)pageInfoSysLoad.getList().get(0)).getHostname();
                maxFifteenLoadHostName = ", " + maxFifteenLoadHostName + HostUtil.addRemark((String)maxFifteenLoadHostName);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u627e5\u5206\u949f\u7cfb\u7edf\u8d1f\u8f7d\u6700\u9ad8\u503c\u7684\u4e3b\u673aIP\u9519\u8bef", (Throwable)e);
        }
        params.remove("fifteenLoad");
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "The highest system load of the host in 15 minutes", sysLoadStateMax.getFifteenLoad() + maxFifteenLoadHostName, reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "The lowest system load of the host in 15 minutes", sysLoadStateMin.getFifteenLoad() + "", reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "15 minute average system load of the host", FormatUtil.formatDouble((Double)sysLoadStateAvg.getFifteenLoad(), (int)2) + "", reportInfo.getId());
        Integer maxProcs = 0;
        String maxProcsHostName = "";
        Double avgProcs = 0.0;
        Integer minProcs = 1000;
        String minProcsHostName = "";
        Integer sumProcs = 0;
        Integer maxNetConnections = 0;
        String maxNetConnectionsHostName = "";
        Double avgNetConnections = 0.0;
        Integer minNetConnections = 1000;
        Integer sumNetConnections = 0;
        int systemSize = 0;
        int cpuCoresSum = 0;
        double memSum = 0.0;
        int submitSecondsSum = 0;
        double avgSubmitSeconds = 120.0;
        for (SystemInfo systemInfo : systemInfoList) {
            ++systemSize;
            try {
                cpuCoresSum += Integer.valueOf(systemInfo.getCpuCoreNum()).intValue();
            }
            catch (Exception e) {
                logger.error("\u7edf\u8ba1\u6240\u6709\u4e3b\u673a\u603b\u6838\u6570\u9519\u8bef", (Throwable)e);
            }
            try {
                memSum += Double.valueOf(systemInfo.getTotalMem().replace("G", "")).doubleValue();
            }
            catch (Exception e) {
                logger.error("\u7edf\u8ba1\u6240\u6709\u4e3b\u673a\u603b\u5185\u5b58\u9519\u8bef", (Throwable)e);
            }
            try {
                submitSecondsSum += Integer.valueOf(systemInfo.getSubmitSeconds()).intValue();
            }
            catch (Exception e) {
                logger.error("\u7edf\u8ba1\u6240\u6709\u4e3b\u673a\u7ec4\u88c5\u4e0a\u62a5\u6570\u636e\u9891\u7387\u603b\u548c\u9519\u8bef", (Throwable)e);
            }
            if (!StringUtils.isEmpty((CharSequence)systemInfo.getProcs())) {
                if (Integer.valueOf(systemInfo.getProcs()) > maxProcs) {
                    maxProcs = Integer.valueOf(systemInfo.getProcs());
                    maxProcsHostName = ", " + systemInfo.getHostname() + HostUtil.addRemark((String)systemInfo.getHostname());
                }
                if (Integer.valueOf(systemInfo.getProcs()) < minProcs) {
                    minProcs = Integer.valueOf(systemInfo.getProcs());
                    minProcsHostName = ", " + systemInfo.getHostname() + HostUtil.addRemark((String)systemInfo.getHostname());
                }
                sumProcs = sumProcs + Integer.valueOf(systemInfo.getProcs());
            }
            if (StringUtils.isEmpty((CharSequence)systemInfo.getNetConnections())) continue;
            if (Integer.valueOf(systemInfo.getNetConnections()) > maxNetConnections) {
                maxNetConnections = Integer.valueOf(systemInfo.getNetConnections());
                maxNetConnectionsHostName = ", " + systemInfo.getHostname() + HostUtil.addRemark((String)systemInfo.getHostname());
            }
            if (Integer.valueOf(systemInfo.getNetConnections()) < minNetConnections) {
                minNetConnections = Integer.valueOf(systemInfo.getNetConnections());
            }
            sumNetConnections = sumNetConnections + Integer.valueOf(systemInfo.getNetConnections());
        }
        if (systemSize > 0) {
            avgSubmitSeconds = (double)submitSecondsSum / (double)systemInfoList.size();
            avgProcs = (double)sumProcs.intValue() / (double)systemInfoList.size();
            avgNetConnections = (double)sumNetConnections.intValue() / (double)systemInfoList.size();
        } else {
            avgProcs = 0.0;
            avgNetConnections = 0.0;
        }
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Total number of monitor hosts", systemSize + "", reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Total number of CPU cores", cpuCoresSum + "", reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Total memory", FormatUtil.formatDouble((Double)memSum, (int)2) + "G", reportInfo.getId());
        if (null == params.get("groupId")) {
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Total disk capacity", this.servletContext.getAttribute("sumDiskSizeCache") + "", reportInfo.getId());
        } else {
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Total disk capacity", this.taskUtilService.sumDiskSizeCacheByGroup(params.get("groupId")), reportInfo.getId());
        }
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Average monitor and reporting frequency of agents", FormatUtil.formatDouble((Double)avgSubmitSeconds, (int)2) + "s", reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Maximum number of host connections", maxNetConnections + maxNetConnectionsHostName, reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Average number of host connections", FormatUtil.formatDouble((Double)avgNetConnections, (int)2) + "", reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Minimum number of host connections", minNetConnections + "", reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Maximum number of running processes on the host", maxProcs + maxProcsHostName, reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Average number of running processes on the host", FormatUtil.formatDouble((Double)avgProcs, (int)2) + "", reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Minimum number of running processes on the host", minProcs + minProcsHostName, reportInfo.getId());
        if (null == params.get("groupId")) {
            params.put("hostname", "Start issuing instructions");
            int shellSize = this.logInfoService.countByParams(params);
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Accumulate the number of instructions issued", shellSize + "", reportInfo.getId());
            params.remove("hostname");
            params.put("state", "1");
            int warnSize = this.logInfoService.countByParams(params);
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Accumulated number of alarm messages", warnSize + "", reportInfo.getId());
            params.put("state", "3");
            int recoveredSize = this.logInfoService.countByParams(params);
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Accumulated number of recovery messages", recoveredSize + "", reportInfo.getId());
            params.put("state", "4");
            int thirdWarnSize = this.logInfoService.countByParams(params);
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Number of third-party alarm messages", thirdWarnSize + "", reportInfo.getId());
            params.put("state", "2");
            int xtczLogSize = this.logInfoService.countByParams(params);
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Number of system operation records", xtczLogSize + "", reportInfo.getId());
            params.remove("state");
        }
        Double maxDiskPer = 0.0;
        String maxDiskPerHostName = "";
        Double minDiskPer = 1000.0;
        String minDiskPerHostName = "";
        Double avgDiskPer = 0.0;
        Double sumDiskPer = 0.0;
        params.remove("hostname");
        List hostDiskPerList = this.hostDiskPerService.selectAllByParams(params);
        for (HostDiskPer hostDiskPer : hostDiskPerList) {
            if (null != hostDiskPer.getDiskSumPer() && hostDiskPer.getDiskSumPer() > maxDiskPer) {
                maxDiskPer = hostDiskPer.getDiskSumPer();
                maxDiskPerHostName = ", " + hostDiskPer.getHostname() + HostUtil.addRemark((String)hostDiskPer.getHostname());
            }
            if (null != hostDiskPer.getDiskSumPer() && hostDiskPer.getDiskSumPer() < minDiskPer) {
                minDiskPer = hostDiskPer.getDiskSumPer();
                minDiskPerHostName = ", " + hostDiskPer.getHostname() + HostUtil.addRemark((String)hostDiskPer.getHostname());
            }
            if (null == hostDiskPer.getDiskSumPer()) continue;
            sumDiskPer = sumDiskPer + hostDiskPer.getDiskSumPer();
        }
        if (hostDiskPerList.size() > 0) {
            avgDiskPer = sumDiskPer / (double)hostDiskPerList.size();
        } else {
            minDiskPer = 0.0;
        }
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "The highest total utilization rate of the host disk", maxDiskPer + maxDiskPerHostName, reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Average Total Utilization of Host Disk", FormatUtil.formatDouble((Double)avgDiskPer, (int)2) + "", reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "The lowest total utilization rate of the host disk", minDiskPer + minDiskPerHostName, reportInfo.getId());
        DiskIoState diskIoStateMax = this.diskIoStateService.selectMaxByHostname(params);
        if (null != diskIoStateMax) {
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Disk read/write speed", "The highest reading speed: " + diskIoStateMax.getReadIoAvg() + "MB/s, The highest write rate: " + diskIoStateMax.getWriteIoAvg() + "MB/s", reportInfo.getId());
        } else {
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Disk read/write speed", "No data available at the moment", reportInfo.getId());
        }
        Double maxInput = 0.0;
        String maxInputHostName = "";
        Double minInput = 1000.0;
        String minInputHostName = "";
        Double avgInput = 0.0;
        Double sumInput = 0.0;
        List cpuTemperaturesList = this.cpuTemperaturesService.selectAllByParams(params);
        for (CpuTemperatures cpuTemperatures : cpuTemperaturesList) {
            try {
                Double inputDouble = Double.valueOf(cpuTemperatures.getInput());
                if (null != inputDouble && inputDouble > maxInput) {
                    maxInput = inputDouble;
                    maxInputHostName = ", " + cpuTemperatures.getHostname() + HostUtil.addRemark((String)cpuTemperatures.getHostname());
                }
                if (null != inputDouble && inputDouble < minInput) {
                    minInput = inputDouble;
                    minInputHostName = ", " + cpuTemperatures.getHostname() + HostUtil.addRemark((String)cpuTemperatures.getHostname());
                }
                if (null == inputDouble) continue;
                sumInput = sumInput + inputDouble;
            }
            catch (Exception e) {
                logger.error("cpuTemperatures\u8f6c\u6362\u9519\u8bef", (Throwable)e);
            }
        }
        if (cpuTemperaturesList.size() > 0) {
            avgInput = sumInput / (double)cpuTemperaturesList.size();
        } else {
            minInput = 0.0;
        }
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Maximum CPU temperature", maxInput + maxInputHostName, reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Average CPU temperature", FormatUtil.formatDouble((Double)avgInput, (int)2) + "", reportInfo.getId());
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Minimum CPU temperature", minInput + minInputHostName, reportInfo.getId());
        HashMap<String, Object> paramsPasswdInfo = new HashMap<String, Object>();
        paramsPasswdInfo.put("groupId", params.get("groupId"));
        int passwdInfoSize = this.passwdInfoService.countByParams(paramsPasswdInfo);
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Total number of device accounts", passwdInfoSize + "", reportInfo.getId());
        HashMap<String, Object> paramsHostWarnDiy = new HashMap<String, Object>();
        paramsHostWarnDiy.put("groupId", params.get("groupId"));
        int hostWarnDiySize = this.hostWarnDiyService.countByParams(paramsHostWarnDiy);
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Customize the total number of alarms", hostWarnDiySize + "", reportInfo.getId());
        if (null == params.get("groupId")) {
            HashMap<String, String> paramsK8SMonitor = new HashMap<String, String>();
            paramsK8SMonitor.put("dataType", "node");
            int k8sNodeSize = this.k8sMonitorService.countByParams(paramsK8SMonitor);
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "K8S Node", k8sNodeSize + "", reportInfo.getId());
            paramsK8SMonitor.put("dataType", "deployment");
            int k8sDeploymentSize = this.k8sMonitorService.countByParams(paramsK8SMonitor);
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "K8S Deployment", k8sDeploymentSize + "", reportInfo.getId());
            paramsK8SMonitor.put("dataType", "namespace");
            int k8sNamespaceSize = this.k8sMonitorService.countByParams(paramsK8SMonitor);
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "K8S Namespace", k8sNamespaceSize + "", reportInfo.getId());
            paramsK8SMonitor.put("dataType", "service");
            int k8sServiceSize = this.k8sMonitorService.countByParams(paramsK8SMonitor);
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "K8S Service", k8sServiceSize + "", reportInfo.getId());
            paramsK8SMonitor.put("dataType", "pod");
            int k8sPodSize = this.k8sMonitorService.countByParams(paramsK8SMonitor);
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "K8S Pod", k8sPodSize + "", reportInfo.getId());
            paramsK8SMonitor.put("dataType", "container");
            int k8sContainerSize = this.k8sMonitorService.countByParams(paramsK8SMonitor);
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "K8S Container", k8sContainerSize + "", reportInfo.getId());
            HashMap paramsKafkaMonitor = new HashMap();
            int kafkaSize = this.kafkaMonitorService.countByParams(paramsKafkaMonitor);
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Kafka", kafkaSize + "", reportInfo.getId());
            HashMap paramsRedisMonitor = new HashMap();
            int redisSize = this.redisMonitorService.countByParams(paramsRedisMonitor);
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Redis", redisSize + "", reportInfo.getId());
            List rabbitmqList = RabbitmqUtil.viewRabbitmqHandler();
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "RabbitMQ", rabbitmqList.size() + "", reportInfo.getId());
            List activemqList = ActivemqUtil.viewActivemqHandler();
            this.reportInstanceService.mergeReportInsToList(reportInstanceList, "ActiveMQ", activemqList.size() + "", reportInfo.getId());
        }
        HashMap<String, Object> paramsTaskJob = new HashMap<String, Object>();
        paramsTaskJob.put("groupId", params.get("groupId"));
        paramsTaskJob.put("active", "1");
        int taskJobInfoSize = this.taskJobInfoService.countByParams(paramsTaskJob);
        paramsTaskJob.put("active", "2");
        int taskJobInfoDownSize = this.taskJobInfoService.countByParams(paramsTaskJob);
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "Planned task execution status", "Running quantity: " + taskJobInfoSize + ", Stopped quantity: " + taskJobInfoDownSize, reportInfo.getId());
        HashMap<String, Object> paramsSnmpDeep = new HashMap<String, Object>();
        paramsSnmpDeep.put("groupId", params.get("groupId"));
        int snmpDeepInfoSize = this.snmpDeepInfoService.countByParams(paramsSnmpDeep);
        this.reportInstanceService.mergeReportInsToList(reportInstanceList, "SNMP deep monitor device", "Number of SNMP deep monitor devices: " + snmpDeepInfoSize, reportInfo.getId());
    }

    public void countWarnInfoLastWeekHandler() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        String timePart = DateUtil.setLastWeekBeginEndTime(params);
        logger.info("\u7edf\u8ba1\u4e0a\u4e00\u5468\u7684\u544a\u8b66\u6570\u91cf\u548c\u6062\u590d\u6570\u91cf\u67e5\u8be2\u6761\u4ef6--------" + ((Object)params).toString());
        if ("false".equals(this.mailConfig.getAllWarnMail()) || "false".equals(this.mailConfig.getLastWeekWarnMail())) {
            logger.info("\u7edf\u8ba1\u4e0a\u4e00\u5468\u7684\u544a\u8b66\u6570\u91cf\u548c\u6062\u590d\u6570\u91cf\uff0c\u544a\u8b66\u5f00\u5173\u5df2\u914d\u7f6e\u5173\u95ed");
            return;
        }
        params.put("state", "1");
        int warnSize = this.logInfoService.countByParams(params);
        params.put("state", "3");
        int recoveredSize = this.logInfoService.countByParams(params);
        Runnable runnable = () -> {
            try {
                WarnOtherUtil.sendUtil((String)(timePart + " Alarm message and recovery message statistics details"), (String)(timePart + ", The total number of alarm messages is " + warnSize + ", The total number of recovered messages is " + recoveredSize), (String)"", (String)"", (boolean)true, (String)"ERROR", (String)"");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        ThreadPoolUtil.executor.execute(runnable);
    }
}

