/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.wgcloud.entity.DiskState;
import com.wgcloud.entity.SystemInfo;
import com.wgcloud.service.AppInfoService;
import com.wgcloud.service.DiskStateService;
import com.wgcloud.service.DockerInfoService;
import com.wgcloud.service.PortInfoService;
import com.wgcloud.service.SystemInfoService;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.PropertyUtil;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskUtilService {
    private Logger logger = LoggerFactory.getLogger(TaskUtilService.class);
    @Autowired
    SystemInfoService systemInfoService;
    @Autowired
    AppInfoService appInfoService;
    @Autowired
    DockerInfoService dockerInfoService;
    @Autowired
    PortInfoService portInfoService;
    @Autowired
    DiskStateService diskStateService;
    @Autowired
    private ServletContext servletContext;

    @Transactional
    public void refreshCommitDate() throws Exception {
        Date nowDate = new Date();
        this.logger.info("Refresh monitor data update time: " + nowDate);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("state", "1");
        List systemInfolist = this.systemInfoService.selectAllByParamsForTask(params);
        ArrayList<SystemInfo> systemInfoUpdateList = new ArrayList<SystemInfo>();
        for (SystemInfo systemInfo : systemInfolist) {
            SystemInfo systemInfoUpdate = new SystemInfo();
            systemInfoUpdate.setCreateTime(nowDate);
            systemInfoUpdate.setId(systemInfo.getId());
            systemInfoUpdateList.add(systemInfoUpdate);
        }
        this.systemInfoService.updateRecord(systemInfoUpdateList);
    }

    public String sumDiskSizeCache(HttpServletRequest request) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        HostUtil.addAccountquery((HttpServletRequest)request, params);
        params.put("countBlockNe", "2");
        List deskStateList = this.diskStateService.selectAllByParams(params);
        BigDecimal sumSize = new BigDecimal(0);
        for (DiskState deskState : deskStateList) {
            if (StringUtils.isEmpty((CharSequence)deskState.getDiskSize())) continue;
            try {
                sumSize = sumSize.add(new BigDecimal(deskState.getDiskSize().replace("G", "")));
            }
            catch (Exception e) {
                this.logger.error("double\u7c7b\u578b\u8f6c\u6362\u9519\u8bef", (Throwable)e);
            }
        }
        String sumSizeStr = String.valueOf(sumSize);
        if (sumSizeStr.indexOf(".") > 0) {
            sumSizeStr = sumSizeStr.substring(0, sumSizeStr.lastIndexOf("."));
        }
        return FormatUtil.gToT((String)sumSizeStr);
    }

    public String sumDiskSizeCacheByGroup(Object groupId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("groupId", groupId);
            params.put("countBlockNe", "2");
            List diskStateList = this.diskStateService.selectAllByParams(params);
            BigDecimal sumSize = new BigDecimal(0);
            for (DiskState deskState : diskStateList) {
                if (StringUtils.isEmpty((CharSequence)deskState.getDiskSize())) continue;
                try {
                    sumSize = sumSize.add(new BigDecimal(deskState.getDiskSize().replace("G", "")));
                }
                catch (Exception e) {
                    this.logger.error("double\u7c7b\u578b\u8f6c\u6362\u9519\u8bef", (Throwable)e);
                }
            }
            String sumSizeStr = String.valueOf(sumSize);
            if (sumSizeStr.indexOf(".") > 0) {
                sumSizeStr = sumSizeStr.substring(0, sumSizeStr.lastIndexOf("."));
            }
            return FormatUtil.gToT((String)sumSizeStr);
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u6807\u7b7e\u7edf\u8ba1\u78c1\u76d8\u5bb9\u91cf\u603b\u548c\u9519\u8bef", (Throwable)e);
            return "";
        }
    }

    public String getValFromContext(String key, String defaultVal) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return defaultVal;
        }
        Object obj = this.servletContext.getAttribute(key);
        if (null == obj) {
            return defaultVal;
        }
        return obj.toString();
    }

    public void initMenuNames() {
        try {
            this.servletContext.setAttribute("jianKongGaiYao", (Object)"Dashboard");
            this.servletContext.setAttribute("ziYuanGuanLi", (Object)"Resource");
            this.servletContext.setAttribute("zhuJiGuanLi", (Object)"Host Monitor");
            this.servletContext.setAttribute("yiChangJinCheng", (Object)"Exception Process");
            this.servletContext.setAttribute("jinChengJianCe", (Object)"Process Monitor");
            this.servletContext.setAttribute("duanKouJianCe", (Object)"Port Monitor");
            this.servletContext.setAttribute("riZhiJianKong", (Object)"Log Monitor");
            this.servletContext.setAttribute("wenJianFangCuanGai", (Object)"File Security");
            this.servletContext.setAttribute("dockerJianCe", (Object)"Docker Monitor");
            this.servletContext.setAttribute("ziDingYiJianKongXiang", (Object)"Custom Monitor");
            this.servletContext.setAttribute("shuJuJianKong", (Object)"DB Monitor");
            this.servletContext.setAttribute("shuJuKuGuanLi", (Object)"DB Monitor");
            this.servletContext.setAttribute("shuJuBiaoJianCe", (Object)"Table Monitor");
            this.servletContext.setAttribute("fuWuJieKouJianCe", (Object)"API");
            this.servletContext.setAttribute("zhanShiKanBan", (Object)"Board");
            this.servletContext.setAttribute("wangLuoSheBeiJianCe", (Object)"Network Monitor");
            this.servletContext.setAttribute("pingJianCe", (Object)"Ping Monitor");
            this.servletContext.setAttribute("snmpJianCe", (Object)"SNMP Monitor");
            this.servletContext.setAttribute("snmpDeepJianCe", (Object)"SNMP Deep");
            this.servletContext.setAttribute("ftpJianCe", (Object)"FTP/SFTP Monitor");
            this.servletContext.setAttribute("zhongJianJianJianCe", (Object)"Component");
            this.servletContext.setAttribute("redis", (Object)"Redis");
            this.servletContext.setAttribute("dongHuanJianCe", (Object)"Power Monitor");
            this.servletContext.setAttribute("nginxRiZhiJianCe", (Object)"Nginx Log");
            this.servletContext.setAttribute("kafka", (Object)"Kafka");
            this.servletContext.setAttribute("rabbitmq", (Object)"RabbitMQ");
            this.servletContext.setAttribute("activemq", (Object)"ActiveMQ");
            this.servletContext.setAttribute("k8sNode", (Object)"K8S-Node");
            this.servletContext.setAttribute("k8sDeployment", (Object)"K8S-Deployment");
            this.servletContext.setAttribute("k8sNamespace", (Object)"K8S-Namespace");
            this.servletContext.setAttribute("k8sPod", (Object)"K8S-Pod");
            this.servletContext.setAttribute("k8sService", (Object)"K8S-Service");
            this.servletContext.setAttribute("k8sContainer", (Object)"K8S-Container");
            this.servletContext.setAttribute("serverBackupName", (Object)"Server-Backup");
            this.servletContext.setAttribute("tuopuTu", (Object)"Topo Graph");
            this.servletContext.setAttribute("zhuJiTuopuTu", (Object)"Host");
            this.servletContext.setAttribute("pingTuopuTu", (Object)"PING");
            this.servletContext.setAttribute("snmpTuopuTu", (Object)"SNMP");
            this.servletContext.setAttribute("snmpDeepTuopuTu", (Object)"SNMP Deep");
            this.servletContext.setAttribute("xunJianBaoGao", (Object)"Report");
            this.servletContext.setAttribute("jiHuaRenWu", (Object)"Scheduled Task");
            this.servletContext.setAttribute("xiTongGuanLi", (Object)"System Manage");
            this.servletContext.setAttribute("xiTongRiZhi", (Object)"System Log");
            this.servletContext.setAttribute("zhiLingXiaFa", (Object)"Command Send");
            this.servletContext.setAttribute("biaoQianGuanLi", (Object)"Label");
            this.servletContext.setAttribute("chengYuanZhangHao", (Object)"Account");
            this.servletContext.setAttribute("gaoJingSheZhi", (Object)"Alarm");
            this.servletContext.setAttribute("youJianGaoJing", (Object)"Email");
            this.servletContext.setAttribute("jiaoBenGaoJing", (Object)"Script Alarm");
            this.servletContext.setAttribute("ziDingYiGaoJing", (Object)"Custom Alarm");
            this.servletContext.setAttribute("ziChanGuanLi", (Object)"Equipment");
            this.servletContext.setAttribute("sheBeiZhangHao", (Object)"Device");
            this.servletContext.setAttribute("gongZuoBiJi", (Object)"Work Note");
            this.servletContext.setAttribute("zhongDuanYunXing", (Object)"Agent Statistics");
            this.servletContext.setAttribute("aillm", (Object)"AI-LLM");
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u8bbe\u7f6e\u83dc\u5355\u540d\u79f0\u9519\u8bef", (Throwable)e);
        }
    }

    public void setDiyMenuNames() {
        try {
            Map mapColNames = PropertyUtil.getMenuNames((String)(StaticKeys.JAR_PATH + "/config/menusNameDiy.properties"));
            if (null != mapColNames) {
                if (!LicenseUtil.checkEnterpriseVersion()) {
                    this.logger.info("The menu name currently using the system's default configuration");
                    return;
                }
                for (Map.Entry entry : mapColNames.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    this.servletContext.setAttribute(key, (Object)value);
                }
                this.logger.info("The menu name currently using custom configuration");
            }
        }
        catch (Exception e) {
            this.logger.error("\u81ea\u5b9a\u4e49\u8bbe\u7f6e\u83dc\u5355\u540d\u79f0\u9519\u8bef", (Throwable)e);
        }
    }
}

