/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util;

import com.wgcloud.config.CommonConfig;
import com.wgcloud.util.redis.RedisDataUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;

@Component
public class MessageErrorUtils {
    private static final Logger logger = LoggerFactory.getLogger(MessageErrorUtils.class);
    @Autowired
    private CommonConfig commonConfig;

    public void setErrorMsgHandler(String id, String errorMsg) {
        try {
            if (StringUtils.isEmpty((CharSequence)errorMsg)) {
                errorMsg = "";
            }
            if (StringUtils.isEmpty((CharSequence)this.commonConfig.getRedisUrl())) {
                StaticKeys.MESSAGE_ERROR_MAP.put(id, errorMsg);
            } else {
                RedisDataUtil.setValue((String)("MESSAGE_ERROR_" + id), (String)errorMsg);
            }
        }
        catch (Exception e) {
            logger.error("setErrorMsgHandler\u9519\u8bef", (Throwable)e);
        }
    }

    public String viewErrorMsgHandler(String id) {
        String result = "";
        try {
            result = StringUtils.isEmpty((CharSequence)this.commonConfig.getRedisUrl()) ? (String)StaticKeys.MESSAGE_ERROR_MAP.get(id) : RedisDataUtil.getValue((String)("MESSAGE_ERROR_" + id));
            if (StringUtils.isEmpty((CharSequence)result)) {
                result = "success";
            }
        }
        catch (Exception e) {
            logger.error("viewErrorMsgHandler\u9519\u8bef", (Throwable)e);
        }
        return result;
    }

    public void getCallBackMsgForShell(Model model, String id, String customShell) {
        if (StringUtils.isEmpty((CharSequence)customShell)) {
            model.addAttribute("shellCallBackMsg", (Object)"NULL");
            return;
        }
        if (!StaticKeys.LICENSE_STATE.equals("1") && !StringUtils.isEmpty((CharSequence)customShell)) {
            model.addAttribute("shellCallBackMsg", (Object)"The current version does not support auto command processing. It needs to be upgraded to the professional version to support it");
            return;
        }
        String result = this.viewErrorMsgHandler(id + "_CallBackMsg");
        if ("success".equals(result)) {
            result = "Ready";
        }
        model.addAttribute("shellCallBackMsg", (Object)result);
    }
}

