/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.wgcloud.dto.HeathMonitorResDto;
import com.wgcloud.entity.HeathMonitor;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.msg.WarnOtherUtil;
import com.wgcloud.util.msg.WarnPools;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Component
public class RestUtil {
    private Logger logger = LoggerFactory.getLogger(RestUtil.class);
    @Autowired
    private RestTemplate restTemplate;

    public HeathMonitorResDto post(HeathMonitor heathMonitor, HashMap<String, String> headerMap) {
        HeathMonitorResDto heathMonitorResDto = new HeathMonitorResDto();
        try {
            heathMonitorResDto.setResTimes(Integer.valueOf(20000));
            long startTimes = System.currentTimeMillis();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.add("Accept", "*/*");
            headers.set("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:50.0) Gecko/20100101 Firefox/50.0");
            this.addHeaderMap(headers, headerMap);
            HttpEntity httpEntity = new HttpEntity((Object)heathMonitor.getPostStr(), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(heathMonitor.getHeathUrl(), (Object)httpEntity, String.class, new Object[0]);
            long endTimes = System.currentTimeMillis();
            String resTimes = endTimes - startTimes + "";
            heathMonitorResDto.setResTimes(Integer.valueOf(resTimes));
            heathMonitorResDto.setHeathStatus(Integer.valueOf(responseEntity.getStatusCodeValue()));
            this.logger.debug((String)responseEntity.getBody());
            Integer bodyBytes = ((String)responseEntity.getBody()).getBytes(StandardCharsets.UTF_8).length;
            String bodySize = FormatUtil.bytesFormatUnit((String)String.valueOf(bodyBytes), (String)"byte");
            heathMonitor.setResponseBodySize(bodySize);
            this.responseBodyHandle(responseEntity, heathMonitor, heathMonitorResDto);
            return heathMonitorResDto;
        }
        catch (HttpClientErrorException e) {
            this.logger.error("Service interface check task error", (Throwable)e);
            heathMonitorResDto.setHeathStatus(Integer.valueOf(e.getRawStatusCode()));
            heathMonitor.setResponseBodySize("0B");
            heathMonitorResDto.setErrorMsg(e.toString());
            return heathMonitorResDto;
        }
        catch (Exception e) {
            this.logger.error("Service interface check task error", (Throwable)e);
            heathMonitorResDto.setHeathStatus(Integer.valueOf(500));
            heathMonitor.setResponseBodySize("0B");
            heathMonitorResDto.setErrorMsg(e.toString());
            return heathMonitorResDto;
        }
    }

    public HeathMonitorResDto postFormData(HeathMonitor heathMonitor, HashMap<String, String> headerMap, HashMap<String, String> formMap) {
        HeathMonitorResDto heathMonitorResDto = new HeathMonitorResDto();
        try {
            heathMonitorResDto.setResTimes(Integer.valueOf(20000));
            long startTimes = System.currentTimeMillis();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            headers.add("Accept", "*/*");
            headers.set("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:50.0) Gecko/20100101 Firefox/50.0");
            this.addHeaderMap(headers, headerMap);
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            if (null != formMap && formMap.size() > 0) {
                params.setAll(formMap);
            }
            HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(heathMonitor.getHeathUrl(), (Object)httpEntity, String.class, new Object[0]);
            long endTimes = System.currentTimeMillis();
            String resTimes = endTimes - startTimes + "";
            heathMonitorResDto.setResTimes(Integer.valueOf(resTimes));
            heathMonitorResDto.setHeathStatus(Integer.valueOf(responseEntity.getStatusCodeValue()));
            this.logger.debug((String)responseEntity.getBody());
            Integer bodyBytes = ((String)responseEntity.getBody()).getBytes(StandardCharsets.UTF_8).length;
            String bodySize = FormatUtil.bytesFormatUnit((String)String.valueOf(bodyBytes), (String)"byte");
            heathMonitor.setResponseBodySize(bodySize);
            this.responseBodyHandle(responseEntity, heathMonitor, heathMonitorResDto);
            return heathMonitorResDto;
        }
        catch (HttpClientErrorException e) {
            this.logger.error("Service interface check task error", (Throwable)e);
            heathMonitorResDto.setHeathStatus(Integer.valueOf(e.getRawStatusCode()));
            heathMonitor.setResponseBodySize("0B");
            heathMonitorResDto.setErrorMsg(e.toString());
            return heathMonitorResDto;
        }
        catch (Exception e) {
            this.logger.error("Service interface check task error", (Throwable)e);
            heathMonitorResDto.setHeathStatus(Integer.valueOf(500));
            heathMonitor.setResponseBodySize("0B");
            heathMonitorResDto.setErrorMsg(e.toString());
            return heathMonitorResDto;
        }
    }

    public JSONObject post(String url, JSONObject jsonObject) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add("Accept", MediaType.APPLICATION_JSON_UTF8.toString());
        HttpEntity httpEntity = new HttpEntity((Object)JSONUtil.parse((Object)jsonObject).toString(), (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        return JSONUtil.parseObj((String)((String)responseEntity.getBody()));
    }

    public JSONObject post(String url) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add("Accept", MediaType.APPLICATION_JSON_UTF8.toString());
        HttpEntity httpEntity = new HttpEntity((Object)"", (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        return JSONUtil.parseObj((String)((String)responseEntity.getBody()));
    }

    public HeathMonitorResDto get(HeathMonitor heathMonitor, HashMap<String, String> headerMap) {
        HeathMonitorResDto heathMonitorResDto = new HeathMonitorResDto();
        try {
            heathMonitorResDto.setResTimes(Integer.valueOf(20000));
            long startTimes = System.currentTimeMillis();
            ResponseEntity responseEntity = null;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.add("Accept", "*/*");
            headers.set("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:50.0) Gecko/20100101 Firefox/50.0");
            this.addHeaderMap(headers, headerMap);
            HttpEntity httpEntity = new HttpEntity((Object)"", (MultiValueMap)headers);
            responseEntity = this.restTemplate.exchange(heathMonitor.getHeathUrl(), HttpMethod.GET, httpEntity, String.class, new Object[0]);
            long endTimes = System.currentTimeMillis();
            String resTimes = endTimes - startTimes + "";
            heathMonitorResDto.setResTimes(Integer.valueOf(resTimes));
            heathMonitorResDto.setHeathStatus(Integer.valueOf(responseEntity.getStatusCodeValue()));
            this.logger.debug((String)responseEntity.getBody());
            Integer bodyBytes = ((String)responseEntity.getBody()).getBytes(StandardCharsets.UTF_8).length;
            String bodySize = FormatUtil.bytesFormatUnit((String)String.valueOf(bodyBytes), (String)"byte");
            heathMonitor.setResponseBodySize(bodySize);
            this.responseBodyHandle(responseEntity, heathMonitor, heathMonitorResDto);
            return heathMonitorResDto;
        }
        catch (HttpClientErrorException e) {
            this.logger.error("Service interface check task error", (Throwable)e);
            heathMonitorResDto.setHeathStatus(Integer.valueOf(e.getRawStatusCode()));
            heathMonitor.setResponseBodySize("0B");
            heathMonitorResDto.setErrorMsg(e.toString());
            return heathMonitorResDto;
        }
        catch (Exception e) {
            this.logger.error("Service interface check task error", (Throwable)e);
            heathMonitorResDto.setHeathStatus(Integer.valueOf(500));
            heathMonitor.setResponseBodySize("0B");
            heathMonitorResDto.setErrorMsg(e.toString());
            return heathMonitorResDto;
        }
    }

    public String get(String url) {
        try {
            ResponseEntity responseEntity = null;
            if (url.startsWith("https")) {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                headers.add("Accept", MediaType.APPLICATION_JSON_UTF8.toString());
                headers.set("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:50.0) Gecko/20100101 Firefox/50.0");
                HttpEntity httpEntity = new HttpEntity((Object)"", (MultiValueMap)headers);
                responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, String.class, new Object[0]);
            } else {
                responseEntity = this.restTemplate.getForEntity(url, String.class, new Object[0]);
            }
            return (String)responseEntity.getBody();
        }
        catch (HttpClientErrorException e) {
            this.logger.error("Request daemon process information error", (Throwable)e);
            return "";
        }
        catch (Exception e) {
            this.logger.error("Request daemon process information error", (Throwable)e);
            Runnable runnable = () -> {
                if (null == WarnPools.MEM_WARN_MAP.get((Object)"wgcloud-daemon-release-error")) {
                    WarnOtherUtil.sendUtil((String)"Request daemon process information error", (String)("Request server-daemon error, please check if the daemon is running. If it is not running, the monitor host may experience offline status." + e.toString()), (String)"", (String)"wgcloud-daemon-release-error", (boolean)true, (String)"ERROR", (String)"");
                }
            };
            ThreadPoolUtil.executor.execute(runnable);
            return "";
        }
    }

    private void responseBodyHandle(ResponseEntity<String> responseEntity, HeathMonitor heathMonitor, HeathMonitorResDto heathMonitorResDto) {
        heathMonitorResDto.setBodyInfo((String)responseEntity.getBody());
        if (!StringUtils.isEmpty((CharSequence)heathMonitor.getResKeyword()) && !((String)responseEntity.getBody()).contains(heathMonitor.getResKeyword())) {
            this.logger.error(heathMonitor.getHeathUrl() + "----The response content does not contain any identification-------" + heathMonitor.getResKeyword());
            heathMonitorResDto.setHeathStatus(Integer.valueOf(500));
            heathMonitorResDto.setErrorMsg("The response content does not contain any identification: " + heathMonitor.getResKeyword());
        }
        if (!StringUtils.isEmpty((CharSequence)heathMonitor.getResNoKeyword())) {
            String[] noKeyWords;
            for (String noKeyWordChar : noKeyWords = heathMonitor.getResNoKeyword().split(",")) {
                if (!((String)responseEntity.getBody()).contains(noKeyWordChar)) continue;
                this.logger.error(heathMonitor.getHeathUrl() + "----Response content includes (set keywords that cannot be included) identification-------" + noKeyWordChar);
                heathMonitorResDto.setHeathStatus(Integer.valueOf(500));
                heathMonitorResDto.setErrorMsg("Response content includes (set keywords that cannot be included) identification: " + noKeyWordChar);
                break;
            }
        }
    }

    private void addHeaderMap(HttpHeaders httpHeaders, HashMap<String, String> headerMap) {
        if (null != headerMap && headerMap.size() > 0) {
            httpHeaders.setAll(headerMap);
            if (!StringUtils.isEmpty((CharSequence)headerMap.get("AuthorizationUsername")) && !StringUtils.isEmpty((CharSequence)headerMap.get("AuthorizationPassword"))) {
                String Username = headerMap.get("AuthorizationUsername");
                httpHeaders.remove((Object)"AuthorizationUsername");
                String Password = headerMap.get("AuthorizationPassword");
                httpHeaders.remove((Object)"AuthorizationPassword");
                String authStr = Username.concat(":").concat(Password);
                String authStrEnc = new String(Base64.encodeBase64((byte[])authStr.getBytes()));
                httpHeaders.set("Authorization", "Basic ".concat(authStrEnc));
            }
            if (!StringUtils.isEmpty((CharSequence)headerMap.get("AuthorizationBearerToken"))) {
                String bearerToken = headerMap.get("AuthorizationBearerToken");
                httpHeaders.remove((Object)"AuthorizationBearerToken");
                httpHeaders.set("Authorization", "Bearer " + bearerToken);
            }
        }
    }
}

