/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util;

import cn.hutool.core.collection.CollectionUtil;
import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import com.wgcloud.entity.SnmpInfo;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.PingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class SnmpUtil {
    private static final Logger logger = LoggerFactory.getLogger(SnmpUtil.class);
    private static final String SEND_PREFIX = "send_";
    private static final String RECEIVE_PREFIX = "receive_";
    private static final String GROUP_BY_AVG_PREFIX = "avg";
    private static final String GROUP_BY_MIN_PREFIX = "min";
    private static final String GROUP_BY_MAX_PREFIX = "max";
    private static final String GROUP_BY_SUM_PREFIX = "sum";
    private static final String GROUP_BY_COUNT_PREFIX = "count";

    public static Target createDefault(String ip, String community, String port, int snmpVersion) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            logger.error("ip is null.");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)community)) {
            logger.error("community is null.");
            return null;
        }
        Address address = GenericAddress.parse((String)("udp:" + ip + "/" + port));
        UserTarget target = null;
        if (snmpVersion == 3) {
            target = new UserTarget();
            target.setSecurityLevel(3);
            target.setSecurityName(new OctetString(community));
        } else {
            target = new CommunityTarget();
            ((CommunityTarget)target).setCommunity(new OctetString(community));
            if (snmpVersion == 1) {
                target.setSecurityModel(2);
            }
        }
        target.setVersion(snmpVersion);
        target.setAddress(address);
        target.setTimeout(3000L);
        target.setRetries(2);
        return target;
    }

    public static Map<String, String> getOnLineList(List<SnmpInfo> snmpInfoAllList) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        HashSet<String> set = new HashSet<String>();
        for (SnmpInfo snmpInfo : snmpInfoAllList) {
            set.add(snmpInfo.getHostname());
        }
        for (String hostName : set) {
            if (!SnmpUtil.isEthernetConnection((String)hostName)) {
                resultMap.put(hostName, "2");
                continue;
            }
            resultMap.put(hostName, "1");
        }
        logger.info("snmp on line : " + ((Object)resultMap).toString());
        return resultMap;
    }

    public static boolean isEthernetConnection(String ip) {
        try {
            long resTimes = PingUtil.ping((String)ip, (int)1, (int)4);
            if (resTimes > 0L) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("isEthernetConnection\u9519\u8bef", (Throwable)e);
        }
        return false;
    }

    public static SnmpInfo getAvgSnmpInfo(SnmpInfo snmpInfo) {
        SnmpInfo snmpInfoResult = new SnmpInfo();
        try {
            HashMap everyIfOctetMapBegin = new HashMap();
            snmpInfoResult = SnmpUtil.snmpGet((SnmpInfo)snmpInfo, everyIfOctetMapBegin);
            if (!StringUtils.isEmpty((CharSequence)snmpInfo.getRecvOID()) && !StringUtils.isEmpty((CharSequence)snmpInfo.getSentOID())) {
                if (!"1.3.6.1.2.1.2.2.1.10".equals(snmpInfo.getRecvOID()) && !"1.3.6.1.2.1.2.2.1.16".equals(snmpInfo.getSentOID())) {
                    Thread.sleep(2000L);
                    SnmpInfo snmpInfoForSpeed = new SnmpInfo();
                    snmpInfoForSpeed.setHostname(snmpInfo.getHostname());
                    snmpInfoForSpeed.setSnmpPort(snmpInfo.getSnmpPort());
                    snmpInfoForSpeed.setSnmpCommunity(snmpInfo.getSnmpCommunity());
                    snmpInfoForSpeed.setSnmpVersion(snmpInfo.getSnmpVersion());
                    snmpInfoForSpeed.setSentOID(snmpInfo.getSentOID());
                    snmpInfoForSpeed.setRecvOID(snmpInfo.getRecvOID());
                    HashMap everyIfOctetMapEnd = new HashMap();
                    SnmpUtil.snmpGet((SnmpInfo)snmpInfoForSpeed, everyIfOctetMapEnd);
                    SnmpUtil.calcEveryIfOctetSpeedForPart(everyIfOctetMapBegin, everyIfOctetMapEnd, (SnmpInfo)snmpInfoResult, (SnmpInfo)snmpInfoForSpeed);
                }
                SnmpUtil.noInOutOidHanler((SnmpInfo)snmpInfo, (SnmpInfo)snmpInfoResult);
            }
            if (!StringUtils.isEmpty((CharSequence)snmpInfo.getIfOperStatusOid())) {
                String allIfOperStatus = SnmpUtil.walkSnmpIfOperStatus((SnmpInfo)snmpInfo);
                snmpInfoResult.setIfOperStatusValue(allIfOperStatus);
                if (!StringUtils.isEmpty((CharSequence)snmpInfo.getTestErrorMsg())) {
                    snmpInfoResult.setTestErrorMsg(snmpInfoResult.getTestErrorMsg() + "," + snmpInfo.getTestErrorMsg());
                }
            }
            SnmpUtil.snmpWalkForGroupBy((SnmpInfo)snmpInfo, (SnmpInfo)snmpInfoResult);
            return snmpInfoResult;
        }
        catch (Exception e) {
            logger.error("getAvgSnmpInfo\u9519\u8bef", (Throwable)e);
            snmpInfoResult.setRecvAvg("");
            snmpInfoResult.setSentAvg("");
            snmpInfoResult.setMemPer("0");
            snmpInfoResult.setTemperatureValue("0");
            snmpInfoResult.setCpuPer("0");
            snmpInfoResult.setTestErrorMsg(snmpInfoResult.getTestErrorMsg() + "," + e.toString());
            return snmpInfoResult;
        }
    }

    private static void calcEveryIfOctetSpeedForPart(Map<String, Long> everyIfOctetMapBegin, Map<String, Long> everyIfOctetMapEnd, SnmpInfo snmpInfoResult, SnmpInfo snmpInfoForSpeed) {
        String[] recvOIDArray;
        ArrayList<String> ifOperOidAllList = new ArrayList<String>();
        for (String recvOID : recvOIDArray = snmpInfoForSpeed.getRecvOID().split("\\r\\n")) {
            String indexOper = SnmpUtil.getLastIfOctetIndex((String)recvOID);
            ifOperOidAllList.add(indexOper);
        }
        SnmpUtil.calcEveryIfOctetSpeed(everyIfOctetMapBegin, everyIfOctetMapEnd, (SnmpInfo)snmpInfoResult, ifOperOidAllList);
    }

    private static String getLastIfOctetIndex(String octetOid) {
        if (StringUtils.isEmpty((CharSequence)octetOid)) {
            return "";
        }
        if (!octetOid.contains(".")) {
            return octetOid;
        }
        try {
            String indexOper = octetOid.substring(octetOid.lastIndexOf(".") + 1);
            return indexOper;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u63a5\u53e3\u7684\u7f16\u53f7\u9519\u8bef", (Throwable)e);
            return "";
        }
    }

    private static void calcEveryIfOctetSpeed(Map<String, Long> everyIfOctetMapBegin, Map<String, Long> everyIfOctetMapEnd, SnmpInfo snmpInfoResult, List<String> ifOperOidList) {
        StringBuffer sendSpeedValues = new StringBuffer();
        StringBuffer receiveSpeedValues = new StringBuffer();
        Double recvAvgSum = 0.0;
        Double sentAvgSum = 0.0;
        for (String key : ifOperOidList) {
            Long diffSend;
            double valueAvgSend;
            Long valueByteBeginSend;
            Long diff;
            double valueAvgRece;
            Long valueByteBeginReceive;
            String indexOper = SnmpUtil.getLastIfOctetIndex((String)key);
            Long valueByteEndReceive = everyIfOctetMapEnd.get("receive_" + key);
            if (null == valueByteEndReceive) {
                valueByteEndReceive = 0L;
            }
            if (null == (valueByteBeginReceive = everyIfOctetMapBegin.get("receive_" + key))) {
                valueByteBeginReceive = 0L;
            }
            if ((valueAvgRece = (double)(diff = Long.valueOf(valueByteEndReceive - valueByteBeginReceive)).longValue() / 2.0) < 0.0) {
                valueAvgRece = Math.abs(valueAvgRece);
            }
            valueAvgRece = FormatUtil.formatDouble((Double)(valueAvgRece / 1024.0), (int)2);
            receiveSpeedValues.append(indexOper + ":" + valueAvgRece + ",");
            recvAvgSum = recvAvgSum + valueAvgRece;
            Long valueByteEndSend = everyIfOctetMapEnd.get("send_" + key);
            if (null == valueByteEndSend) {
                valueByteEndSend = 0L;
            }
            if (null == (valueByteBeginSend = everyIfOctetMapBegin.get("send_" + key))) {
                valueByteBeginSend = 0L;
            }
            if ((valueAvgSend = (double)(diffSend = Long.valueOf(valueByteEndSend - valueByteBeginSend)).longValue() / 2.0) < 0.0) {
                valueAvgSend = Math.abs(valueAvgSend);
            }
            valueAvgSend = FormatUtil.formatDouble((Double)(valueAvgSend / 1024.0), (int)2);
            sendSpeedValues.append(indexOper + ":" + valueAvgSend + ",");
            sentAvgSum = sentAvgSum + valueAvgSend;
        }
        snmpInfoResult.setSentAvg(sendSpeedValues.toString());
        snmpInfoResult.setRecvAvg(receiveSpeedValues.toString());
        snmpInfoResult.setRecvAvgSum(FormatUtil.formatDouble((Double)recvAvgSum, (int)2) + "");
        snmpInfoResult.setSentAvgSum(FormatUtil.formatDouble((Double)sentAvgSum, (int)2) + "");
    }

    private static void noInOutOidHanler(SnmpInfo snmpInfo, SnmpInfo snmpInfoResult) {
        SnmpInfo snmpInfoDefaultAllOpers = new SnmpInfo();
        if ("1.3.6.1.2.1.2.2.1.10".equals(snmpInfo.getRecvOID()) && "1.3.6.1.2.1.2.2.1.16".equals(snmpInfo.getSentOID())) {
            snmpInfoDefaultAllOpers = SnmpUtil.getDefaultAllOpersBytes((SnmpInfo)snmpInfo);
            snmpInfoResult.setBytesRecv(snmpInfoDefaultAllOpers.getBytesRecv());
            snmpInfoResult.setBytesSent(snmpInfoDefaultAllOpers.getBytesSent());
            snmpInfoResult.setRecvAvg(snmpInfoDefaultAllOpers.getRecvAvg());
            snmpInfoResult.setSentAvg(snmpInfoDefaultAllOpers.getSentAvg());
            snmpInfoResult.setRecvAvgSum(snmpInfoDefaultAllOpers.getRecvAvgSum());
            snmpInfoResult.setSentAvgSum(snmpInfoDefaultAllOpers.getSentAvgSum());
            if (!StringUtils.isEmpty((CharSequence)snmpInfoDefaultAllOpers.getTestErrorMsg())) {
                snmpInfoResult.setTestErrorMsg(snmpInfoResult.getTestErrorMsg() + "," + snmpInfoDefaultAllOpers.getTestErrorMsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnmpInfo snmpGet(SnmpInfo snmpInfo, Map<String, Long> everyIfOctetMap) {
        SnmpInfo snmpInfoRes;
        block29: {
            SnmpInfo snmpInfo2;
            Snmp snmp = null;
            DefaultUdpTransportMapping transport = null;
            snmpInfoRes = new SnmpInfo();
            Vector vector = null;
            try {
                String diskPerOid;
                String voltageOID;
                String temperatureOID;
                String memSizeOID;
                String cpuPerOID;
                String receiveOID;
                String ip = snmpInfo.getHostname();
                String community = snmpInfo.getSnmpCommunity();
                String port = snmpInfo.getSnmpPort();
                int snmpVersion = Integer.valueOf(snmpInfo.getSnmpVersion());
                String sendOID = snmpInfo.getSentOID();
                if (StringUtils.isEmpty((CharSequence)sendOID)) {
                    sendOID = "";
                }
                if (StringUtils.isEmpty((CharSequence)(receiveOID = snmpInfo.getRecvOID()))) {
                    receiveOID = "";
                }
                if (SnmpUtil.checkGroupByFunc((String)(cpuPerOID = snmpInfo.getCpuPerOID()))) {
                    cpuPerOID = "";
                }
                if (SnmpUtil.checkGroupByFunc((String)(memSizeOID = snmpInfo.getMemSizeOID()))) {
                    memSizeOID = "";
                }
                if (SnmpUtil.checkGroupByFunc((String)(temperatureOID = snmpInfo.getTemperatureOid()))) {
                    temperatureOID = "";
                }
                if (SnmpUtil.checkGroupByFunc((String)(voltageOID = snmpInfo.getVoltageOid()))) {
                    voltageOID = "";
                }
                if (SnmpUtil.checkGroupByFunc((String)(diskPerOid = snmpInfo.getDiskPerOid()))) {
                    diskPerOid = "";
                }
                String sysDescOid = snmpInfo.getSysDescOid();
                if (StringUtils.isEmpty((CharSequence)sendOID) || StringUtils.isEmpty((CharSequence)receiveOID)) {
                    snmpInfoRes.setBytesSent("0");
                    snmpInfoRes.setBytesRecv("0");
                }
                Target myTarget = SnmpUtil.createDefault((String)ip, (String)community, (String)port, (int)snmpVersion);
                transport = new DefaultUdpTransportMapping();
                transport.listen();
                snmp = new Snmp((TransportMapping)transport);
                PDU request = new PDU();
                if (!"1.3.6.1.2.1.2.2.1.16".equals(snmpInfo.getSentOID())) {
                    SnmpUtil.bindingRequestVars((PDU)request, (String[])sendOID.split("\\r\\n"));
                }
                if (!"1.3.6.1.2.1.2.2.1.10".equals(snmpInfo.getRecvOID())) {
                    SnmpUtil.bindingRequestVars((PDU)request, (String[])receiveOID.split("\\r\\n"));
                }
                HashMap<String, Double> otherOIDValMap = new HashMap<String, Double>();
                if (!StringUtils.isEmpty((CharSequence)cpuPerOID)) {
                    List cpuPerOIDList = SnmpUtil.compileExpression((String)cpuPerOID);
                    for (String cpuPerOIDTmp : cpuPerOIDList) {
                        SnmpUtil.bindingRequestVars((PDU)request, (String)cpuPerOIDTmp.trim());
                        otherOIDValMap.put(cpuPerOIDTmp.trim(), 0.0);
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)memSizeOID)) {
                    List memSizeOIDList = SnmpUtil.compileExpression((String)memSizeOID);
                    for (String memSizeOIDTmp : memSizeOIDList) {
                        SnmpUtil.bindingRequestVars((PDU)request, (String)memSizeOIDTmp.trim());
                        otherOIDValMap.put(memSizeOIDTmp.trim(), 0.0);
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)diskPerOid)) {
                    List diskPerOidList = SnmpUtil.compileExpression((String)diskPerOid);
                    for (String diskPerOidTmp : diskPerOidList) {
                        SnmpUtil.bindingRequestVars((PDU)request, (String)diskPerOidTmp.trim());
                        otherOIDValMap.put(diskPerOidTmp.trim(), 0.0);
                    }
                }
                SnmpUtil.bindingRequestVars((PDU)request, (String)temperatureOID);
                SnmpUtil.bindingRequestVars((PDU)request, (String)voltageOID);
                SnmpUtil.bindingRequestVars((PDU)request, (String)sysDescOid);
                request.setType(-96);
                ResponseEvent responseEvent = snmp.send(request, myTarget);
                PDU response = responseEvent.getResponse();
                vector = response.getVariableBindings();
                long bytesSentSum = 0L;
                long bytesRecvSum = 0L;
                for (int i = 0; i < vector.size(); ++i) {
                    try {
                        VariableBinding vb1 = (VariableBinding)vector.get(i);
                        if (!StringUtils.isEmpty((CharSequence)sendOID) && sendOID.contains(String.valueOf(vb1.getOid()))) {
                            long sendBytes = Long.valueOf(String.valueOf(vb1.getVariable()));
                            bytesSentSum += sendBytes;
                            everyIfOctetMap.put("send_" + SnmpUtil.getLastIfOctetIndex((String)String.valueOf(vb1.getOid())), sendBytes);
                            continue;
                        }
                        if (!StringUtils.isEmpty((CharSequence)receiveOID) && receiveOID.contains(String.valueOf(vb1.getOid()))) {
                            long receiveBytes = Long.valueOf(String.valueOf(vb1.getVariable()));
                            bytesRecvSum += receiveBytes;
                            everyIfOctetMap.put("receive_" + SnmpUtil.getLastIfOctetIndex((String)String.valueOf(vb1.getOid())), receiveBytes);
                            continue;
                        }
                        for (Map.Entry entry : otherOIDValMap.entrySet()) {
                            if (!((String)entry.getKey()).contains(String.valueOf(vb1.getOid()))) continue;
                            otherOIDValMap.put((String)entry.getKey(), Double.valueOf(String.valueOf(vb1.getVariable())));
                            break;
                        }
                        if (!StringUtils.isEmpty((CharSequence)temperatureOID) && temperatureOID.contains(String.valueOf(vb1.getOid()))) {
                            snmpInfoRes.setTemperatureValue(FormatUtil.formatDouble((String)String.valueOf(vb1.getVariable()), (int)2) + "");
                            continue;
                        }
                        if (!StringUtils.isEmpty((CharSequence)voltageOID) && voltageOID.contains(String.valueOf(vb1.getOid()))) {
                            snmpInfoRes.setVoltageValue(FormatUtil.formatDouble((String)String.valueOf(vb1.getVariable()), (int)2) + "");
                            continue;
                        }
                        if (StringUtils.isEmpty((CharSequence)sysDescOid) || !sysDescOid.contains(String.valueOf(vb1.getOid()))) continue;
                        snmpInfoRes.setSysDescVal(String.valueOf(vb1.getVariable()));
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("snmp\u5e94\u7b54pdu\u83b7\u5f97mib\u4fe1\u606f\u9519\u8bef", (Throwable)e);
                        snmpInfoRes.setTestErrorMsg(snmpInfoRes.getTestErrorMsg() + "," + e.toString());
                    }
                }
                snmpInfoRes.setBytesSent(String.valueOf(bytesSentSum));
                snmpInfoRes.setBytesRecv(String.valueOf(bytesRecvSum));
                snmpInfoRes.setCpuPer(SnmpUtil.computeExpressionValue((String)cpuPerOID, otherOIDValMap) + "");
                snmpInfoRes.setMemPer(SnmpUtil.computeExpressionValue((String)memSizeOID, otherOIDValMap) + "");
                snmpInfoRes.setDiskPer(SnmpUtil.computeExpressionValue((String)diskPerOid, otherOIDValMap) + "");
                snmpInfo2 = snmpInfoRes;
                SnmpUtil.closeTransport((TransportMapping)transport);
            }
            catch (Exception e) {
                logger.error("snmp\u68c0\u6d4b\u9519\u8bef", (Throwable)e);
                snmpInfoRes.setTestErrorMsg(snmpInfoRes.getTestErrorMsg() + "," + e.toString());
                break block29;
            }
            finally {
                SnmpUtil.closeTransport(transport);
                SnmpUtil.closeSnmp(snmp);
            }
            SnmpUtil.closeSnmp((Snmp)snmp);
            return snmpInfo2;
        }
        return snmpInfoRes;
    }

    private static void bindingRequestVars(PDU request, String[] oids) {
        if (oids != null) {
            for (String oid : oids) {
                request.add(new VariableBinding(new OID(oid.trim())));
            }
        }
    }

    private static void bindingRequestVars(PDU request, String oid) {
        if (!StringUtils.isEmpty((CharSequence)oid)) {
            request.add(new VariableBinding(new OID(oid.trim())));
        }
    }

    public static SnmpInfo getDefaultAllOpersBytes(SnmpInfo snmpInfo) {
        SnmpInfo snmpInfoWalkResult = null;
        try {
            SnmpInfo snmpInfoWalkEnd;
            ArrayList ifOperOidList = new ArrayList();
            HashMap everyIfOctetMapBegin = new HashMap();
            SnmpInfo snmpInfoWalkBegin = SnmpUtil.walkSnmp((SnmpInfo)snmpInfo, everyIfOctetMapBegin, null);
            Thread.sleep(2000L);
            HashMap everyIfOctetMapEnd = new HashMap();
            snmpInfoWalkResult = snmpInfoWalkEnd = SnmpUtil.walkSnmp((SnmpInfo)snmpInfo, everyIfOctetMapEnd, ifOperOidList);
            SnmpUtil.calcEveryIfOctetSpeed(everyIfOctetMapBegin, everyIfOctetMapEnd, (SnmpInfo)snmpInfoWalkResult, ifOperOidList);
            return snmpInfoWalkResult;
        }
        catch (Exception e) {
            logger.error("getDefaultAllOpersBytes\u9519\u8bef", (Throwable)e);
            if (null != snmpInfoWalkResult) {
                snmpInfoWalkResult.setTestErrorMsg(snmpInfoWalkResult.getTestErrorMsg() + "," + e.toString());
            }
            return snmpInfoWalkResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnmpInfo walkSnmp(SnmpInfo snmpInfo, Map<String, Long> everyIfOctetMap, List<String> ifOperOidList) {
        Snmp snmp = null;
        SnmpInfo snmpInfoRes = new SnmpInfo();
        try {
            long bytesSentSum = 0L;
            long bytesRecvSum = 0L;
            String allReceiveOID = "1.3.6.1.2.1.2.2.1.10";
            String allSendOID = "1.3.6.1.2.1.2.2.1.16";
            String ip = snmpInfo.getHostname();
            String community = snmpInfo.getSnmpCommunity();
            String port = snmpInfo.getSnmpPort();
            int snmpVersion = Integer.valueOf(snmpInfo.getSnmpVersion());
            snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
            snmp.listen();
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(community));
            target.setVersion(snmpVersion);
            target.setAddress((Address)new UdpAddress(ip + "/" + port));
            target.setTimeout(60000L);
            target.setRetries(1);
            TableUtils utils = new TableUtils((Session)snmp, (PDUFactory)new DefaultPDUFactory(-91));
            utils.setMaxNumRowsPerPDU(5);
            OID[] columnOids = new OID[]{new OID(allReceiveOID), new OID(allSendOID)};
            List l = utils.getTable((Target)target, columnOids, null, null);
            for (TableEvent e : l) {
                logger.info("IfOperByte TableEvent---------" + e.toString());
                VariableBinding[] values = e.getColumns();
                if (values == null) continue;
                String oidTemp = values[0].getOid().toString();
                if (null != ifOperOidList) {
                    ifOperOidList.add(oidTemp);
                }
                Long receiveByte = Long.valueOf(values[0].getVariable().toString());
                everyIfOctetMap.put("receive_" + oidTemp, receiveByte);
                Long sendByte = Long.valueOf(values[1].getVariable().toString());
                everyIfOctetMap.put("send_" + oidTemp, sendByte);
                bytesRecvSum += receiveByte.longValue();
                bytesSentSum += sendByte.longValue();
            }
            snmpInfoRes.setBytesSent(String.valueOf(bytesSentSum));
            snmpInfoRes.setBytesRecv(String.valueOf(bytesRecvSum));
            SnmpInfo snmpInfo2 = snmpInfoRes;
            SnmpUtil.closeSnmp((Snmp)snmp);
            return snmpInfo2;
        }
        catch (Exception e) {
            logger.error("walkSnmp\u9519\u8bef", (Throwable)e);
        }
        finally {
            SnmpUtil.closeSnmp(snmp);
        }
        return snmpInfoRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String walkSnmpIfOperStatus(SnmpInfo snmpInfo) {
        if (StringUtils.isEmpty((CharSequence)snmpInfo.getIfOperStatusOid())) {
            return "";
        }
        logger.info("walkSnmpIfOperStatus------" + snmpInfo.getHostname());
        Snmp snmp = null;
        try {
            String allOperStatusOid = snmpInfo.getIfOperStatusOid();
            String ip = snmpInfo.getHostname();
            String community = snmpInfo.getSnmpCommunity();
            String port = snmpInfo.getSnmpPort();
            int snmpVersion = Integer.valueOf(snmpInfo.getSnmpVersion());
            snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
            snmp.listen();
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(community));
            target.setVersion(snmpVersion);
            target.setAddress((Address)new UdpAddress(ip + "/" + port));
            target.setTimeout(60000L);
            target.setRetries(1);
            TableUtils utils = new TableUtils((Session)snmp, (PDUFactory)new DefaultPDUFactory(-91));
            utils.setMaxNumRowsPerPDU(5);
            OID[] columnOids = new OID[]{new OID(allOperStatusOid)};
            List l = utils.getTable((Target)target, columnOids, null, null);
            StringBuffer operStatusResult = new StringBuffer("");
            String oidTemp = "";
            String indexOperTemp = "";
            String operStatusTemp = "";
            for (TableEvent e : l) {
                logger.info("IfOperStatus TableEvent---------" + e.toString());
                VariableBinding[] values = e.getColumns();
                if (values == null) continue;
                oidTemp = values[0].getOid().toString();
                indexOperTemp = oidTemp.substring(oidTemp.lastIndexOf(".") + 1);
                operStatusTemp = values[0].getVariable().toString();
                operStatusResult.append(indexOperTemp + ":" + operStatusTemp + ",");
            }
            String string = operStatusResult.toString();
            SnmpUtil.closeSnmp((Snmp)snmp);
            return string;
        }
        catch (Exception e) {
            logger.error("walkSnmpOperStatus\u9519\u8bef", (Throwable)e);
            snmpInfo.setTestErrorMsg(snmpInfo.getTestErrorMsg() + "," + e.toString());
        }
        finally {
            SnmpUtil.closeSnmp(snmp);
        }
        return "";
    }

    private static void closeTransport(TransportMapping transport) {
        try {
            if (null != transport) {
                transport.close();
            }
        }
        catch (Exception e) {
            logger.error("closeTransport\u9519\u8bef", (Throwable)e);
        }
    }

    private static void closeSnmp(Snmp snmp) {
        try {
            if (null != snmp) {
                snmp.close();
            }
        }
        catch (Exception e) {
            logger.error("closeSnmp\u9519\u8bef", (Throwable)e);
        }
    }

    private static List<String> compileExpression(String expression) {
        ArrayList<String> oids = new ArrayList<String>();
        try {
            if (!StringUtils.isEmpty((CharSequence)expression) && expression.indexOf("[") < 0) {
                oids.add(expression);
                return oids;
            }
            String regex = "\\[(.*?)\\]";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(expression);
            String extractedContent = "";
            while (matcher.find()) {
                extractedContent = matcher.group(1);
                oids.add(extractedContent);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u8868\u8fbe\u5f0f\u63d0\u53d6\u5176\u4e2d\u7684OID\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
        return oids;
    }

    private static Double computeExpressionValue(String expression, Map<String, Double> env) {
        Double result = 0.0;
        try {
            if (StringUtils.isEmpty((CharSequence)expression) || null == env) {
                return result;
            }
            List oidList = SnmpUtil.compileExpression((String)expression);
            HashMap<String, Double> envNew = new HashMap<String, Double>();
            String key = "";
            for (int i = 0; i < oidList.size(); ++i) {
                key = "w" + i;
                expression = expression.replace("[" + (String)oidList.get(i) + "]", key).replace((CharSequence)oidList.get(i), key);
                envNew.put(key, env.get(((String)oidList.get(i)).trim()));
            }
            Expression compiledExp = AviatorEvaluator.compile((String)expression);
            result = Double.valueOf(String.valueOf(compiledExp.execute(envNew)));
            if (result == null) {
                return 0.0;
            }
            result = FormatUtil.formatDouble((Double)result, (int)2);
        }
        catch (Exception e) {
            logger.error("computeExpressionValue\u9519\u8bef", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void snmpWalkForGroupBy(SnmpInfo snmpInfo, SnmpInfo snmpInfoResult) {
        String diskPerOid;
        String voltageOID;
        String temperatureOID;
        String memSizeOID;
        ArrayList<String> oidList = new ArrayList<String>();
        String cpuPerOID = snmpInfo.getCpuPerOID();
        if (SnmpUtil.checkGroupByFunc((String)cpuPerOID)) {
            oidList.add(cpuPerOID);
        }
        if (SnmpUtil.checkGroupByFunc((String)(memSizeOID = snmpInfo.getMemSizeOID()))) {
            oidList.add(memSizeOID);
        }
        if (SnmpUtil.checkGroupByFunc((String)(temperatureOID = snmpInfo.getTemperatureOid()))) {
            oidList.add(temperatureOID);
        }
        if (SnmpUtil.checkGroupByFunc((String)(voltageOID = snmpInfo.getVoltageOid()))) {
            oidList.add(voltageOID);
        }
        if (SnmpUtil.checkGroupByFunc((String)(diskPerOid = snmpInfo.getDiskPerOid()))) {
            oidList.add(diskPerOid);
        }
        if (CollectionUtil.isEmpty(oidList)) {
            return;
        }
        logger.info("snmpWalkForGroupBy------" + ((Object)oidList).toString());
        Snmp snmp = null;
        try {
            String ip = snmpInfo.getHostname();
            String community = snmpInfo.getSnmpCommunity();
            String port = snmpInfo.getSnmpPort();
            int snmpVersion = Integer.valueOf(snmpInfo.getSnmpVersion());
            snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
            snmp.listen();
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(community));
            target.setVersion(snmpVersion);
            target.setAddress((Address)new UdpAddress(ip + "/" + port));
            target.setTimeout(60000L);
            target.setRetries(1);
            TableUtils utils = new TableUtils((Session)snmp, (PDUFactory)new DefaultPDUFactory(-91));
            utils.setMaxNumRowsPerPDU(5);
            for (String oidValue : oidList) {
                try {
                    List oidChildList = SnmpUtil.compileExpression((String)oidValue);
                    if (CollectionUtil.isEmpty((Collection)oidChildList)) continue;
                    String result = "";
                    OID[] columnOids = new OID[]{new OID((String)oidChildList.get(0))};
                    List tableList = utils.getTable((Target)target, columnOids, null, null);
                    ArrayList<Double> valueList = new ArrayList<Double>();
                    for (TableEvent e : tableList) {
                        VariableBinding[] values = e.getColumns();
                        if (values == null) continue;
                        valueList.add(Double.valueOf(String.valueOf(values[0].getVariable())));
                        logger.info("TableEvent---------" + e.toString());
                    }
                    if (oidValue.equals(snmpInfo.getCpuPerOID())) {
                        snmpInfoResult.setCpuPer(SnmpUtil.getDataGroupByFunc(valueList, (String)oidValue) + "");
                        if (snmpInfoResult.getCpuPer().length() > 10) {
                            snmpInfoResult.setCpuPer(snmpInfoResult.getCpuPer().substring(0, 10));
                        }
                    }
                    if (oidValue.equals(snmpInfo.getMemSizeOID())) {
                        snmpInfoResult.setMemPer(SnmpUtil.getDataGroupByFunc(valueList, (String)oidValue) + "");
                        if (snmpInfoResult.getMemPer().length() > 10) {
                            snmpInfoResult.setMemPer(snmpInfoResult.getMemPer().substring(0, 10));
                        }
                    }
                    if (oidValue.equals(snmpInfo.getTemperatureOid())) {
                        snmpInfoResult.setTemperatureValue(SnmpUtil.getDataGroupByFunc(valueList, (String)oidValue) + "");
                        if (snmpInfoResult.getTemperatureValue().length() > 10) {
                            snmpInfoResult.setTemperatureValue(snmpInfoResult.getTemperatureValue().substring(0, 10));
                        }
                    }
                    if (oidValue.equals(snmpInfo.getVoltageOid())) {
                        snmpInfoResult.setVoltageValue(SnmpUtil.getDataGroupByFunc(valueList, (String)oidValue) + "");
                        if (snmpInfoResult.getVoltageValue().length() > 10) {
                            snmpInfoResult.setVoltageValue(snmpInfoResult.getVoltageValue().substring(0, 10));
                        }
                    }
                    if (!oidValue.equals(snmpInfo.getDiskPerOid())) continue;
                    snmpInfoResult.setDiskPer(SnmpUtil.getDataGroupByFunc(valueList, (String)oidValue) + "");
                    if (snmpInfoResult.getDiskPer().length() <= 10) continue;
                    snmpInfoResult.setDiskPer(snmpInfoResult.getDiskPer().substring(0, 10));
                }
                catch (Exception e) {
                    logger.error("snmp\u5e94\u7b54pdu\u83b7\u5f97mib\u4fe1\u606f\u9519\u8bef", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error("snmpWalkForGroupBy\u9519\u8bef", (Throwable)e);
                snmpInfoResult.setTestErrorMsg(snmpInfoResult.getTestErrorMsg() + "," + e.toString());
            }
            catch (Throwable throwable) {
                SnmpUtil.closeSnmp(snmp);
                throw throwable;
            }
            SnmpUtil.closeSnmp((Snmp)snmp);
        }
        SnmpUtil.closeSnmp((Snmp)snmp);
    }

    public static boolean checkGroupByFunc(String oid) {
        boolean sign = false;
        if (StringUtils.isEmpty((CharSequence)oid)) {
            return sign;
        }
        String oidLow = oid.trim().toLowerCase();
        if (oidLow.startsWith("avg") || oidLow.startsWith("min") || oidLow.startsWith("max") || oidLow.startsWith("sum") || oidLow.startsWith("count")) {
            sign = true;
        }
        return sign;
    }

    public static Double getDataGroupByFunc(List<Double> valueList, String oid) {
        double result = 0.0;
        try {
            if (CollectionUtil.isEmpty(valueList)) {
                return 0.0;
            }
            String oidLow = oid.trim().toLowerCase();
            if (oidLow.startsWith("avg")) {
                Double sum = 0.0;
                for (Double number : valueList) {
                    sum = sum + number;
                }
                result = sum / (double)valueList.size();
                result = FormatUtil.formatDouble((Double)result, (int)2);
                return result;
            }
            if (oidLow.startsWith("min")) {
                return (Double)CollectionUtil.min(valueList);
            }
            if (oidLow.startsWith("max")) {
                return (Double)CollectionUtil.max(valueList);
            }
            if (oidLow.startsWith("sum")) {
                Double sum = 0.0;
                for (Double number : valueList) {
                    sum = sum + number;
                }
                result = FormatUtil.formatDouble((Double)sum, (int)2);
                return result;
            }
            if (oidLow.startsWith("count")) {
                return valueList.size();
            }
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97\u805a\u5408\u51fd\u6570\u7684\u503c\u9519\u8bef", (Throwable)e);
        }
        return 0.0;
    }
}

