/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util.license;

import cn.hutool.core.codec.Base64;
import com.wgcloud.common.ApplicationContextHelper;
import com.wgcloud.entity.SystemInfo;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.license.RSAEncrypt;
import com.wgcloud.util.msg.WarnOtherUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.Model;

/*
 * Exception performing whole class analysis ignored.
 */
public class LicenseUtil {
    private static final Logger logger = LoggerFactory.getLogger(LicenseUtil.class);
    private static LogInfoService logInfoService = (LogInfoService)ApplicationContextHelper.getBean(LogInfoService.class);
    public static final String RPO_MSG = "The personal version can monitor up to 10 items. Please click on the website at the bottom of the page and contact us to upgrade to the professional version";
    public static final String RPO_OUT_TIME_MSG = "The authorization has expired. Please click on the website at the bottom of the page to contact us for authorization";
    public static final String RPO_REQUEST_MSG = "This feature needs to be upgraded to the Professional version. Please click on the website at the bottom of the page to contact us";
    public static final String PRO_OUT_NUM_MSG = "The number of monitor nodes has exceeded the number of authorized nodes. The number of authorized nodes is " + StaticKeys.LICENSE_NUM + ". Please click on the website at the bottom of the page and contact us to upgrade the authorization";
    public static final String PLUS_REQUEST_MSG = "This feature needs to be upgraded to the Enterprise version. Please click on the website at the bottom of the page to contact us.";

    private void testThread() {
        new Thread(() -> logger.info("\u542f\u52a8\u5b50\u7ebf\u7a0b\u6d4b\u8bd5")).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readLicFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            logger.info("No authorization file check----------------");
            return "";
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(path));
            String readLine = null;
            StringBuilder sb = new StringBuilder();
            while ((readLine = br.readLine()) != null) {
                sb.append(readLine);
            }
            String string = sb.toString().trim();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    public static String validateLicense(int agentNum, int pageSize, int pingNum, int snmpInfoNum) {
        try {
            String name;
            String date;
            String path = System.getProperty("user.dir");
            String licenseStr = LicenseUtil.readLicFile((String)(path + "/license.txt"));
            if (StringUtils.isEmpty((CharSequence)licenseStr)) {
                logger.info("No authorization file /server/license.txt detected, current version reset to personal version. The personal version is free and does not require authorization files. Please feel free to use it. If you need a professional version or technical support, please contact us www.wgstart.com");
                return "0";
            }
            byte[] res = RSAEncrypt.decrypt((RSAPublicKey)RSAEncrypt.loadPublicKeyByStr((String)"MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCJgRaOg/qygEtsVWTl+35+RN77mmT6Pjl2v/UZExxH4LmVMFx2U2vHz53tSfWJ0sshuPbn2Y5QOst6BEwrKHNL4/w/Iqc/Rv4Q8hiUIQZtd/M1Yq82+uRKsdmIi6gXLZXQmoUjRTmssGutNonRcnyeowpE4LX6YV1B8Dh8vdgXuwIDAQAB"), (byte[])Base64.decode((CharSequence)licenseStr));
            String restr = new String(res);
            if (StringUtils.isEmpty((CharSequence)restr)) {
                logger.info("license\u89e3\u5bc6\u516c\u94a5\u4e3a\u7a7a");
                return "0";
            }
            String[] restrs = restr.split("-");
            StaticKeys.LICENSE_DATE = date = restrs[0];
            String num = restrs[1];
            StaticKeys.LICENSE_NUM = Integer.valueOf(num);
            StaticKeys.LICENSE_NAME = name = restrs[2];
            String sso = "no";
            if (restrs.length > 3) {
                sso = restrs[3];
            }
            StaticKeys.LICENSE_OPEN_SSO = sso;
            String copyRightUpdate = "no";
            if (restrs.length > 4) {
                copyRightUpdate = restrs[4];
            }
            StaticKeys.LICENSE_COPYRIGHT_UPDATE = copyRightUpdate;
            String hideVersion = "no";
            if (restrs.length > 5) {
                hideVersion = restrs[5];
            }
            StaticKeys.LICENSE_HIDE_VERSION = hideVersion;
            String diyContextPath = "no";
            if (restrs.length > 6) {
                diyContextPath = restrs[6];
            }
            StaticKeys.LICENSE_DIY_CONTEXT_PATH = diyContextPath;
            logger.info("License parsing successful: expiration date " + (StaticKeys.LICENSE_DATE.startsWith("2099") ? " Permanent Authorization " : StaticKeys.LICENSE_DATE) + ", Number of authorized nodes " + StaticKeys.LICENSE_NUM + ", customer name " + StaticKeys.LICENSE_NAME + ", Is SSO service enabled " + StaticKeys.LICENSE_OPEN_SSO + ", CopyRight " + StaticKeys.LICENSE_COPYRIGHT_UPDATE + ", Hide Version " + StaticKeys.LICENSE_HIDE_VERSION + ", ContextPath " + StaticKeys.LICENSE_DIY_CONTEXT_PATH);
            long LICENSE_DATE = Long.valueOf(date);
            if (agentNum > StaticKeys.LICENSE_NUM || pingNum > StaticKeys.LICENSE_NUM || snmpInfoNum > StaticKeys.LICENSE_NUM) {
                logInfoService.save("\u6388\u6743\u89e3\u6790\u9519\u8bef", "\u76d1\u63a7\u8282\u70b9\u8d85\u8fc7\u6388\u6743\u8282\u70b9\u6570\u91cf\uff1a" + num + "\uff0c\u5f53\u524d\u76d1\u63a7\u8282\u70b9\u6570\u91cf\uff1a" + agentNum, "2");
                logger.info("\u76d1\u63a7\u8282\u70b9\u8d85\u8fc7\u6388\u6743\u8282\u70b9\u6570\u91cf\uff0c\u5f53\u524d\u76d1\u63a7\u8282\u70b9\u6570\u91cf" + agentNum + "\uff0cPING\u6570\u91cf" + pingNum + "\uff0cSNMP\u6570\u91cf" + snmpInfoNum);
                return "3";
            }
            Long nowDate = Long.valueOf(DateUtil.getCurrentDate().replace("-", ""));
            if (nowDate > LICENSE_DATE) {
                logInfoService.save("\u6388\u6743\u89e3\u6790\u9519\u8bef", "\u6388\u6743\u5df2\u7ecf\u5230\u671f\uff1a" + date, "2");
                logger.info("\u6388\u6743\u5df2\u7ecf\u5230\u671f");
                return "2";
            }
            StaticKeys.LICENSE_PAGE = StaticKeys.LICENSE_NUM / pageSize + 1;
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u6388\u6743\u6587\u4ef6\u9519\u8bef\uff1a", (Throwable)e);
            return "0";
        }
        return "1";
    }

    public static void checkHostList(SystemInfo systemInfo, Model model) {
        if (systemInfo.getPage() > StaticKeys.LICENSE_PAGE && !StaticKeys.LICENSE_STATE.equals("1")) {
            if (StaticKeys.LICENSE_STATE.equals("0")) {
                model.addAttribute("msg", (Object)"The personal version can monitor up to 10 items. Please click on the website at the bottom of the page and contact us to upgrade to the professional version");
            } else if (StaticKeys.LICENSE_STATE.equals("2")) {
                model.addAttribute("msg", (Object)"The authorization has expired. Please click on the website at the bottom of the page to contact us for authorization");
            } else if (StaticKeys.LICENSE_STATE.equals("3")) {
                model.addAttribute("msg", (Object)PRO_OUT_NUM_MSG);
            }
        }
        if (!StaticKeys.LICENSE_STATE.equals("1")) {
            systemInfo.setPage(Integer.valueOf(1));
            systemInfo.setPageSize(Integer.valueOf(10));
        }
    }

    public static void maxLicense_10(Model model, HttpServletRequest request, Object obj) {
        try {
            String liceFlage = request.getParameter(StaticKeys.LICENSE_LICE_FLAGE);
            Class<?> superClazz = obj.getClass().getSuperclass();
            Method pageGetMethod = superClazz.getDeclaredMethod("getPage", new Class[0]);
            Integer page = (Integer)pageGetMethod.invoke(obj, new Object[0]);
            Method pageSetMethod = superClazz.getDeclaredMethod("setPage", Integer.class);
            Method pageSizeSetMethod = superClazz.getDeclaredMethod("setPageSize", Integer.class);
            if (!StringUtils.isEmpty((CharSequence)liceFlage)) {
                if ("2".equals(liceFlage)) {
                    model.addAttribute("msg", (Object)"This feature needs to be upgraded to the Professional version. Please click on the website at the bottom of the page to contact us");
                    pageSizeSetMethod.invoke(obj, 10);
                    return;
                }
                if (!StaticKeys.LICENSE_STATE.equals("1")) {
                    if (StaticKeys.LICENSE_STATE.equals("0")) {
                        model.addAttribute("msg", (Object)"The personal version can monitor up to 10 items. Please click on the website at the bottom of the page and contact us to upgrade to the professional version");
                    } else if (StaticKeys.LICENSE_STATE.equals("2")) {
                        model.addAttribute("msg", (Object)"The authorization has expired. Please click on the website at the bottom of the page to contact us for authorization");
                    } else {
                        model.addAttribute("msg", (Object)PRO_OUT_NUM_MSG);
                    }
                }
            } else if (page > StaticKeys.LICENSE_PAGE && !StaticKeys.LICENSE_STATE.equals("1")) {
                if (StaticKeys.LICENSE_STATE.equals("0")) {
                    model.addAttribute("msg", (Object)"The personal version can monitor up to 10 items. Please click on the website at the bottom of the page and contact us to upgrade to the professional version");
                } else if (StaticKeys.LICENSE_STATE.equals("2")) {
                    model.addAttribute("msg", (Object)"The authorization has expired. Please click on the website at the bottom of the page to contact us for authorization");
                } else {
                    model.addAttribute("msg", (Object)PRO_OUT_NUM_MSG);
                }
            }
            if (!StaticKeys.LICENSE_STATE.equals("1")) {
                pageSetMethod.invoke(obj, 1);
                pageSizeSetMethod.invoke(obj, 10);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u901a\u7528\u8d44\u6e90\u76d1\u63a7\u6570\u91cf\u9519\u8bef: ", (Throwable)e);
        }
    }

    public static void sendOutDateMail() {
        try {
            Long days;
            if (StaticKeys.LICENSE_STATE.equals("1") && (days = LicenseUtil.getOutDays()) <= 7L) {
                Runnable runnable = () -> WarnOtherUtil.sendUtil((String)"WGCLOUD authorization is about to expire reminder", (String)("Hello, WGCLOUD authorization will expire on \u3010" + StaticKeys.LICENSE_DATE + "\u3011\uff0cPlease contact us for renewal at www.wgstart. com"), (String)"", (String)"", (boolean)false, (String)"ERROR", (String)"");
                ThreadPoolUtil.executor.execute(runnable);
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6388\u6743\u5373\u5c06\u5230\u671f\u63d0\u9192\u90ae\u4ef6\u9519\u8bef", (Throwable)e);
        }
    }

    public static Long getOutDays() throws ParseException {
        String formatLicenseOutDate = StaticKeys.LICENSE_DATE.substring(0, 4) + "-" + StaticKeys.LICENSE_DATE.substring(4, 6) + "-" + StaticKeys.LICENSE_DATE.substring(6);
        Date licenseOutDate = DateUtil.getDate((String)formatLicenseOutDate, (String)"yyyy-MM-dd");
        Date nowDate = new Date();
        Long starTime = nowDate.getTime();
        Long endTime = licenseOutDate.getTime();
        Long num = endTime - starTime;
        Long days = num / 24L / 60L / 60L / 1000L;
        return days;
    }

    public static void outDateAlter(Model model, int agentNum) {
        try {
            if (StaticKeys.LICENSE_STATE.equals("1")) {
                Long days = LicenseUtil.getOutDays();
                if (days < 22L) {
                    model.addAttribute("msg", (Object)("The license is about to expire, please contact us for renewal www.wgstart.com , License expiration date: " + StaticKeys.LICENSE_DATE));
                } else {
                    model.addAttribute("msg", (Object)"");
                }
            }
            if (StaticKeys.LICENSE_STATE.equals("0")) {
                if (agentNum > 10) {
                    model.addAttribute("msg", (Object)"The monitor nodes have exceeded the number of nodes allowed for monitor in the personal version. Please contact us to purchase the professional version www.wgstart.com");
                } else {
                    model.addAttribute("msg", (Object)"");
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5224\u65ad\u6388\u6743\u662f\u5426\u5373\u5c06\u5230\u671f\u9519\u8bef", (Throwable)e);
            model.addAttribute("msg", (Object)"");
        }
    }

    public static void footerLicenseHandle(ServletContext servletContext, String showVersion) {
        if (!StaticKeys.LICENSE_STATE.equals("1")) {
            return;
        }
        servletContext.setAttribute("LICENSE_SHOW_VERSION", (Object)"true");
        String licenseType = "Professional";
        String licenseDate = StaticKeys.LICENSE_DATE;
        if (StaticKeys.LICENSE_DATE.startsWith("2099")) {
            licenseDate = "Permanent";
        }
        if (LicenseUtil.checkEnterpriseVersion()) {
            licenseType = "Enterprise";
            servletContext.setAttribute("LICENSE_SHOW_VERSION", (Object)showVersion);
        }
        String footerLicenseInfo = licenseType + " Version, Expiration Date " + licenseDate + ", Number " + StaticKeys.LICENSE_NUM + ", Customer Name " + StaticKeys.LICENSE_NAME;
        servletContext.setAttribute("footerLicenseInfo", (Object)footerLicenseInfo);
        String footerLicenseInfoDashView = licenseType + " Version";
        servletContext.setAttribute("footerLicenseInfoDashView", (Object)footerLicenseInfoDashView);
    }

    public static void sendStopWarnMail(int listAgentNum) {
        try {
            if (listAgentNum > 10 && !StaticKeys.LICENSE_STATE.equals("1")) {
                StaticKeys.WARN_LICENSE_CHECK_SIGN = false;
                logger.info("Due to the current number of monitor hosts exceeding the allowed monitor limit, the system has stopped sending alert notifications");
            } else {
                StaticKeys.WARN_LICENSE_CHECK_SIGN = true;
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6388\u6743\u63d0\u9192\u90ae\u4ef6\u9519\u8bef", (Throwable)e);
        }
    }

    public static boolean checkEnterpriseVersion() {
        return StaticKeys.LICENSE_STATE.equals("1") && StaticKeys.LICENSE_NAME.startsWith("S");
    }
}

