/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util.msg;

import com.wgcloud.common.ApplicationContextHelper;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.config.LevelConfig;
import com.wgcloud.config.MailConfig;
import com.wgcloud.entity.AppInfo;
import com.wgcloud.entity.CpuState;
import com.wgcloud.entity.CpuTemperatures;
import com.wgcloud.entity.CustomInfo;
import com.wgcloud.entity.DiskIoState;
import com.wgcloud.entity.DiskSmart;
import com.wgcloud.entity.DiskState;
import com.wgcloud.entity.DockerInfo;
import com.wgcloud.entity.FileSafe;
import com.wgcloud.entity.FileWarnInfo;
import com.wgcloud.entity.HostWarnDiy;
import com.wgcloud.entity.MemState;
import com.wgcloud.entity.NetIoState;
import com.wgcloud.entity.PortInfo;
import com.wgcloud.entity.SysLoadState;
import com.wgcloud.entity.SystemInfo;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.SystemInfoService;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.msg.WarnOtherUtil;
import com.wgcloud.util.msg.WarnPools;
import com.wgcloud.util.staticvar.StaticKeys;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

/*
 * Exception performing whole class analysis ignored.
 */
public class WarnMailUtil {
    private static final Logger logger = LoggerFactory.getLogger(WarnMailUtil.class);
    private static CommonConfig commonConfig = (CommonConfig)ApplicationContextHelper.getBean(CommonConfig.class);
    private static LogInfoService logInfoService = (LogInfoService)ApplicationContextHelper.getBean(LogInfoService.class);
    private static MailConfig mailConfig = (MailConfig)ApplicationContextHelper.getBean(MailConfig.class);
    private static LevelConfig levelConfig = (LevelConfig)ApplicationContextHelper.getBean(LevelConfig.class);
    private static SystemInfoService systemInfoService = (SystemInfoService)ApplicationContextHelper.getBean(SystemInfoService.class);

    private static boolean preWarnInit(String hostname, String warnMail, String warnKey) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(warnMail)) {
            return false;
        }
        return !WarnPools.checkWarnCacheTimes((String)warnKey, (Integer)commonConfig.getWarnCacheTimes());
    }

    public static boolean sendWarnInfo(MemState memState) {
        String key = memState.getHostname() + "_mem";
        boolean sign = WarnMailUtil.preWarnInit((String)memState.getHostname(), (String)mailConfig.getMemWarnMail(), (String)key);
        if (!sign) {
            return false;
        }
        Double memWarnVal = mailConfig.getMemWarnVal();
        String warnLevel = levelConfig.getMemWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(memState.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getMemWarnMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (null != hostWarnDiyDto.getMemWarnVal()) {
                memWarnVal = hostWarnDiyDto.getMemWarnVal();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getMemWarnLevel())) {
                warnLevel = hostWarnDiyDto.getMemWarnLevel();
            }
        }
        if (memState.getUsePer() != null && memState.getUsePer() >= memWarnVal) {
            try {
                if (!WarnMailUtil.isOutWarnCount((String)key, (Integer)mailConfig.getMemWarnCount())) {
                    logger.info(memState.getHostname() + "---The memory usage does not reach the number of alarms---" + WarnPools.HOST_WARN_COUNT_MAP.get((Object)key));
                    return false;
                }
                String remark = HostUtil.addRemark((String)memState.getHostname());
                String title = "Memory alarm " + memState.getHostname() + remark;
                String commContent = "Host: " + memState.getHostname() + remark + ", Current memory usage is " + Double.valueOf(memState.getUsePer()) + ", Continuous " + mailConfig.getMemWarnCount() + " times exceeding the alarm value " + memWarnVal;
                String account = WarnMailUtil.getAccount((String)memState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)memState.getHostname(), (String)""), (String)memState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u5185\u5b58\u544a\u8b66\u90ae\u4ef6\u9519\u8bef: ", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u5185\u5b58\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendSysLoadWarnInfo(SysLoadState sysLoadState) {
        String key = sysLoadState.getHostname() + "_load";
        boolean sign = WarnMailUtil.preWarnInit((String)sysLoadState.getHostname(), (String)mailConfig.getSysLoadWarnMail(), (String)key);
        if (!sign) {
            return false;
        }
        Double sysLoadWarnVal = mailConfig.getSysLoadWarnVal();
        String warnLevel = levelConfig.getSysLoadWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(sysLoadState.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getSysLoadWarnMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (null != hostWarnDiyDto.getSysLoadWarnVal()) {
                sysLoadWarnVal = hostWarnDiyDto.getSysLoadWarnVal();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getSysLoadWarnLevel())) {
                warnLevel = hostWarnDiyDto.getSysLoadWarnLevel();
            }
        }
        if (sysLoadState.getFiveLoad() != null && sysLoadState.getFiveLoad() >= sysLoadWarnVal) {
            try {
                String remark = HostUtil.addRemark((String)sysLoadState.getHostname());
                String title = "System load (5 minutes) alarm " + sysLoadState.getHostname() + remark;
                String commContent = "Host: " + sysLoadState.getHostname() + remark + ", Current system load (5 minutes) is " + Double.valueOf(sysLoadState.getFiveLoad()) + ", Alarm value exceeded " + sysLoadWarnVal;
                String account = WarnMailUtil.getAccount((String)sysLoadState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)sysLoadState.getHostname(), (String)""), (String)sysLoadState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u7cfb\u7edf\u8d1f\u8f7d(5\u5206\u949f)\u544a\u8b66\u90ae\u4ef6\u9519\u8bef: ", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u7cfb\u7edf\u8d1f\u8f7d(5\u5206\u949f)\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendCpuWarnInfo(CpuState cpuState) {
        String key = cpuState.getHostname() + "_cpu";
        boolean sign = WarnMailUtil.preWarnInit((String)cpuState.getHostname(), (String)mailConfig.getCpuWarnMail(), (String)key);
        if (!sign) {
            return false;
        }
        Double cpuWarnVal = mailConfig.getCpuWarnVal();
        String warnLevel = levelConfig.getCpuWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(cpuState.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getCpuWarnMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (null != hostWarnDiyDto.getCpuWarnVal()) {
                cpuWarnVal = hostWarnDiyDto.getCpuWarnVal();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getCpuWarnLevel())) {
                warnLevel = hostWarnDiyDto.getCpuWarnLevel();
            }
        }
        if (cpuState.getSys() != null && cpuState.getSys() >= cpuWarnVal) {
            try {
                if (!WarnMailUtil.isOutWarnCount((String)key, (Integer)mailConfig.getCpuWarnCount())) {
                    logger.info(cpuState.getHostname() + "---The CPU usage does not reach the number of alarms---" + WarnPools.HOST_WARN_COUNT_MAP.get((Object)key));
                    return false;
                }
                String remark = HostUtil.addRemark((String)cpuState.getHostname());
                String title = "CPU alarm " + cpuState.getHostname() + remark;
                String commContent = "Host: " + cpuState.getHostname() + remark + ", Current CPU usage is " + Double.valueOf(cpuState.getSys()) + ", Continuous " + mailConfig.getCpuWarnCount() + " times exceeding the alarm value " + cpuWarnVal;
                String account = WarnMailUtil.getAccount((String)cpuState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)cpuState.getHostname(), (String)""), (String)cpuState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001CPU\u544a\u8b66\u90ae\u4ef6\u9519\u8bef: ", (Throwable)e);
                logInfoService.save("\u53d1\u9001CPU\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendNetConnectionsWarnInfo(NetIoState netIoState) {
        Integer netConnections;
        String key = netIoState.getHostname() + "_netConnections";
        boolean sign = WarnMailUtil.preWarnInit((String)netIoState.getHostname(), (String)mailConfig.getNetConnectionsWarnMail(), (String)key);
        if (!sign) {
            return false;
        }
        Double netConnectionsWarnVal = mailConfig.getNetConnectionsWarnVal();
        String warnLevel = levelConfig.getNetConnectionsWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(netIoState.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getNetConnectionsWarnMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (null != hostWarnDiyDto.getNetConnectionsWarnVal()) {
                netConnectionsWarnVal = hostWarnDiyDto.getNetConnectionsWarnVal();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getNetConnectionsWarnLevel())) {
                warnLevel = hostWarnDiyDto.getNetConnectionsWarnLevel();
            }
        }
        if ((double)(netConnections = Integer.valueOf(netIoState.getNetConnections())).intValue() >= netConnectionsWarnVal) {
            try {
                String remark = HostUtil.addRemark((String)netIoState.getHostname());
                String title = "Host connection quantity alarm " + netIoState.getHostname() + remark;
                String commContent = "Host: " + netIoState.getHostname() + remark + ", The current number of connections is " + netConnections + ", Exceeding the alarm value " + netConnectionsWarnVal;
                String account = WarnMailUtil.getAccount((String)netIoState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)netIoState.getHostname(), (String)""), (String)netIoState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u4e3b\u673a\u8fde\u63a5\u6570\u91cf\u544a\u8b66\u90ae\u4ef6\u9519\u8bef: ", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u4e3b\u673a\u8fde\u63a5\u6570\u91cf\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendUpSpeedWarnInfo(NetIoState netIoState) {
        String account;
        String commContent;
        String title;
        String remark;
        boolean sign;
        String key = netIoState.getHostname() + "_txbyt";
        Double upSpeedVal = mailConfig.getUpSpeedVal();
        Double upSpeedMinVal = mailConfig.getUpSpeedMinVal();
        String warnLevel = levelConfig.getSpeedWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(netIoState.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getUpSpeedMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (null != hostWarnDiyDto.getUpSpeedVal()) {
                upSpeedVal = hostWarnDiyDto.getUpSpeedVal();
            }
            if (null != hostWarnDiyDto.getUpSpeedMinVal()) {
                upSpeedMinVal = hostWarnDiyDto.getUpSpeedMinVal();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getSpeedWarnLevel())) {
                warnLevel = hostWarnDiyDto.getSpeedWarnLevel();
            }
        }
        if (!StringUtils.isEmpty((CharSequence)netIoState.getTxbyt()) && Double.valueOf(netIoState.getTxbyt()) >= upSpeedVal) {
            try {
                sign = WarnMailUtil.preWarnInit((String)netIoState.getHostname(), (String)mailConfig.getUpSpeedMail(), (String)(key + "_max"));
                if (!sign) {
                    return false;
                }
                remark = HostUtil.addRemark((String)netIoState.getHostname());
                title = "Transmission rate alarm " + netIoState.getHostname() + remark;
                commContent = "Host: " + netIoState.getHostname() + remark + ", The current upstream rate is " + FormatUtil.kbToM((String)netIoState.getTxbyt()) + "/s, Exceeded Alarm value " + FormatUtil.kbToM((String)(upSpeedVal + "")) + "/s";
                account = WarnMailUtil.getAccount((String)netIoState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)(key + "_max"), (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)netIoState.getHostname(), (String)""), (String)netIoState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u8d85\u8fc7\u4e0a\u884c\u4f20\u8f93\u901f\u7387\u544a\u8b66\u90ae\u4ef6\u9519\u8bef: ", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u8d85\u8fc7\u4e0a\u884c\u4f20\u8f93\u901f\u7387\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)netIoState.getTxbyt()) && Double.valueOf(netIoState.getTxbyt()) < upSpeedMinVal) {
            try {
                sign = WarnMailUtil.preWarnInit((String)netIoState.getHostname(), (String)mailConfig.getUpSpeedMail(), (String)(key + "_min"));
                if (!sign) {
                    return false;
                }
                remark = HostUtil.addRemark((String)netIoState.getHostname());
                title = "Transmission rate alarm: " + netIoState.getHostname() + remark;
                commContent = "Host: " + netIoState.getHostname() + remark + ", The current upstream rate is " + FormatUtil.kbToM((String)netIoState.getTxbyt()) + "/s, Below alarm value " + FormatUtil.kbToM((String)(upSpeedMinVal + "")) + "/s";
                account = WarnMailUtil.getAccount((String)netIoState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)(key + "_min"), (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)netIoState.getHostname(), (String)""), (String)netIoState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u4f4e\u4e8e\u4e0a\u884c\u4f20\u8f93\u901f\u7387\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u4f4e\u4e8e\u4e0a\u884c\u4f20\u8f93\u901f\u7387\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendDownSpeedWarnInfo(NetIoState netIoState) {
        String account;
        String commContent;
        String title;
        String remark;
        boolean sign;
        String key = netIoState.getHostname() + "_rxbyt";
        Double downSpeedVal = mailConfig.getDownSpeedVal();
        Double downSpeedMinVal = mailConfig.getDownSpeedMinVal();
        String warnLevel = levelConfig.getSpeedWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(netIoState.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getDownSpeedMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (null != hostWarnDiyDto.getDownSpeedVal()) {
                downSpeedVal = hostWarnDiyDto.getDownSpeedVal();
            }
            if (null != hostWarnDiyDto.getDownSpeedMinVal()) {
                downSpeedMinVal = hostWarnDiyDto.getDownSpeedMinVal();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getSpeedWarnLevel())) {
                warnLevel = hostWarnDiyDto.getSpeedWarnLevel();
            }
        }
        if (!StringUtils.isEmpty((CharSequence)netIoState.getRxbyt()) && Double.valueOf(netIoState.getRxbyt()) >= downSpeedVal) {
            try {
                sign = WarnMailUtil.preWarnInit((String)netIoState.getHostname(), (String)mailConfig.getDownSpeedMail(), (String)(key + "_max"));
                if (!sign) {
                    return false;
                }
                remark = HostUtil.addRemark((String)netIoState.getHostname());
                title = "Transmission rate alarm: " + netIoState.getHostname() + remark;
                commContent = "Host: " + netIoState.getHostname() + remark + ", The current downstream rate is " + FormatUtil.kbToM((String)netIoState.getRxbyt()) + "/s, Exceeded Alarm value " + FormatUtil.kbToM((String)(downSpeedVal + "")) + "/s";
                account = WarnMailUtil.getAccount((String)netIoState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)(key + "_max"), (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)netIoState.getHostname(), (String)""), (String)netIoState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u8d85\u8fc7\u4e0b\u884c\u4f20\u8f93\u901f\u7387\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u8d85\u8fc7\u4e0b\u884c\u4f20\u8f93\u901f\u7387\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)netIoState.getRxbyt()) && Double.valueOf(netIoState.getRxbyt()) < downSpeedMinVal) {
            try {
                sign = WarnMailUtil.preWarnInit((String)netIoState.getHostname(), (String)mailConfig.getDownSpeedMail(), (String)(key + "_min"));
                if (!sign) {
                    return false;
                }
                remark = HostUtil.addRemark((String)netIoState.getHostname());
                title = "Transmission rate alarm: " + netIoState.getHostname() + remark;
                commContent = "Host: " + netIoState.getHostname() + remark + ", The current downstream rate is " + FormatUtil.kbToM((String)netIoState.getRxbyt()) + "/s, Below alarm value " + FormatUtil.kbToM((String)(downSpeedMinVal + "")) + "/s";
                account = WarnMailUtil.getAccount((String)netIoState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)(key + "_min"), (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)netIoState.getHostname(), (String)""), (String)netIoState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u4f4e\u4e8e\u4e0b\u884c\u4f20\u8f93\u901f\u7387\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u4f4e\u4e8e\u4e0b\u884c\u4f20\u8f93\u901f\u7387\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendDiskSmartWarnInfo(DiskSmart smartBean) {
        String key = smartBean.getHostname() + "_smart";
        boolean sign = WarnMailUtil.preWarnInit((String)smartBean.getHostname(), (String)mailConfig.getSmartWarnMail(), (String)key);
        if (!sign) {
            return false;
        }
        String warnLevel = levelConfig.getSmartWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(smartBean.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getSmartWarnMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getSmartWarnLevel())) {
                warnLevel = hostWarnDiyDto.getSmartWarnLevel();
            }
        }
        if (!StringUtils.isEmpty((CharSequence)smartBean.getDiskState()) && "FAILED".equals(smartBean.getDiskState())) {
            try {
                String remark = HostUtil.addRemark((String)smartBean.getHostname());
                String title = "Disk alarm SMART " + smartBean.getHostname() + remark;
                String commContent = "Host: " + smartBean.getHostname() + remark + ", Disk " + smartBean.getFileSystem() + ", SMART health test results are  " + "FAILED";
                String account = WarnMailUtil.getAccount((String)smartBean.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)smartBean.getHostname(), (String)""), (String)smartBean.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u78c1\u76d8\u544a\u8b66SMART\u90ae\u4ef6\u9519\u8bef", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u78c1\u76d8\u544a\u8b66SMART\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendDiskWarnInfo(DiskState deskState) {
        Double usePer;
        logger.debug("\u544a\u8b66\u78c1\u76d8-------------" + deskState.getFileSystem());
        String key = deskState.getHostname() + "_disk_" + deskState.getFileSystem();
        Double diskWarnVal = mailConfig.getDiskWarnVal();
        String warnLevel = levelConfig.getDiskWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(deskState.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getDiskWarnMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (null != hostWarnDiyDto.getDiskWarnVal()) {
                diskWarnVal = hostWarnDiyDto.getDiskWarnVal();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getDiskWarnLevel())) {
                warnLevel = hostWarnDiyDto.getDiskWarnLevel();
            }
        }
        if ((usePer = Double.valueOf(deskState.getUsePer().replace("%", ""))) != null && usePer < diskWarnVal && null != WarnPools.MEM_WARN_MAP.get((Object)key)) {
            try {
                String remark = HostUtil.addRemark((String)deskState.getHostname());
                String title = "Disk Recovered " + deskState.getHostname() + remark;
                String commContent = "Host disk restored: " + deskState.getHostname() + remark + ", Disk " + deskState.getFileSystem() + " Usage rate is " + usePer + ", Not reaching alarm value " + diskWarnVal;
                String account = WarnMailUtil.getAccount((String)deskState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)false, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)deskState.getHostname(), (String)""), (String)deskState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u78c1\u76d8\u5df2\u6062\u590d\u90ae\u4ef6\u9519\u8bef: ", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u78c1\u76d8\u5df2\u6062\u590d\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
            return false;
        }
        boolean sign = WarnMailUtil.preWarnInit((String)deskState.getHostname(), (String)mailConfig.getDiskWarnMail(), (String)key);
        if (!sign) {
            return false;
        }
        if (WarnMailUtil.blockDisk((DiskState)deskState)) {
            return false;
        }
        if (usePer != null && usePer >= diskWarnVal) {
            try {
                String remark = HostUtil.addRemark((String)deskState.getHostname());
                String title = "Disk alarm " + deskState.getHostname() + remark;
                String commContent = "Host disk alarm: " + deskState.getHostname() + remark + ", Disk " + deskState.getFileSystem() + " Usage rate is " + usePer + ", Exceeded Alarm value " + diskWarnVal;
                String account = WarnMailUtil.getAccount((String)deskState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)deskState.getHostname(), (String)""), (String)deskState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u78c1\u76d8\u544a\u8b66\u90ae\u4ef6\u9519\u8bef: ", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u78c1\u76d8\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    private static boolean blockDisk(DiskState deskState) {
        String diskBlock = mailConfig.getDiskBlock();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(deskState.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive()) && !StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getDiskBlock()) && "no".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
            diskBlock = hostWarnDiyDto.getDiskBlock();
        }
        if (!StringUtils.isEmpty((CharSequence)diskBlock)) {
            String[] blocks = diskBlock.split(",");
            AntPathMatcher pm = new AntPathMatcher();
            for (String diskBlcok : blocks) {
                diskBlcok = diskBlcok.replace("'", "");
                if ("/".equals(deskState.getFileSystem())) {
                    if (!diskBlcok.equals(deskState.getFileSystem())) continue;
                    return true;
                }
                boolean matchStart = pm.matchStart(diskBlcok, deskState.getFileSystem());
                if (!matchStart) continue;
                return matchStart;
            }
        }
        return false;
    }

    public static boolean sendCpuTemperatures(CpuTemperatures cpuTemperatures) {
        Double inputVal;
        String key = cpuTemperatures.getHostname() + "_temperatures";
        boolean sign = WarnMailUtil.preWarnInit((String)cpuTemperatures.getHostname(), (String)mailConfig.getCpuTemperatureWarnMail(), (String)key);
        if (!sign) {
            return false;
        }
        Double cpuTemperatureWarnVal = mailConfig.getCpuTemperatureWarnVal();
        String warnLevel = levelConfig.getCpuTemperatureWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(cpuTemperatures.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getCpuTemperatureWarnMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (null != hostWarnDiyDto.getCpuTemperatureWarnVal()) {
                cpuTemperatureWarnVal = hostWarnDiyDto.getCpuTemperatureWarnVal();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getCpuTemperatureWarnLevel())) {
                warnLevel = hostWarnDiyDto.getCpuTemperatureWarnLevel();
            }
        }
        if ((inputVal = Double.valueOf(cpuTemperatures.getInput().replace("\u2103", "").replace("+", ""))) != null && inputVal >= cpuTemperatureWarnVal) {
            try {
                String remark = HostUtil.addRemark((String)cpuTemperatures.getHostname());
                String title = "CPU temperature alarm " + cpuTemperatures.getHostname() + remark;
                String commContent = "Host: " + cpuTemperatures.getHostname() + remark + ", Current CPU temperature is " + cpuTemperatures.getInput() + ", Exceeded Alarm value " + cpuTemperatureWarnVal + "\u2103";
                String account = WarnMailUtil.getAccount((String)cpuTemperatures.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)cpuTemperatures.getHostname(), (String)""), (String)cpuTemperatures.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001CPU\u6e29\u5ea6\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", (Throwable)e);
                logInfoService.save("\u53d1\u9001CPU\u6e29\u5ea6\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendDiskIoSpeedWarnInfo(DiskIoState diskIoState) {
        String key = diskIoState.getHostname() + "_diskIoSpeed";
        boolean sign = WarnMailUtil.preWarnInit((String)diskIoState.getHostname(), (String)mailConfig.getDiskIoSpeedWarnMail(), (String)key);
        if (!sign) {
            return false;
        }
        Double diskIoSpeedWarnVal = mailConfig.getDiskIoSpeedWarnVal();
        String warnLevel = levelConfig.getDiskWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(diskIoState.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getDiskIoSpeedWarnMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (null != hostWarnDiyDto.getDiskIoSpeedWarnVal()) {
                diskIoSpeedWarnVal = hostWarnDiyDto.getDiskIoSpeedWarnVal();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getDiskWarnLevel())) {
                warnLevel = hostWarnDiyDto.getDiskWarnLevel();
            }
        }
        Double readIoAvg = Double.valueOf(diskIoState.getReadIoAvg());
        Double writeIoAvg = Double.valueOf(diskIoState.getWriteIoAvg());
        if (readIoAvg >= diskIoSpeedWarnVal || writeIoAvg >= diskIoSpeedWarnVal) {
            try {
                String remark = HostUtil.addRemark((String)diskIoState.getHostname());
                String title = "\u78c1\u76d8IO\u8bfb\u5199\u901f\u7387\u544a\u8b66\uff1a" + diskIoState.getHostname() + remark;
                String centerMsg = "\uff0c";
                if (readIoAvg >= diskIoSpeedWarnVal) {
                    centerMsg = centerMsg + "\u5f53\u524d\u78c1\u76d8IO\u8bfb\u53d6\u901f\u7387" + readIoAvg + "MB/s\uff0c";
                }
                if (writeIoAvg >= diskIoSpeedWarnVal) {
                    centerMsg = centerMsg + "\u5f53\u524d\u78c1\u76d8IO\u5199\u5165\u901f\u7387" + writeIoAvg + "MB/s\uff0c";
                }
                String commContent = "\u4e3b\u673a\uff1a" + diskIoState.getHostname() + remark + centerMsg + "\u8d85\u8fc7\u544a\u8b66\u503c" + diskIoSpeedWarnVal + "MB/s";
                String account = WarnMailUtil.getAccount((String)diskIoState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)diskIoState.getHostname(), (String)""), (String)diskIoState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u4e3b\u673a\u78c1\u76d8IO\u8bfb\u5199\u901f\u7387\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u4e3b\u673a\u78c1\u76d8IO\u8bfb\u5199\u901f\u7387\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendHostDown(SystemInfo systemInfo, boolean isDown) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getHostDownWarnMail())) {
            return false;
        }
        String hostDownWarnCount = "";
        hostDownWarnCount = ", Has not reported data for " + mailConfig.getHostDownWarnCount() + " consecutive times";
        String warnLevel = levelConfig.getHostDownWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(systemInfo.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getHostDownWarnMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getHostDownWarnLevel())) {
                warnLevel = hostWarnDiyDto.getHostDownWarnLevel();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getHostDownWarnCount())) {
                hostDownWarnCount = ", Has not reported data for " + hostWarnDiyDto.getHostDownWarnCount() + " consecutive times";
            }
        }
        String key = systemInfo.getId();
        String remark = HostUtil.addRemark((String)systemInfo.getHostname());
        if (isDown) {
            if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                return false;
            }
            try {
                String title = "Host offline alarm " + systemInfo.getHostname() + remark;
                String commContent = "Host may be offline: " + systemInfo.getHostname() + remark + hostDownWarnCount;
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)systemInfo.getAccount(), (String)key, (boolean)isDown, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)systemInfo.getHostname(), (String)""), (String)systemInfo.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u4e3b\u673a\u4e0b\u7ebf\u544a\u8b66\u90ae\u4ef6\u5931\u8d25", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u4e3b\u673a\u4e0b\u7ebf\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        } else {
            try {
                String title = "Host Recovered " + systemInfo.getHostname() + remark;
                String commContent = "The host has resumed online : " + systemInfo.getHostname() + remark;
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)systemInfo.getAccount(), (String)key, (boolean)isDown, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)systemInfo.getHostname(), (String)""), (String)systemInfo.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u4e3b\u673a\u6062\u590d\u4e0a\u7ebf\u901a\u77e5\u90ae\u4ef6\u9519\u8bef", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u4e3b\u673a\u6062\u590d\u4e0a\u7ebf\u901a\u77e5\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendAppDown(AppInfo appInfo, boolean isDown) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getAppDownWarnMail())) {
            return false;
        }
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(appInfo.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive()) && "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
            return false;
        }
        String key = appInfo.getId();
        String remark = HostUtil.addRemark((String)appInfo.getHostname());
        if (isDown) {
            if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                return false;
            }
            try {
                String title = "Process offline alarm " + appInfo.getAppName() + ", " + appInfo.getHostname() + remark;
                String commContent = "Process may be offline " + appInfo.getHostname() + remark + ", Process " + appInfo.getAppName();
                String account = WarnMailUtil.getAccount((String)appInfo.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)appInfo.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)appInfo.getHostname(), (String)appInfo.getGroupId()), (String)appInfo.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u8fdb\u7a0b\u4e0b\u7ebf\u544a\u8b66\u90ae\u4ef6\u5931\u8d25", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u8fdb\u7a0b\u4e0b\u7ebf\u544a\u8b66\u9519\u8bef", e.toString(), "1");
            }
        } else {
            try {
                String title = "Process Recovered " + appInfo.getAppName() + ", " + appInfo.getHostname() + remark;
                String commContent = "Process has resumed online " + appInfo.getHostname() + remark + ", Process " + appInfo.getAppName();
                String account = WarnMailUtil.getAccount((String)appInfo.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)appInfo.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)appInfo.getHostname(), (String)appInfo.getGroupId()), (String)appInfo.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u8fdb\u7a0b\u6062\u590d\u4e0a\u7ebf\u901a\u77e5\u90ae\u4ef6\u5931\u8d25", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u8fdb\u7a0b\u6062\u590d\u4e0a\u7ebf\u901a\u77e5\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendDockerDown(DockerInfo dockerInfo, boolean isDown) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getDockerDownWarnMail())) {
            return false;
        }
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(dockerInfo.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive()) && "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
            return false;
        }
        String key = dockerInfo.getId();
        String remark = HostUtil.addRemark((String)dockerInfo.getHostname());
        String dockerTypeStr = "CONTAINER ID";
        if ("2".equals(dockerInfo.getAppType())) {
            dockerTypeStr = "CONTAINER NAME";
        }
        if (isDown) {
            if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                return false;
            }
            try {
                String title = "Docker offline alarm " + dockerInfo.getDockerName() + ", " + dockerInfo.getHostname() + remark;
                String commContent = "Docker may have been offline: " + dockerInfo.getHostname() + remark + ", Name " + dockerInfo.getDockerName() + ", " + dockerTypeStr + ": " + dockerInfo.getDockerId();
                String account = WarnMailUtil.getAccount((String)dockerInfo.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)dockerInfo.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)dockerInfo.getHostname(), (String)dockerInfo.getGroupId()), (String)dockerInfo.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001docker\u4e0b\u7ebf\u544a\u8b66\u90ae\u4ef6\u5931\u8d25: ", (Throwable)e);
                logInfoService.save("\u53d1\u9001docker\u4e0b\u7ebf\u544a\u8b66\u9519\u8bef", e.toString(), "1");
            }
        } else {
            WarnPools.MEM_WARN_MAP.remove((Object)key);
            try {
                String title = "Docker Recovered " + dockerInfo.getDockerName() + ", " + dockerInfo.getHostname() + remark;
                String commContent = "Docker has recovered online: " + dockerInfo.getHostname() + remark + ", Name " + dockerInfo.getDockerName() + ", " + dockerTypeStr + ": " + dockerInfo.getDockerId();
                String account = WarnMailUtil.getAccount((String)dockerInfo.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)dockerInfo.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)dockerInfo.getHostname(), (String)dockerInfo.getGroupId()), (String)dockerInfo.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001docker\u5df2\u6062\u590d\u4e0a\u7ebf\u90ae\u4ef6\u5931\u8d25: ", (Throwable)e);
                logInfoService.save("\u53d1\u9001docker\u5df2\u6062\u590d\u4e0a\u7ebf\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendPortDown(PortInfo portInfo, boolean isDown) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getPortWarnMail())) {
            return false;
        }
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(portInfo.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive()) && "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
            return false;
        }
        String key = portInfo.getId();
        String remark = HostUtil.addRemark((String)portInfo.getHostname());
        String telnetIp = portInfo.getTelnetIp();
        if (!StringUtils.isEmpty((CharSequence)telnetIp) && telnetIp.length() > 50) {
            telnetIp = telnetIp.substring(0, 50);
        }
        if (isDown) {
            if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                return false;
            }
            if (!WarnMailUtil.isOutWarnCount((String)key, (Integer)mailConfig.getPortWarnCount())) {
                logger.info(portInfo.getHostname() + "---Port monitor error without reaching the number of alarms---" + WarnPools.HOST_WARN_COUNT_MAP.get((Object)key));
                return false;
            }
            try {
                String title = "Port telnet failure alarm " + portInfo.getPortName() + ", telnet-" + telnetIp + "-" + portInfo.getPort() + ", " + portInfo.getHostname() + remark;
                String commContent = "Port has been disconnected from telnet " + mailConfig.getPortWarnCount() + ", Name: " + portInfo.getPortName() + ", telnet-" + telnetIp + "-" + portInfo.getPort() + ", Host: " + portInfo.getHostname() + remark;
                String account = WarnMailUtil.getAccount((String)portInfo.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)portInfo.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)portInfo.getHostname(), (String)portInfo.getGroupId()), (String)portInfo.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u7aef\u53e3telnet\u4e0d\u901a\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u7aef\u53e3telnet\u4e0d\u901a\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        } else {
            WarnPools.MEM_WARN_MAP.remove((Object)key);
            try {
                String title = "Port Recovered " + portInfo.getPortName() + ", telnet-" + telnetIp + "-" + portInfo.getPort() + ", " + portInfo.getHostname() + remark;
                String commContent = "Port has recovered online, Name: " + portInfo.getPortName() + ", telnet-" + telnetIp + "-" + portInfo.getPort() + ", Host: " + portInfo.getHostname() + remark;
                String account = WarnMailUtil.getAccount((String)portInfo.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)portInfo.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)portInfo.getHostname(), (String)portInfo.getGroupId()), (String)portInfo.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u7aef\u53e3telnet\u5df2\u6062\u590d\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u7aef\u53e3telnet\u5df2\u6062\u590d\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendFileSafeDown(FileSafe fileSafe, boolean isDown, String errorFileCount) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getFileSafeWarnMail())) {
            return false;
        }
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(fileSafe.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive()) && "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
            return false;
        }
        String key = fileSafe.getId();
        String remark = HostUtil.addRemark((String)fileSafe.getHostname());
        String errorFileCountStr = "";
        if (null != errorFileCount) {
            errorFileCountStr = ", " + errorFileCount;
        }
        if (isDown) {
            if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                return false;
            }
            try {
                String title = "File Security alarm " + fileSafe.getFileName() + ", " + fileSafe.getHostname() + remark;
                String commContent = "File Security alarm " + fileSafe.getHostname() + remark + ", File: " + fileSafe.getFileName() + ", Path: " + fileSafe.getFilePath() + ", Last modified: " + fileSafe.getFileModtime() + errorFileCountStr;
                String account = WarnMailUtil.getAccount((String)fileSafe.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)fileSafe.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)fileSafe.getHostname(), (String)fileSafe.getGroupId()), (String)fileSafe.getHostname());
            }
            catch (Exception e) {
                logger.error("\u6587\u4ef6\u9632\u7be1\u6539\u76d1\u6d4b\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", (Throwable)e);
                logInfoService.save("\u6587\u4ef6\u9632\u7be1\u6539\u76d1\u6d4b\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        } else {
            WarnPools.MEM_WARN_MAP.remove((Object)key);
            try {
                String title = "File Security Recovered " + fileSafe.getFileName() + ", " + fileSafe.getHostname() + remark;
                String commContent = "File Security Recovered " + fileSafe.getHostname() + remark + ", File: " + fileSafe.getFileName() + ", Path: " + fileSafe.getFilePath() + ", Last modified: " + fileSafe.getFileModtime();
                String account = WarnMailUtil.getAccount((String)fileSafe.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)fileSafe.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)fileSafe.getHostname(), (String)fileSafe.getGroupId()), (String)fileSafe.getHostname());
            }
            catch (Exception e) {
                logger.error("\u6587\u4ef6\u9632\u7be1\u6539\u76d1\u6d4b\u5df2\u6062\u590d\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", (Throwable)e);
                logInfoService.save("\u6587\u4ef6\u9632\u7be1\u6539\u76d1\u6d4b\u5df2\u6062\u590d\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendCustomInfoDown(CustomInfo customInfo, boolean isDown) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getCustomInfoWarnMail())) {
            return false;
        }
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(customInfo.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive()) && "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
            return false;
        }
        String key = customInfo.getId();
        String remark = HostUtil.addRemark((String)customInfo.getHostname());
        try {
            if (isDown) {
                if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                    return false;
                }
                String title = "Custom alarm " + customInfo.getCustomName() + ", " + customInfo.getHostname() + remark;
                String commContent = "Custom alarm " + customInfo.getHostname() + remark + ", " + customInfo.getCustomName() + ", Alarm expression is valid: " + customInfo.getResultExp() + ", result is " + customInfo.getCustomValue();
                String account = WarnMailUtil.getAccount((String)customInfo.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)true, (String)customInfo.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)customInfo.getHostname(), (String)customInfo.getGroupId()), (String)customInfo.getHostname());
            } else {
                WarnPools.MEM_WARN_MAP.remove((Object)key);
                String title = "Custom Recovered " + customInfo.getCustomName() + ", " + customInfo.getHostname() + remark;
                String commContent = "Custom Recovered " + customInfo.getHostname() + remark + ", " + customInfo.getCustomName() + ", Alarm expression is not valid: " + customInfo.getResultExp() + ", result is " + customInfo.getCustomValue();
                String account = WarnMailUtil.getAccount((String)customInfo.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)customInfo.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)customInfo.getHostname(), (String)customInfo.getGroupId()), (String)customInfo.getHostname());
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u81ea\u5b9a\u4e49\u76d1\u63a7\u9879\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", (Throwable)e);
            logInfoService.save("\u53d1\u9001\u81ea\u5b9a\u4e49\u76d1\u63a7\u9879\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
        }
        return false;
    }

    public static boolean sendHostMacInfoDown(String bindIp, String delMacAddress) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getMacInfoWarnMail())) {
            return false;
        }
        String remark = HostUtil.addRemark((String)bindIp);
        try {
            String title = "Host MAC address change alarm " + bindIp + remark;
            String commContent = "Host MAC address change alarm " + bindIp + remark + ", The lost MAC addresses include: " + delMacAddress;
            String account = WarnMailUtil.getAccount((String)bindIp);
            WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)"", (boolean)true, (String)"WARN", (String)WarnMailUtil.getHostGroups((String)bindIp, (String)""), (String)bindIp);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001mac\u5730\u5740\u53d8\u5316\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", (Throwable)e);
            logInfoService.save("\u53d1\u9001mac\u5730\u5740\u53d8\u5316\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
        }
        return false;
    }

    public static boolean sendFileWarnDown(FileWarnInfo fileWarnInfo, String filePath, String warnContent, boolean isDown) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getFileLogWarnMail())) {
            return false;
        }
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(fileWarnInfo.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive()) && "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
            return false;
        }
        String key = fileWarnInfo.getId();
        String remark = HostUtil.addRemark((String)fileWarnInfo.getHostname());
        String fileRemark = "";
        if (!StringUtils.isEmpty((CharSequence)fileWarnInfo.getRemark())) {
            fileRemark = fileWarnInfo.getRemark();
        }
        if (isDown) {
            try {
                String title = "Log monitor alarm " + fileWarnInfo.getHostname() + remark;
                String commContent = "Log monitor alarm " + fileWarnInfo.getHostname() + remark + ", Log Remark: " + fileRemark + ", File Path: " + filePath + ", " + warnContent;
                String account = WarnMailUtil.getAccount((String)fileWarnInfo.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)"", (boolean)false, (String)fileWarnInfo.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)fileWarnInfo.getHostname(), (String)""), (String)fileWarnInfo.getHostname());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u65e5\u5fd7\u76d1\u63a7\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u65e5\u5fd7\u76d1\u63a7\u544a\u8b66\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static String getAccount(String hostname) {
        if ("true".equals(commonConfig.getUserInfoManage()) && !StringUtils.isEmpty((CharSequence)hostname)) {
            return (String)StaticKeys.HOST_ACCOUNT_MAP.get(hostname);
        }
        return "";
    }

    public static void sendUtil(String title, String commContent, String account, String key, boolean isDown, String warnLevel, String groupIds, String hostName) {
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(hostName);
        if (!(null == hostWarnDiyDto || !"1".equals(hostWarnDiyDto.getActive()) || StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getCustomWarnMail()) && StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getCustomWarnAccountKey()))) {
            WarnOtherUtil.sendUtilToCustomMail((String)title, (String)commContent, (String)hostWarnDiyDto.getCustomWarnMail(), (String)hostWarnDiyDto.getCustomWarnAccountKey(), (String)key, (boolean)isDown, (String)warnLevel, (String)groupIds);
            return;
        }
        WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)warnLevel, (String)groupIds);
    }

    public static String getHostGroups(String bindIp, String childGroupId) {
        if (!StringUtils.isEmpty((CharSequence)childGroupId)) {
            return childGroupId;
        }
        try {
            SystemInfo systemInfo = systemInfoService.selectByHostname(bindIp);
            if (null != systemInfo) {
                return systemInfo.getGroupId();
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4e3b\u673a\u6807\u7b7e\u9519\u8bef", (Throwable)e);
        }
        return "";
    }

    private static boolean isOutWarnCount(String key, Integer warnCount) {
        if (WarnPools.HOST_WARN_COUNT_MAP.get((Object)key) == null) {
            WarnPools.HOST_WARN_COUNT_MAP.put((Object)key, (Object)1);
        } else {
            WarnPools.HOST_WARN_COUNT_MAP.put((Object)key, (Object)((Integer)WarnPools.HOST_WARN_COUNT_MAP.get((Object)key) + 1));
        }
        return (Integer)WarnPools.HOST_WARN_COUNT_MAP.get((Object)key) >= warnCount;
    }
}

