/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50717
Source Host           : localhost:3306
Source Database       : wgcloud

Target Server Type    : MYSQL
Target Server Version : 50717
File Encoding         : 65001

Date: 2021-12-18 21:44:36
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for app_info
-- ----------------------------
CREATE TABLE `APP_INFO` (
  `ID` varchar(32) NOT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `APP_PID` varchar(200) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `APP_NAME` varchar(50) DEFAULT NULL,
  `CPU_PER` double(8,2) DEFAULT NULL,
  `MEM_PER` double(10,2) DEFAULT NULL,
  `APP_TYPE` char(1) DEFAULT NULL,
  `STATE` char(1) DEFAULT NULL,
  `ACTIVE` char(1) DEFAULT NULL,
  `READ_BYTES` char(20) DEFAULT NULL,
  `WRITES_BYTES` char(20) DEFAULT NULL,
  `THREADS_NUM` varchar(20) DEFAULT NULL,
  `GATHER_PID` varchar(20) DEFAULT NULL,
  `GROUP_ID` varchar(500) DEFAULT NULL,
  `APP_TIMES` varchar(50) DEFAULT NULL,
  `PRO_USERNAME` varchar(100) DEFAULT NULL,
  `CUSTOM_SHELL` varchar(500) DEFAULT NULL,
  `WARN_LEVEL` varchar(10) DEFAULT NULL,
  `NET_CONNECTIONS` varchar(8) DEFAULT NULL,
  `APP_CMD_LINE` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for app_state
-- ----------------------------
CREATE TABLE `APP_STATE` (
  `ID` varchar(32) NOT NULL,
  `APP_INFO_ID` varchar(32) DEFAULT NULL,
  `CPU_PER` double(8,2) DEFAULT NULL,
  `MEM_PER` double(8,2) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `THREADS_NUM` varchar(10) DEFAULT NULL,
  `NET_CONNECTIONS` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `APP_STAT_INDEX` (`APP_INFO_ID`,`CREATE_TIME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for cpu_state
-- ----------------------------
CREATE TABLE `CPU_STATE` (
  `ID` varchar(32) NOT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `SYS` double(8,2) DEFAULT NULL,
  `PROCS_NUM` integer DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `CPU_ACC_HOST_INDEX` (`HOST_NAME`,`CREATE_TIME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for cpu_temperatures
-- ----------------------------
CREATE TABLE `CPU_TEMPERATURES` (
  `ID` varchar(32) NOT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `CORE_INDEX` varchar(50) DEFAULT NULL,
  `CRIT` char(10) DEFAULT NULL,
  `INPUT` char(10) DEFAULT NULL,
  `MAX` char(10) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for db_info
-- ----------------------------
CREATE TABLE `DB_INFO` (
  `ID` varchar(32) NOT NULL,
  `DBTYPE` varchar(32) DEFAULT NULL,
  `USER_NAME` varchar(50) DEFAULT NULL,
  `PASSWD` varchar(100) DEFAULT NULL,
  `DBURL` varchar(500) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `DB_STATE` char(1) DEFAULT NULL,
  `ALIAS_NAME` varchar(50) DEFAULT NULL,
  `ACCOUNT` varchar(50) DEFAULT NULL,
  `WARN_LEVEL` varchar(10) DEFAULT NULL,
  `ACTIVE` varchar(1) DEFAULT NULL,
  `DRIVER_NAME` varchar(100) DEFAULT NULL,
  `TEST_QUERY_SQL` varchar(100) DEFAULT NULL,
  `GROUP_ID` varchar(500) DEFAULT NULL,
  `RES_TIMES` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for db_table
-- ----------------------------
CREATE TABLE `DB_TABLE` (
  `ID` varchar(32) NOT NULL,
  `TABLE_NAME` varchar(100) DEFAULT NULL,
  `WHERE_VAL` varchar(2000) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `REMARK` varchar(50) DEFAULT NULL,
  `TABLE_COUNT` varchar(100) DEFAULT NULL,
  `DBINFO_ID` char(32) DEFAULT NULL,
  `ACTIVE` char(1) DEFAULT NULL,
  `STATE` varchar(1) DEFAULT NULL,
  `RESULT_EXP` varchar(100) DEFAULT NULL,
  `WARN_LEVEL` varchar(10) DEFAULT NULL,
  `REMARK_EXT` varchar(100) DEFAULT NULL,
  `RES_TIMES` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for db_table_count
-- ----------------------------
CREATE TABLE `DB_TABLE_COUNT` (
  `ID` varchar(32) NOT NULL,
  `DB_TABLE_ID` varchar(32) DEFAULT NULL,
  `TABLE_COUNT` varchar(100) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `DBTABLE_ID_CREATE_TIME` (`DB_TABLE_ID`,`CREATE_TIME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dce_info
-- ----------------------------
CREATE TABLE `DCE_INFO` (
  `ID` varchar(32) NOT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `ACTIVE` char(1) DEFAULT NULL,
  `RES_TIMES` int(11) DEFAULT NULL,
  `REMARK` varchar(50) DEFAULT NULL,
  `GROUP_ID` varchar(500) DEFAULT NULL,
  `ACCOUNT` varchar(50) DEFAULT NULL,
  `WARN_LEVEL` varchar(10) DEFAULT NULL,
  `ORDER_NUM` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `DCE_INFO_HOSTNAME_INDEX` (`HOST_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dce_state
-- ----------------------------
CREATE TABLE `DCE_STATE` (
  `ID` varchar(32) NOT NULL,
  `DCE_ID` varchar(32) DEFAULT NULL,
  `RES_TIMES` int(11) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `DCE_STATE_DCEID_INDEX` (`DCE_ID`,`CREATE_TIME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for desk_io
-- ----------------------------
CREATE TABLE `DESK_IO` (
  `ID` varchar(32) NOT NULL,
  `FILE_STSTEM` varchar(200) DEFAULT NULL,
  `READ_COUNT` varchar(20) DEFAULT NULL,
  `WRITE_OUNT` varchar(20) DEFAULT NULL,
  `READ_BYTES` varchar(20) DEFAULT NULL,
  `WRITE_BYTES` varchar(20) DEFAULT NULL,
  `READ_TIME` varchar(20) DEFAULT NULL,
  `WRITE_TIME` varchar(20) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for DISK_STATE
-- ----------------------------
CREATE TABLE `DISK_STATE` (
  `ID` varchar(32) NOT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `FILE_STSTEM` varchar(200) DEFAULT NULL,
  `DISK_SIZE` varchar(30) DEFAULT NULL,
  `USED` varchar(30) DEFAULT NULL,
  `AVAIL` varchar(30) DEFAULT NULL,
  `USE_PER` varchar(10) DEFAULT NULL,
  `DATE_STR` varchar(30) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for disk_smart
-- ----------------------------
CREATE TABLE `DISK_SMART` (
  `ID` varchar(32) COLLATE utf8_bin NOT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `FILE_STSTEM` varchar(255) DEFAULT NULL,
  `DISK_STATE` varchar(50) DEFAULT NULL,
  `POWER_HOURS` varchar(50) DEFAULT NULL,
  `POWER_COUNT` varchar(50) DEFAULT NULL,
  `TEMPERATURE` varchar(50) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for docker_info
-- ----------------------------
CREATE TABLE `DOCKER_INFO` (
  `ID` varchar(32) NOT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `DOCKER_ID` varchar(200) DEFAULT NULL,
  `DOCKER_NAME` varchar(100) DEFAULT NULL,
  `DOCKER_STATE` varchar(50) DEFAULT NULL,
  `MEM_PER` double(8,0) DEFAULT NULL,
  `STATE` char(1) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `USER_TIME` varchar(20) DEFAULT NULL,
  `ACTIVE` char(1) DEFAULT NULL,
  `APP_TYPE` char(1) DEFAULT NULL,
  `DOCKER_IMAGE` varchar(200) DEFAULT NULL,
  `DOCKER_PORT` varchar(200) DEFAULT NULL,
  `DOCKER_COMMAND` varchar(500) DEFAULT NULL,
  `DOCKER_CREATED` varchar(50) DEFAULT NULL,
  `DOCKER_SIZE` varchar(20) DEFAULT NULL,
  `DOCKER_STATUS` varchar(100) DEFAULT NULL,
  `GATHER_DOCKER_NAMES` varchar(150) DEFAULT NULL,
  `GROUP_ID` varchar(500) DEFAULT NULL,
  `WARN_LEVEL` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for docker_state
-- ----------------------------
CREATE TABLE `DOCKER_STATE` (
  `ID` varchar(32) NOT NULL,
  `DOCKER_INFO_ID` varchar(32) DEFAULT NULL,
  `CPU_PER` double(8,2) DEFAULT NULL,
  `MEM_PER` double(8,0) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `DOCKER_STATE_INDEX` (`DOCKER_INFO_ID`,`CREATE_TIME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for equipment
-- ----------------------------
CREATE TABLE `EQUIPMENT` (
  `ID` varchar(32) NOT NULL,
  `EQ_NAME` varchar(50) DEFAULT NULL,
  `XINGHAO` varchar(50) DEFAULT NULL,
  `PERSON` varchar(50) DEFAULT NULL,
  `DEPT` varchar(50) DEFAULT NULL,
  `CODE` varchar(50) DEFAULT NULL,
  `PRICE` double(10,2) DEFAULT NULL,
  `GONGYINGSHANG` varchar(50) DEFAULT NULL,
  `CAIGOU_DATE` varchar(50) DEFAULT NULL,
  `WEIBAO_DATE` varchar(50) DEFAULT NULL,
  `REMARK` varchar(255) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `ACCOUNT` varchar(50) DEFAULT NULL,
  `GROUP_ID` varchar(500) DEFAULT NULL,
  `FILE_NAME` varchar(50) DEFAULT NULL,
  `FILE_PATH` varchar(150) DEFAULT NULL,
  `FILE_SIZE` varchar(20) DEFAULT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for file_safe
-- ----------------------------
CREATE TABLE `FILE_SAFE` (
  `ID` varchar(32) NOT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `FILE_NAME` varchar(50) DEFAULT NULL,
  `STATE` char(1) DEFAULT NULL,
  `FILE_PATH` varchar(255) DEFAULT NULL,
  `ACTIVE` char(1) DEFAULT NULL,
  `FILE_SIGN` varchar(50) DEFAULT NULL,
  `FILE_MODTIME` varchar(50) DEFAULT NULL,
  `WARN_LEVEL` varchar(10) DEFAULT NULL,
  `GROUP_ID` varchar(500) DEFAULT NULL,
  `FILE_IS_DIR` varchar(10) DEFAULT NULL,
  `CUSTOM_SHELL` varchar(500) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for file_warn
-- ----------------------------
CREATE TABLE `FILE_WARN` (
  `ID` varchar(32) NOT NULL,
  `FILE_PATH` varchar(255) DEFAULT NULL,
  `FILE_SIZE` varchar(32) DEFAULT NULL,
  `WARN_CHARS` varchar(500) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `WARN_ROWS` varchar(20) DEFAULT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `REMARK` varchar(255) DEFAULT NULL,
  `ACTIVE` char(1) DEFAULT NULL,
  `FILE_NAME_PREFIX` varchar(50) DEFAULT NULL,
  `WARN_LEVEL` varchar(10) DEFAULT NULL,
  `FILE_TYPE` varchar(1) DEFAULT NULL,
  `CUSTOM_SHELL` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for file_warn_state
-- ----------------------------
CREATE TABLE `FILE_WARN_STATE` (
  `ID` varchar(32) NOT NULL,
  `WAR_CONTENT` text,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `FILE_WARN_ID` varchar(32) DEFAULT NULL,
  `FILE_PATH` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `FILE_WARN_ID_INDEX` (`FILE_WARN_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for heath_monitor
-- ----------------------------
CREATE TABLE `HEATH_MONITOR` (
  `ID` varchar(32) NOT NULL,
  `APP_NAME` varchar(50) DEFAULT NULL,
  `HEATH_URL` varchar(255) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `HEATH_STATUS` varchar(10) DEFAULT NULL,
  `RES_TIMES` int(11) DEFAULT NULL,
  `ACTIVE` char(1) DEFAULT NULL,
  `RES_KEYWORD` varchar(255) DEFAULT NULL,
  `METHOD` varchar(5) DEFAULT NULL,
  `POST_STR` varchar(2000) DEFAULT NULL,
  `RES_NO_KEYWORD` varchar(255) DEFAULT NULL,
  `HEADER_JSON` varchar(1500) DEFAULT NULL,
  `ACCOUNT` varchar(50) DEFAULT NULL,
  `RESPONSE_BODY_SIZE` varchar(20) DEFAULT NULL,
  `FORM_JSON` varchar(1500) DEFAULT NULL,
  `WARN_LEVEL` varchar(10) DEFAULT NULL,
  `ERROR_MSG` varchar(200) DEFAULT NULL,
  `GROUP_ID` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for heath_state
-- ----------------------------
CREATE TABLE `HEATH_STATE` (
  `ID` varchar(32) NOT NULL,
  `HEATH_ID` varchar(32) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `RES_TIMES` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `HEATH_ID_CREATE_TIME` (`HEATH_ID`,`CREATE_TIME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for host_disk_per
-- ----------------------------
CREATE TABLE `HOST_DISK_PER` (
  `ID` varchar(32) NOT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `DISK_SUM_PER` double DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for host_group
-- ----------------------------
CREATE TABLE `HOST_GROUP` (
  `ID` varchar(32) NOT NULL,
  `GROUP_NAME` varchar(30) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `REMARK` varchar(255) DEFAULT NULL,
  `GROUP_TYPE` varchar(5) DEFAULT NULL,
  `ACCOUNT` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for intrusion_info
-- ----------------------------
CREATE TABLE `INTRUSION_INFO` (
  `ID` char(32) NOT NULL,
  `HOST_NAME` char(30) DEFAULT NULL,
  `LSMOD` text,
  `PASSWD_INFO` varchar(100) DEFAULT NULL,
  `CRONTAB` text,
  `PROMISC` varchar(100) DEFAULT NULL,
  `RPCINFO` text,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for log_info
-- ----------------------------
CREATE TABLE `LOG_INFO` (
  `ID` varchar(32) NOT NULL,
  `HOST_NAME` varchar(200) DEFAULT NULL,
  `INFO_CONTENT` text,
  `STATE` char(1) DEFAULT NULL,
  `CREATE_TIME` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for mail_set
-- ----------------------------
CREATE TABLE `MAIL_SET` (
  `ID` varchar(32)  NOT NULL,
  `SEND_MAIL` varchar(60)  DEFAULT NULL,
  `FROM_MAIL_NAME` varchar(60)  DEFAULT NULL,
  `FROM_PWD` varchar(100)  DEFAULT NULL,
  `SMTP_HOST` varchar(100)  DEFAULT NULL,
  `SMTP_PORT` varchar(30)  DEFAULT NULL,
  `SMTP_SSL` varchar(30)  DEFAULT NULL,
  `TO_MAIL` varchar(300)  DEFAULT NULL,
  `CPU_PER` varchar(30)  DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `ACTIVE` varchar(10)  DEFAULT NULL,
  `JAVAX_MAIL` varchar(10)  DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for mem_state
-- ----------------------------
CREATE TABLE `MEM_STATE` (
  `ID` varchar(32) NOT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `USE_PER` double(8,2) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `MEM_ACC_HOST_INDEX` (`HOST_NAME`,`CREATE_TIME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for netio_state
-- ----------------------------
CREATE TABLE `NETIO_STATE` (
  `ID` varchar(32) NOT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `RXPCK` varchar(15) DEFAULT NULL,
  `TXPCK` varchar(15) DEFAULT NULL,
  `RXBYT` varchar(15) DEFAULT NULL,
  `TXBYT` varchar(15) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `DROPIN` varchar(15) DEFAULT NULL,
  `DROPOUT` varchar(15) DEFAULT NULL,
  `NET_CONNECTIONS` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `NETIO_ACC_HOST_INDEX` (`HOST_NAME`,`CREATE_TIME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for port_info
-- ----------------------------
CREATE TABLE `PORT_INFO` (
  `ID` varchar(32) NOT NULL,
  `PORT` varchar(30) DEFAULT NULL,
  `PORT_NAME` varchar(30) DEFAULT NULL,
  `STATE` char(1) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `ACTIVE` char(1) DEFAULT NULL,
  `TELNET_IP` varchar(300) DEFAULT NULL,
  `GROUP_ID` varchar(500) DEFAULT NULL,
  `WARN_LEVEL` varchar(10) DEFAULT NULL,
  `PORT_TYPE` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `PORT_HOST_NAME_INDEX` (`HOST_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for shell_info
-- ----------------------------
CREATE TABLE `SHELL_INFO` (
  `ID` varchar(32) NOT NULL,
  `SHELL` varchar(2000) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `STATE` char(1) DEFAULT NULL,
  `SHELL_NAME` varchar(100) DEFAULT NULL,
  `SHELL_TYPE` varchar(5) DEFAULT NULL,
  `SHELL_TIME` varchar(20) DEFAULT NULL,
  `SHELL_DAY` varchar(5) DEFAULT NULL,
  `ACCOUNT` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for shell_state
-- ----------------------------
CREATE TABLE `SHELL_STATE` (
  `ID` varchar(32) NOT NULL,
  `SHELL_ID` varchar(32) DEFAULT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `STATE` varchar(50) DEFAULT NULL,
  `SHELL` varchar(2000) DEFAULT NULL,
  `SHELL_TIME` varchar(20) DEFAULT NULL,
  `SHELL_RESULT` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `SHELL_STATE_INDEX2` (`SHELL_ID`) USING BTREE,
  KEY `SHELL_STATE_INDEX1` (`HOST_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for system_info
-- ----------------------------
CREATE TABLE `SYSTEM_INFO` (
  `ID` varchar(32) NOT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `CPU_PER` double(8,2) DEFAULT NULL,
  `MEM_PER` double(8,2) DEFAULT NULL,
  `CPU_CORE_NUM` varchar(10) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `STATE` char(1) DEFAULT NULL,
  `PROCS` varchar(11) DEFAULT NULL,
  `GROUP_ID` varchar(500) DEFAULT NULL,
  `REMARK` varchar(100) DEFAULT NULL,
  `TOTAL_MEM` varchar(50) DEFAULT NULL,
  `RXBYT` varchar(15) DEFAULT NULL,
  `TXBYT` varchar(15) DEFAULT NULL,
  `WIN_CONSOLE` varchar(255) DEFAULT NULL,
  `FIVE_LOAD` double(8,2) DEFAULT NULL,
  `FIFTEEN_LOAD` double(8,2) DEFAULT NULL,
  `NET_CONNECTIONS` varchar(10) DEFAULT NULL,
  `ACCOUNT` varchar(50) DEFAULT NULL,
  `ACTIVE` char(1) DEFAULT NULL,
  `COUNT_BLOCK` char(1) DEFAULT NULL,
  `ORDER_NUM` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sys_load_state
-- ----------------------------
CREATE TABLE `SYS_LOAD_STATE` (
  `ID` varchar(32) NOT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `ONE_LOAD` double(8,2) DEFAULT NULL,
  `FIVE_LOAD` double(8,2) DEFAULT NULL,
  `FIFTEEN_LOAD` double(8,2) DEFAULT NULL,
  `USERS` varchar(10) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `LOAD_ACC_HOST_INDEX` (`HOST_NAME`,`CREATE_TIME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tcp_state
-- ----------------------------
CREATE TABLE `TCP_STATE` (
  `ID` char(32) NOT NULL,
  `HOST_NAME` char(30) DEFAULT NULL,
  `ACTIVE` char(30) DEFAULT NULL,
  `PASSIVE` char(30) DEFAULT NULL,
  `RETRANS` char(30) DEFAULT NULL,
  `DATE_STR` char(30) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `TCP_ACC_HOST_INDEX` (`HOST_NAME`,`CREATE_TIME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `SNMP_INFO` (
  `ID` varchar(32) NOT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `BYTES_RECV` varchar(30) DEFAULT NULL,
  `BYTES_SENT` varchar(30) DEFAULT NULL,
  `RECV_AVG` varchar(2000) DEFAULT NULL,
  `SENT_AVG` varchar(2000) DEFAULT NULL,
  `STATE` char(1) DEFAULT NULL,
  `ACTIVE` char(1) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `SNMP_UNIT` varchar(20) DEFAULT NULL,
  `REMARK` varchar(50) DEFAULT NULL,
  `RECV_OID` varchar(2000) DEFAULT NULL,
  `SENT_OID` varchar(2000) DEFAULT NULL,
  `SNMP_COMMUNITY` varchar(50) DEFAULT NULL,
  `SNMP_PORT` varchar(10) DEFAULT NULL,
  `SNMP_VERSION` varchar(10) DEFAULT NULL,
  `ACCOUNT` varchar(50) DEFAULT NULL,
  `CPU_PER_OID` varchar(300) DEFAULT NULL,
  `MEM_SIZE_OID` varchar(300) DEFAULT NULL,
  `TEMPERATURE_OID` varchar(100) DEFAULT NULL,
  `CPU_PER` varchar(10) DEFAULT NULL,
  `MEM_PER` varchar(10) DEFAULT NULL,
  `DISK_PER_OID` varchar(300) DEFAULT NULL,
  `DISK_PER` varchar(10) DEFAULT NULL,
  `SYS_DESC_VAL` varchar(200) DEFAULT NULL,
  `SYS_DESC_OID` varchar(100) DEFAULT NULL,
  `WARN_LEVEL` varchar(10) DEFAULT NULL,
  `GROUP_ID` varchar(500) DEFAULT NULL,
  `TEMPERATURE_VALUE` varchar(10) DEFAULT NULL,
  `VOLTAGE_OID` varchar(100) DEFAULT NULL,
  `VOLTAGE_VALUE` varchar(10) DEFAULT NULL,
  `IFOPERSTATUS_OID` varchar(100) DEFAULT NULL,
  `IFOPERSTATUS_VALUE` varchar(1500) DEFAULT NULL,
  `VOLTAGE_UNIT` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `SNMP_STATE` (
  `ID` varchar(32) NOT NULL,
  `SNMP_INFO_ID` varchar(32) DEFAULT NULL,
  `RECV_AVG` varchar(20) DEFAULT NULL,
  `SENT_AVG` varchar(20) DEFAULT NULL,
  `CPU_PER` varchar(10) DEFAULT NULL,
  `MEM_PER` varchar(10) DEFAULT NULL,
  `VOLTAGE_VALUE` varchar(10) DEFAULT NULL,
  `TEMPERATURE_VALUE` varchar(10) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `SNMP_ID_CREATE_TIME` (`SNMP_INFO_ID`,`CREATE_TIME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `ACCOUNT_INFO` (
  `ID` varchar(32) NOT NULL,
  `ACCOUNT` varchar(50) DEFAULT NULL,
  `EMAIL` varchar(200) DEFAULT NULL,
  `PASSWD` varchar(50) DEFAULT NULL,
  `ACCOUNT_KEY` varchar(50) DEFAULT NULL,
  `REMARK` varchar(50) DEFAULT NULL,
  `MENU_IDS` varchar(200) DEFAULT NULL,
  `ACCOUNT_ROLE` varchar(10) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for custom_info
-- ----------------------------
CREATE TABLE `CUSTOM_INFO` (
  `ID` varchar(32) NOT NULL,
  `CUSTOM_NAME` varchar(200) DEFAULT NULL,
  `CUSTOM_SHELL` varchar(2000) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `ACTIVE` char(1) DEFAULT NULL,
  `STATE` char(1) DEFAULT NULL,
  `RESULT_EXP` varchar(100) DEFAULT NULL,
  `GROUP_ID` varchar(500) DEFAULT NULL,
  `CUSTOM_VALUE` varchar(50) DEFAULT NULL,
  `WARN_LEVEL` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for custom_state
-- ----------------------------
CREATE TABLE `CUSTOM_STATE` (
  `ID` varchar(32) NOT NULL,
  `CUSTOM_INFO_ID` varchar(32) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `CUSTOM_VALUE` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `CUSTOM_STAT_INDEX` (`CUSTOM_INFO_ID`,`CREATE_TIME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `FTP_INFO` (
  `ID` varchar(32) NOT NULL,
  `FTP_HOST` varchar(100) DEFAULT NULL,
  `USER_NAME` varchar(50) DEFAULT NULL,
  `PASSWD` varchar(100) DEFAULT NULL,
  `PORT` varchar(50) DEFAULT NULL,
  `ACTIVE` char(1) DEFAULT NULL,
  `WARN_TYPE` varchar(10) DEFAULT NULL,
  `STATE` char(1) DEFAULT NULL,
  `FTP_TYPE` varchar(10) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `ACCOUNT` varchar(50) DEFAULT NULL,
  `FTP_NAME` varchar(50) DEFAULT NULL,
  `WARN_LEVEL` varchar(10) DEFAULT NULL,
  `RES_TIMES` int(11) DEFAULT NULL,
  `GROUP_ID` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `REPORT_INFO` (
  `ID` varchar(32) NOT NULL,
  `TIME_PART` varchar(100) DEFAULT NULL,
  `REPORT_TYPE` varchar(1) DEFAULT NULL,
  `GROUP_NAME` varchar(50) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `REPORT_INSTANCE` (
  `ID` varchar(32) NOT NULL,
  `INFO_KEY` varchar(100) DEFAULT NULL,
  `INFO_CONTENT` varchar(200) DEFAULT NULL,
  `REPORT_INFO_ID` varchar(32) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `HOST_USERS` (
  `ID` varchar(32) NOT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `HOST_USER` varchar(50) DEFAULT NULL,
  `LAST_LOGIN_IP` varchar(50) DEFAULT NULL,
  `LAST_LOGIN_TIME` varchar(50) DEFAULT NULL,
  `TERMINAL` varchar(50) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `PASSWD_INFO` (
  `ID` varchar(32) NOT NULL,
  `HOST_NAME` varchar(100) DEFAULT NULL,
  `HOST_ACCOUNT` varchar(50) DEFAULT NULL,
  `HOST_PASSWD` varchar(100) DEFAULT NULL,
  `HOST_REMARK` varchar(300) DEFAULT NULL,
  `ACCOUNT` varchar(50) DEFAULT NULL,
  `GROUP_ID` varchar(500) DEFAULT NULL,
  `HOST_MARK` varchar(100) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `HOST_WARN_DIY`  (
  `ID` varchar(32)  NOT NULL,
  `HOST_NAME` varchar(50)  DEFAULT NULL,
  `MEM_WARN_VAL` double(8, 2)  DEFAULT NULL,
  `CPU_WARN_VAL` double(8, 2)  DEFAULT NULL,
  `UPSPEED_VAL` double(10, 2)  DEFAULT NULL,
  `UPSPEED_MIN_VAL` double(10, 2)  DEFAULT NULL,
  `DOWNSPEED_VAL` double(10, 2)  DEFAULT NULL,
  `DOWNSPEED_MIN_VAL` double(10, 2)  DEFAULT NULL,
  `CPUTEMPERATURE_WARN_VAL` double(8, 2)  DEFAULT NULL,
  `MEM_WARN_MAIL` varchar(10)  DEFAULT NULL,
  `UPSPEED_MAIL` varchar(10)  DEFAULT NULL,
  `DOWNSPEED_MAIL` varchar(10)  DEFAULT NULL,
  `CPU_WARN_MAIL` varchar(10)  DEFAULT NULL,
  `CPUTEMPERATURE_WARN_MAIL` varchar(10)  DEFAULT NULL,
  `DISK_WARN_MAIL` varchar(10)   DEFAULT NULL,
  `SMART_WARN_MAIL` varchar(10)   DEFAULT NULL,
  `DISK_BLOCK` varchar(200)  DEFAULT NULL,
  `DISK_WARN_VAL` double(8,2)  DEFAULT NULL,
  `SYSLOAD_WARN_MAIL` varchar(10)   DEFAULT NULL,
  `SYSLOAD_WARN_VAL` double(8, 2)  DEFAULT NULL,
  `HOST_DOWN_WARN_MAIL` varchar(10)  DEFAULT NULL,
  `HOST_LOGIN_WARN_MAIL` varchar(10)  DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `ACCOUNT` varchar(50) DEFAULT NULL,
  `ACTIVE` varchar(1)  DEFAULT NULL,
  `HOST_BLOCK_ALL_WARN` varchar(10) DEFAULT NULL,
  `REMARK` varchar(255)  DEFAULT NULL,
  `SPEED_WARN_LEVEL` varchar(10)  DEFAULT NULL,
  `MEM_WARN_LEVEL` varchar(10)  DEFAULT NULL,
  `SYSLOAD_WARN_LEVEL` varchar(10)  DEFAULT NULL,
  `CPU_WARN_LEVEL` varchar(10)  DEFAULT NULL,
  `CPUTEMPERATURE_WARN_LEVEL` varchar(10)  DEFAULT NULL,
  `DISK_WARN_LEVEL` varchar(10)  DEFAULT NULL,
  `SMART_WARN_LEVEL` varchar(10)  DEFAULT NULL,
  `HOST_DOWN_WARN_LEVEL` varchar(10)  DEFAULT NULL,
  `HOST_LOGIN_WARN_LEVEL` varchar(10)  DEFAULT NULL,
  `NETCONNECTIONS_WARN_MAIL` varchar(10)  DEFAULT NULL,
  `NETCONNECTIONS_WARN_VAL` double(8, 2)  DEFAULT NULL,
  `NETCONNECTIONS_WARN_LEVEL` varchar(10)  DEFAULT NULL,
  `DISK_BLOCK_SAVE` varchar(200)  DEFAULT NULL,
  `HOST_DOWN_WARN_COUNT` varchar(2)  DEFAULT NULL,
  `CUSTOM_WARN_MAIL` varchar(100)  DEFAULT NULL,
  `CUSTOM_WARN_ACCOUNT_KEY` varchar(100)  DEFAULT NULL,
  `DISKIO_SPEED_WARN_MAIL` varchar(10)  DEFAULT NULL,
  `DISKIO_SPEED_WARN_VAL` double(10,2)  DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE = InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `APP_EXCEPTION_INFO` (
  `ID` varchar(32) NOT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `APP_PID` varchar(200) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `APP_NAME` varchar(100) DEFAULT NULL,
  `CPU_PER` double(8,2) DEFAULT NULL,
  `MEM_PER` double(10,2) DEFAULT NULL,
  `APP_TYPE` char(1) DEFAULT NULL,
  `STATE` char(1) DEFAULT NULL,
  `ACTIVE` char(1) DEFAULT NULL,
  `READ_BYTES` char(20) DEFAULT NULL,
  `WRITES_BYTES` char(20) DEFAULT NULL,
  `THREADS_NUM` varchar(20) DEFAULT NULL,
  `GATHER_PID` varchar(20) DEFAULT NULL,
  `GROUP_ID` varchar(500) DEFAULT NULL,
  `APP_TIMES` varchar(50) DEFAULT NULL,
  `PRO_USERNAME` varchar(100) DEFAULT NULL,
  `CUSTOM_SHELL` varchar(500) DEFAULT NULL,
  `WARN_LEVEL` varchar(10) DEFAULT NULL,
  `NET_CONNECTIONS` varchar(8) DEFAULT NULL,
  `APP_CMD_LINE` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `K8S_MONITOR`  (
  `ID` varchar(32)  NOT NULL,
  `DATA_TYPE` varchar(20) DEFAULT NULL,
  `K8S_NAME` varchar(50) DEFAULT NULL,
  `DATA_JSON` varchar(500) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `SYSTEM_INFO_EXT`  (
  `ID` varchar(32)  NOT NULL,
  `HOST_NAME` varchar(50) NULL DEFAULT NULL,
  `PLATFORM` varchar(200)  NULL DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `CPU_XH` varchar(200)  NULL DEFAULT NULL,
  `BOOT_TIME` bigint(20) NULL DEFAULT NULL,
  `PLATFORM_VERSION` varchar(100) NULL DEFAULT NULL,
  `UPTIME` bigint(20) NULL DEFAULT NULL,
  `SUBMIT_SECONDS` varchar(10) NULL DEFAULT NULL,
  `AGENT_VER` varchar(50) NULL DEFAULT NULL,
  `BYTES_RECV` varchar(20) NULL DEFAULT NULL,
  `BYTES_SENT` varchar(20) NULL DEFAULT NULL,
  `HOST_NAME_EXT` varchar(100) NULL DEFAULT NULL,
  `SWAP_MEM_PER` varchar(20) NULL DEFAULT NULL,
  `TOTAL_SWAP_MEM` varchar(50) NULL DEFAULT NULL,
  `CPU_PHYSICALID` varchar(50) NULL DEFAULT NULL,
  `CPU_FAMILY` varchar(50) NULL DEFAULT NULL,
  `CPU_MHZ` varchar(50) NULL DEFAULT NULL,
  `KERNEL_ARCH` varchar(50) NULL DEFAULT NULL,
  `NET_INTERFACE_NAME` varchar(150) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `SHELL_NOTE_INFO` (
  `ID` varchar(32) NOT NULL,
  `SHELL_TITLE` varchar(100) DEFAULT NULL,
  `SHELL_CONTENT` text,
  `ACCOUNT` varchar(50) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `HOST_MAC_INFO` (
  `ID` varchar(32) NOT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `MAC_NAME` varchar(100) DEFAULT NULL,
  `MAC_ADDRESS` varchar(100) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `KAFKA_MONITOR` (
  `ID` varchar(32)  NOT NULL,
  `KAFKA_NAME` varchar(50)   DEFAULT NULL,
  `GROUP_ID` varchar(100)   DEFAULT NULL,
  `TOPIC_NAME` varchar(100)   DEFAULT NULL,
  `KAFKA_PARTITION` varchar(50)   DEFAULT NULL,
  `KAFKA_OFFSET` varchar(50)   DEFAULT NULL,
  `LAG_COUNT` varchar(50)   DEFAULT NULL,
  `STATE` varchar(1) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `REDIS_MONITOR`  (
  `ID` varchar(32) NOT NULL,
  `REDIS_NAME` varchar(50)  DEFAULT NULL,
  `REDIS_VERSION` varchar(50)  DEFAULT NULL,
  `REDIS_MODE` varchar(50)  DEFAULT NULL,
  `PROCESS_ID` varchar(20)  DEFAULT NULL,
  `TCP_PORT` varchar(10)  DEFAULT NULL,
  `UPTIME_IN_DAYS` varchar(10)  DEFAULT NULL,
  `EXECUTABLE` varchar(100)  DEFAULT NULL,
  `CONFIG_FILE` varchar(100)  DEFAULT NULL,
  `CONNECTED_CLIENTS` varchar(10)  DEFAULT NULL,
  `BLOCKED_CLIENTS` varchar(10)  DEFAULT NULL,
  `USED_MEMORY_HUMAN` varchar(30)  DEFAULT NULL,
  `USED_MEMORY_PEAK_HUMAN` varchar(30)  DEFAULT NULL,
  `MAXMEMORY_HUMAN` varchar(30)  DEFAULT NULL,
  `AOF_ENABLED` varchar(5)  DEFAULT NULL,
  `RDB_LAST_BGSAVE_STATUS` varchar(10)  DEFAULT NULL,
  `RDB_LAST_BGSAVE_TIME_SEC` varchar(20)  DEFAULT NULL,
  `INSTANTANEOUS_OPS_PER_SEC` varchar(20)  DEFAULT NULL,
  `TOTAL_NET_INPUT_BYTES` varchar(50)  DEFAULT NULL,
  `TOTAL_NET_OUTPUT_BYTES` varchar(50)  DEFAULT NULL,
  `REJECTED_CONNECTIONS` varchar(10)  DEFAULT NULL,
  `REDIS_ROLE` varchar(20)  DEFAULT NULL,
  `CONNECTED_SLAVES` varchar(10)  DEFAULT NULL,
  `USED_CPU_SYS` varchar(20)  DEFAULT NULL,
  `EXPIRED_KEYS` varchar(20)  DEFAULT NULL,
  `EVICTED_KEYS` varchar(20)  DEFAULT NULL,
  `KEYSPACE_HITS` varchar(20)  DEFAULT NULL,
  `KEYSPACE_MISSES` varchar(20)  DEFAULT NULL,
  `PUBSUB_CHANNELS` varchar(10)  DEFAULT NULL,
  `PUBSUB_PATTERNS` varchar(10)  DEFAULT NULL,
  `CLUSTER_ENABLED` varchar(10)  DEFAULT NULL,
  `STATE` varchar(1) DEFAULT NULL,
  `REDIS_NODE_INFO` varchar(50) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `DISK_IO_STATE`  (
  `ID` varchar(32)  NOT NULL,
  `READ_IO_AVG` varchar(10)  DEFAULT NULL,
  `WRITE_IO_AVG` varchar(10)  DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `DISK_IO_STATE_INDEX` (`HOST_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `TASK_JOB_INFO`  (
  `ID` varchar(32)  NOT NULL,
  `HOST_NAME` varchar(50)  DEFAULT NULL,
  `JOB_NAME` varchar(50)  DEFAULT NULL,
  `JOB_REMARK` varchar(200)  DEFAULT NULL,
  `CRON_VALUE` varchar(100)  DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  `ACTIVE` varchar(1) DEFAULT NULL,
  `ACCOUNT` varchar(50) DEFAULT NULL,
  `GROUP_ID` varchar(500) DEFAULT NULL,
  `CALL_BACK_TIME` timestamp NULL DEFAULT NULL,
  `CALL_BACK_STATE` varchar(500)  DEFAULT NULL,
  `SHELL` varchar(2000) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `AGENT_RUN_STATE`  (
  `ID` varchar(32)  NOT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `ONLINE_TIME` int(11) DEFAULT NULL,
  `DOWN_TIME` int(11) DEFAULT NULL,
  `LAST_TIME` timestamp NULL DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE = InnoDB CHARACTER SET = utf8;


CREATE TABLE `SNMP_DEEP_INFO`  (
  `ID` varchar(32)  NOT NULL,
  `HOST_NAME` varchar(50) DEFAULT NULL,
  `STATE` varchar(1) DEFAULT NULL,
  `ACTIVE` varchar(1) DEFAULT NULL,
  `REMARK` varchar(100) DEFAULT NULL,
  `SNMP_COMMUNITY` varchar(50) DEFAULT NULL,
  `SNMP_PORT` varchar(10) DEFAULT NULL,
  `SNMP_VERSION` varchar(50) DEFAULT NULL,
  `ACCOUNT` varchar(50) DEFAULT NULL,
  `GROUP_ID` varchar(500) DEFAULT NULL,
  `WARN_LEVEL` varchar(10) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE = InnoDB CHARACTER SET = utf8;

CREATE TABLE `SNMP_DEEP_STATE`  (
  `ID` varchar(32)  NOT NULL,
  `SNMP_DEEP_INFO_ID` varchar(32) DEFAULT NULL,
  `OID_VALUE` varchar(100) DEFAULT NULL,
  `OID_TYPE` varchar(50) DEFAULT NULL,
  `OID_NAME` varchar(100) DEFAULT NULL,
  `OID_ORDER_NUM` int(11) DEFAULT NULL,
  `CREATE_TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE = InnoDB CHARACTER SET = utf8;
