function searchByOrder(orderBy,orderType){
	var urlParams = window.location.search;
	var hrefUrl = SERVER_SERVLET_CONTEXT_PATH + "/snmpDeepInfo/list?orderBy="+orderBy+"&orderType="+orderType;
	if (urlParams.indexOf("groupId") != -1) {
		hrefUrl += "&groupId="+$("#groupId").val();
	}
	window.location.href = hrefUrl;
}

function searchByOnline(state){
	window.location.href = SERVER_SERVLET_CONTEXT_PATH + "/snmpDeepInfo/list?state="+state;
}

function searchByAccount() {
	window.location.href = SERVER_SERVLET_CONTEXT_PATH + "/snmpDeepInfo/list?account="+$("#account").val();
}


function add() {
	window.location.href = SERVER_SERVLET_CONTEXT_PATH + "/snmpDeepInfo/edit";
}

function view(id) {
	window.location.href = SERVER_SERVLET_CONTEXT_PATH + "/snmpDeepInfo/view?id="+id;
}

function viewDate(id,searchTime){
	window.location.href = SERVER_SERVLET_CONTEXT_PATH + "/snmpDeepInfo/view?id="+id+"&am="+searchTime;
}

function excelExport(id,searchTime){
	var startTime = $("#startTime").val();
	var endTime = $("#endTime").val();
	window.open(SERVER_SERVLET_CONTEXT_PATH + "/snmpDeepInfo/chartExcel?id="+id+"&startTime="+startTime+"&endTime="+endTime+"&am="+searchTime);
}

function del(id) {
	if(confirm('Are you sure you want to delete this record?')) {
		window.location.href = SERVER_SERVLET_CONTEXT_PATH + "/snmpDeepInfo/del?id=" + id;
	}
}
function edit(id){
	window.location.href = SERVER_SERVLET_CONTEXT_PATH + "/snmpDeepInfo/edit?id="+id;
}

function showSetGroupId() {
	var chk_value =[];
	$("input[name='todo2']:checkbox").each(function() {
		if($(this).is(':checked')) {
			chk_value.push($(this).val());
		}
	});
	if(chk_value.length == 0){
		alert("Please select the data that needs to be labeled first");
		return;
	}
	$("#id3").val(chk_value.join(","));
	$("#modal-default3").modal("toggle");
}

function ajaxSaveGroupId() {
	$("#form4").ajaxSubmit(function(message) {
		window.location.href = window.location.href;
	});
}

function searchByGroupId() {
	window.location.href = SERVER_SERVLET_CONTEXT_PATH + "/snmpDeepInfo/list?groupId="+$("#groupId").val();
}

function ajaxTestData(numId) {
	var hostname = $("#hostname").val();
	if(""==hostname){
		alert("Please input the device IP address");
		return;
	}
	var snmpPort = $("#snmpPort").val();
	if(""==snmpPort){
		alert("Please input the SNMP port");
		return;
	}
	var snmpVersion = $("input[name='snmpVersion']:checked").val();
	if(""==snmpVersion){
		alert("Please input the SNMP version");
		return;
	}
	var snmpCommunity = $("#snmpCommunity").val();
	if(""==snmpCommunity){
		alert("Please input the SNMP community");
		return;
	}
	var testOid = $("#oidValue"+numId).val();
	if(""==testOid){
		alert("Please input the Oid");
		return;
	}
	var snmpType = $("input[name='oidType"+numId+"']:checked").val();
	if(""==snmpType){
		alert("Please input the oid Type");
		return;
	}
	$('#modal-default').modal('show');
	var testOidName = $("#oidName"+numId).val();
	$("#testOidValue").html(testOidName+"，"+testOid+"，"+snmpType);
	$("#testResultData").html("Getting data ......");
	$.ajax({
		url: SERVER_SERVLET_CONTEXT_PATH + "/snmpInfo/testResultData",
		type: "POST",
		data:{"hostname":hostname,"snmpPort":snmpPort,"snmpVersion":snmpVersion,"snmpCommunity":snmpCommunity,"testOid":testOid,"snmpType":snmpType},
		//dataType: "json",
		success: function(data) {
			$("#testResultData").html(data);
		}
	});
}

function ajaxTestDataView(hostname,snmpPort,snmpVersion,snmpCommunity,oidValue,oidType,testOidName) {
	$('#modal-default').modal('show');
	$("#testOidValue").html(testOidName+"，"+oidValue+"，"+oidType);
	$("#testResultData").html("Getting data ......");
	if("version2c"==snmpVersion){
		snmpVersion="1";
	}
	if("version1"==snmpVersion){
		snmpVersion="0";
	}
	if("version3"==snmpVersion){
		snmpVersion="3";
	}
	$.ajax({
		url: SERVER_SERVLET_CONTEXT_PATH + "/snmpInfo/testResultData",
		type: "POST",
		data:{"hostname":hostname,"snmpPort":snmpPort,"snmpVersion":snmpVersion,"snmpCommunity":snmpCommunity,"testOid":oidValue,"snmpType":oidType},
		//dataType: "json",
		success: function(data) {
			$("#testResultData").html(data);
			toastr.success("Operation completed");
		}
	});
}

function testHeath(id,name) {
	toastr.info("Testing【"+name+"】......");
	$.ajax({
		url: SERVER_SERVLET_CONTEXT_PATH + "/snmpDeepInfo/testHeath?id=" + id,
		//data: {},
		type: "GET",
		//dataType: "json",
		success: function(data) {
			if("success"==data){
				toastr.success("SNMP detection successful, please refresh the page to view the data");
			}else if("noPro"==data){
				toastr.info("Hello, to use this feature, you need to upgrade to the professional version");
			}else{
				toastr.error(data);
			}
		}
	});
}

//数据表单动态添加一行下标，每次添加+1
var dataFromIndex = 1 ;
if($("#dataFromIndex").val() != ""){
	dataFromIndex = parseInt($("#dataFromIndex").val())+1 ;
}
function addDataForm() {
	var dataHideContentHtml = $("#dataHideContent").html();
	dataHideContentHtml = dataHideContentHtml.replace(/{num}/g, dataFromIndex);
	$("#dataFormList").append(dataHideContentHtml);
	$("#dataFromIndex").val(dataFromIndex);
	dataFromIndex += 1;
}

function copySnmpDeepInfo(){
	var chk_value =[];
	$("input[name='todo2']:checkbox").each(function() {
		if($(this).is(':checked')) {
			chk_value.push($(this).val());
		}
	});
	if(chk_value.length == 0){
		alert("Please select the data to be copied first");
		return;
	}
	if(chk_value.length > 1){
		alert("Only one piece of data can be selected");
		return;
	}
	if(confirm('Are you sure you want to copy the selected data?')) {
		var vals = chk_value.join(",");
		$("#idCopy").val(vals);
		$("#modal-defaultCopy").modal("toggle");
	}
}

function ajaxSaveCopySnmpDeepInfo() {
	$("#formCopy").ajaxSubmit(function(message) {
		window.location.href = window.location.href;
	});
}