/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.agentController;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.KafkaMonitor;
import com.wgcloud.service.KafkaMonitorService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.ActivemqUtil;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.IpUtil;
import com.wgcloud.util.MessageErrorUtils;
import com.wgcloud.util.RabbitmqUtil;
import com.wgcloud.util.ResDataUtils;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.TokenUtils;
import com.wgcloud.util.msg.WarnOtherUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/agentKafkaGo"})
public class AgentKafkaGoController {
    private static final Logger logger = LoggerFactory.getLogger(AgentKafkaGoController.class);
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private KafkaMonitorService kafkaMonitorService;
    @Autowired
    private MessageErrorUtils messageErrorUtils;
    @Autowired
    private TokenUtils tokenUtils;
    @Autowired
    private CommonConfig commonConfig;

    @ResponseBody
    @RequestMapping(value={"/minTask"})
    public String minTask(@RequestBody String paramBean, HttpServletRequest request) {
        logger.info("server-backup request Kafka-------" + IpUtil.getIpAddr((HttpServletRequest)request));
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        boolean checkResult = this.tokenUtils.checkAgentToken(agentJsonObject);
        if (!checkResult) {
            logger.error("Token is error");
            return ResDataUtils.resetErrorJson((String)"Token is error");
        }
        logger.debug("server-backup\u76e3\u63a7kafka\u4e0a\u5831\u6578\u64da-------------" + agentJsonObject.toString());
        Date nowtime = new Date();
        try {
            String code = agentJsonObject.getStr((Object)"code");
            String kafkaName = agentJsonObject.getStr((Object)"kafkaName");
            if ("2".equals(code)) {
                this.kafkaMonitorService.downByKafkaName(kafkaName);
                String testErrorMsg = agentJsonObject.getStr((Object)"testErrorMsg");
                if (!StringUtils.isEmpty((CharSequence)testErrorMsg)) {
                    this.messageErrorUtils.setErrorMsgHandler(kafkaName, testErrorMsg);
                }
                Runnable runnable = () -> WarnOtherUtil.sendMiddlewareInfo((String)("Kafka-" + kafkaName), (boolean)true);
                ThreadPoolUtil.executor.execute(runnable);
                return ResDataUtils.resetSuccessJson(null);
            }
            this.kafkaMonitorService.deleteByKafkaName(kafkaName);
            JSONArray dataJsonArr = agentJsonObject.getJSONArray((Object)"data");
            List kafkaMonitorList = JSONUtil.toList((JSONArray)dataJsonArr, KafkaMonitor.class);
            ArrayList<KafkaMonitor> willSaveList = new ArrayList<KafkaMonitor>();
            for (KafkaMonitor kafkaMonitor : kafkaMonitorList) {
                kafkaMonitor.setCreateTime(nowtime);
                kafkaMonitor.setState(code);
                willSaveList.add(kafkaMonitor);
            }
            this.kafkaMonitorService.saveRecord(willSaveList);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790server-backup\u76e3\u63a7kafka\u4e0a\u5831\u6578\u64da\u932f\u8aa4", (Throwable)e);
            return ResDataUtils.resetErrorJson((String)e.toString());
        }
        return ResDataUtils.resetSuccessJson(null);
    }

    @ResponseBody
    @RequestMapping(value={"/minTaskRabbitmq"})
    public String minTaskRabbitmq(@RequestBody String paramBean, HttpServletRequest request) {
        logger.info("server-backup request Rabbitmq-------" + IpUtil.getIpAddr((HttpServletRequest)request));
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        boolean checkResult = this.tokenUtils.checkAgentToken(agentJsonObject);
        if (!checkResult) {
            logger.error("Token is error");
            return ResDataUtils.resetErrorJson((String)"Token is error");
        }
        logger.info("server-backup\u76e3\u63a7Rabbitmq\u4e0a\u5831\u6578\u64da-------------" + agentJsonObject.toString());
        try {
            JSONArray monitorsJsonArr = agentJsonObject.getJSONArray((Object)"data");
            for (Object object : monitorsJsonArr) {
                JSONObject monitorJsonObject = (JSONObject)JSONUtil.parse(object);
                String queueName = monitorJsonObject.getStr((Object)"queueName");
                String name = monitorJsonObject.getStr((Object)"name");
                monitorJsonObject.set("createTime", (Object)DateUtil.getDateTimeString((Date)new Date()));
                RabbitmqUtil.setRabbitmqHandler((String)(name + "_" + queueName), (JSONObject)monitorJsonObject);
                String code = monitorJsonObject.getStr((Object)"code");
                if (!"2".equals(code)) continue;
                Runnable runnable = () -> WarnOtherUtil.sendMiddlewareInfo((String)("RabbitMQ-" + name), (boolean)true);
                ThreadPoolUtil.executor.execute(runnable);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790server-backup\u76e3\u63a7Rabbitmq\u4e0a\u5831\u6578\u64da\u932f\u8aa4", (Throwable)e);
            return ResDataUtils.resetErrorJson((String)e.toString());
        }
        return ResDataUtils.resetSuccessJson(null);
    }

    @ResponseBody
    @RequestMapping(value={"/minTaskActivemq"})
    public String minTaskActivemq(@RequestBody String paramBean, HttpServletRequest request) {
        logger.info("server-backup request Activemq-------" + IpUtil.getIpAddr((HttpServletRequest)request));
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        boolean checkResult = this.tokenUtils.checkAgentToken(agentJsonObject);
        if (!checkResult) {
            logger.error("Token is error");
            return ResDataUtils.resetErrorJson((String)"Token is error");
        }
        logger.info("server-backup\u76e3\u63a7Activemq\u4e0a\u5831\u6578\u64da-------------" + agentJsonObject.toString());
        try {
            JSONArray monitorsJsonArr = agentJsonObject.getJSONArray((Object)"data");
            for (Object object : monitorsJsonArr) {
                JSONObject monitorJsonObject = (JSONObject)JSONUtil.parse(object);
                String queueName = monitorJsonObject.getStr((Object)"queueName");
                String name = monitorJsonObject.getStr((Object)"name");
                monitorJsonObject.set("createTime", (Object)DateUtil.getDateTimeString((Date)new Date()));
                ActivemqUtil.setActivemqHandler((String)(name + "_" + queueName), (JSONObject)monitorJsonObject);
                String code = monitorJsonObject.getStr((Object)"code");
                if (!"2".equals(code)) continue;
                Runnable runnable = () -> WarnOtherUtil.sendMiddlewareInfo((String)("ActiveMQ-" + name), (boolean)true);
                ThreadPoolUtil.executor.execute(runnable);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790server-backup\u76e3\u63a7Activemq\u4e0a\u5831\u6578\u64da\u932f\u8aa4", (Throwable)e);
            return ResDataUtils.resetErrorJson((String)e.toString());
        }
        return ResDataUtils.resetSuccessJson(null);
    }
}

