/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.common;

import com.wgcloud.common.NettyServer;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.util.MD5Utils;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.UUIDUtil;
import com.wgcloud.util.msg.WarnPools;
import com.wgcloud.util.staticvar.StaticKeys;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ApplicationStartListener
implements ApplicationRunner {
    private Logger logger = LoggerFactory.getLogger(ApplicationStartListener.class);
    @Autowired
    CommonConfig commonConfig;
    @Autowired
    private ServletContext servletContext;
    @Autowired
    private Environment env;

    public void run(ApplicationArguments args) throws Exception {
        this.servletContext.setAttribute("hostGroup", (Object)this.commonConfig.getHostGroup());
        this.servletContext.setAttribute("userInfoManage", (Object)this.commonConfig.getUserInfoManage());
        this.servletContext.setAttribute("showWarnCount", (Object)this.commonConfig.getShowWarnCount());
        this.servletContext.setAttribute("shellToRun", (Object)this.commonConfig.getShellToRun());
        this.servletContext.setAttribute("SESSION_VERCODE", (Object)this.commonConfig.getVercodeCheck());
        StaticKeys.PAGE_SIZE = this.commonConfig.getPageSize();
        ApplicationHome h = new ApplicationHome(this.getClass());
        String jarPath = h.getSource().getParentFile().toString();
        this.logger.debug("jar\u5305\u8def\u5f91-----------------" + jarPath);
        StaticKeys.JAR_PATH = jarPath;
        WarnPools.checkWarnCacheTimes((String)"TEST", (Integer)this.commonConfig.getWarnCacheTimes());
        WarnPools.initWarnCountMap();
        if ("master".equals(this.commonConfig.getNodeType())) {
            this.servletContext.setAttribute("serverInfoId", (Object)UUIDUtil.getUUID());
        } else {
            this.servletContext.setAttribute("serverInfoId", (Object)this.commonConfig.getNodeType());
        }
        if (null != this.commonConfig.getMaxPoolSize()) {
            ThreadPoolUtil.executor.setMaximumPoolSize(this.commonConfig.getMaxPoolSize());
        }
        StaticKeys.SERVER_WGTOKEN_MD5STR = MD5Utils.GetMD5Code((String)this.commonConfig.getWgToken());
        String serverServletContextPath = this.env.getProperty("server.servlet.context-path");
        if (!StringUtils.isEmpty((CharSequence)serverServletContextPath) && !"/".equals(serverServletContextPath)) {
            StaticKeys.SERVER_SERVLET_CONTEXT_PATH = serverServletContextPath;
            this.servletContext.setAttribute("SERVER_SERVLET_CONTEXT_PATH", (Object)StaticKeys.SERVER_SERVLET_CONTEXT_PATH);
            this.logger.info("server.servlet.context-path--------------" + serverServletContextPath);
        } else {
            this.servletContext.setAttribute("SERVER_SERVLET_CONTEXT_PATH", (Object)"");
        }
        try {
            this.servletContext.setAttribute("webSsh", (Object)this.commonConfig.getWebSsh());
            if ("true".equals(this.commonConfig.getWebSsh())) {
                this.logger.info("NettyServer\u670d\u52d9\u555f\u52d5\uff0c\u7aef\u53e3\uff1a" + this.commonConfig.getWebSshPort());
                NettyServer.start((int)this.commonConfig.getWebSshPort());
            }
        }
        catch (Exception e) {
            this.logger.error("NettyServer\u670d\u52d9\u555f\u52d5\u932f\u8aa4\uff1a", (Throwable)e);
        }
    }
}

