/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.github.pagehelper.PageInfo;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.dto.ShellCheckDto;
import com.wgcloud.entity.FileWarnInfo;
import com.wgcloud.entity.FileWarnState;
import com.wgcloud.entity.SystemInfo;
import com.wgcloud.service.ExcelExportService;
import com.wgcloud.service.FileWarnInfoService;
import com.wgcloud.service.FileWarnStateService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.ShellInfoService;
import com.wgcloud.service.SystemInfoService;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.MessageErrorUtils;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.ResDataUtils;
import com.wgcloud.util.TokenUtils;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/fileWarnInfo"})
public class FileWarnInfoController {
    private static final Logger logger = LoggerFactory.getLogger(FileWarnInfoController.class);
    @Resource
    private FileWarnInfoService fileWarnInfoService;
    @Resource
    private FileWarnStateService fileWarnStateService;
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private SystemInfoService systemInfoService;
    @Resource
    private ExcelExportService excelExportService;
    @Resource
    private ShellInfoService shellInfoService;
    @Autowired
    private TokenUtils tokenUtils;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private MessageErrorUtils messageErrorUtils;

    @ResponseBody
    @RequestMapping(value={"agentList"})
    public String agentList(@RequestBody String paramBean) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        if (!this.tokenUtils.checkAgentToken(agentJsonObject)) {
            logger.error("Token is error");
            return ResDataUtils.resetErrorJson((String)"Token is error");
        }
        if (!this.tokenUtils.checkAllowOpenData(agentJsonObject)) {
            logger.error("The module needs to professional version. Please contact us at www.wgstart.com");
            return ResDataUtils.resetErrorJson((String)"The module needs to professional version. Please contact us at www.wgstart.com");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (null == agentJsonObject.get((Object)"hostname") || StringUtils.isEmpty((CharSequence)agentJsonObject.get((Object)"hostname").toString())) {
            return "";
        }
        params.put("hostname", agentJsonObject.get((Object)"hostname").toString());
        try {
            params.put("active", "1");
            List fileWarnInfoList = this.fileWarnInfoService.selectAllByParams(params);
            ShellCheckDto shellCheckDto = this.shellInfoService.getShellCheckDto(agentJsonObject.get((Object)"hostname").toString());
            String cmdSplitChar = shellCheckDto.getCmdSplitChar();
            String blockKey = "";
            ArrayList<FileWarnInfo> fileWarnListResult = new ArrayList<FileWarnInfo>();
            for (FileWarnInfo fileWarnInfo : fileWarnInfoList) {
                if (StringUtils.isEmpty((CharSequence)fileWarnInfo.getCustomShell())) {
                    fileWarnInfo.setCustomShell("");
                }
                if (!StringUtils.isEmpty((CharSequence)(blockKey = FormatUtil.haveBlockDanger((String)fileWarnInfo.getCustomShell(), (String)this.commonConfig.getShellToRunBlock())))) {
                    logger.error(fileWarnInfo.getCustomShell() + "\u65e5\u8a8c\u76e3\u63a7\u8655\u7406\u6307\u4ee4\u542b\u6709\u654f\u611f\u5b57\u7b26" + blockKey + "\uff0c\u4e0d\u9032\u884c\u4e0b\u767c");
                    continue;
                }
                fileWarnInfo.setCustomShell(fileWarnInfo.getCustomShell().replaceAll("\\r\\n", cmdSplitChar));
                fileWarnListResult.add(fileWarnInfo);
            }
            return ResDataUtils.resetSuccessJson(fileWarnListResult);
        }
        catch (Exception e) {
            logger.error("agent\u7372\u53d6\u65e5\u8a8c\u76e3\u63a7\u4fe1\u606f\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("agent\u7372\u53d6\u65e5\u8a8c\u76e3\u63a7\u4fe1\u606f\u932f\u8aa4", e.toString(), "2");
            return ResDataUtils.resetErrorJson((String)e.toString());
        }
    }

    @ResponseBody
    @RequestMapping(value={"agentStateListList"})
    public String agentStateListList(@RequestBody String paramBean) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        String checkResult = this.tokenUtils.preOpenDataAPICheck(agentJsonObject);
        if (!StringUtils.isEmpty((CharSequence)checkResult)) {
            return checkResult;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (null == agentJsonObject.get((Object)"fileWarnId") || StringUtils.isEmpty((CharSequence)agentJsonObject.get((Object)"fileWarnId").toString())) {
            return ResDataUtils.resetErrorJson((String)"Missing require parameters");
        }
        params.put("fileWarnId", agentJsonObject.get((Object)"fileWarnId").toString());
        try {
            PageInfo pageInfo = this.fileWarnStateService.selectByParams(params, agentJsonObject.getInt((Object)"page").intValue(), agentJsonObject.getInt((Object)"pageSize").intValue());
            JSONObject pageJson = new JSONObject();
            pageJson.set("total", (Object)pageInfo.getTotal());
            pageJson.set("pages", (Object)pageInfo.getPages());
            pageJson.set("page", (Object)agentJsonObject.getInt((Object)"page"));
            pageJson.set("pageSize", (Object)agentJsonObject.getInt((Object)"pageSize"));
            pageJson.set("list", (Object)pageInfo.getList());
            return ResDataUtils.resetSuccessJson((Object)pageJson);
        }
        catch (Exception e) {
            logger.error("agent\u7372\u53d6\u65e5\u8a8c\u76e3\u63a7\u72c0\u614b\u4fe1\u606f\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("agent\u7372\u53d6\u65e5\u8a8c\u76e3\u63a7\u72c0\u614b\u4fe1\u606f\u932f\u8aa4", e.toString(), "2");
            return ResDataUtils.resetErrorJson((String)e.toString());
        }
    }

    @RequestMapping(value={"list"})
    public String fileWarnInfoList(FileWarnInfo fileWarnInfo, Model model, HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            LicenseUtil.maxLicense_10((Model)model, (HttpServletRequest)request, (Object)fileWarnInfo);
            StringBuffer url = new StringBuffer();
            String hostname = null;
            if (!StringUtils.isEmpty((CharSequence)fileWarnInfo.getHostname())) {
                hostname = fileWarnInfo.getHostname();
                params.put("hostname", hostname.trim());
                url.append("&hostname=").append(hostname);
            }
            if (!StringUtils.isEmpty((CharSequence)fileWarnInfo.getAccount())) {
                params.put("account", fileWarnInfo.getAccount());
                url.append("&account=").append(fileWarnInfo.getAccount());
            }
            if (!StringUtils.isEmpty((CharSequence)fileWarnInfo.getActive())) {
                params.put("active", fileWarnInfo.getActive());
                url.append("&active=").append(fileWarnInfo.getActive());
            }
            if (!StringUtils.isEmpty((CharSequence)fileWarnInfo.getOrderBy())) {
                params.put("orderBy", fileWarnInfo.getOrderBy());
                params.put("orderType", fileWarnInfo.getOrderType());
                url.append("&orderBy=").append(fileWarnInfo.getOrderBy());
                url.append("&orderType=").append(fileWarnInfo.getOrderType());
            }
            HostUtil.addAccountquery((HttpServletRequest)request, params);
            PageInfo pageInfo = this.fileWarnInfoService.selectByParams(params, fileWarnInfo.getPage().intValue(), fileWarnInfo.getPageSize().intValue());
            for (FileWarnInfo fileWarnInfo1 : pageInfo.getList()) {
                if ("true".equals(this.commonConfig.getUserInfoManage())) {
                    fileWarnInfo1.setAccount(HostUtil.getAccount((String)fileWarnInfo1.getHostname()));
                }
                fileWarnInfo1.setHostname(fileWarnInfo1.getHostname() + HostUtil.addRemark((String)fileWarnInfo1.getHostname()));
                if (StringUtils.isEmpty((CharSequence)fileWarnInfo1.getFileSize())) continue;
                String fileFormatSize = FormatUtil.bytesFormatUnit((String)fileWarnInfo1.getFileSize(), (String)"byte");
                fileWarnInfo1.setFileSize(fileFormatSize);
            }
            HostUtil.addAccountListModel((Model)model);
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            model.addAttribute("pageUrl", (Object)("/fileWarnInfo/list?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("fileWarnInfo", (Object)fileWarnInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8a62\u65e5\u8a8c\u76e3\u63a7\u4fe1\u606f\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("\u67e5\u8a62\u65e5\u8a8c\u76e3\u63a7\u4fe1\u606f\u932f\u8aa4", e.toString(), "2");
        }
        return "file/list";
    }

    @RequestMapping(value={"save"})
    public String saveFileWarnInfo(FileWarnInfo fileWarnInfo, Model model, HttpServletRequest request) {
        try {
            String blockKey = FormatUtil.haveBlockDanger((String)fileWarnInfo.getCustomShell(), (String)this.commonConfig.getShellToRunBlock());
            if (!StringUtils.isEmpty((CharSequence)blockKey)) {
                model.addAttribute("fileWarnInfo", (Object)fileWarnInfo);
                model.addAttribute("msg", (Object)("\u81ea\u52d5\u8655\u7406\u6307\u4ee4\u542b\u6709\u654f\u611f\u5b57\u7b26" + blockKey + "\uff0c\u8acb\u6aa2\u67e5"));
                this.shellInfoService.getBlockStr(model);
                HashMap params = new HashMap();
                HostUtil.addAccountquery((HttpServletRequest)request, params);
                List systemInfoList = this.systemInfoService.selectAllByParams(params);
                model.addAttribute("systemInfoList", (Object)systemInfoList);
                return "file/add";
            }
            if (StringUtils.isEmpty((CharSequence)fileWarnInfo.getId())) {
                fileWarnInfo.setWarnRows("0");
                fileWarnInfo.setFileSize("0");
                this.fileWarnInfoService.save(fileWarnInfo);
                this.fileWarnInfoService.saveLog(request, "\u6dfb\u52a0", fileWarnInfo);
            } else {
                this.fileWarnInfoService.updateById(fileWarnInfo);
                this.fileWarnInfoService.saveLog(request, "\u4fee\u6539", fileWarnInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u65e5\u8a8c\u76e3\u63a7\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58\u65e5\u8a8c\u76e3\u63a7\u932f\u8aa4", e.toString(), "2");
        }
        return "redirect:/fileWarnInfo/list";
    }

    @RequestMapping(value={"saveBatch"})
    public String saveBatchFileWarnInfo(FileWarnInfo fileWarnInfo, Model model, HttpServletRequest request) {
        try {
            String[] hostnames = request.getParameterValues("hostnames");
            if (null == hostnames || hostnames.length < 1) {
                return "redirect:/fileWarnInfo/list";
            }
            String blockKey = FormatUtil.haveBlockDanger((String)fileWarnInfo.getCustomShell(), (String)this.commonConfig.getShellToRunBlock());
            if (!StringUtils.isEmpty((CharSequence)blockKey)) {
                model.addAttribute("fileWarnInfo", (Object)fileWarnInfo);
                model.addAttribute("selectedHosts", (Object)hostnames);
                List systemInfoList = this.systemInfoService.selectAllByParams(new HashMap());
                for (SystemInfo systemInfo : systemInfoList) {
                    for (String selectedHost : hostnames) {
                        if (!selectedHost.equals(systemInfo.getHostname())) continue;
                        systemInfo.setSelected("selected");
                    }
                }
                model.addAttribute("systemInfoList", (Object)systemInfoList);
                model.addAttribute("msg", (Object)("\u81ea\u52d5\u8655\u7406\u6307\u4ee4\u542b\u6709\u654f\u611f\u5b57\u7b26" + blockKey + "\uff0c\u8acb\u6aa2\u67e5"));
                this.shellInfoService.getBlockStr(model);
                return "file/addBatch";
            }
            for (String selectedHost : hostnames) {
                fileWarnInfo.setHostname(selectedHost);
                fileWarnInfo.setWarnRows("0");
                fileWarnInfo.setFileSize("0");
                this.fileWarnInfoService.save(fileWarnInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u4fdd\u5b58\u65e5\u8a8c\u76e3\u63a7\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("\u6279\u91cf\u4fdd\u5b58\u65e5\u8a8c\u76e3\u63a7\u932f\u8aa4", e.toString(), "2");
        }
        return "redirect:/fileWarnInfo/list";
    }

    @RequestMapping(value={"edit"})
    public String edit(Model model, HttpServletRequest request) {
        String errorMsg = "\u6dfb\u52a0\u65e5\u8a8c\u76e3\u63a7";
        String id = request.getParameter("id");
        FileWarnInfo fileWarnInfo = new FileWarnInfo();
        try {
            this.shellInfoService.getBlockStr(model);
            HashMap paramsAccount = new HashMap();
            HostUtil.addAccountquery((HttpServletRequest)request, paramsAccount);
            List systemInfoList = this.systemInfoService.selectAllByParams(paramsAccount);
            model.addAttribute("systemInfoList", (Object)systemInfoList);
            if (StringUtils.isEmpty((CharSequence)id)) {
                fileWarnInfo.setFileType("1");
                model.addAttribute("fileWarnInfo", (Object)fileWarnInfo);
                if (!this.isAddContinue()) {
                    return "redirect:/fileWarnInfo/list?liceFlage=1";
                }
                return "file/add";
            }
            fileWarnInfo = this.fileWarnInfoService.selectById(id);
            model.addAttribute("fileWarnInfo", (Object)fileWarnInfo);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "file/add";
    }

    @RequestMapping(value={"updateActive"})
    public String updateActive(Model model, HttpServletRequest request) {
        String errorMsg = "\u6279\u91cf\u958b\u59cb\u76e3\u63a7\u548c\u505c\u6b62\u76e3\u63a7\u932f\u8aa4";
        try {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                String[] ids = request.getParameter("id").split(",");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("ids", ids);
                String activeValue = request.getParameter("active");
                params.put("active", activeValue);
                this.fileWarnInfoService.updateActive(params);
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "redirect:/fileWarnInfo/list";
    }

    @RequestMapping(value={"editBatch"})
    public String editBatch(Model model, HttpServletRequest request) {
        String errorMsg = "\u6279\u91cf\u6dfb\u52a0\u65e5\u8a8c\u76e3\u63a7";
        FileWarnInfo fileWarnInfo = new FileWarnInfo();
        try {
            if (!StaticKeys.LICENSE_STATE.equals("1")) {
                return "redirect:/fileWarnInfo/list?liceFlage=2";
            }
            this.shellInfoService.getBlockStr(model);
            List systemInfoList = this.systemInfoService.selectAllByParams(new HashMap());
            model.addAttribute("systemInfoList", (Object)systemInfoList);
            fileWarnInfo.setFileType("1");
            model.addAttribute("fileWarnInfo", (Object)fileWarnInfo);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "file/addBatch";
    }

    @RequestMapping(value={"view"})
    public String view(Model model, HttpServletRequest request) {
        String errorMsg = "\u67e5\u770b\u65e5\u8a8c\u76e3\u63a7";
        String id = request.getParameter("id");
        FileWarnInfo fileWarnInfo = new FileWarnInfo();
        try {
            fileWarnInfo = this.fileWarnInfoService.selectById(id);
            fileWarnInfo.setHostname(fileWarnInfo.getHostname() + HostUtil.addRemark((String)fileWarnInfo.getHostname()));
            model.addAttribute("fileWarnInfo", (Object)fileWarnInfo);
            model.addAttribute("fileWarnErrorMsg", (Object)this.messageErrorUtils.viewErrorMsgHandler(id));
            this.messageErrorUtils.getCallBackMsgForShell(model, id, fileWarnInfo.getCustomShell());
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "file/view";
    }

    @RequestMapping(value={"stateList"})
    public String stateList(FileWarnState fileWarnState, Model model, HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            StringBuffer url = new StringBuffer();
            FileWarnInfo fileWarnInfo = null;
            if (!StringUtils.isEmpty((CharSequence)fileWarnState.getFileWarnId())) {
                fileWarnInfo = this.fileWarnInfoService.selectById(fileWarnState.getFileWarnId());
                params.put("fileWarnId", fileWarnState.getFileWarnId());
                url.append("&fileWarnId=").append(fileWarnState.getFileWarnId());
            }
            PageInfo pageInfo = this.fileWarnStateService.selectByParams(params, fileWarnState.getPage().intValue(), fileWarnState.getPageSize().intValue());
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            model.addAttribute("pageUrl", (Object)("/fileWarnInfo/stateList?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            fileWarnInfo.setHostname(fileWarnInfo.getHostname() + HostUtil.addRemark((String)fileWarnInfo.getHostname()));
            model.addAttribute("fileWarnInfo", (Object)fileWarnInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8a62\u65e5\u8a8c\u76e3\u63a7\u4fe1\u606f\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("\u67e5\u8a62\u65e5\u8a8c\u76e3\u63a7\u4fe1\u606f\u932f\u8aa4", e.toString(), "2");
        }
        return "file/stateList";
    }

    @RequestMapping(value={"chartExcel"})
    public void chartExcel(Model model, HttpServletRequest request, HttpServletResponse response) {
        String errorMsg = "\u65e5\u8a8c\u76e3\u63a7\u4fe1\u606f\u5c0e\u51faexcel\u932f\u8aa4";
        String id = request.getParameter("id");
        try {
            if (!StaticKeys.LICENSE_STATE.equals("1")) {
                response.setContentType("text/html;charset=UTF-8");
                response.getOutputStream().write("The module needs to professional version. Please contact us at www.wgstart.com".getBytes());
                return;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            if (StringUtils.isEmpty((CharSequence)id)) {
                response.setContentType("text/html;charset=UTF-8");
                response.getOutputStream().write("Missing require parameters".getBytes());
                return;
            }
            FileWarnInfo fileWarnInfo = this.fileWarnInfoService.selectById(id);
            params.put("fileWarnId", id);
            this.excelExportService.exportFileWarnStateExcel(fileWarnInfo, params, response);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
    }

    @RequestMapping(value={"stateView"})
    public String stateView(FileWarnState fileWarnState, Model model, HttpServletRequest request) {
        HashMap params = new HashMap();
        try {
            fileWarnState = this.fileWarnStateService.selectById(fileWarnState.getId());
            model.addAttribute("fileWarnState", (Object)fileWarnState);
            FileWarnInfo fileWarnInfo = this.fileWarnInfoService.selectById(fileWarnState.getFileWarnId());
            fileWarnInfo.setHostname(fileWarnInfo.getHostname() + HostUtil.addRemark((String)fileWarnInfo.getHostname()));
            model.addAttribute("fileWarnInfo", (Object)fileWarnInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8a62\u65e5\u8a8c\u76e3\u63a7\u4fe1\u606f\u8a73\u60c5\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("\u67e5\u8a62\u65e5\u8a8c\u76e3\u63a7\u4fe1\u606f\u8a73\u60c5\u932f\u8aa4", e.toString(), "2");
        }
        return "file/stateView";
    }

    @RequestMapping(value={"del"})
    public String delete(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        String errorMsg = "\u522a\u9664\u65e5\u8a8c\u76e3\u63a7\u4fe1\u606f\u932f\u8aa4";
        FileWarnInfo FileWarnInfo2 = new FileWarnInfo();
        try {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                String[] ids;
                for (String id : ids = request.getParameter("id").split(",")) {
                    FileWarnInfo2 = this.fileWarnInfoService.selectById(id);
                    this.logInfoService.save("\u522a\u9664\u65e5\u8a8c\u76e3\u63a7\uff1a" + FileWarnInfo2.getHostname(), "\u522a\u9664\u65e5\u8a8c\u76e3\u63a7\uff1a" + FileWarnInfo2.getHostname(), "2");
                }
                this.fileWarnInfoService.deleteById(ids);
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "redirect:/fileWarnInfo/list";
    }

    private boolean isAddContinue() {
        try {
            HashMap params;
            int dbSize;
            if (!StaticKeys.LICENSE_STATE.equals("1") && (dbSize = this.fileWarnInfoService.countByParams(params = new HashMap()).intValue()) >= 10) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error("isAddContinue error", (Throwable)e);
        }
        return true;
    }
}

