/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.FileUtils;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.TokenUtils;
import com.wgcloud.util.msg.WarnPools;
import com.wgcloud.util.staticvar.StaticKeys;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/nginxMonitor"})
public class NginxMonitorController {
    private static final Logger logger = LoggerFactory.getLogger(NginxMonitorController.class);
    @Resource
    private LogInfoService logInfoService;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private TokenUtils tokenUtils;
    private static final String sqlChars = "xp_cmdshell,%20xor,%20and,%20AND,%20or,%20OR,select%20,%20and%201=1,%20and%201=2,%20from,%27exec,information_schema.tables,load_file,benchmark,substring,table_name,table_schema,%20where%20,%20union%20,%20UNION%20,concat(,concat_ws(,%20group%20,0x5f,0x7e,0x7c,0x27,%20limit,current_user,%20LIMIT,version%28,version(,database%28,database(,user%28,user(,%20extractvalue,%updatexml,rand(0)*2,%20group%20by%20x,%20NULL%2C,sqlmap";
    private static final String scanChars = "acunetix,by_wvs,nikto,netsparker,HP404,nsfocus,WebCruiser,owasp,nmap,nessus,HEAD /,AppScan,burpsuite,w3af,ZAP,openVAS,.+avij,.+angolin,360webscan,webscan,XSS@HERE,XSS%40HERE,NOSEC.JSky,wwwscan,wscan,antSword,WebVulnScan,WebInspect,ltx71,masscan,python-requests,Python-urllib,WinHttpRequest";
    String spider = "spider,pider,Googlebot";

    @RequestMapping(value={"toAddView"})
    public String toAddView(Model model, HttpServletRequest request) {
        model.addAttribute("NGINX_CHECK_DAY_COUNT", (Object)WarnPools.NGINX_CHECK_DAY_COUNT);
        return "nginx/add";
    }

    @RequestMapping(value={"/uploadLog"})
    public String singleFileUpload(@RequestParam(value="file") MultipartFile file, Model model, HttpServletRequest request) {
        AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
        if ("guest".equals(accountInfo.getRole())) {
            return "redirect:/common/error/guestError";
        }
        model.addAttribute("NGINX_CHECK_DAY_COUNT", (Object)WarnPools.NGINX_CHECK_DAY_COUNT);
        if (!StaticKeys.LICENSE_STATE.equals("1") && WarnPools.NGINX_CHECK_DAY_COUNT > 0) {
            model.addAttribute("msg", (Object)"\u500b\u4eba\u7248\u6bcf\u5929\u53ea\u80fd\u6aa2\u6e2c1\u6b21\uff0c\u8acb\u806f\u7e6b\u6211\u5011\u5347\u7d1a\u70ba\u5c08\u696d\u7248");
            return "nginx/add";
        }
        if (StaticKeys.LICENSE_STATE.equals("1") && WarnPools.NGINX_CHECK_DAY_COUNT > StaticKeys.LICENSE_NUM) {
            model.addAttribute("msg", (Object)("\u8a72\u5c08\u696d\u7248\u6388\u6b0a\u6bcf\u5929\u6700\u591a\u6aa2\u6e2c" + StaticKeys.LICENSE_NUM + "\u6b21\uff0c\u8acb\u806f\u7e6b\u6211\u5011\u5347\u7d1a\u6388\u6b0a"));
            return "nginx/add";
        }
        if (file.isEmpty()) {
            logger.error("\u6587\u4ef6\u70ba\u7a7a,\u8acb\u9078\u64c7Nginx Log\u6587\u4ef6\u4e0a\u50b3");
            model.addAttribute("msg", (Object)"\u6587\u4ef6\u70ba\u7a7a,\u8acb\u9078\u64c7\u4f60\u7684\u6587\u4ef6\u4e0a\u50b3");
            return "nginx/add";
        }
        if (!file.getOriginalFilename().endsWith(".log")) {
            logger.error("\u8acb\u4e0a\u50b3.log\u6587\u4ef6");
            model.addAttribute("msg", (Object)"\u8acb\u4e0a\u50b3Nginx\u7684.log\u6587\u4ef6");
            return "nginx/add";
        }
        String sourceFileName = file.getOriginalFilename();
        model.addAttribute("accessLogName", (Object)sourceFileName);
        String saveFolder = StaticKeys.JAR_PATH + "/nginxLog";
        FileUtils.existsFolder((String)saveFolder);
        String newFileName = saveFolder + "/" + DateUtil.getCurrentDateTimeNoChar() + ".log";
        Path path = Paths.get(newFileName, new String[0]);
        try {
            file.transferTo(path);
            this.checkNgingLog(newFileName, model);
            this.logInfoService.save(HostUtil.getAccountByRequest((HttpServletRequest)request).getAccount() + "\u4e0a\u50b3\u4e26\u6aa2\u6e2cNingx\u65e5\u8a8c\u6587\u4ef6: " + sourceFileName, newFileName, "2");
            WarnPools.NGINX_CHECK_DAY_COUNT = WarnPools.NGINX_CHECK_DAY_COUNT + 1;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u50b3nginx\u65e5\u8a8c\u6587\u4ef6\u932f\u8aa4", (Throwable)e);
            model.addAttribute("msg", (Object)e.toString());
        }
        return "nginx/view";
    }

    private void checkNgingLog(String fileName, Model model) {
        try {
            File file = new File(fileName);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String[] sqlCharArr = sqlChars.split(",");
            String[] scanCharArr = scanChars.split(",");
            String[] spiderCharArr = this.spider.split(",");
            String resultContent = "";
            String strLine = null;
            int code404 = 0;
            int code408 = 0;
            int code413 = 0;
            int code414 = 0;
            int code400 = 0;
            int code401 = 0;
            int code403 = 0;
            int code301 = 0;
            int code500 = 0;
            int code502 = 0;
            int code503 = 0;
            int sqlCount = 0;
            int scanCount = 0;
            int spiderCount = 0;
            HashSet<String> setIp = new HashSet<String>();
            HashMap<String, Integer> ipCountMap = new HashMap<String, Integer>();
            block2: while (null != (strLine = bufferedReader.readLine())) {
                if (StringUtils.isEmpty((CharSequence)strLine)) continue;
                String ip = strLine.substring(0, strLine.indexOf("-"));
                setIp.add(ip.trim());
                if (ipCountMap.get(ip) == null) {
                    ipCountMap.put(ip, 1);
                } else {
                    ipCountMap.put(ip, (Integer)ipCountMap.get(ip) + 1);
                }
                if (strLine.contains(" 400 ")) {
                    ++code400;
                }
                if (strLine.contains(" 401 ")) {
                    ++code401;
                }
                if (strLine.contains(" 403 ")) {
                    ++code403;
                }
                if (strLine.contains(" 404 ")) {
                    ++code404;
                }
                if (strLine.contains(" 408 ")) {
                    ++code408;
                }
                if (strLine.contains(" 413 ")) {
                    ++code413;
                }
                if (strLine.contains(" 414 ")) {
                    ++code414;
                }
                if (strLine.contains(" 301 ")) {
                    ++code301;
                }
                if (strLine.contains(" 500 ")) {
                    ++code500;
                }
                if (strLine.contains(" 502 ")) {
                    ++code502;
                }
                if (strLine.contains(" 503 ")) {
                    ++code503;
                }
                for (String sqlCharTemp : sqlCharArr) {
                    if (!strLine.contains(sqlCharTemp)) continue;
                    ++sqlCount;
                    break;
                }
                for (String scanCharTemp : scanCharArr) {
                    if (!strLine.contains(scanCharTemp)) continue;
                    ++scanCount;
                    break;
                }
                for (String spiderCharTemp : spiderCharArr) {
                    if (!strLine.contains(spiderCharTemp)) continue;
                    ++spiderCount;
                    continue block2;
                }
            }
            resultContent = resultContent + "IP\u7e3d\u6578\u91cf: " + setIp.size() + "</br>";
            resultContent = resultContent + "\u97ff\u61c9\u72c0\u614b\u78bc400\u5171\u51fa\u73fe\u6b21\u6578: " + code400 + "</br>";
            resultContent = resultContent + "\u97ff\u61c9\u72c0\u614b\u78bc401\u5171\u51fa\u73fe\u6b21\u6578: " + code401 + "</br>";
            resultContent = resultContent + "\u97ff\u61c9\u72c0\u614b\u78bc403\u5171\u51fa\u73fe\u6b21\u6578: " + code403 + "</br>";
            resultContent = resultContent + "\u97ff\u61c9\u72c0\u614b\u78bc404\u5171\u51fa\u73fe\u6b21\u6578: " + code404 + "</br>";
            resultContent = resultContent + "\u97ff\u61c9\u72c0\u614b\u78bc408\u5171\u51fa\u73fe\u6b21\u6578: " + code408 + "</br>";
            resultContent = resultContent + "\u97ff\u61c9\u72c0\u614b\u78bc413\u5171\u51fa\u73fe\u6b21\u6578: " + code413 + "</br>";
            resultContent = resultContent + "\u97ff\u61c9\u72c0\u614b\u78bc414\u5171\u51fa\u73fe\u6b21\u6578: " + code414 + "</br>";
            resultContent = resultContent + "\u97ff\u61c9\u72c0\u614b\u78bc301\u5171\u51fa\u73fe\u6b21\u6578: " + code301 + "</br>";
            resultContent = resultContent + "\u97ff\u61c9\u72c0\u614b\u78bc500\u5171\u51fa\u73fe\u6b21\u6578: " + code500 + "</br>";
            resultContent = resultContent + "\u97ff\u61c9\u72c0\u614b\u78bc502\u5171\u51fa\u73fe\u6b21\u6578: " + code502 + "</br>";
            resultContent = resultContent + "\u97ff\u61c9\u72c0\u614b\u78bc503\u5171\u51fa\u73fe\u6b21\u6578: " + code503 + "</br>";
            resultContent = resultContent + "SQL\u6ce8\u5165\u653b\u64ca\u7e3d\u6b21\u6578: " + sqlCount + "</br>";
            resultContent = resultContent + "\u6aa2\u6e2c\u5230\u6383\u63cf\u653b\u64ca\u7e3d\u6b21\u6578: " + scanCount + "</br>";
            resultContent = resultContent + "\u641c\u7d22\u5f15\u64ce\u8718\u86db\u722c\u53d6\u7e3d\u6b21\u6578: " + spiderCount + "</br>";
            resultContent = resultContent + "</br>\u8a2a\u554f\u6b21\u6578\u6700\u9ad8\u524d20\u500bIP\u5982\u4e0b (IP\u548c\u8a2a\u554f\u6b21\u6578)</br>";
            ArrayList ipCountMapIds = new ArrayList(ipCountMap.entrySet());
            Collections.sort(ipCountMapIds, new /* Unavailable Anonymous Inner Class!! */);
            if (ipCountMapIds.size() <= 20) {
                for (int i = 0; i < ipCountMapIds.size(); ++i) {
                    resultContent = resultContent + (String)((Map.Entry)ipCountMapIds.get(i)).getKey() + "\u8a2a\u554f\u6b21\u6578 " + ((Map.Entry)ipCountMapIds.get(i)).getValue() + "</br>";
                }
            } else {
                for (int i = 0; i < 20; ++i) {
                    resultContent = resultContent + (String)((Map.Entry)ipCountMapIds.get(i)).getKey() + "\u8a2a\u554f\u6b21\u6578 " + ((Map.Entry)ipCountMapIds.get(i)).getValue() + "</br>";
                }
            }
            model.addAttribute("nginxMonitorContent", (Object)resultContent);
        }
        catch (Exception e) {
            logger.error("nginx\u65e5\u8a8c\u6587\u4ef6\u89e3\u6790\u932f\u8aa4", (Throwable)e);
        }
    }
}

