/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.RedisMonitorService;
import com.wgcloud.util.IpUtil;
import com.wgcloud.util.ResDataUtils;
import com.wgcloud.util.ServerBackupUtil;
import com.wgcloud.util.TokenUtils;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/serverBackupMonitor"})
public class ServerBackupController {
    private static final Logger logger = LoggerFactory.getLogger(ServerBackupController.class);
    @Resource
    private RedisMonitorService redisMonitorService;
    @Resource
    private LogInfoService logInfoService;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private TokenUtils tokenUtils;

    @ResponseBody
    @RequestMapping(value={"/agentList"})
    public String minTaskMarkServerBackup(@RequestBody String paramBean, HttpServletRequest request) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        boolean checkResult = this.tokenUtils.checkAgentToken(agentJsonObject);
        if (!checkResult) {
            logger.error("Token is error");
            return ResDataUtils.resetErrorJson((String)"Token is error");
        }
        logger.debug("server-backup\u4e0a\u5831IP\u6578\u64da-------------" + agentJsonObject.toString());
        try {
            logger.info("minTaskMarkServerBackup-------" + IpUtil.getIpAddr((HttpServletRequest)request) + "---------" + agentJsonObject.getStr((Object)"bindIp"));
            ServerBackupUtil.cacheSaveServerBackupIP((JSONObject)agentJsonObject, (HttpServletRequest)request);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790server-backup\u4e0a\u5831bindIp\u6578\u64da\u932f\u8aa4", (Throwable)e);
            return ResDataUtils.resetErrorJson((String)e.toString());
        }
        return ResDataUtils.resetSuccessJson(null);
    }

    @RequestMapping(value={"list"})
    public String serverBackupList(Model model, HttpServletRequest request) {
        HashMap params = new HashMap();
        try {
            List serverBackupIpList = ServerBackupUtil.getServerBackupIPList();
            if (serverBackupIpList.size() > 10 && !StaticKeys.LICENSE_STATE.equals("1")) {
                logger.info("serverBackup\u500b\u4eba\u7248\u53ea\u80fd\u76e3\u6e2c10\u9805");
                model.addAttribute("msg", (Object)("\u500b\u4eba\u7248\u53ea\u80fd\u76e3\u6e2c10\u9805\uff08\u7e3d\u6578\u91cf" + serverBackupIpList.size() + "\uff09"));
                serverBackupIpList = serverBackupIpList.subList(0, 10);
            }
            model.addAttribute("serverBackupIpList", (Object)serverBackupIpList);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8a62serverBackupIp\u76e3\u63a7\u4fe1\u606f\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("\u67e5\u8a62serverBackupIp\u76e3\u63a7\u4fe1\u606f\u932f\u8aa4", e.toString(), "2");
        }
        return "serverBackup/list";
    }
}

