/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.github.pagehelper.PageInfo;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AppExceptionInfo;
import com.wgcloud.entity.SystemInfo;
import com.wgcloud.service.AccountInfoService;
import com.wgcloud.service.CpuStateService;
import com.wgcloud.service.CpuTemperaturesService;
import com.wgcloud.service.DashboardService;
import com.wgcloud.service.DeskIoService;
import com.wgcloud.service.DiskIoStateService;
import com.wgcloud.service.DiskSmartService;
import com.wgcloud.service.DiskStateService;
import com.wgcloud.service.ExcelExportService;
import com.wgcloud.service.HostDiskPerService;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.HostMacInfoService;
import com.wgcloud.service.HostUsersService;
import com.wgcloud.service.HostWarnDiyService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.MemStateService;
import com.wgcloud.service.NetIoStateService;
import com.wgcloud.service.SysLoadStateService;
import com.wgcloud.service.SystemInfoExtService;
import com.wgcloud.service.SystemInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.ResDataUtils;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.TokenUtils;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/systemInfo"})
public class SystemInfoController {
    private static final Logger logger = LoggerFactory.getLogger(SystemInfoController.class);
    @Resource
    private SystemInfoService systemInfoService;
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private DashboardService dashboardService;
    @Resource
    private CpuStateService cpuStateService;
    @Resource
    private DiskStateService diskStateService;
    @Resource
    private DeskIoService deskIoService;
    @Autowired
    private DiskIoStateService diskIoStateService;
    @Resource
    private HostUsersService hostUsersService;
    @Autowired
    private HostMacInfoService hostMacInfoService;
    @Resource
    private DiskSmartService diskSmartService;
    @Resource
    private CpuTemperaturesService cpuTemperaturesService;
    @Resource
    private HostDiskPerService hostDiskPerService;
    @Resource
    private MemStateService memStateService;
    @Resource
    private NetIoStateService netIoStateService;
    @Resource
    private SysLoadStateService sysLoadStateService;
    @Resource
    private ExcelExportService excelExportService;
    @Resource
    private SystemInfoExtService systemInfoExtService;
    @Resource
    private HostWarnDiyService hostWarnDiyService;
    @Resource
    private AccountInfoService accountInfoService;
    @Resource
    private HostGroupService hostGroupService;
    @Autowired
    private TokenUtils tokenUtils;
    @Autowired
    private CommonConfig commonConfig;

    private void testThread() {
        Runnable runnable = () -> logger.info("SystemInfoController----------testThread");
        ThreadPoolUtil.executor.execute(runnable);
    }

    @ResponseBody
    @RequestMapping(value={"agentList"})
    public String agentList(@RequestBody String paramBean) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        String checkResult = this.tokenUtils.preOpenDataAPICheck(agentJsonObject);
        if (!StringUtils.isEmpty((CharSequence)checkResult)) {
            return checkResult;
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            if (!StringUtils.isEmpty((CharSequence)agentJsonObject.getStr((Object)"hostname"))) {
                params.put("hostname", agentJsonObject.getStr((Object)"hostname").trim());
            }
            if (!StringUtils.isEmpty((CharSequence)agentJsonObject.getStr((Object)"account"))) {
                params.put("account", agentJsonObject.getStr((Object)"account").trim());
            }
            if (!StringUtils.isEmpty((CharSequence)agentJsonObject.getStr((Object)"orderBy"))) {
                params.put("orderBy", agentJsonObject.getStr((Object)"orderBy"));
                params.put("orderType", agentJsonObject.getStr((Object)"orderType"));
            }
            PageInfo pageInfo = this.systemInfoService.selectByParams(params, agentJsonObject.getInt((Object)"page").intValue(), agentJsonObject.getInt((Object)"pageSize").intValue());
            HashMap<String, String> paramsAppInfo = new HashMap<String, String>();
            for (SystemInfo systemInfo1 : pageInfo.getList()) {
                paramsAppInfo.put("hostname", systemInfo1.getHostname());
                List deskStates = this.diskStateService.selectAllByParams(paramsAppInfo);
                HostUtil.setDiskSumPer((List)deskStates, (SystemInfo)systemInfo1);
            }
            return ResDataUtils.resetSuccessJson((Object)pageInfo);
        }
        catch (Exception e) {
            logger.error("agent\u7372\u53d6\u4e3b\u6a5f\u5217\u8868\u4fe1\u606f\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("agent\u7372\u53d6\u4e3b\u6a5f\u5217\u8868\u4fe1\u606f\u932f\u8aa4", e.toString(), "2");
            return ResDataUtils.resetErrorJson((String)e.toString());
        }
    }

    @ResponseBody
    @RequestMapping(value={"save"})
    public String saveSystemInfo(SystemInfo SystemInfo2, Model model, HttpServletRequest request) {
        try {
            if (!StringUtils.isEmpty((CharSequence)SystemInfo2.getId())) {
                SystemInfo ho = this.systemInfoService.selectById(SystemInfo2.getId());
                ho.setRemark(SystemInfo2.getRemark());
                this.systemInfoService.updateById(ho);
                this.logInfoService.save(HostUtil.getAccountByRequest((HttpServletRequest)request).getAccount() + "\u4fee\u6539\u4e3b\u6a5f\u5099\u8a3b\uff1a" + ho.getHostname(), "\u4e3b\u6a5f\u5099\u8a3b\uff1a" + ho.getRemark(), "2");
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u4e3b\u6a5f\u5099\u8a3b\u4fe1\u606f\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58\u4e3b\u6a5f\u5099\u8a3b\u4fe1\u606f\u932f\u8aa4", e.toString(), "2");
        }
        return "redirect:/systemInfo/systemInfoList";
    }

    @ResponseBody
    @RequestMapping(value={"saveWinConsole"})
    public String saveWinConsole(SystemInfo SystemInfo2, Model model, HttpServletRequest request) {
        try {
            if (!StringUtils.isEmpty((CharSequence)SystemInfo2.getId())) {
                SystemInfo ho = this.systemInfoService.selectById(SystemInfo2.getId());
                ho.setWinConsole(SystemInfo2.getWinConsole());
                this.systemInfoService.updateById(ho);
                this.logInfoService.save(HostUtil.getAccountByRequest((HttpServletRequest)request).getAccount() + "\u4fee\u6539\u4e3b\u6a5f\u670d\u52d9\uff1a" + ho.getHostname(), "\u4e3b\u6a5f\u670d\u52d9\uff1a" + ho.getWinConsole(), "2");
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u4e3b\u6a5f\u670d\u52d9url\u4fe1\u606f\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58\u4e3b\u6a5f\u4e3b\u6a5f\u670d\u52d9url\u4fe1\u606f\u932f\u8aa4", e.toString(), "2");
        }
        return SystemInfo2.getWinConsole();
    }

    @ResponseBody
    @RequestMapping(value={"saveHostListHideCols"})
    public String saveHostListHideCols(Model model, HttpServletRequest request) {
        try {
            Object[] hostListHideCols = request.getParameterValues("hostListHideCols");
            if (null != hostListHideCols) {
                request.getSession().setAttribute("HostListHideColsInfo", (Object)StringUtils.join((Object[])hostListHideCols, (String)","));
            } else {
                request.getSession().setAttribute("HostListHideColsInfo", (Object)"");
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u4e3b\u6a5f\u5217\u8868\u9700\u8981\u96b1\u85cf\u7684\u5217\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58\u4e3b\u6a5f\u5217\u8868\u9700\u8981\u96b1\u85cf\u7684\u5217\u932f\u8aa4", e.toString(), "2");
        }
        return "redirect:/systemInfo/systemInfoList";
    }

    @ResponseBody
    @RequestMapping(value={"saveGroupId"})
    public String saveGroupId(Model model, HttpServletRequest request) {
        try {
            String ids = request.getParameter("ids");
            String[] groupIdsArr = request.getParameterValues("groupId");
            this.systemInfoService.saveGroupId(ids, groupIdsArr, request);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u4e3b\u6a5f\u6a19\u7c64\u4fe1\u606f\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58\u4e3b\u6a5f\u6a19\u7c64\u4fe1\u606f\u932f\u8aa4", e.toString(), "2");
        }
        return "redirect:/systemInfo/systemInfoList";
    }

    @RequestMapping(value={"updateActive"})
    public String updateActive(Model model, HttpServletRequest request) {
        String errorMsg = "\u4e3b\u6a5f\u958b\u59cb\u76e3\u63a7\u548c\u505c\u6b62\u76e3\u63a7\u932f\u8aa4";
        try {
            this.systemInfoService.updateActive(request);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "redirect:/systemInfo/systemInfoList";
    }

    @RequestMapping(value={"updateOrderNum"})
    public String updateOrderNum(Model model, HttpServletRequest request) {
        String errorMsg = "\u8a2d\u7f6e\u4e3b\u6a5f\u6392\u5e8f\u5e8f\u865f\u932f\u8aa4";
        try {
            this.systemInfoService.updateOrderNum(request);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "redirect:/systemInfo/systemInfoList";
    }

    @RequestMapping(value={"updateCountBlock"})
    public String updateCountBlock(Model model, HttpServletRequest request) {
        String errorMsg = "\u4e3b\u6a5f\u52a0\u5165\u770b\u677f\u7d71\u8a08\u64cd\u4f5c\u932f\u8aa4";
        try {
            this.systemInfoService.updateCountBlock(request);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "redirect:/systemInfo/systemInfoList";
    }

    @RequestMapping(value={"systemInfoList"})
    public String systemInfoList(SystemInfo systemInfo, Model model, HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            StringBuffer url = new StringBuffer();
            String hostname = null;
            if (!StringUtils.isEmpty((CharSequence)systemInfo.getHostname())) {
                hostname = systemInfo.getHostname();
                params.put("hostname", hostname.trim());
                url.append("&hostname=").append(hostname);
            }
            if (!StringUtils.isEmpty((CharSequence)systemInfo.getState())) {
                params.put("state", systemInfo.getState());
                url.append("&state=").append(systemInfo.getState());
            }
            if (!StringUtils.isEmpty((CharSequence)systemInfo.getActive())) {
                if ("1".equals(systemInfo.getActive())) {
                    params.put("activeNe", "2");
                } else {
                    params.put("active", systemInfo.getActive());
                }
                url.append("&active=").append(systemInfo.getActive());
            }
            if (!StringUtils.isEmpty((CharSequence)systemInfo.getAccount())) {
                params.put("account", systemInfo.getAccount());
                url.append("&account=").append(systemInfo.getAccount());
            }
            if (!StringUtils.isEmpty((CharSequence)systemInfo.getGroupId())) {
                params.put("groupId", systemInfo.getGroupId());
                url.append("&groupId=").append(systemInfo.getGroupId());
            }
            if (!StringUtils.isEmpty((CharSequence)systemInfo.getOrderBy())) {
                params.put("orderBy", systemInfo.getOrderBy());
                params.put("orderType", systemInfo.getOrderType());
                url.append("&orderBy=").append(systemInfo.getOrderBy());
                url.append("&orderType=").append(systemInfo.getOrderType());
            }
            if (request.getParameter("dashView") != null) {
                url.append("&dashView=1");
            }
            LicenseUtil.checkHostList((SystemInfo)systemInfo, (Model)model);
            HostUtil.addAccountquery((HttpServletRequest)request, params);
            PageInfo pageInfo = this.systemInfoService.selectByParams(params, systemInfo.getPage().intValue(), systemInfo.getPageSize().intValue());
            if ("true".equals(this.commonConfig.getUserInfoManage())) {
                params.clear();
                List accountInfoList = this.accountInfoService.selectAllByParams(params);
                model.addAttribute("accountList", (Object)accountInfoList);
            }
            this.systemInfoService.hostAddVal(pageInfo, model, request);
            if (request.getParameter("dashView") != null) {
                this.systemInfoService.hideLeftIp(pageInfo, request);
            }
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            model.addAttribute("pageUrl", (Object)("/systemInfo/systemInfoList?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("systemInfo", (Object)systemInfo);
            if (null == request.getSession().getAttribute("HostListHideColsInfo")) {
                request.getSession().setAttribute("HostListHideColsInfo", (Object)"18");
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8a62\u4e3b\u6a5f\u5217\u8868\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("\u67e5\u8a62\u4e3b\u6a5f\u5217\u8868\u932f\u8aa4", e.toString(), "2");
        }
        if (request.getParameter("dashView") != null) {
            model.addAttribute("dashViewListAutoData", (Object)this.commonConfig.getDashViewListAutoData());
            return "dashView/list";
        }
        return "host/list";
    }

    @ResponseBody
    @RequestMapping(value={"systemInfoListAjax"})
    public String systemInfoListAjax(SystemInfo systemInfo, Model model, HttpServletRequest request) {
        HashMap params = new HashMap();
        try {
            List systemInfoList = this.systemInfoService.selectAllByParamsForTask(params);
            for (SystemInfo sys : systemInfoList) {
                if ("2".equals(sys.getState())) {
                    sys.setHostname("<span  class='badge bg-danger'>" + FormatUtil.getString((String)sys.getHostname(), (int)20) + "</span>");
                }
                if ("1".equals(sys.getState())) {
                    sys.setHostname("<span  class='badge bg-success'>" + FormatUtil.getString((String)sys.getHostname(), (int)20) + "</span>");
                }
                if (sys.getMemPer() >= 90.0) {
                    sys.setImage("<span class='badge bg-danger'>" + sys.getMemPer() + "</span>");
                }
                if (sys.getMemPer() >= 70.0 && sys.getMemPer() < 90.0) {
                    sys.setImage("<span class='badge bg-warning'>" + sys.getMemPer() + "</span>");
                }
                if (sys.getMemPer() < 70.0) {
                    sys.setImage("<span class='badge bg-primary'>" + sys.getMemPer() + "</span>");
                }
                if (sys.getCpuPer() >= 90.0) {
                    sys.setHostnameExt("<span class='badge bg-danger'>" + sys.getCpuPer() + "</span>");
                }
                if (sys.getCpuPer() >= 70.0 && sys.getCpuPer() < 90.0) {
                    sys.setHostnameExt("<span class='badge bg-warning'>" + sys.getCpuPer() + "</span>");
                }
                if (sys.getCpuPer() < 70.0) {
                    sys.setHostnameExt("<span class='badge bg-primary'>" + sys.getCpuPer() + "</span>");
                }
                sys.setRxbyt(FormatUtil.kbToM((String)sys.getRxbyt()) + "/s");
                sys.setTxbyt(FormatUtil.kbToM((String)sys.getTxbyt()) + "/s");
                sys.setRemark(DateUtil.getDateTimeString((Date)sys.getCreateTime()));
            }
            return JSONUtil.toJsonStr((Object)systemInfoList);
        }
        catch (Exception e) {
            logger.error("ajax\u67e5\u8a62\u4e3b\u6a5f\u5217\u8868\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("ajax\u67e5\u8a62\u4e3b\u6a5f\u5217\u8868\u932f\u8aa4", e.toString(), "2");
            return "";
        }
    }

    @RequestMapping(value={"detail"})
    public String hostDetail(Model model, HttpServletRequest request) {
        String id = request.getParameter("id");
        if (StringUtils.isEmpty((CharSequence)id)) {
            return "error/500";
        }
        try {
            SystemInfo systemInfo = this.systemInfoService.selectById(id);
            model.addAttribute("systemInfo", (Object)systemInfo);
            HostUtil.setSysFontAwesome((SystemInfo)systemInfo);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("hostname", systemInfo.getHostname());
            List diskStateList = this.diskStateService.selectAllByParams(params);
            model.addAttribute("diskStateList", (Object)diskStateList);
            this.diskStateService.computeDaysForDisk(diskStateList, systemInfo.getHostname());
            HostUtil.setDiskListSumSize((List)diskStateList);
            this.diskStateService.setWarnDisk(systemInfo, model);
            List deskIoList = this.deskIoService.selectAllByParams(params);
            model.addAttribute("deskIoList", (Object)deskIoList);
            ArrayList diskIoStateList = this.diskIoStateService.selectAllByParamsAndDay(systemInfo.getHostname(), model, request);
            if (!StaticKeys.LICENSE_STATE.equals("1")) {
                diskIoStateList = new ArrayList();
            }
            model.addAttribute("diskIoStateList", diskIoStateList);
            this.diskIoStateService.findMaxVal(diskIoStateList, model);
            this.diskIoStateService.setWarnValue(systemInfo, model);
            List diskSmartList = this.diskSmartService.selectAllByParams(params);
            model.addAttribute("diskSmartList", (Object)diskSmartList);
            List cpuTemperaturesList = this.cpuTemperaturesService.selectAllByParams(params);
            model.addAttribute("cpuTemperaturesList", (Object)cpuTemperaturesList);
            this.cpuTemperaturesService.setWarnValue(systemInfo, model);
            List hostUsersList = this.hostUsersService.selectAllByParams(params);
            model.addAttribute("hostUsersList", (Object)hostUsersList);
            List hostMacInfoList = this.hostMacInfoService.selectAllByParams(params);
            model.addAttribute("hostMacInfoList", (Object)hostMacInfoList);
            List hostDiskPerList = this.hostDiskPerService.selectAllByParams(params);
            this.hostDiskPerService.setSubtitle(model, hostDiskPerList);
            model.addAttribute("hostDiskPerList", (Object)JSONUtil.parseArray((Object)hostDiskPerList));
            HostUtil.viewAllNetworkHandler((Model)model, (String)systemInfo.getHostname());
            if (request.getParameter("dashView") != null) {
                this.systemInfoService.hideLeftIp(systemInfo, request);
            }
            if ("true".equals(this.commonConfig.getHostGroup())) {
                systemInfo.setGroupId(this.hostGroupService.returnGroupNames(systemInfo.getGroupId()));
            }
        }
        catch (Exception e) {
            logger.error("\u4e3b\u6a5f\u8a73\u7d30\u4fe1\u606f\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("\u4e3b\u6a5f\u8a73\u7d30\u4fe1\u606f\u932f\u8aa4", e.toString(), "2");
        }
        if (request.getParameter("dashView") != null) {
            return "dashView/view";
        }
        return "host/view";
    }

    @RequestMapping(value={"viewAllProcess"})
    public String viewAllProcess(AppExceptionInfo appExceptionInfo, Model model, HttpServletRequest request) {
        String id = request.getParameter("id");
        if (StringUtils.isEmpty((CharSequence)id)) {
            return "error/500";
        }
        try {
            HostUtil.viewAllProcessHandler((AppExceptionInfo)appExceptionInfo, (Model)model, (String)id);
        }
        catch (Exception e) {
            logger.error("\u4e3b\u6a5f\u5168\u91cf\u9032\u7a0b\u4fe1\u606f\u67e5\u770b\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("\u4e3b\u6a5f\u5168\u91cf\u9032\u7a0b\u4fe1\u606f\u67e5\u770b\u932f\u8aa4", e.toString(), "2");
        }
        return "host/viewAllProcess";
    }

    @RequestMapping(value={"viewImportInfo"})
    public String viewImportInfo(Model model, HttpServletRequest request) {
        String id = request.getParameter("id");
        if (StringUtils.isEmpty((CharSequence)id)) {
            return "error/500";
        }
        try {
            HostUtil.viewImportInfoHandler((Model)model, (String)id);
        }
        catch (Exception e) {
            logger.error("\u4e3b\u6a5fGPU\u3001\u9632\u706b\u7246\u3001CRONTAB\u4fe1\u606f\u67e5\u770b\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("\u4e3b\u6a5fGPU\u3001\u9632\u706b\u7246\u3001CRONTAB\u4fe1\u606f\u67e5\u770b\u932f\u8aa4", e.toString(), "2");
        }
        return "host/viewGpuInfo";
    }

    @RequestMapping(value={"viewAllPortInfo"})
    public String viewAllPortInfo(Model model, HttpServletRequest request) {
        String id = request.getParameter("id");
        if (StringUtils.isEmpty((CharSequence)id)) {
            return "error/500";
        }
        try {
            HostUtil.viewAllPortInfoHandler((Model)model, (String)id);
        }
        catch (Exception e) {
            logger.error("\u4e3b\u6a5f\u5168\u91cf\u7aef\u53e3\u4fe1\u606f\u67e5\u770b\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("\u4e3b\u6a5f\u5168\u91cf\u7aef\u53e3\u4fe1\u606f\u67e5\u770b\u932f\u8aa4", e.toString(), "2");
        }
        return "host/viewAllPort";
    }

    @RequestMapping(value={"del"})
    public String delete(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        String errorMsg = "\u522a\u9664\u4e3b\u6a5f\u4fe1\u606f\u932f\u8aa4";
        try {
            ArrayList<String> hostnameList = new ArrayList<String>();
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                String[] ids;
                for (String id : ids = request.getParameter("id").split(",")) {
                    SystemInfo sys = this.systemInfoService.selectById(id);
                    hostnameList.add(sys.getHostname());
                    this.logInfoService.save(HostUtil.getAccountByRequest((HttpServletRequest)request).getAccount() + "\u522a\u9664\u4e3b\u6a5f\uff1a" + sys.getHostname(), "\u4e3b\u6a5f\uff1a" + sys.getRemark(), "2");
                }
                this.systemInfoService.deleteById(ids);
                this.systemInfoExtService.deleteByHostname(hostnameList);
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "redirect:/systemInfo/systemInfoList";
    }

    @RequestMapping(value={"chart"})
    public String hostChart(Model model, HttpServletRequest request) {
        String id = request.getParameter("id");
        String startTime = request.getParameter("startTime");
        String endTime = request.getParameter("endTime");
        String am = request.getParameter("am");
        if (StringUtils.isEmpty((CharSequence)id)) {
            logger.error("hostChart id is  null");
            return "error/500";
        }
        try {
            SystemInfo systemInfo = this.systemInfoService.selectById(id);
            model.addAttribute("systemInfo", (Object)systemInfo);
            HostUtil.setSysFontAwesome((SystemInfo)systemInfo);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("hostname", systemInfo.getHostname());
            this.dashboardService.setDateParam(am, startTime, endTime, params, model);
            model.addAttribute("amList", (Object)this.dashboardService.getAmList());
            List cpuStateList = this.cpuStateService.selectAllByParams(params);
            List cpuStateCompressList = HostUtil.compressChartListData((List)cpuStateList, (Model)model);
            model.addAttribute("cpuStateList", (Object)JSONUtil.parseArray((Object)cpuStateCompressList));
            List memStateList = this.memStateService.selectAllByParams(params);
            List memStateCompressList = HostUtil.compressChartListData((List)memStateList, (Model)model);
            model.addAttribute("memStateList", (Object)JSONUtil.parseArray((Object)memStateCompressList));
            List sysLoadStateList = this.sysLoadStateService.selectAllByParams(params);
            List sysLoadStateCompressList = HostUtil.compressChartListData((List)sysLoadStateList, (Model)model);
            model.addAttribute("sysLoadStateList", (Object)JSONUtil.parseArray((Object)sysLoadStateCompressList));
            this.systemInfoService.findLoadMaxVal(sysLoadStateCompressList, model);
            List netIoStateList = this.netIoStateService.selectAllByParams(params);
            List netIoStateCompressList = HostUtil.compressChartListData((List)netIoStateList, (Model)model);
            List netIoStateDtoList = this.systemInfoService.toNetIoStateDto(netIoStateCompressList);
            model.addAttribute("netIoStateList", (Object)JSONUtil.parseArray((Object)netIoStateDtoList));
            this.systemInfoService.findNetIoStateBytMaxVal(netIoStateDtoList, model);
            this.systemInfoService.setSubtitle(model, cpuStateCompressList, memStateCompressList);
            if (request.getParameter("dashView") != null) {
                this.systemInfoService.hideLeftIp(systemInfo, request);
            }
            this.systemInfoService.setChartWarnElement(systemInfo, model);
        }
        catch (Exception e) {
            logger.error("\u4e3b\u6a5f\u5716\u5f62\u5831\u8868\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("\u4e3b\u6a5f\u5716\u5f62\u5831\u8868\u932f\u8aa4", e.toString(), "2");
        }
        if (request.getParameter("dashView") != null) {
            return "dashView/viewChart";
        }
        return "host/viewChart";
    }

    @RequestMapping(value={"chartExcel"})
    public void hostChartExcel(Model model, HttpServletRequest request, HttpServletResponse response) {
        String id = request.getParameter("id");
        String startTime = request.getParameter("startTime");
        String endTime = request.getParameter("endTime");
        String am = request.getParameter("am");
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        try {
            if (!StaticKeys.LICENSE_STATE.equals("1")) {
                response.setContentType("text/html;charset=UTF-8");
                response.getOutputStream().write("The module needs to professional version. Please contact us at www.wgstart.com".getBytes());
                return;
            }
            SystemInfo systemInfo = this.systemInfoService.selectById(id);
            model.addAttribute("systemInfo", (Object)systemInfo);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("hostname", systemInfo.getHostname());
            this.dashboardService.setDateParam(am, startTime, endTime, params, model);
            this.excelExportService.exportExcel(params, response);
        }
        catch (Exception e) {
            logger.error("\u4e3b\u6a5f\u5716\u5f62\u5831\u8868\u5c0e\u51faexcel\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("\u4e3b\u6a5f\u5716\u5f62\u5831\u8868\u5c0e\u51faexcel\u932f\u8aa4", e.toString(), "2");
        }
    }

    @RequestMapping(value={"hostListExcel"})
    public void hostListExcel(SystemInfo systemInfo, Model model, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (!StaticKeys.LICENSE_STATE.equals("1")) {
                response.setContentType("text/html;charset=UTF-8");
                response.getOutputStream().write("The module needs to professional version. Please contact us at www.wgstart.com".getBytes());
                return;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            if (!StringUtils.isEmpty((CharSequence)systemInfo.getState())) {
                params.put("state", systemInfo.getState());
            }
            if (!StringUtils.isEmpty((CharSequence)systemInfo.getGroupId())) {
                params.put("groupId", systemInfo.getGroupId());
            }
            if (!StringUtils.isEmpty((CharSequence)systemInfo.getOrderBy())) {
                params.put("orderBy", systemInfo.getOrderBy());
                params.put("orderType", systemInfo.getOrderType());
            }
            PageInfo pageInfo = new PageInfo();
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                String[] ids = request.getParameter("id").split(",");
                List list = this.systemInfoService.selectByIds(ids);
                pageInfo.setList(list);
            } else {
                HostUtil.addAccountquery((HttpServletRequest)request, params);
                pageInfo = this.systemInfoService.selectByParams(params, 1, 20000);
            }
            this.systemInfoService.hostAddVal(pageInfo, model, request);
            this.excelExportService.exportHostListExcel(pageInfo.getList(), response);
        }
        catch (Exception e) {
            logger.error("\u6240\u6709\u4e3b\u6a5f\u5217\u8868\u5c0e\u51faexcel\u932f\u8aa4", (Throwable)e);
            this.logInfoService.save("\u6240\u6709\u4e3b\u6a5f\u5217\u8868\u5c0e\u51faexcel\u932f\u8aa4", e.toString(), "2");
        }
    }
}

