/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import cn.hutool.core.collection.CollectionUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wgcloud.config.MailConfig;
import com.wgcloud.entity.DiskState;
import com.wgcloud.entity.HostWarnDiy;
import com.wgcloud.entity.SystemInfo;
import com.wgcloud.mapper.DiskStateMapper;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.UUIDUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

@Service
public class DiskStateService {
    private static final Logger logger = LoggerFactory.getLogger(DiskStateService.class);
    @Autowired
    private DiskStateMapper diskStateMapper;
    @Autowired
    private MailConfig mailConfig;

    public PageInfo selectByParams(Map<String, Object> params, int currPage, int pageSize) throws Exception {
        PageHelper.startPage((int)currPage, (int)pageSize);
        List list = this.diskStateMapper.selectByParams(params);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public void save(DiskState DiskState2) throws Exception {
        DiskState2.setId(UUIDUtil.getUUID());
        DiskState2.setCreateTime(new Date());
        this.diskStateMapper.save(DiskState2);
    }

    public void initDiskComputeCache() {
        try {
            HashMap params = new HashMap();
            List list = this.selectAllByParams(params);
            HostUtil.DISK_LIST_COMPUTE.clear();
            for (DiskState diskState : list) {
                DiskState diskStateCache = new DiskState();
                diskStateCache.setHostname(diskState.getHostname());
                diskStateCache.setFileSystem(diskState.getFileSystem());
                diskStateCache.setAvail(diskState.getAvail());
                diskStateCache.setCreateTime(diskState.getCreateTime());
                HostUtil.DISK_LIST_COMPUTE.add(diskStateCache);
            }
        }
        catch (Exception e) {
            logger.error("\u8655\u7406\u78c1\u76e4\u7a7a\u9593\u7684\u7de9\u5b58\u6578\u64da\u932f\u8aa4", (Throwable)e);
        }
    }

    public void setWarnDisk(SystemInfo systemInfo, Model model) {
        try {
            Double diskWarnVal = this.mailConfig.getDiskWarnVal();
            HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(systemInfo.getHostname());
            model.addAttribute("diskWarnVal", (Object)"no");
            if (null != hostWarnDiyDto && null != hostWarnDiyDto.getDiskWarnVal()) {
                diskWarnVal = hostWarnDiyDto.getDiskWarnVal();
                if ("yes".equals(hostWarnDiyDto.getDiskWarnMail()) && "true".equals(this.mailConfig.getDiskWarnMail())) {
                    model.addAttribute("diskWarnVal", (Object)diskWarnVal);
                }
            } else if ("true".equals(this.mailConfig.getDiskWarnMail())) {
                model.addAttribute("diskWarnVal", (Object)diskWarnVal);
            }
        }
        catch (Exception e) {
            logger.error("\u78c1\u76e4\u544a\u8b66\u503c\u8a2d\u7f6e\u932f\u8aa4", (Throwable)e);
        }
    }

    public void computeDaysForDisk(List<DiskState> diskStateList, String hostName) {
        try {
            if (CollectionUtil.isEmpty((Collection)HostUtil.DISK_LIST_COMPUTE)) {
                this.initDiskComputeCache();
            }
            ArrayList<DiskState> listCache = new ArrayList<DiskState>();
            for (DiskState diskState : HostUtil.DISK_LIST_COMPUTE) {
                if (!diskState.getHostname().equals(hostName)) continue;
                listCache.add(diskState);
            }
            for (DiskState diskState : diskStateList) {
                for (DiskState diskStateCache : listCache) {
                    if (!diskState.getFileSystem().equals(diskStateCache.getFileSystem())) continue;
                    long diffTimes = diskState.getCreateTime().getTime() - diskStateCache.getCreateTime().getTime();
                    if (diffTimes <= 3600000L) {
                        diskState.setDateStr("\u5927\u65bc1\u5e74");
                        continue;
                    }
                    double hours = FormatUtil.formatDouble((Double)((double)diffTimes / 3600000.0), (int)2);
                    double diffSize = Double.valueOf(diskStateCache.getAvail().replace("G", "")) - Double.valueOf(diskState.getAvail().replace("G", ""));
                    if (diffSize <= 0.0) {
                        diskState.setDateStr("\u5927\u65bc1\u5e74");
                        continue;
                    }
                    double sizeEveryHour = FormatUtil.formatDouble((Double)(diffSize / hours), (int)2);
                    if (sizeEveryHour <= 0.0) {
                        diskState.setDateStr("\u5927\u65bc1\u5e74");
                        continue;
                    }
                    double availDays = FormatUtil.formatDouble((Double)(Double.valueOf(diskState.getAvail().replace("G", "")) / sizeEveryHour / 24.0), (int)2);
                    diskState.setDateStr(availDays + "\u5929");
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8a08\u7b97\u4e3b\u6a5f\u7684\u6bcf\u500b\u78c1\u76e4\u53ef\u7528\u6642\u9593\u932f\u8aa4", (Throwable)e);
        }
    }

    @Transactional
    public void saveRecord(List<DiskState> recordList) throws Exception {
        if (recordList.size() < 1) {
            return;
        }
        for (DiskState as : recordList) {
            as.setId(UUIDUtil.getUUID());
        }
        this.diskStateMapper.insertList(recordList);
    }

    public int deleteById(String[] id) throws Exception {
        return this.diskStateMapper.deleteById(id);
    }

    public DiskState selectById(String id) throws Exception {
        return this.diskStateMapper.selectById(id);
    }

    public List<DiskState> selectAllByParams(Map<String, Object> params) throws Exception {
        return this.diskStateMapper.selectAllByParams(params);
    }

    public int deleteByAccHname(List<String> recordList) throws Exception {
        return this.diskStateMapper.deleteByAccHname(recordList);
    }

    public int deleteByAccountAndDate(Map<String, Object> map) throws Exception {
        return this.diskStateMapper.deleteByAccountAndDate(map);
    }
}

