/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.wgcloud.entity.DiskState;
import com.wgcloud.entity.SystemInfo;
import com.wgcloud.service.AppInfoService;
import com.wgcloud.service.DiskStateService;
import com.wgcloud.service.DockerInfoService;
import com.wgcloud.service.PortInfoService;
import com.wgcloud.service.SystemInfoService;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.PropertyUtil;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskUtilService {
    private Logger logger = LoggerFactory.getLogger(TaskUtilService.class);
    @Autowired
    SystemInfoService systemInfoService;
    @Autowired
    AppInfoService appInfoService;
    @Autowired
    DockerInfoService dockerInfoService;
    @Autowired
    PortInfoService portInfoService;
    @Autowired
    DiskStateService diskStateService;
    @Autowired
    private ServletContext servletContext;

    @Transactional
    public void refreshCommitDate() throws Exception {
        Date nowDate = new Date();
        this.logger.info("\u5237\u65b0\u76e3\u63a7\u6578\u64da\u66f4\u65b0\u6642\u9593\uff1a" + nowDate);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("state", "1");
        List systemInfolist = this.systemInfoService.selectAllByParamsForTask(params);
        ArrayList<SystemInfo> systemInfoUpdateList = new ArrayList<SystemInfo>();
        for (SystemInfo systemInfo : systemInfolist) {
            SystemInfo systemInfoUpdate = new SystemInfo();
            systemInfoUpdate.setCreateTime(nowDate);
            systemInfoUpdate.setId(systemInfo.getId());
            systemInfoUpdateList.add(systemInfoUpdate);
        }
        this.systemInfoService.updateRecord(systemInfoUpdateList);
    }

    public String sumDiskSizeCache(HttpServletRequest request) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        HostUtil.addAccountquery((HttpServletRequest)request, params);
        params.put("countBlockNe", "2");
        List deskStateList = this.diskStateService.selectAllByParams(params);
        BigDecimal sumSize = new BigDecimal(0);
        for (DiskState deskState : deskStateList) {
            if (StringUtils.isEmpty((CharSequence)deskState.getDiskSize())) continue;
            try {
                sumSize = sumSize.add(new BigDecimal(deskState.getDiskSize().replace("G", "")));
            }
            catch (Exception e) {
                this.logger.error("double\u985e\u578b\u8f49\u63db\u932f\u8aa4", (Throwable)e);
            }
        }
        String sumSizeStr = String.valueOf(sumSize);
        if (sumSizeStr.indexOf(".") > 0) {
            sumSizeStr = sumSizeStr.substring(0, sumSizeStr.lastIndexOf("."));
        }
        return FormatUtil.gToT((String)sumSizeStr);
    }

    public String sumDiskSizeCacheByGroup(Object groupId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("groupId", groupId);
            params.put("countBlockNe", "2");
            List diskStateList = this.diskStateService.selectAllByParams(params);
            BigDecimal sumSize = new BigDecimal(0);
            for (DiskState deskState : diskStateList) {
                if (StringUtils.isEmpty((CharSequence)deskState.getDiskSize())) continue;
                try {
                    sumSize = sumSize.add(new BigDecimal(deskState.getDiskSize().replace("G", "")));
                }
                catch (Exception e) {
                    this.logger.error("double\u985e\u578b\u8f49\u63db\u932f\u8aa4", (Throwable)e);
                }
            }
            String sumSizeStr = String.valueOf(sumSize);
            if (sumSizeStr.indexOf(".") > 0) {
                sumSizeStr = sumSizeStr.substring(0, sumSizeStr.lastIndexOf("."));
            }
            return FormatUtil.gToT((String)sumSizeStr);
        }
        catch (Exception e) {
            this.logger.error("\u6839\u64da\u6a19\u7c64\u7d71\u8a08\u78c1\u76e4\u5bb9\u91cf\u7e3d\u548c\u932f\u8aa4", (Throwable)e);
            return "";
        }
    }

    public String getValFromContext(String key, String defaultVal) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return defaultVal;
        }
        Object obj = this.servletContext.getAttribute(key);
        if (null == obj) {
            return defaultVal;
        }
        return obj.toString();
    }

    public void initMenuNames() {
        try {
            this.servletContext.setAttribute("jianKongGaiYao", (Object)"\u76e3\u63a7\u6982\u8981");
            this.servletContext.setAttribute("ziYuanGuanLi", (Object)"\u8cc7\u6e90\u7ba1\u7406");
            this.servletContext.setAttribute("zhuJiGuanLi", (Object)"\u4e3b\u6a5f\u7ba1\u7406");
            this.servletContext.setAttribute("yiChangJinCheng", (Object)"\u4e3b\u6a5f\u7570\u5e38\u9032\u7a0b");
            this.servletContext.setAttribute("jinChengJianCe", (Object)"\u9032\u7a0b\u76e3\u6e2c");
            this.servletContext.setAttribute("duanKouJianCe", (Object)"\u7aef\u53e3\u76e3\u6e2c");
            this.servletContext.setAttribute("riZhiJianKong", (Object)"\u65e5\u8a8c\u76e3\u63a7");
            this.servletContext.setAttribute("wenJianFangCuanGai", (Object)"\u6587\u4ef6\u9632\u7be1\u6539");
            this.servletContext.setAttribute("dockerJianCe", (Object)"DOCKER\u76e3\u6e2c");
            this.servletContext.setAttribute("ziDingYiJianKongXiang", (Object)"\u81ea\u5b9a\u7fa9\u76e3\u63a7\u9805");
            this.servletContext.setAttribute("shuJuJianKong", (Object)"\u6578\u64da\u76e3\u63a7");
            this.servletContext.setAttribute("shuJuKuGuanLi", (Object)"\u6578\u64da\u5eab\u7ba1\u7406");
            this.servletContext.setAttribute("shuJuBiaoJianCe", (Object)"\u6578\u64da\u8868\u76e3\u6e2c");
            this.servletContext.setAttribute("fuWuJieKouJianCe", (Object)"\u670d\u52d9\u63a5\u53e3\u76e3\u6e2c");
            this.servletContext.setAttribute("zhanShiKanBan", (Object)"\u5c55\u793a\u770b\u677f");
            this.servletContext.setAttribute("wangLuoSheBeiJianCe", (Object)"\u7db2\u7d61\u8a2d\u5099\u76e3\u6e2c");
            this.servletContext.setAttribute("pingJianCe", (Object)"PING\u76e3\u6e2c");
            this.servletContext.setAttribute("snmpJianCe", (Object)"SNMP\u76e3\u6e2c");
            this.servletContext.setAttribute("snmpDeepJianCe", (Object)"SNMP\u6df1\u5ea6\u76e3\u63a7");
            this.servletContext.setAttribute("ftpJianCe", (Object)"FTP/SFTP\u76e3\u6e2c");
            this.servletContext.setAttribute("zhongJianJianJianCe", (Object)"\u4e2d\u9593\u4ef6\u76e3\u6e2c");
            this.servletContext.setAttribute("redis", (Object)"Redis");
            this.servletContext.setAttribute("dongHuanJianCe", (Object)"\u52d5\u74b0\u76e3\u6e2c");
            this.servletContext.setAttribute("nginxRiZhiJianCe", (Object)"Nginx\u65e5\u8a8c\u6aa2\u6e2c");
            this.servletContext.setAttribute("kafka", (Object)"Kafka");
            this.servletContext.setAttribute("rabbitmq", (Object)"RabbitMQ");
            this.servletContext.setAttribute("activemq", (Object)"ActiveMQ");
            this.servletContext.setAttribute("k8sNode", (Object)"K8S-Node");
            this.servletContext.setAttribute("k8sDeployment", (Object)"K8S-Deployment");
            this.servletContext.setAttribute("k8sNamespace", (Object)"K8S-Namespace");
            this.servletContext.setAttribute("k8sPod", (Object)"K8S-Pod");
            this.servletContext.setAttribute("k8sService", (Object)"K8S-Service");
            this.servletContext.setAttribute("k8sContainer", (Object)"K8S-Container");
            this.servletContext.setAttribute("serverBackupName", (Object)"Server-Backup");
            this.servletContext.setAttribute("tuopuTu", (Object)"\u62d3\u64b2\u5716");
            this.servletContext.setAttribute("zhuJiTuopuTu", (Object)"\u4e3b\u6a5f\u62d3\u64b2\u5716");
            this.servletContext.setAttribute("pingTuopuTu", (Object)"PING\u62d3\u64b2\u5716");
            this.servletContext.setAttribute("snmpTuopuTu", (Object)"SNMP\u62d3\u64b2\u5716");
            this.servletContext.setAttribute("snmpDeepTuopuTu", (Object)"SNMP\u6df1\u5ea6\u62d3\u64b2");
            this.servletContext.setAttribute("xunJianBaoGao", (Object)"\u5de1\u6aa2\u5831\u544a");
            this.servletContext.setAttribute("jiHuaRenWu", (Object)"\u8a08\u5283\u4efb\u52d9");
            this.servletContext.setAttribute("xiTongGuanLi", (Object)"\u7cfb\u7d71\u7ba1\u7406");
            this.servletContext.setAttribute("xiTongRiZhi", (Object)"\u7cfb\u7d71\u65e5\u8a8c");
            this.servletContext.setAttribute("zhiLingXiaFa", (Object)"\u6307\u4ee4\u4e0b\u767c");
            this.servletContext.setAttribute("biaoQianGuanLi", (Object)"\u6a19\u7c64\u7ba1\u7406");
            this.servletContext.setAttribute("chengYuanZhangHao", (Object)"\u6210\u54e1\u8cec\u865f");
            this.servletContext.setAttribute("gaoJingSheZhi", (Object)"\u544a\u8b66\u8a2d\u7f6e");
            this.servletContext.setAttribute("youJianGaoJing", (Object)"\u90f5\u4ef6\u544a\u8b66");
            this.servletContext.setAttribute("jiaoBenGaoJing", (Object)"\u8173\u672c\u544a\u8b66");
            this.servletContext.setAttribute("ziDingYiGaoJing", (Object)"\u81ea\u5b9a\u7fa9\u544a\u8b66");
            this.servletContext.setAttribute("ziChanGuanLi", (Object)"\u8cc7\u7522\u7ba1\u7406");
            this.servletContext.setAttribute("sheBeiZhangHao", (Object)"\u8a2d\u5099\u8cec\u865f\u7ba1\u7406");
            this.servletContext.setAttribute("gongZuoBiJi", (Object)"\u5de5\u4f5c\u7b46\u8a18");
            this.servletContext.setAttribute("zhongDuanYunXing", (Object)"\u7d42\u7aef\u904b\u884c\u7d71\u8a08");
            this.servletContext.setAttribute("aillm", (Object)"AI-LLM");
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u8a2d\u7f6e\u83dc\u55ae\u540d\u7a31\u932f\u8aa4", (Throwable)e);
        }
    }

    public void setDiyMenuNames() {
        try {
            Map mapColNames = PropertyUtil.getMenuNames((String)(StaticKeys.JAR_PATH + "/config/menusNameDiy.properties"));
            if (null != mapColNames) {
                if (!LicenseUtil.checkEnterpriseVersion()) {
                    this.logger.info("\u7576\u524d\u5df2\u4f7f\u7528\u7cfb\u7d71\u9ed8\u8a8d\u914d\u7f6e\u7684\u83dc\u55ae\u540d\u7a31");
                    return;
                }
                for (Map.Entry entry : mapColNames.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    this.servletContext.setAttribute(key, (Object)value);
                }
                this.logger.info("\u7576\u524d\u5df2\u4f7f\u7528\u81ea\u5b9a\u7fa9\u914d\u7f6e\u7684\u83dc\u55ae\u540d\u7a31");
            }
        }
        catch (Exception e) {
            this.logger.error("\u81ea\u5b9a\u7fa9\u8a2d\u7f6e\u83dc\u55ae\u540d\u7a31\u932f\u8aa4", (Throwable)e);
        }
    }
}

