/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util.msg;

import com.wgcloud.common.ApplicationContextHelper;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.config.LevelConfig;
import com.wgcloud.config.MailConfig;
import com.wgcloud.entity.AppInfo;
import com.wgcloud.entity.CpuState;
import com.wgcloud.entity.CpuTemperatures;
import com.wgcloud.entity.CustomInfo;
import com.wgcloud.entity.DiskIoState;
import com.wgcloud.entity.DiskSmart;
import com.wgcloud.entity.DiskState;
import com.wgcloud.entity.DockerInfo;
import com.wgcloud.entity.FileSafe;
import com.wgcloud.entity.FileWarnInfo;
import com.wgcloud.entity.HostWarnDiy;
import com.wgcloud.entity.MemState;
import com.wgcloud.entity.NetIoState;
import com.wgcloud.entity.PortInfo;
import com.wgcloud.entity.SysLoadState;
import com.wgcloud.entity.SystemInfo;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.SystemInfoService;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.msg.WarnOtherUtil;
import com.wgcloud.util.msg.WarnPools;
import com.wgcloud.util.staticvar.StaticKeys;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

/*
 * Exception performing whole class analysis ignored.
 */
public class WarnMailUtil {
    private static final Logger logger = LoggerFactory.getLogger(WarnMailUtil.class);
    private static CommonConfig commonConfig = (CommonConfig)ApplicationContextHelper.getBean(CommonConfig.class);
    private static LogInfoService logInfoService = (LogInfoService)ApplicationContextHelper.getBean(LogInfoService.class);
    private static MailConfig mailConfig = (MailConfig)ApplicationContextHelper.getBean(MailConfig.class);
    private static LevelConfig levelConfig = (LevelConfig)ApplicationContextHelper.getBean(LevelConfig.class);
    private static SystemInfoService systemInfoService = (SystemInfoService)ApplicationContextHelper.getBean(SystemInfoService.class);

    private static boolean preWarnInit(String hostname, String warnMail, String warnKey) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(warnMail)) {
            return false;
        }
        return !WarnPools.checkWarnCacheTimes((String)warnKey, (Integer)commonConfig.getWarnCacheTimes());
    }

    public static boolean sendWarnInfo(MemState memState) {
        String key = memState.getHostname() + "_mem";
        boolean sign = WarnMailUtil.preWarnInit((String)memState.getHostname(), (String)mailConfig.getMemWarnMail(), (String)key);
        if (!sign) {
            return false;
        }
        Double memWarnVal = mailConfig.getMemWarnVal();
        String warnLevel = levelConfig.getMemWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(memState.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getMemWarnMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (null != hostWarnDiyDto.getMemWarnVal()) {
                memWarnVal = hostWarnDiyDto.getMemWarnVal();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getMemWarnLevel())) {
                warnLevel = hostWarnDiyDto.getMemWarnLevel();
            }
        }
        if (memState.getUsePer() != null && memState.getUsePer() >= memWarnVal) {
            try {
                if (!WarnMailUtil.isOutWarnCount((String)key, (Integer)mailConfig.getMemWarnCount())) {
                    logger.info(memState.getHostname() + "---\u5167\u5b58\u4f7f\u7528\u7387\u6c92\u6709\u9054\u5230\u544a\u8b66\u6b21\u6578---" + WarnPools.HOST_WARN_COUNT_MAP.get((Object)key));
                    return false;
                }
                String remark = HostUtil.addRemark((String)memState.getHostname());
                String title = "\u5167\u5b58\u544a\u8b66\uff1a" + memState.getHostname() + remark;
                String commContent = "\u4e3b\u6a5f\uff1a" + memState.getHostname() + remark + "\uff0c\u7576\u524d\u5167\u5b58\u4f7f\u7528\u7387\u70ba" + Double.valueOf(memState.getUsePer()) + "\uff0c\u5df2\u9023\u7e8c" + mailConfig.getMemWarnCount() + "\u6b21\u8d85\u904e\u544a\u8b66\u503c" + memWarnVal;
                String account = WarnMailUtil.getAccount((String)memState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)memState.getHostname(), (String)""), (String)memState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u5167\u5b58\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u5167\u5b58\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendSysLoadWarnInfo(SysLoadState sysLoadState) {
        String key = sysLoadState.getHostname() + "_load";
        boolean sign = WarnMailUtil.preWarnInit((String)sysLoadState.getHostname(), (String)mailConfig.getSysLoadWarnMail(), (String)key);
        if (!sign) {
            return false;
        }
        Double sysLoadWarnVal = mailConfig.getSysLoadWarnVal();
        String warnLevel = levelConfig.getSysLoadWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(sysLoadState.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getSysLoadWarnMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (null != hostWarnDiyDto.getSysLoadWarnVal()) {
                sysLoadWarnVal = hostWarnDiyDto.getSysLoadWarnVal();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getSysLoadWarnLevel())) {
                warnLevel = hostWarnDiyDto.getSysLoadWarnLevel();
            }
        }
        if (sysLoadState.getFiveLoad() != null && sysLoadState.getFiveLoad() >= sysLoadWarnVal) {
            try {
                String remark = HostUtil.addRemark((String)sysLoadState.getHostname());
                String title = "\u7cfb\u7d71\u8ca0\u8f09(5\u5206\u9418)\u544a\u8b66\uff1a" + sysLoadState.getHostname() + remark;
                String commContent = "\u4e3b\u6a5f\uff1a" + sysLoadState.getHostname() + remark + "\uff0c\u7576\u524d\u7cfb\u7d71\u8ca0\u8f09(5\u5206\u9418)\u70ba" + Double.valueOf(sysLoadState.getFiveLoad()) + "\uff0c\u8d85\u904e\u544a\u8b66\u503c" + sysLoadWarnVal;
                String account = WarnMailUtil.getAccount((String)sysLoadState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)sysLoadState.getHostname(), (String)""), (String)sysLoadState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u7cfb\u7d71\u8ca0\u8f09(5\u5206\u9418)\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u7cfb\u7d71\u8ca0\u8f09(5\u5206\u9418)\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendCpuWarnInfo(CpuState cpuState) {
        String key = cpuState.getHostname() + "_cpu";
        boolean sign = WarnMailUtil.preWarnInit((String)cpuState.getHostname(), (String)mailConfig.getCpuWarnMail(), (String)key);
        if (!sign) {
            return false;
        }
        Double cpuWarnVal = mailConfig.getCpuWarnVal();
        String warnLevel = levelConfig.getCpuWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(cpuState.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getCpuWarnMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (null != hostWarnDiyDto.getCpuWarnVal()) {
                cpuWarnVal = hostWarnDiyDto.getCpuWarnVal();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getCpuWarnLevel())) {
                warnLevel = hostWarnDiyDto.getCpuWarnLevel();
            }
        }
        if (cpuState.getSys() != null && cpuState.getSys() >= cpuWarnVal) {
            try {
                if (!WarnMailUtil.isOutWarnCount((String)key, (Integer)mailConfig.getCpuWarnCount())) {
                    logger.info(cpuState.getHostname() + "---CPU\u4f7f\u7528\u7387\u6c92\u6709\u9054\u5230\u544a\u8b66\u6b21\u6578---" + WarnPools.HOST_WARN_COUNT_MAP.get((Object)key));
                    return false;
                }
                String remark = HostUtil.addRemark((String)cpuState.getHostname());
                String title = "CPU\u544a\u8b66\uff1a" + cpuState.getHostname() + remark;
                String commContent = "\u4e3b\u6a5f\uff1a" + cpuState.getHostname() + remark + "\uff0c\u7576\u524dCPU\u4f7f\u7528\u7387\u70ba" + Double.valueOf(cpuState.getSys()) + "\uff0c\u5df2\u9023\u7e8c" + mailConfig.getCpuWarnCount() + "\u6b21\u8d85\u904e\u544a\u8b66\u503c" + cpuWarnVal;
                String account = WarnMailUtil.getAccount((String)cpuState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)cpuState.getHostname(), (String)""), (String)cpuState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001CPU\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001CPU\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendNetConnectionsWarnInfo(NetIoState netIoState) {
        Integer netConnections;
        String key = netIoState.getHostname() + "_netConnections";
        boolean sign = WarnMailUtil.preWarnInit((String)netIoState.getHostname(), (String)mailConfig.getNetConnectionsWarnMail(), (String)key);
        if (!sign) {
            return false;
        }
        Double netConnectionsWarnVal = mailConfig.getNetConnectionsWarnVal();
        String warnLevel = levelConfig.getNetConnectionsWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(netIoState.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getNetConnectionsWarnMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (null != hostWarnDiyDto.getNetConnectionsWarnVal()) {
                netConnectionsWarnVal = hostWarnDiyDto.getNetConnectionsWarnVal();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getNetConnectionsWarnLevel())) {
                warnLevel = hostWarnDiyDto.getNetConnectionsWarnLevel();
            }
        }
        if ((double)(netConnections = Integer.valueOf(netIoState.getNetConnections())).intValue() >= netConnectionsWarnVal) {
            try {
                String remark = HostUtil.addRemark((String)netIoState.getHostname());
                String title = "\u4e3b\u6a5f\u9023\u63a5\u6578\u91cf\u544a\u8b66\uff1a" + netIoState.getHostname() + remark;
                String commContent = "\u4e3b\u6a5f\uff1a" + netIoState.getHostname() + remark + "\uff0c\u7576\u524d\u9023\u63a5\u6578\u91cf\u70ba" + netConnections + "\uff0c\u8d85\u904e\u544a\u8b66\u503c" + netConnectionsWarnVal;
                String account = WarnMailUtil.getAccount((String)netIoState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)netIoState.getHostname(), (String)""), (String)netIoState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u4e3b\u6a5f\u9023\u63a5\u6578\u91cf\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u4e3b\u6a5f\u9023\u63a5\u6578\u91cf\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendUpSpeedWarnInfo(NetIoState netIoState) {
        String account;
        String commContent;
        String title;
        String remark;
        boolean sign;
        String key = netIoState.getHostname() + "_txbyt";
        Double upSpeedVal = mailConfig.getUpSpeedVal();
        Double upSpeedMinVal = mailConfig.getUpSpeedMinVal();
        String warnLevel = levelConfig.getSpeedWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(netIoState.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getUpSpeedMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (null != hostWarnDiyDto.getUpSpeedVal()) {
                upSpeedVal = hostWarnDiyDto.getUpSpeedVal();
            }
            if (null != hostWarnDiyDto.getUpSpeedMinVal()) {
                upSpeedMinVal = hostWarnDiyDto.getUpSpeedMinVal();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getSpeedWarnLevel())) {
                warnLevel = hostWarnDiyDto.getSpeedWarnLevel();
            }
        }
        if (!StringUtils.isEmpty((CharSequence)netIoState.getTxbyt()) && Double.valueOf(netIoState.getTxbyt()) >= upSpeedVal) {
            try {
                sign = WarnMailUtil.preWarnInit((String)netIoState.getHostname(), (String)mailConfig.getUpSpeedMail(), (String)(key + "_max"));
                if (!sign) {
                    return false;
                }
                remark = HostUtil.addRemark((String)netIoState.getHostname());
                title = "\u8d85\u904e\u4e0a\u884c\u50b3\u8f38\u901f\u7387\u544a\u8b66\uff1a" + netIoState.getHostname() + remark;
                commContent = "\u4e3b\u6a5f\uff1a" + netIoState.getHostname() + remark + "\uff0c\u7576\u524d\u4e0a\u884c\u50b3\u8f38\u901f\u7387\u70ba" + FormatUtil.kbToM((String)netIoState.getTxbyt()) + "/s\uff0c\u8d85\u904e\u544a\u8b66\u503c" + FormatUtil.kbToM((String)(upSpeedVal + "")) + "/s";
                account = WarnMailUtil.getAccount((String)netIoState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)(key + "_max"), (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)netIoState.getHostname(), (String)""), (String)netIoState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u8d85\u904e\u4e0a\u884c\u50b3\u8f38\u901f\u7387\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u8d85\u904e\u4e0a\u884c\u50b3\u8f38\u901f\u7387\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)netIoState.getTxbyt()) && Double.valueOf(netIoState.getTxbyt()) < upSpeedMinVal) {
            try {
                sign = WarnMailUtil.preWarnInit((String)netIoState.getHostname(), (String)mailConfig.getUpSpeedMail(), (String)(key + "_min"));
                if (!sign) {
                    return false;
                }
                remark = HostUtil.addRemark((String)netIoState.getHostname());
                title = "\u4f4e\u65bc\u4e0a\u884c\u50b3\u8f38\u901f\u7387\u544a\u8b66\uff1a" + netIoState.getHostname() + remark;
                commContent = "\u4e3b\u6a5f\uff1a" + netIoState.getHostname() + remark + "\uff0c\u7576\u524d\u4e0a\u884c\u50b3\u8f38\u901f\u7387\u70ba" + FormatUtil.kbToM((String)netIoState.getTxbyt()) + "/s\uff0c\u4f4e\u65bc\u544a\u8b66\u503c" + FormatUtil.kbToM((String)(upSpeedMinVal + "")) + "/s";
                account = WarnMailUtil.getAccount((String)netIoState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)(key + "_min"), (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)netIoState.getHostname(), (String)""), (String)netIoState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u4f4e\u65bc\u4e0a\u884c\u50b3\u8f38\u901f\u7387\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u4f4e\u65bc\u4e0a\u884c\u50b3\u8f38\u901f\u7387\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendDownSpeedWarnInfo(NetIoState netIoState) {
        String account;
        String commContent;
        String title;
        String remark;
        boolean sign;
        String key = netIoState.getHostname() + "_rxbyt";
        Double downSpeedVal = mailConfig.getDownSpeedVal();
        Double downSpeedMinVal = mailConfig.getDownSpeedMinVal();
        String warnLevel = levelConfig.getSpeedWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(netIoState.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getDownSpeedMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (null != hostWarnDiyDto.getDownSpeedVal()) {
                downSpeedVal = hostWarnDiyDto.getDownSpeedVal();
            }
            if (null != hostWarnDiyDto.getDownSpeedMinVal()) {
                downSpeedMinVal = hostWarnDiyDto.getDownSpeedMinVal();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getSpeedWarnLevel())) {
                warnLevel = hostWarnDiyDto.getSpeedWarnLevel();
            }
        }
        if (!StringUtils.isEmpty((CharSequence)netIoState.getRxbyt()) && Double.valueOf(netIoState.getRxbyt()) >= downSpeedVal) {
            try {
                sign = WarnMailUtil.preWarnInit((String)netIoState.getHostname(), (String)mailConfig.getDownSpeedMail(), (String)(key + "_max"));
                if (!sign) {
                    return false;
                }
                remark = HostUtil.addRemark((String)netIoState.getHostname());
                title = "\u8d85\u904e\u4e0b\u884c\u50b3\u8f38\u901f\u7387\u544a\u8b66\uff1a" + netIoState.getHostname() + remark;
                commContent = "\u4e3b\u6a5f\uff1a" + netIoState.getHostname() + remark + "\uff0c\u7576\u524d\u4e0b\u884c\u50b3\u8f38\u901f\u7387\u70ba" + FormatUtil.kbToM((String)netIoState.getRxbyt()) + "/s\uff0c\u8d85\u904e\u544a\u8b66\u503c" + FormatUtil.kbToM((String)(downSpeedVal + "")) + "/s";
                account = WarnMailUtil.getAccount((String)netIoState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)(key + "_max"), (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)netIoState.getHostname(), (String)""), (String)netIoState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u8d85\u904e\u4e0b\u884c\u50b3\u8f38\u901f\u7387\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u8d85\u904e\u4e0b\u884c\u50b3\u8f38\u901f\u7387\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)netIoState.getRxbyt()) && Double.valueOf(netIoState.getRxbyt()) < downSpeedMinVal) {
            try {
                sign = WarnMailUtil.preWarnInit((String)netIoState.getHostname(), (String)mailConfig.getDownSpeedMail(), (String)(key + "_min"));
                if (!sign) {
                    return false;
                }
                remark = HostUtil.addRemark((String)netIoState.getHostname());
                title = "\u4f4e\u65bc\u4e0b\u884c\u50b3\u8f38\u901f\u7387\u544a\u8b66\uff1a" + netIoState.getHostname() + remark;
                commContent = "\u4e3b\u6a5f\uff1a" + netIoState.getHostname() + remark + "\uff0c\u7576\u524d\u4e0b\u884c\u50b3\u8f38\u901f\u7387\u70ba" + FormatUtil.kbToM((String)netIoState.getRxbyt()) + "/s\uff0c\u4f4e\u65bc\u544a\u8b66\u503c" + FormatUtil.kbToM((String)(downSpeedMinVal + "")) + "/s";
                account = WarnMailUtil.getAccount((String)netIoState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)(key + "_min"), (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)netIoState.getHostname(), (String)""), (String)netIoState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u4f4e\u65bc\u4e0b\u884c\u50b3\u8f38\u901f\u7387\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u4f4e\u65bc\u4e0b\u884c\u50b3\u8f38\u901f\u7387\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendDiskSmartWarnInfo(DiskSmart smartBean) {
        String key = smartBean.getHostname() + "_smart";
        boolean sign = WarnMailUtil.preWarnInit((String)smartBean.getHostname(), (String)mailConfig.getSmartWarnMail(), (String)key);
        if (!sign) {
            return false;
        }
        String warnLevel = levelConfig.getSmartWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(smartBean.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getSmartWarnMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getSmartWarnLevel())) {
                warnLevel = hostWarnDiyDto.getSmartWarnLevel();
            }
        }
        if (!StringUtils.isEmpty((CharSequence)smartBean.getDiskState()) && "FAILED".equals(smartBean.getDiskState())) {
            try {
                String remark = HostUtil.addRemark((String)smartBean.getHostname());
                String title = "\u78c1\u76e4\u544a\u8b66SMART\uff1a" + smartBean.getHostname() + remark;
                String commContent = "\u4e3b\u6a5f\uff1a" + smartBean.getHostname() + remark + "\uff0c\u78c1\u76e4" + smartBean.getFileSystem() + "\uff0cSMART\u5065\u5eb7\u6aa2\u6e2c\u7d50\u679c\u70ba" + "FAILED";
                String account = WarnMailUtil.getAccount((String)smartBean.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)smartBean.getHostname(), (String)""), (String)smartBean.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u78c1\u76e4\u544a\u8b66SMART\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u78c1\u76e4\u544a\u8b66SMART\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendDiskWarnInfo(DiskState deskState) {
        Double usePer;
        logger.debug("\u544a\u8b66\u78c1\u76e4-------------" + deskState.getFileSystem());
        String key = deskState.getHostname() + "_disk_" + deskState.getFileSystem();
        Double diskWarnVal = mailConfig.getDiskWarnVal();
        String warnLevel = levelConfig.getDiskWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(deskState.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getDiskWarnMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (null != hostWarnDiyDto.getDiskWarnVal()) {
                diskWarnVal = hostWarnDiyDto.getDiskWarnVal();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getDiskWarnLevel())) {
                warnLevel = hostWarnDiyDto.getDiskWarnLevel();
            }
        }
        if ((usePer = Double.valueOf(deskState.getUsePer().replace("%", ""))) != null && usePer < diskWarnVal && null != WarnPools.MEM_WARN_MAP.get((Object)key)) {
            try {
                String remark = HostUtil.addRemark((String)deskState.getHostname());
                String title = "\u78c1\u76e4\u5df2\u6062\u5fa9\uff1a" + deskState.getHostname() + remark;
                String commContent = "\u4e3b\u6a5f\u78c1\u76e4\u5df2\u6062\u5fa9\uff1a" + deskState.getHostname() + remark + "\uff0c\u78c1\u76e4" + deskState.getFileSystem() + "\u4f7f\u7528\u7387\u70ba" + usePer + "\uff0c\u672a\u9054\u5230\u544a\u8b66\u503c" + diskWarnVal;
                String account = WarnMailUtil.getAccount((String)deskState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)false, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)deskState.getHostname(), (String)""), (String)deskState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u78c1\u76e4\u5df2\u6062\u5fa9\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u78c1\u76e4\u5df2\u6062\u5fa9\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
            return false;
        }
        boolean sign = WarnMailUtil.preWarnInit((String)deskState.getHostname(), (String)mailConfig.getDiskWarnMail(), (String)key);
        if (!sign) {
            return false;
        }
        if (WarnMailUtil.blockDisk((DiskState)deskState)) {
            return false;
        }
        if (usePer != null && usePer >= diskWarnVal) {
            try {
                String remark = HostUtil.addRemark((String)deskState.getHostname());
                String title = "\u78c1\u76e4\u544a\u8b66\uff1a" + deskState.getHostname() + remark;
                String commContent = "\u4e3b\u6a5f\u78c1\u76e4\u544a\u8b66\uff1a" + deskState.getHostname() + remark + "\uff0c\u78c1\u76e4" + deskState.getFileSystem() + "\u4f7f\u7528\u7387\u70ba" + usePer + "\uff0c\u8d85\u904e\u544a\u8b66\u503c" + diskWarnVal;
                String account = WarnMailUtil.getAccount((String)deskState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)deskState.getHostname(), (String)""), (String)deskState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u78c1\u76e4\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u78c1\u76e4\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    private static boolean blockDisk(DiskState deskState) {
        String diskBlock = mailConfig.getDiskBlock();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(deskState.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive()) && !StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getDiskBlock()) && "no".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
            diskBlock = hostWarnDiyDto.getDiskBlock();
        }
        if (!StringUtils.isEmpty((CharSequence)diskBlock)) {
            String[] blocks = diskBlock.split(",");
            AntPathMatcher pm = new AntPathMatcher();
            for (String diskBlcok : blocks) {
                diskBlcok = diskBlcok.replace("'", "");
                if ("/".equals(deskState.getFileSystem())) {
                    if (!diskBlcok.equals(deskState.getFileSystem())) continue;
                    return true;
                }
                boolean matchStart = pm.matchStart(diskBlcok, deskState.getFileSystem());
                if (!matchStart) continue;
                return matchStart;
            }
        }
        return false;
    }

    public static boolean sendCpuTemperatures(CpuTemperatures cpuTemperatures) {
        Double inputVal;
        String key = cpuTemperatures.getHostname() + "_temperatures";
        boolean sign = WarnMailUtil.preWarnInit((String)cpuTemperatures.getHostname(), (String)mailConfig.getCpuTemperatureWarnMail(), (String)key);
        if (!sign) {
            return false;
        }
        Double cpuTemperatureWarnVal = mailConfig.getCpuTemperatureWarnVal();
        String warnLevel = levelConfig.getCpuTemperatureWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(cpuTemperatures.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getCpuTemperatureWarnMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (null != hostWarnDiyDto.getCpuTemperatureWarnVal()) {
                cpuTemperatureWarnVal = hostWarnDiyDto.getCpuTemperatureWarnVal();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getCpuTemperatureWarnLevel())) {
                warnLevel = hostWarnDiyDto.getCpuTemperatureWarnLevel();
            }
        }
        if ((inputVal = Double.valueOf(cpuTemperatures.getInput().replace("\u2103", "").replace("+", ""))) != null && inputVal >= cpuTemperatureWarnVal) {
            try {
                String remark = HostUtil.addRemark((String)cpuTemperatures.getHostname());
                String title = "CPU\u6eab\u5ea6\u544a\u8b66\uff1a" + cpuTemperatures.getHostname() + remark;
                String commContent = "\u4e3b\u6a5f\uff1a" + cpuTemperatures.getHostname() + remark + "\uff0cCPU\u7576\u524d\u6eab\u5ea6\u70ba" + cpuTemperatures.getInput() + "\uff0c\u8d85\u904e\u544a\u8b66\u503c" + cpuTemperatureWarnVal + "\u2103";
                String account = WarnMailUtil.getAccount((String)cpuTemperatures.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)cpuTemperatures.getHostname(), (String)""), (String)cpuTemperatures.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001CPU\u6eab\u5ea6\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001CPU\u6eab\u5ea6\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendDiskIoSpeedWarnInfo(DiskIoState diskIoState) {
        String key = diskIoState.getHostname() + "_diskIoSpeed";
        boolean sign = WarnMailUtil.preWarnInit((String)diskIoState.getHostname(), (String)mailConfig.getDiskIoSpeedWarnMail(), (String)key);
        if (!sign) {
            return false;
        }
        Double diskIoSpeedWarnVal = mailConfig.getDiskIoSpeedWarnVal();
        String warnLevel = levelConfig.getDiskWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(diskIoState.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getDiskIoSpeedWarnMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (null != hostWarnDiyDto.getDiskIoSpeedWarnVal()) {
                diskIoSpeedWarnVal = hostWarnDiyDto.getDiskIoSpeedWarnVal();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getDiskWarnLevel())) {
                warnLevel = hostWarnDiyDto.getDiskWarnLevel();
            }
        }
        Double readIoAvg = Double.valueOf(diskIoState.getReadIoAvg());
        Double writeIoAvg = Double.valueOf(diskIoState.getWriteIoAvg());
        if (readIoAvg >= diskIoSpeedWarnVal || writeIoAvg >= diskIoSpeedWarnVal) {
            try {
                String remark = HostUtil.addRemark((String)diskIoState.getHostname());
                String title = "\u78c1\u76e4IO\u8b80\u5beb\u901f\u7387\u544a\u8b66\uff1a" + diskIoState.getHostname() + remark;
                String centerMsg = "\uff0c";
                if (readIoAvg >= diskIoSpeedWarnVal) {
                    centerMsg = centerMsg + "\u7576\u524d\u78c1\u76e4IO\u8b80\u53d6\u901f\u7387" + readIoAvg + "MB/s\uff0c";
                }
                if (writeIoAvg >= diskIoSpeedWarnVal) {
                    centerMsg = centerMsg + "\u7576\u524d\u78c1\u76e4IO\u5beb\u5165\u901f\u7387" + writeIoAvg + "MB/s\uff0c";
                }
                String commContent = "\u4e3b\u6a5f\uff1a" + diskIoState.getHostname() + remark + centerMsg + "\u8d85\u904e\u544a\u8b66\u503c" + diskIoSpeedWarnVal + "MB/s";
                String account = WarnMailUtil.getAccount((String)diskIoState.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)true, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)diskIoState.getHostname(), (String)""), (String)diskIoState.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u4e3b\u6a5f\u78c1\u76e4IO\u8b80\u5beb\u901f\u7387\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u4e3b\u6a5f\u78c1\u76e4IO\u8b80\u5beb\u901f\u7387\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendHostDown(SystemInfo systemInfo, boolean isDown) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getHostDownWarnMail())) {
            return false;
        }
        String hostDownWarnCount = "";
        hostDownWarnCount = "\uff0c\u5df2\u9023\u7e8c" + mailConfig.getHostDownWarnCount() + "\u6b21\u672a\u4e0a\u5831\u6578\u64da";
        String warnLevel = levelConfig.getHostDownWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(systemInfo.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getHostDownWarnMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getHostDownWarnLevel())) {
                warnLevel = hostWarnDiyDto.getHostDownWarnLevel();
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getHostDownWarnCount())) {
                hostDownWarnCount = "\uff0c\u5df2\u9023\u7e8c" + hostWarnDiyDto.getHostDownWarnCount() + "\u6b21\u672a\u4e0a\u5831\u6578\u64da";
            }
        }
        String key = systemInfo.getId();
        String remark = HostUtil.addRemark((String)systemInfo.getHostname());
        if (isDown) {
            if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                return false;
            }
            try {
                String title = "\u4e3b\u6a5f\u4e0b\u7dda\u544a\u8b66\uff1a" + systemInfo.getHostname() + remark;
                String commContent = "\u4e3b\u6a5f\u53ef\u80fd\u5df2\u4e0b\u7dda\uff1a" + systemInfo.getHostname() + remark + hostDownWarnCount;
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)systemInfo.getAccount(), (String)key, (boolean)isDown, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)systemInfo.getHostname(), (String)""), (String)systemInfo.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u4e3b\u6a5f\u4e0b\u7dda\u544a\u8b66\u90f5\u4ef6\u5931\u6557", (Throwable)e);
                logInfoService.save("\u767c\u9001\u4e3b\u6a5f\u4e0b\u7dda\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        } else {
            try {
                String title = "\u4e3b\u6a5f\u5df2\u6062\u5fa9\u4e0a\u7dda\uff1a" + systemInfo.getHostname() + remark;
                String commContent = "\u4e3b\u6a5f\u5df2\u6062\u5fa9\u4e0a\u7dda\uff1a" + systemInfo.getHostname() + remark;
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)systemInfo.getAccount(), (String)key, (boolean)isDown, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)systemInfo.getHostname(), (String)""), (String)systemInfo.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u4e3b\u6a5f\u6062\u5fa9\u4e0a\u7dda\u901a\u77e5\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u4e3b\u6a5f\u6062\u5fa9\u4e0a\u7dda\u901a\u77e5\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendAppDown(AppInfo appInfo, boolean isDown) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getAppDownWarnMail())) {
            return false;
        }
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(appInfo.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive()) && "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
            return false;
        }
        String key = appInfo.getId();
        String remark = HostUtil.addRemark((String)appInfo.getHostname());
        if (isDown) {
            if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                return false;
            }
            try {
                String title = "\u9032\u7a0b\u4e0b\u7dda\u544a\u8b66\uff1a" + appInfo.getAppName() + "\uff0c" + appInfo.getHostname() + remark;
                String commContent = "\u9032\u7a0b\u53ef\u80fd\u5df2\u4e0b\u7dda\uff1a" + appInfo.getHostname() + remark + "\uff0c\u9032\u7a0b\uff1a" + appInfo.getAppName();
                String account = WarnMailUtil.getAccount((String)appInfo.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)appInfo.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)appInfo.getHostname(), (String)appInfo.getGroupId()), (String)appInfo.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u9032\u7a0b\u4e0b\u7dda\u544a\u8b66\u90f5\u4ef6\u5931\u6557\uff1a", (Throwable)e);
                logInfoService.save("\u767c\u9001\u9032\u7a0b\u4e0b\u7dda\u544a\u8b66\u932f\u8aa4", e.toString(), "1");
            }
        } else {
            try {
                String title = "\u9032\u7a0b\u5df2\u6062\u5fa9\u4e0a\u7dda\uff1a" + appInfo.getAppName() + "\uff0c" + appInfo.getHostname() + remark;
                String commContent = "\u9032\u7a0b\u5df2\u6062\u5fa9\u4e0a\u7dda\uff1a" + appInfo.getHostname() + remark + "\uff0c\u9032\u7a0b\uff1a" + appInfo.getAppName();
                String account = WarnMailUtil.getAccount((String)appInfo.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)appInfo.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)appInfo.getHostname(), (String)appInfo.getGroupId()), (String)appInfo.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u9032\u7a0b\u6062\u5fa9\u4e0a\u7dda\u901a\u77e5\u90f5\u4ef6\u5931\u6557", (Throwable)e);
                logInfoService.save("\u767c\u9001\u9032\u7a0b\u6062\u5fa9\u4e0a\u7dda\u901a\u77e5\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendDockerDown(DockerInfo dockerInfo, boolean isDown) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getDockerDownWarnMail())) {
            return false;
        }
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(dockerInfo.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive()) && "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
            return false;
        }
        String key = dockerInfo.getId();
        String remark = HostUtil.addRemark((String)dockerInfo.getHostname());
        String dockerTypeStr = "CONTAINER ID";
        if ("2".equals(dockerInfo.getAppType())) {
            dockerTypeStr = "CONTAINER NAME";
        }
        if (isDown) {
            if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                return false;
            }
            try {
                String title = "docker\u4e0b\u7dda\u544a\u8b66\uff1a" + dockerInfo.getDockerName() + "\uff0c" + dockerInfo.getHostname() + remark;
                String commContent = "docker\u53ef\u80fd\u5df2\u4e0b\u7dda\uff1a" + dockerInfo.getHostname() + remark + "\uff0c\u540d\u7a31\uff1a" + dockerInfo.getDockerName() + "\uff0c" + dockerTypeStr + "\uff1a" + dockerInfo.getDockerId();
                String account = WarnMailUtil.getAccount((String)dockerInfo.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)dockerInfo.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)dockerInfo.getHostname(), (String)dockerInfo.getGroupId()), (String)dockerInfo.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001docker\u4e0b\u7dda\u544a\u8b66\u90f5\u4ef6\u5931\u6557\uff1a", (Throwable)e);
                logInfoService.save("\u767c\u9001docker\u4e0b\u7dda\u544a\u8b66\u932f\u8aa4", e.toString(), "1");
            }
        } else {
            WarnPools.MEM_WARN_MAP.remove((Object)key);
            try {
                String title = "docker\u5df2\u6062\u5fa9\u4e0a\u7dda\uff1a" + dockerInfo.getDockerName() + "\uff0c" + dockerInfo.getHostname() + remark;
                String commContent = "docker\u5df2\u6062\u5fa9\u4e0a\u7dda\uff1a" + dockerInfo.getHostname() + remark + "\uff0c\u540d\u7a31\uff1a" + dockerInfo.getDockerName() + "\uff0c" + dockerTypeStr + "\uff1a" + dockerInfo.getDockerId();
                String account = WarnMailUtil.getAccount((String)dockerInfo.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)dockerInfo.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)dockerInfo.getHostname(), (String)dockerInfo.getGroupId()), (String)dockerInfo.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001docker\u5df2\u6062\u5fa9\u4e0a\u7dda\u90f5\u4ef6\u5931\u6557", (Throwable)e);
                logInfoService.save("\u767c\u9001docker\u5df2\u6062\u5fa9\u4e0a\u7dda\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendPortDown(PortInfo portInfo, boolean isDown) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getPortWarnMail())) {
            return false;
        }
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(portInfo.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive()) && "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
            return false;
        }
        String key = portInfo.getId();
        String remark = HostUtil.addRemark((String)portInfo.getHostname());
        String telnetIp = portInfo.getTelnetIp();
        if (!StringUtils.isEmpty((CharSequence)telnetIp) && telnetIp.length() > 50) {
            telnetIp = telnetIp.substring(0, 50);
        }
        if (isDown) {
            if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                return false;
            }
            if (!WarnMailUtil.isOutWarnCount((String)key, (Integer)mailConfig.getPortWarnCount())) {
                logger.info(portInfo.getHostname() + "---\u7aef\u53e3\u76e3\u63a7\u5931\u6557\u6c92\u6709\u9054\u5230\u544a\u8b66\u6b21\u6578---" + WarnPools.HOST_WARN_COUNT_MAP.get((Object)key));
                return false;
            }
            try {
                String title = "\u7aef\u53e3telnet\u4e0d\u901a\u544a\u8b66\uff1a" + portInfo.getPortName() + "\uff0ctelnet-" + telnetIp + "-" + portInfo.getPort() + "\uff0c" + portInfo.getHostname() + remark;
                String commContent = "\u7aef\u53e3\u5df2\u9023\u7e8c" + mailConfig.getPortWarnCount() + "\u6b21telnet\u4e0d\u901a\uff0c\u540d\u7a31\uff1a" + portInfo.getPortName() + "\uff0ctelnet-" + telnetIp + "-" + portInfo.getPort() + "\uff0c\u76e3\u63a7\u4e3b\u6a5f\uff1a" + portInfo.getHostname() + remark;
                String account = WarnMailUtil.getAccount((String)portInfo.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)portInfo.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)portInfo.getHostname(), (String)portInfo.getGroupId()), (String)portInfo.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u7aef\u53e3telnet\u4e0d\u901a\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4\uff1a", (Throwable)e);
                logInfoService.save("\u767c\u9001\u7aef\u53e3telnet\u4e0d\u901a\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        } else {
            WarnPools.MEM_WARN_MAP.remove((Object)key);
            try {
                String title = "\u7aef\u53e3\u5df2\u6062\u5fa9\u4e0a\u7dda\uff1a" + portInfo.getPortName() + "\uff0ctelnet-" + telnetIp + "-" + portInfo.getPort() + "\uff0c" + portInfo.getHostname() + remark;
                String commContent = "\u7aef\u53e3\u5df2\u6062\u5fa9\u4e0a\u7dda\uff0c\u540d\u7a31\uff1a" + portInfo.getPortName() + "\uff0ctelnet-" + telnetIp + "-" + portInfo.getPort() + "\uff0c\u76e3\u63a7\u4e3b\u6a5f\uff1a" + portInfo.getHostname() + remark;
                String account = WarnMailUtil.getAccount((String)portInfo.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)portInfo.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)portInfo.getHostname(), (String)portInfo.getGroupId()), (String)portInfo.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u7aef\u53e3telnet\u5df2\u6062\u5fa9\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u7aef\u53e3telnet\u5df2\u6062\u5fa9\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendFileSafeDown(FileSafe fileSafe, boolean isDown, String errorFileCount) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getFileSafeWarnMail())) {
            return false;
        }
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(fileSafe.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive()) && "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
            return false;
        }
        String key = fileSafe.getId();
        String remark = HostUtil.addRemark((String)fileSafe.getHostname());
        String errorFileCountStr = "";
        if (null != errorFileCount) {
            errorFileCountStr = "\uff0c" + errorFileCount;
        }
        if (isDown) {
            if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                return false;
            }
            try {
                String title = "\u6587\u4ef6\u9632\u7be1\u6539\u76e3\u6e2c\u544a\u8b66\uff1a" + fileSafe.getFileName() + "\uff0c" + fileSafe.getHostname() + remark;
                String commContent = "\u6587\u4ef6\u9632\u7be1\u6539\u76e3\u6e2c\u7570\u5e38\uff1a" + fileSafe.getHostname() + remark + "\uff0c\u6587\u4ef6\uff1a" + fileSafe.getFileName() + "\uff0c\u6587\u4ef6\u8def\u5f91\uff1a" + fileSafe.getFilePath() + "\uff0c\u6587\u4ef6\u6700\u5f8c\u4fee\u6539\u6642\u9593\uff1a" + fileSafe.getFileModtime() + errorFileCountStr;
                String account = WarnMailUtil.getAccount((String)fileSafe.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)fileSafe.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)fileSafe.getHostname(), (String)fileSafe.getGroupId()), (String)fileSafe.getHostname());
            }
            catch (Exception e) {
                logger.error("\u6587\u4ef6\u9632\u7be1\u6539\u76e3\u6e2c\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4\uff1a", (Throwable)e);
                logInfoService.save("\u6587\u4ef6\u9632\u7be1\u6539\u76e3\u6e2c\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        } else {
            WarnPools.MEM_WARN_MAP.remove((Object)key);
            try {
                String title = "\u6587\u4ef6\u9632\u7be1\u6539\u76e3\u6e2c\u5df2\u6062\u5fa9\uff1a" + fileSafe.getFileName() + "\uff0c" + fileSafe.getHostname() + remark;
                String commContent = "\u6587\u4ef6\u9632\u7be1\u6539\u76e3\u6e2c\u5df2\u6062\u5fa9\uff1a" + fileSafe.getHostname() + remark + "\uff0c\u6587\u4ef6\uff1a" + fileSafe.getFileName() + "\uff0c\u6587\u4ef6\u8def\u5f91\uff1a" + fileSafe.getFilePath() + "\uff0c\u6587\u4ef6\u6700\u5f8c\u4fee\u6539\u6642\u9593\uff1a" + fileSafe.getFileModtime();
                String account = WarnMailUtil.getAccount((String)fileSafe.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)fileSafe.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)fileSafe.getHostname(), (String)fileSafe.getGroupId()), (String)fileSafe.getHostname());
            }
            catch (Exception e) {
                logger.error("\u6587\u4ef6\u9632\u7be1\u6539\u76e3\u6e2c\u5df2\u6062\u5fa9\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u6587\u4ef6\u9632\u7be1\u6539\u76e3\u6e2c\u5df2\u6062\u5fa9\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendCustomInfoDown(CustomInfo customInfo, boolean isDown) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getCustomInfoWarnMail())) {
            return false;
        }
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(customInfo.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive()) && "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
            return false;
        }
        String key = customInfo.getId();
        String remark = HostUtil.addRemark((String)customInfo.getHostname());
        try {
            if (isDown) {
                if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                    return false;
                }
                String title = "\u81ea\u5b9a\u7fa9\u76e3\u63a7\u9805\u544a\u8b66\uff1a" + customInfo.getCustomName() + "\uff0c" + customInfo.getHostname() + remark;
                String commContent = "\u81ea\u5b9a\u7fa9\u76e3\u63a7\u9805\u544a\u8b66\uff1a" + customInfo.getHostname() + remark + "\uff0c" + customInfo.getCustomName() + "\uff0c\u544a\u8b66\u8868\u9054\u5f0f\u6210\u7acb\uff1a" + customInfo.getResultExp() + "\uff0cresult\u7576\u524d\u503c\u70ba\uff1a" + customInfo.getCustomValue();
                String account = WarnMailUtil.getAccount((String)customInfo.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)true, (String)customInfo.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)customInfo.getHostname(), (String)customInfo.getGroupId()), (String)customInfo.getHostname());
            } else {
                WarnPools.MEM_WARN_MAP.remove((Object)key);
                String title = "\u81ea\u5b9a\u7fa9\u76e3\u63a7\u9805\u5df2\u6062\u5fa9\uff1a" + customInfo.getCustomName() + "\uff0c" + customInfo.getHostname() + remark;
                String commContent = "\u81ea\u5b9a\u7fa9\u76e3\u63a7\u9805\u5df2\u6062\u5fa9\uff1a" + customInfo.getHostname() + remark + "\uff0c" + customInfo.getCustomName() + "\uff0c\u544a\u8b66\u8868\u9054\u5f0f\u4e0d\u6210\u7acb\uff1a" + customInfo.getResultExp() + "\uff0cresult\u7576\u524d\u503c\u70ba\uff1a" + customInfo.getCustomValue();
                String account = WarnMailUtil.getAccount((String)customInfo.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)customInfo.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)customInfo.getHostname(), (String)customInfo.getGroupId()), (String)customInfo.getHostname());
            }
        }
        catch (Exception e) {
            logger.error("\u767c\u9001\u81ea\u5b9a\u7fa9\u76e3\u63a7\u9805\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
            logInfoService.save("\u767c\u9001\u81ea\u5b9a\u7fa9\u76e3\u63a7\u9805\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
        }
        return false;
    }

    public static boolean sendHostMacInfoDown(String bindIp, String delMacAddress) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getMacInfoWarnMail())) {
            return false;
        }
        String remark = HostUtil.addRemark((String)bindIp);
        try {
            String title = "\u4e3b\u6a5fMAC\u5730\u5740\u8b8a\u5316\u544a\u8b66\uff1a" + bindIp + remark;
            String commContent = "\u4e3b\u6a5fMAC\u5730\u5740\u8b8a\u5316\u544a\u8b66\uff1a" + bindIp + remark + "\uff0c\u4e1f\u5931\u7684MAC\u5730\u5740\u5305\u62ec\uff1a" + delMacAddress;
            String account = WarnMailUtil.getAccount((String)bindIp);
            WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)"", (boolean)true, (String)"WARN", (String)WarnMailUtil.getHostGroups((String)bindIp, (String)""), (String)bindIp);
        }
        catch (Exception e) {
            logger.error("\u767c\u9001mac\u5730\u5740\u8b8a\u5316\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
            logInfoService.save("\u767c\u9001mac\u5730\u5740\u8b8a\u5316\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
        }
        return false;
    }

    public static boolean sendFileWarnDown(FileWarnInfo fileWarnInfo, String filePath, String warnContent, boolean isDown) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getFileLogWarnMail())) {
            return false;
        }
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(fileWarnInfo.getHostname());
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive()) && "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
            return false;
        }
        String key = fileWarnInfo.getId();
        String remark = HostUtil.addRemark((String)fileWarnInfo.getHostname());
        String fileRemark = "";
        if (!StringUtils.isEmpty((CharSequence)fileWarnInfo.getRemark())) {
            fileRemark = fileWarnInfo.getRemark();
        }
        if (isDown) {
            try {
                String title = "\u65e5\u8a8c\u76e3\u63a7\u544a\u8b66\uff1a" + fileWarnInfo.getHostname() + remark;
                String commContent = "\u65e5\u8a8c\u76e3\u63a7\u544a\u8b66\uff1a" + fileWarnInfo.getHostname() + remark + "\uff0c\u65e5\u8a8c\u5099\u8a3b\uff1a" + fileRemark + "\uff0c\u65e5\u8a8c\u6587\u4ef6\uff1a" + filePath + "\uff0c" + warnContent;
                String account = WarnMailUtil.getAccount((String)fileWarnInfo.getHostname());
                WarnMailUtil.sendUtil((String)title, (String)commContent, (String)account, (String)"", (boolean)false, (String)fileWarnInfo.getWarnLevel(), (String)WarnMailUtil.getHostGroups((String)fileWarnInfo.getHostname(), (String)""), (String)fileWarnInfo.getHostname());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u65e5\u8a8c\u76e3\u63a7\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u65e5\u8a8c\u76e3\u63a7\u544a\u8b66\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static String getAccount(String hostname) {
        if ("true".equals(commonConfig.getUserInfoManage()) && !StringUtils.isEmpty((CharSequence)hostname)) {
            return (String)StaticKeys.HOST_ACCOUNT_MAP.get(hostname);
        }
        return "";
    }

    public static void sendUtil(String title, String commContent, String account, String key, boolean isDown, String warnLevel, String groupIds, String hostName) {
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(hostName);
        if (!(null == hostWarnDiyDto || !"1".equals(hostWarnDiyDto.getActive()) || StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getCustomWarnMail()) && StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getCustomWarnAccountKey()))) {
            WarnOtherUtil.sendUtilToCustomMail((String)title, (String)commContent, (String)hostWarnDiyDto.getCustomWarnMail(), (String)hostWarnDiyDto.getCustomWarnAccountKey(), (String)key, (boolean)isDown, (String)warnLevel, (String)groupIds);
            return;
        }
        WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)warnLevel, (String)groupIds);
    }

    public static String getHostGroups(String bindIp, String childGroupId) {
        if (!StringUtils.isEmpty((CharSequence)childGroupId)) {
            return childGroupId;
        }
        try {
            SystemInfo systemInfo = systemInfoService.selectByHostname(bindIp);
            if (null != systemInfo) {
                return systemInfo.getGroupId();
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8a62\u4e3b\u6a5f\u6a19\u7c64\u932f\u8aa4", (Throwable)e);
        }
        return "";
    }

    private static boolean isOutWarnCount(String key, Integer warnCount) {
        if (WarnPools.HOST_WARN_COUNT_MAP.get((Object)key) == null) {
            WarnPools.HOST_WARN_COUNT_MAP.put((Object)key, (Object)1);
        } else {
            WarnPools.HOST_WARN_COUNT_MAP.put((Object)key, (Object)((Integer)WarnPools.HOST_WARN_COUNT_MAP.get((Object)key) + 1));
        }
        return (Integer)WarnPools.HOST_WARN_COUNT_MAP.get((Object)key) >= warnCount;
    }
}

