/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util.msg;

import com.sun.mail.util.MailSSLSocketFactory;
import com.wgcloud.common.ApplicationContextHelper;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.config.LevelConfig;
import com.wgcloud.config.MailConfig;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.entity.DbInfo;
import com.wgcloud.entity.DbTable;
import com.wgcloud.entity.DceInfo;
import com.wgcloud.entity.FtpInfo;
import com.wgcloud.entity.HeathMonitor;
import com.wgcloud.entity.HostWarnDiy;
import com.wgcloud.entity.MailSet;
import com.wgcloud.entity.ShellInfo;
import com.wgcloud.entity.SnmpDeepInfo;
import com.wgcloud.entity.SnmpInfo;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.ExecUtil;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.msg.WarnMailUtil;
import com.wgcloud.util.msg.WarnPools;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.HtmlEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class WarnOtherUtil {
    private static final Logger logger = LoggerFactory.getLogger(WarnMailUtil.class);
    private static CommonConfig commonConfig = (CommonConfig)ApplicationContextHelper.getBean(CommonConfig.class);
    private static LogInfoService logInfoService = (LogInfoService)ApplicationContextHelper.getBean(LogInfoService.class);
    private static MailConfig mailConfig = (MailConfig)ApplicationContextHelper.getBean(MailConfig.class);
    private static LevelConfig levelConfig = (LevelConfig)ApplicationContextHelper.getBean(LevelConfig.class);
    private static HostGroupService hostGroupService = (HostGroupService)ApplicationContextHelper.getBean(HostGroupService.class);

    public static boolean sendHeathInfo(HeathMonitor heathMonitor, boolean isDown) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getHeathWarnMail())) {
            return false;
        }
        String key = heathMonitor.getId();
        if (isDown) {
            if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                return false;
            }
            try {
                if (WarnPools.HEATH_WARN_COUNT_MAP.get((Object)key) == null) {
                    WarnPools.HEATH_WARN_COUNT_MAP.put((Object)key, (Object)1);
                } else {
                    WarnPools.HEATH_WARN_COUNT_MAP.put((Object)key, (Object)((Integer)WarnPools.HEATH_WARN_COUNT_MAP.get((Object)key) + 1));
                }
                if ((Integer)WarnPools.HEATH_WARN_COUNT_MAP.get((Object)key) < mailConfig.getHeathWarnCount()) {
                    logger.info(heathMonitor.getAppName() + "---\u670d\u52d9\u63a5\u53e3\u6c92\u6709\u9054\u5230\u544a\u8b66\u6b21\u6578---" + WarnPools.HEATH_WARN_COUNT_MAP.get((Object)key));
                    return false;
                }
                String testErrorMsg = "";
                if (!StringUtils.isEmpty((CharSequence)heathMonitor.getErrorMsg())) {
                    testErrorMsg = "\uff0c" + heathMonitor.getErrorMsg();
                }
                String title = "\u670d\u52d9\u63a5\u53e3\u6aa2\u6e2c\u544a\u8b66\uff1a" + heathMonitor.getAppName();
                String commContent = "\u670d\u52d9\u63a5\u53e3\u5df2\u9023\u7e8c" + mailConfig.getHeathWarnCount() + "\u6b21\u6aa2\u6e2c\u5931\u6557\uff1a" + heathMonitor.getAppName() + "\uff0curl\uff1a" + heathMonitor.getHeathUrl() + "\uff0c\u97ff\u61c9\u72c0\u614b\u78bc\u70ba" + heathMonitor.getHeathStatus() + testErrorMsg;
                WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)heathMonitor.getAccount(), (String)key, (boolean)isDown, (String)heathMonitor.getWarnLevel(), (String)heathMonitor.getGroupId());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u670d\u52d9\u63a5\u53e3\u6aa2\u6e2c\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u670d\u52d9\u63a5\u53e3\u6aa2\u6e2c\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        } else {
            try {
                String title = "\u670d\u52d9\u63a5\u53e3\u5df2\u6062\u5fa9\uff1a" + heathMonitor.getAppName();
                String commContent = "\u670d\u52d9\u63a5\u53e3\u5df2\u6062\u5fa9\uff1a" + heathMonitor.getAppName() + "\uff0curl\uff1a" + heathMonitor.getHeathUrl() + "\uff0c\u97ff\u61c9\u72c0\u614b\u78bc\u70ba" + heathMonitor.getHeathStatus() + "";
                WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)heathMonitor.getAccount(), (String)key, (boolean)isDown, (String)heathMonitor.getWarnLevel(), (String)heathMonitor.getGroupId());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u670d\u52d9\u63a5\u53e3\u5df2\u6062\u5fa9\u90f5\u4ef6\u932f\u8aa4\uff1a", (Throwable)e);
                logInfoService.save("\u767c\u9001\u670d\u52d9\u63a5\u53e3\u5df2\u6062\u5fa9\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendDceInfo(DceInfo dceInfo, boolean isDown) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getDceWarnMail())) {
            return false;
        }
        String key = dceInfo.getId();
        String remark = dceInfo.getRemark();
        remark = StringUtils.isEmpty((CharSequence)remark) ? "" : "(" + dceInfo.getRemark() + ")";
        if (isDown) {
            if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                return false;
            }
            try {
                if (WarnPools.PING_WARN_COUNT_MAP.get((Object)key) == null) {
                    WarnPools.PING_WARN_COUNT_MAP.put((Object)key, (Object)1);
                } else {
                    WarnPools.PING_WARN_COUNT_MAP.put((Object)key, (Object)((Integer)WarnPools.PING_WARN_COUNT_MAP.get((Object)key) + 1));
                }
                if ((Integer)WarnPools.PING_WARN_COUNT_MAP.get((Object)key) < mailConfig.getDceWarnCount()) {
                    logger.info(dceInfo.getHostname() + "---\u7db2\u7d61\u8a2d\u5099PING\u8d85\u6642\u6c92\u6709\u9054\u5230\u544a\u8b66\u6b21\u6578---" + WarnPools.PING_WARN_COUNT_MAP.get((Object)key));
                    return false;
                }
                String title = "PING\u8d85\u6642\u544a\u8b66\uff1a" + dceInfo.getHostname() + remark;
                String commContent = "\u7db2\u7d61\u8a2d\u5099\u5df2\u9023\u7e8c" + mailConfig.getDceWarnCount() + "\u6b21PING\u6aa2\u6e2c\u8d85\u6642\u6216\u5931\u6557\uff1a" + dceInfo.getHostname() + remark;
                WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)dceInfo.getAccount(), (String)key, (boolean)isDown, (String)dceInfo.getWarnLevel(), (String)dceInfo.getGroupId());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u7db2\u7d61\u8a2d\u5099PING\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u7db2\u7d61\u8a2d\u5099PING\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        } else {
            try {
                String title = "PING\u5df2\u6062\u5fa9\uff1a" + dceInfo.getHostname() + remark;
                String commContent = "\u7db2\u7d61\u8a2d\u5099PING\u5df2\u6062\u5fa9\uff1a" + dceInfo.getHostname() + remark + "\uff0c\u97ff\u61c9\u6642\u9593ms\uff1a" + dceInfo.getResTimes();
                WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)dceInfo.getAccount(), (String)key, (boolean)isDown, (String)dceInfo.getWarnLevel(), (String)dceInfo.getGroupId());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u7db2\u7d61\u8a2d\u5099PING\u5df2\u6062\u5fa9\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u7db2\u7d61\u8a2d\u5099PING\u5df2\u6062\u5fa9\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendSnmpInfo(SnmpInfo snmpInfo, boolean isDown) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getSnmpWarnMail())) {
            return false;
        }
        String key = snmpInfo.getId();
        String remark = snmpInfo.getRemark();
        remark = StringUtils.isEmpty((CharSequence)remark) ? "" : "(" + snmpInfo.getRemark() + ")";
        if (isDown) {
            if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                return false;
            }
            try {
                if (WarnPools.SNMP_WARN_COUNT_MAP.get((Object)key) == null) {
                    WarnPools.SNMP_WARN_COUNT_MAP.put((Object)key, (Object)1);
                } else {
                    WarnPools.SNMP_WARN_COUNT_MAP.put((Object)key, (Object)((Integer)WarnPools.SNMP_WARN_COUNT_MAP.get((Object)key) + 1));
                }
                if ((Integer)WarnPools.SNMP_WARN_COUNT_MAP.get((Object)key) < mailConfig.getSnmpWarnCount()) {
                    logger.info(snmpInfo.getHostname() + "---\u7db2\u7d61\u8a2d\u5099SNMP\u8d85\u6642\u6c92\u6709\u9054\u5230\u544a\u8b66\u6b21\u6578---" + WarnPools.SNMP_WARN_COUNT_MAP.get((Object)key));
                    return false;
                }
                String title = "SNMP\u8a2d\u5099\u76e3\u6e2c\u544a\u8b66\uff1a" + snmpInfo.getHostname() + remark;
                String commContent = "SNMP\u8a2d\u5099\uff1a" + snmpInfo.getHostname() + remark + "\uff0c\u5df2\u9023\u7e8c" + mailConfig.getSnmpWarnCount() + "\u6b21PING\u6aa2\u6e2c\u8d85\u6642\u6216\u5931\u6557";
                WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)snmpInfo.getAccount(), (String)key, (boolean)isDown, (String)snmpInfo.getWarnLevel(), (String)snmpInfo.getGroupId());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001snmp\u8a2d\u5099\u76e3\u6e2c\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001snmp\u8a2d\u5099\u76e3\u6e2c\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        } else {
            try {
                String title = "SNMP\u8a2d\u5099\u76e3\u6e2c\u5df2\u6062\u5fa9\uff1a" + snmpInfo.getHostname() + remark;
                String commContent = "SNMP\u8a2d\u5099\u76e3\u6e2c\u5df2\u6062\u5fa9\uff1a" + snmpInfo.getHostname() + remark;
                WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)snmpInfo.getAccount(), (String)key, (boolean)isDown, (String)snmpInfo.getWarnLevel(), (String)snmpInfo.getGroupId());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001snmp\u8a2d\u5099\u76e3\u6e2c\u5df2\u6062\u5fa9\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001snmp\u8a2d\u5099\u76e3\u6e2c\u5df2\u6062\u5fa9\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendSnmpDeepInfo(SnmpDeepInfo snmpInfo, boolean isDown) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getSnmpWarnMail())) {
            return false;
        }
        String key = snmpInfo.getId();
        String remark = snmpInfo.getRemark();
        remark = StringUtils.isEmpty((CharSequence)remark) ? "" : "(" + snmpInfo.getRemark() + ")";
        if (isDown) {
            if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                return false;
            }
            try {
                if (WarnPools.SNMP_WARN_COUNT_MAP.get((Object)key) == null) {
                    WarnPools.SNMP_WARN_COUNT_MAP.put((Object)key, (Object)1);
                } else {
                    WarnPools.SNMP_WARN_COUNT_MAP.put((Object)key, (Object)((Integer)WarnPools.SNMP_WARN_COUNT_MAP.get((Object)key) + 1));
                }
                if ((Integer)WarnPools.SNMP_WARN_COUNT_MAP.get((Object)key) < mailConfig.getSnmpWarnCount()) {
                    logger.info(snmpInfo.getHostname() + "---\u7db2\u7d61\u8a2d\u5099SNMP\u6df1\u5ea6\u76e3\u63a7\u8d85\u6642\u6c92\u6709\u9054\u5230\u544a\u8b66\u6b21\u6578---" + WarnPools.SNMP_WARN_COUNT_MAP.get((Object)key));
                    return false;
                }
                String title = "SNMP\u8a2d\u5099\u6df1\u5ea6\u76e3\u6e2c\u544a\u8b66\uff1a" + snmpInfo.getHostname() + remark;
                String commContent = "SNMP\u8a2d\u5099\u6df1\u5ea6\u76e3\u6e2c\uff1a" + snmpInfo.getHostname() + remark + "\uff0c\u53ef\u80fd\u5df2\u4e0b\u7dda\uff0c\u5df2\u9023\u7e8c" + mailConfig.getSnmpWarnCount() + "\u6b21PING\u6aa2\u6e2c\u8d85\u6642\u6216\u5931\u6557";
                WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)snmpInfo.getAccount(), (String)key, (boolean)isDown, (String)snmpInfo.getWarnLevel(), (String)snmpInfo.getGroupId());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001snmp\u8a2d\u5099\u6df1\u5ea6\u76e3\u6e2c\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001snmp\u8a2d\u5099\u6df1\u5ea6\u76e3\u6e2c\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        } else {
            try {
                String title = "SNMP\u8a2d\u5099\u6df1\u5ea6\u76e3\u6e2c\u5df2\u6062\u5fa9\uff1a" + snmpInfo.getHostname() + remark;
                String commContent = "SNMP\u8a2d\u5099\u6df1\u5ea6\u76e3\u6e2c\u5df2\u6062\u5fa9\uff1a" + snmpInfo.getHostname() + remark;
                WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)snmpInfo.getAccount(), (String)key, (boolean)isDown, (String)snmpInfo.getWarnLevel(), (String)snmpInfo.getGroupId());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001snmp\u8a2d\u5099\u6df1\u5ea6\u76e3\u6e2c\u5df2\u6062\u5fa9\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001snmp\u8a2d\u5099\u6df1\u5ea6\u76e3\u6e2c\u5df2\u6062\u5fa9\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendDbDown(DbInfo dbInfo, boolean isDown) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getDbDownWarnMail())) {
            return false;
        }
        String key = dbInfo.getId();
        if (isDown) {
            if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                return false;
            }
            try {
                String title = "\u6578\u64da\u5eab\u9023\u63a5\u5931\u6557\u544a\u8b66\uff1a" + dbInfo.getAliasName();
                String commContent = "\u6578\u64da\u5eab\u9023\u63a5\u5931\u6557\uff1a" + dbInfo.getAliasName();
                WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)dbInfo.getAccount(), (String)key, (boolean)isDown, (String)dbInfo.getWarnLevel(), (String)dbInfo.getGroupId());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u6578\u64da\u5eab\u9023\u63a5\u5931\u6557\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u6578\u64da\u5eab\u9023\u63a5\u5931\u6557\u544a\u8b66\u932f\u8aa4", e.toString(), "1");
            }
        } else if (null != WarnPools.MEM_WARN_MAP.get((Object)key)) {
            WarnPools.MEM_WARN_MAP.remove((Object)key);
            try {
                String title = "\u6578\u64da\u5eab\u5df2\u6062\u5fa9\u4e0a\u7dda\uff1a" + dbInfo.getAliasName();
                String commContent = "\u6578\u64da\u5eab\u5df2\u6062\u5fa9\u4e0a\u7dda\uff1a" + dbInfo.getAliasName() + "\uff0c\u9023\u63a5\u7528\u6642" + dbInfo.getResTimes() + "ms";
                WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)dbInfo.getAccount(), (String)key, (boolean)isDown, (String)dbInfo.getWarnLevel(), (String)dbInfo.getGroupId());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u6578\u64da\u5eab\u5df2\u6062\u5fa9\u4e0a\u7dda\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u6578\u64da\u5eab\u5df2\u6062\u5fa9\u4e0a\u7dda\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendDbTableDown(DbTable dbTable, String account, Boolean result) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getDbDownWarnMail())) {
            return false;
        }
        String key = dbTable.getId();
        try {
            if (!result.booleanValue() && null != WarnPools.MEM_WARN_MAP.get((Object)key)) {
                String title = "\u6578\u64da\u8868\u5df2\u6062\u5fa9\uff1a" + dbTable.getRemark();
                String commContent = "\u6578\u64da\u8868\u5df2\u6062\u5fa9\uff1a" + dbTable.getRemark() + "\uff0c\u544a\u8b66\u8868\u9054\u5f0f\u4e0d\u6210\u7acb\uff1a" + dbTable.getResultExp() + "\uff0cresult\u7576\u524d\u503c\u70ba\uff1a" + dbTable.getTableCount() + "\uff0cSQL\u57f7\u884c\u6642\u9593\u70ba" + dbTable.getResTimes() + "ms";
                WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)false, (String)dbTable.getWarnLevel(), (String)"");
                return false;
            }
            if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                return false;
            }
            if (result.booleanValue()) {
                String testErrorMsg = "";
                if (!StringUtils.isEmpty((CharSequence)dbTable.getTestErrorMsg())) {
                    testErrorMsg = "\uff0c" + dbTable.getTestErrorMsg();
                }
                String title = "\u6578\u64da\u8868\u544a\u8b66\uff1a" + dbTable.getRemark();
                String commContent = "\u6578\u64da\u8868\u544a\u8b66\uff1a" + dbTable.getRemark() + "\uff0c\u544a\u8b66\u8868\u9054\u5f0f\u6210\u7acb\uff1a" + dbTable.getResultExp() + "\uff0cresult\u7576\u524d\u503c\u70ba\uff1a" + dbTable.getTableCount() + "\uff0cSQL\u57f7\u884c\u6642\u9593\u70ba" + dbTable.getResTimes() + "ms" + testErrorMsg;
                WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)true, (String)dbTable.getWarnLevel(), (String)"");
            }
        }
        catch (Exception e) {
            logger.error("\u767c\u9001\u6578\u64da\u8868\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
            logInfoService.save("\u767c\u9001\u6578\u64da\u8868\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
        }
        return false;
    }

    public static boolean sendShellInfo(ShellInfo shellInfo, String titlePrefix, HttpServletRequest request) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getShellWarnMail())) {
            return false;
        }
        String continueDays = request.getParameter("continueDays");
        String suffixStr = "";
        if (!StringUtils.isEmpty((CharSequence)continueDays)) {
            suffixStr = "\uff0c\u6307\u4ee4\u5c07\u9023\u7e8c" + continueDays + "\u5929\u5728\u6b64\u6642\u9593\u9ede\u57f7\u884c";
        }
        try {
            String shellTime = "\u7acb\u5373\u4e0b\u767c";
            if ("2".equals(shellInfo.getShellType())) {
                shellTime = shellInfo.getShellTime();
            }
            String title = titlePrefix + "\uff1a" + shellInfo.getShellName();
            String commContent = titlePrefix + "\uff1a" + shellInfo.getShellName() + "\uff0c\u4e0b\u767c\u6642\u9593\uff1a" + shellTime + suffixStr;
            WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)shellInfo.getAccount(), (String)"", (boolean)false, (String)levelConfig.getShellWarn(), (String)"");
        }
        catch (Exception e) {
            logger.error("\u4e0b\u9aee\u6307\u4ee4\u4fe1\u606f\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
            logInfoService.save("\u4e0b\u9aee\u6307\u4ee4\u4fe1\u606f\u932f\u8aa4", e.toString(), "2");
        }
        return false;
    }

    public static boolean sendLastlogWarnInfo(String lastlogWarnInfos, String bindIp) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getHostLoginWarnMail())) {
            return false;
        }
        String warnLevel = levelConfig.getHostLoginWarn();
        HostWarnDiy hostWarnDiyDto = (HostWarnDiy)StaticKeys.HOST_WARN_MAP.get(bindIp);
        if (null != hostWarnDiyDto && "1".equals(hostWarnDiyDto.getActive())) {
            if ("no".equals(hostWarnDiyDto.getHostLoginWarnMail()) || "yes".equals(hostWarnDiyDto.getHostBlockAllWarn())) {
                return false;
            }
            if (!StringUtils.isEmpty((CharSequence)hostWarnDiyDto.getHostLoginWarnLevel())) {
                warnLevel = hostWarnDiyDto.getHostLoginWarnLevel();
            }
        }
        try {
            String remark = HostUtil.addRemark((String)bindIp);
            String title = "\u4e3b\u6a5f\u767b\u9304\u4fe1\u606f\u63d0\u9192\uff1a" + bindIp + remark;
            String commContent = "\u4e3b\u6a5f\u767b\u9304\u4fe1\u606f\u63d0\u9192\uff1a" + bindIp + remark + "\uff0c" + lastlogWarnInfos;
            WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)WarnMailUtil.getAccount((String)bindIp), (String)"", (boolean)false, (String)warnLevel, (String)WarnMailUtil.getHostGroups((String)bindIp, (String)""));
        }
        catch (Exception e) {
            logger.error("\u4e3b\u6a5f\u767b\u9304\u4fe1\u606f\u63d0\u9192\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
            logInfoService.save("\u4e3b\u6a5f\u767b\u9304\u4fe1\u606f\u63d0\u9192\u932f\u8aa4", e.toString(), "2");
        }
        return false;
    }

    public static boolean sendFtpInfo(FtpInfo ftpInfo, boolean isDown) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getFtpWarnMail())) {
            return false;
        }
        String key = ftpInfo.getId();
        if (isDown) {
            if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                return false;
            }
            try {
                String title = "FTP\u6aa2\u6e2c\u544a\u8b66\uff1a" + ftpInfo.getFtpName();
                String commContent = "FTP\u670d\u52d9\u9023\u63a5\u5931\u6557\uff1a" + ftpInfo.getFtpName() + "\uff0c" + ftpInfo.getFtpHost() + ":" + ftpInfo.getPort();
                WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)ftpInfo.getAccount(), (String)key, (boolean)isDown, (String)ftpInfo.getWarnLevel(), (String)ftpInfo.getGroupId());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001FTP\u6aa2\u6e2c\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001FTP\u6aa2\u6e2c\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        } else {
            try {
                String title = "FTP\u6aa2\u6e2c\u5df2\u6062\u5fa9\uff1a" + ftpInfo.getFtpName();
                String commContent = "FTP\u670d\u52d9\u9023\u63a5\u5df2\u6062\u5fa9\uff1a" + ftpInfo.getFtpName() + "\uff0c" + ftpInfo.getFtpHost() + ":" + ftpInfo.getPort() + "\uff0c\u97ff\u61c9\u6642\u9593\u70ba" + ftpInfo.getResTimes() + "ms";
                WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)ftpInfo.getAccount(), (String)key, (boolean)isDown, (String)ftpInfo.getWarnLevel(), (String)ftpInfo.getGroupId());
            }
            catch (Exception e) {
                logger.error("\u767c\u9001FTP\u5df2\u6062\u5fa9\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001FTP\u53e3\u5df2\u6062\u5fa9\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendMiddlewareInfo(String key, boolean isDown) {
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getMiddlewareWarnMail())) {
            return false;
        }
        String account = "";
        String warnLevel = "ERROR";
        String groupIds = "";
        if (isDown) {
            if (WarnPools.checkWarnCacheTimes((String)key, (Integer)commonConfig.getWarnCacheTimes())) {
                return false;
            }
            try {
                String title = "\u4e2d\u9593\u4ef6\u9023\u63a5\u5931\u6557\u544a\u8b66: " + key;
                String commContent = "\u4e2d\u9593\u4ef6\u9023\u63a5\u5931\u6557\u544a\u8b66: " + key;
                WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)warnLevel, (String)groupIds);
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u4e2d\u9593\u4ef6\u9023\u63a5\u5931\u6557\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u4e2d\u9593\u4ef6\u9023\u63a5\u5931\u6557\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        } else {
            try {
                if (null != WarnPools.MEM_WARN_MAP.get((Object)key)) {
                    String title = "\u4e2d\u9593\u4ef6\u9023\u63a5\u5df2\u6062\u5fa9\uff1a" + key;
                    String commContent = "\u4e2d\u9593\u4ef6\u9023\u63a5\u5df2\u6062\u5fa9\uff1a" + key;
                    WarnOtherUtil.sendUtil((String)title, (String)commContent, (String)account, (String)key, (boolean)isDown, (String)warnLevel, (String)groupIds);
                }
            }
            catch (Exception e) {
                logger.error("\u767c\u9001\u4e2d\u9593\u4ef6\u9023\u63a5\u5931\u6557\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
                logInfoService.save("\u767c\u9001\u4e2d\u9593\u4ef6\u9023\u63a5\u5931\u6557\u544a\u8b66\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            }
        }
        return false;
    }

    private static boolean sendUtilCheck() {
        if (!StaticKeys.WARN_CRON_TIME_SIGN) {
            logger.info("\u7576\u524d\u4e0d\u5728\u544a\u8b66\u6642\u9593\u6bb5\u5167\uff0c\u4e0d\u767c\u544a\u8b66\u901a\u77e5");
            return false;
        }
        if (!StaticKeys.WARN_LICENSE_CHECK_SIGN) {
            String cacheKey = "WARN_LICENSE_CHECK_SIGN_TRUE";
            if (!WarnPools.checkWarnCacheTimes((String)cacheKey, (Integer)commonConfig.getWarnCacheTimes())) {
                String licenseErrorMsg = "\u7576\u524d\u76e3\u63a7\u4e3b\u6a5f\u6578\u91cf\u5df2\u8d85\u904e\u5141\u8a31\u76e3\u63a7\u7684\u6578\u91cf\uff0c\u7cfb\u7d71\u5df2\u505c\u6b62\u767c\u9001\u544a\u8b66\uff0c\u8acb\u9069\u7576\u6e1b\u5c11\u4e3b\u6a5f\u6578\u91cf\u6216\u8005\u5347\u7d1a\u6388\u6b0a";
                logger.info(licenseErrorMsg);
                logInfoService.save(licenseErrorMsg, licenseErrorMsg, "2");
                WarnPools.MEM_WARN_MAP.put((Object)cacheKey, (Object)"1");
            }
            return false;
        }
        return true;
    }

    public static void sendUtil(String title, String commContent, String account, String key, boolean isDown, String warnLevel, String groupIds) {
        if (!WarnOtherUtil.sendUtilCheck()) {
            return;
        }
        WarnOtherUtil.saveToLog((String)title, (String)commContent, (String)warnLevel);
        if (!WarnOtherUtil.isSendByWarnLevel((String)warnLevel)) {
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)title) && title.indexOf("\u544a\u8b66") > -1) {
            WarnPools.WARN_COUNT_LIST.add(1);
        }
        String warnLevelName = WarnOtherUtil.getWarnLevelName((String)warnLevel);
        String groupsName = WarnOtherUtil.setGroupInList((String)groupIds);
        MailSet mailSet = StaticKeys.mailSet;
        String mailContentPrefix = WarnOtherUtil.getMailContentPrefix((String)warnLevelName, (String)groupsName);
        if (StringUtils.isEmpty((CharSequence)account) || !"true".equals(commonConfig.getUserInfoManage()) || !StaticKeys.LICENSE_STATE.equals("1")) {
            if (StaticKeys.mailSet != null) {
                WarnOtherUtil.sendMail((String)mailSet.getToMail(), (String)title, (String)(mailContentPrefix + commContent));
            }
            ExecUtil.runScript((String)commContent, (String)"", (String)warnLevelName, (String)groupsName, (String)title);
        } else if ("true".equals(commonConfig.getUserInfoManage())) {
            String accountMail = "";
            String accountKey = "";
            if (null != StaticKeys.ACCOUNT_INFO_MAP.get(account)) {
                accountMail = ((AccountInfo)StaticKeys.ACCOUNT_INFO_MAP.get(account)).getEmail();
                accountKey = ((AccountInfo)StaticKeys.ACCOUNT_INFO_MAP.get(account)).getAccountKey();
            }
            if (StaticKeys.mailSet != null) {
                String addMail = (StringUtils.isEmpty((CharSequence)accountMail) ? "" : ";") + accountMail;
                WarnOtherUtil.sendMail((String)(mailSet.getToMail() + addMail), (String)title, (String)(mailContentPrefix + commContent));
            }
            ExecUtil.runScript((String)commContent, (String)accountKey, (String)warnLevelName, (String)groupsName, (String)title);
        }
        if (!StringUtils.isEmpty((CharSequence)key)) {
            if (isDown) {
                WarnPools.MEM_WARN_MAP.put((Object)key, (Object)"1");
            } else {
                WarnPools.MEM_WARN_MAP.remove((Object)key);
            }
        }
    }

    public static void sendUtilToCustomMail(String title, String commContent, String customMail, String accountKey, String key, boolean isDown, String warnLevel, String groupIds) {
        if (!WarnOtherUtil.sendUtilCheck()) {
            return;
        }
        WarnOtherUtil.saveToLog((String)title, (String)commContent, (String)warnLevel);
        if (!WarnOtherUtil.isSendByWarnLevel((String)warnLevel)) {
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)title) && title.indexOf("\u544a\u8b66") > -1) {
            WarnPools.WARN_COUNT_LIST.add(1);
        }
        String warnLevelName = WarnOtherUtil.getWarnLevelName((String)warnLevel);
        String groupsName = WarnOtherUtil.setGroupInList((String)groupIds);
        String mailContentPrefix = WarnOtherUtil.getMailContentPrefix((String)warnLevelName, (String)groupsName);
        if (StaticKeys.mailSet != null) {
            if (!StringUtils.isEmpty((CharSequence)customMail)) {
                WarnOtherUtil.sendMail((String)customMail, (String)title, (String)(mailContentPrefix + commContent));
            } else {
                WarnOtherUtil.sendMail((String)StaticKeys.mailSet.getToMail(), (String)title, (String)(mailContentPrefix + commContent));
            }
        }
        ExecUtil.runScript((String)commContent, (String)accountKey, (String)warnLevelName, (String)groupsName, (String)title);
        if (!StringUtils.isEmpty((CharSequence)key)) {
            if (isDown) {
                WarnPools.MEM_WARN_MAP.put((Object)key, (Object)"1");
            } else {
                WarnPools.MEM_WARN_MAP.remove((Object)key);
            }
        }
    }

    private static void saveToLog(String title, String commContent, String warnLevel) {
        if (StringUtils.isEmpty((CharSequence)title)) {
            return;
        }
        String warnLevelName = "";
        if (!StringUtils.isEmpty((CharSequence)warnLevel)) {
            warnLevelName = "\u3010" + WarnOtherUtil.getWarnLevelName((String)warnLevel) + "\u3011";
        }
        if (title.startsWith("\u3010\u7b2c\u4e09\u65b9\u544a\u8b66\u3011")) {
            logInfoService.save(title, commContent, "4");
            return;
        }
        if (title.indexOf("\u5df2\u6062\u5fa9") > -1) {
            logInfoService.save(warnLevelName + title, commContent, "3");
        } else {
            logInfoService.save(warnLevelName + title, commContent, "1");
        }
    }

    public static String sendMail(String mails, String mailTitle, String mailContent) {
        if (StringUtils.isEmpty((CharSequence)mails)) {
            return "error";
        }
        if ("2".equals(StaticKeys.mailSet.getActive())) {
            return "error";
        }
        if (mails.startsWith(";")) {
            mails = mails.substring(1);
        }
        if ("true".equals(StaticKeys.mailSet.getJavaxMail())) {
            return WarnOtherUtil.sendMailByJavax((String)mails, (String)mailTitle, (String)mailContent);
        }
        try {
            String mailTitlePrefix = "[WGCLOUD] ";
            String mailContentSuffix = "<p><p><p><a target='_blank' href='http://www.wgstart.com'>WGCLOUD</a>\u656c\u4e0a";
            if (StaticKeys.LICENSE_STATE.equals("1")) {
                mailTitlePrefix = commonConfig.getMailTitlePrefix();
                mailContentSuffix = commonConfig.getMailContentSuffix();
            }
            HtmlEmail email = new HtmlEmail();
            email.setHostName(StaticKeys.mailSet.getSmtpHost());
            email.setSmtpPort(Integer.valueOf(StaticKeys.mailSet.getSmtpPort()).intValue());
            if ("1".equals(StaticKeys.mailSet.getSmtpSSL())) {
                email.setSSLOnConnect(true);
            }
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(StaticKeys.mailSet.getFromMailName(), StaticKeys.mailSet.getFromPwd()));
            email.setFrom(StaticKeys.mailSet.getFromMailName());
            email.setSubject(mailTitlePrefix + mailTitle);
            email.setCharset("UTF-8");
            email.setHtmlMsg(mailContent + "<p><p><p><p>" + DateUtil.getCurrentDateTime() + mailContentSuffix);
            email.addTo(mails.split(";"));
            email.setSentDate(new Date());
            email.send();
            return "success";
        }
        catch (Exception e) {
            logger.error("\u767c\u9001\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
            logInfoService.save("\u767c\u9001\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            return "error";
        }
    }

    private static String sendMailByJavax(String mails, String mailTitle, String mailContent) {
        if (StringUtils.isEmpty((CharSequence)mails)) {
            return "error";
        }
        if (mails.startsWith(";")) {
            mails = mails.substring(1);
        }
        try {
            String mailTitlePrefix = "[WGCLOUD] ";
            String mailContentSuffix = "<p><p><p><a target='_blank' href='http://www.wgstart.com'>WGCLOUD</a>\u656c\u4e0a";
            if (StaticKeys.LICENSE_STATE.equals("1")) {
                mailTitlePrefix = commonConfig.getMailTitlePrefix();
                mailContentSuffix = commonConfig.getMailContentSuffix();
            }
            Properties prop = new Properties();
            prop.setProperty("mail.host", StaticKeys.mailSet.getSmtpHost());
            prop.setProperty("mail.transport.protocol", "smtp");
            prop.setProperty("mail.smtp.auth", "true");
            prop.setProperty("mail.smtp.port", StaticKeys.mailSet.getSmtpPort());
            if ("1".equals(StaticKeys.mailSet.getSmtpSSL())) {
                prop.setProperty("mail.smtp.starttls.enable", "true");
            } else {
                prop.setProperty("mail.smtp.starttls.enable", "false");
            }
            MailSSLSocketFactory sf = new MailSSLSocketFactory();
            sf.setTrustAllHosts(true);
            prop.put("mail.smtp.ssl.socketFactory", sf);
            prop.put("mail.smtp.ssl.protocols", "TLSv1.2");
            Session session = Session.getInstance((Properties)prop, null);
            session.setDebug(false);
            Transport ts = session.getTransport();
            ts.connect(StaticKeys.mailSet.getSmtpHost(), StaticKeys.mailSet.getFromMailName(), StaticKeys.mailSet.getFromPwd());
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(StaticKeys.mailSet.getFromMailName()));
            String[] mailArr = mails.split(";");
            InternetAddress[] internetAddressArr = new InternetAddress[mailArr.length];
            for (int i = 0; i < mailArr.length; ++i) {
                internetAddressArr[i] = new InternetAddress(mailArr[i]);
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])internetAddressArr);
            message.setSubject(mailTitlePrefix + mailTitle);
            message.setContent((Object)(mailContent + "<p><p><p><p>" + DateUtil.getCurrentDateTime() + mailContentSuffix), "text/html;charset=UTF-8");
            message.saveChanges();
            ts.sendMessage((Message)message, message.getAllRecipients());
            ts.close();
            return "success";
        }
        catch (Exception e) {
            logger.error("\u767c\u9001\u90f5\u4ef6\u932f\u8aa4", (Throwable)e);
            logInfoService.save("\u767c\u9001\u90f5\u4ef6\u932f\u8aa4", e.toString(), "1");
            return "error";
        }
    }

    public static boolean isSendByWarnLevel(String warnLevel) {
        if (StringUtils.isEmpty((CharSequence)warnLevel)) {
            return true;
        }
        if ("INFO".equals(levelConfig.getDefaultWarn())) {
            return true;
        }
        if ("ERROR".equals(levelConfig.getDefaultWarn())) {
            return "ERROR".equals(warnLevel);
        }
        if ("WARN".equals(levelConfig.getDefaultWarn())) {
            return "ERROR".equals(warnLevel) || "WARN".equals(warnLevel);
        }
        return true;
    }

    public static String getWarnLevelName(String warnLevel) {
        if (StringUtils.isEmpty((CharSequence)warnLevel)) {
            return "\u91cd\u8981";
        }
        if ("INFO".equals(warnLevel)) {
            return "\u4fe1\u606f";
        }
        if ("WARN".equals(warnLevel)) {
            return "\u4e00\u822c";
        }
        if ("ERROR".equals(warnLevel)) {
            return "\u91cd\u8981";
        }
        return "\u91cd\u8981";
    }

    public static String setGroupInList(String groupIds) {
        return hostGroupService.returnGroupNames(groupIds);
    }

    public static String getMailContentPrefix(String warnLevelName, String groupsName) {
        String mailContentPrefix = "";
        if (StaticKeys.mailSet != null && "true".equals(levelConfig.getAddToWarnContent())) {
            if (!StringUtils.isEmpty((CharSequence)warnLevelName)) {
                mailContentPrefix = mailContentPrefix + "<font style=\"line-height:1.5\">\u544a\u8b66\u7d1a\u5225\uff1a" + warnLevelName + "</font><p>";
            }
            if (!StringUtils.isEmpty((CharSequence)groupsName)) {
                mailContentPrefix = mailContentPrefix + "<font style=\"line-height:1.5\">\u6a19\u7c64\uff1a" + groupsName + "</font><p>";
            }
        }
        return mailContentPrefix;
    }
}

