/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.agentController;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.WorkInfo;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.WorkInfoService;
import com.wgcloud.util.ResDataUtils;
import com.wgcloud.util.TokenUtils;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/agentSubmitWorkInfo"})
public class AgentWorkInfoController {
    private static final Logger logger = LoggerFactory.getLogger(AgentWorkInfoController.class);
    @Resource
    private LogInfoService logInfoService;
    @Autowired
    private WorkInfoService workInfoService;
    @Autowired
    private TokenUtils tokenUtils;
    @Autowired
    private CommonConfig commonConfig;

    @ResponseBody
    @RequestMapping(value={"/save"})
    public String save(@RequestBody String paramBean) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        String checkResult = this.tokenUtils.preOpenDataAPICheck(agentJsonObject);
        if (!StringUtils.isEmpty((CharSequence)checkResult)) {
            return checkResult;
        }
        logger.debug("\u5f00\u653e\u63a5\u53e3\u63d0\u4ea4\u5de5\u5355\u6570\u636e-------------" + agentJsonObject.toString());
        try {
            String content;
            String title = "\u5f00\u653e\u63a5\u53e3\u63d0\u4ea4\u5de5\u5355";
            if (null != agentJsonObject.get((Object)"title") && !StringUtils.isEmpty((CharSequence)agentJsonObject.get((Object)"title").toString())) {
                title = agentJsonObject.get((Object)"title").toString();
            }
            if (StringUtils.isEmpty((CharSequence)(content = agentJsonObject.get((Object)"content").toString()))) {
                content = "\u5f00\u653e\u63a5\u53e3\u63d0\u4ea4\u5de5\u5355";
            }
            String addAccount = agentJsonObject.get((Object)"addAccount").toString();
            String acceptAccount = agentJsonObject.get((Object)"acceptAccount").toString();
            String workType = agentJsonObject.get((Object)"workType").toString();
            WorkInfo workInfo = new WorkInfo();
            workInfo.setWorkTitle(title);
            workInfo.setAddAccount(addAccount);
            workInfo.setAcceptAccount(acceptAccount);
            workInfo.setWorkContent(content);
            workInfo.setWorkType(workType);
            this.workInfoService.save(workInfo);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u5f00\u653e\u63a5\u53e3\u63d0\u4ea4\u5de5\u5355\u6570\u636e\u9519\u8bef", (Throwable)e);
            return ResDataUtils.resetErrorJson((String)e.toString());
        }
        return ResDataUtils.resetSuccessJson(null);
    }
}

