/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.service.AccountInfoService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.IpUtil;
import com.wgcloud.util.MD5Utils;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.msg.WarnOtherUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/login"})
public class LoginController {
    private static final Logger logger = LoggerFactory.getLogger(LoginController.class);
    private static final String USER_BLOCK = "block";
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private AccountInfoService accountInfoService;
    @Resource
    private CommonConfig commonConfig;

    private void testThread() {
        Runnable runnable = () -> logger.info("LoginCotroller----------testThread");
        ThreadPoolUtil.executor.execute(runnable);
    }

    @RequestMapping(value={"toLogin"})
    public String toLogin(Model model, HttpServletRequest request) {
        return "login/login";
    }

    @RequestMapping(value={"loginOut"})
    public String loginOut(Model model, HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.invalidate();
        return "redirect:/login/toLogin";
    }

    @RequestMapping(value={"login"})
    public String login(Model model, HttpServletRequest request) {
        String vercode;
        HttpSession session = request.getSession();
        if ("true".equals(this.commonConfig.getVercodeCheck()) && (StringUtils.isEmpty((CharSequence)(vercode = request.getParameter("validateCode"))) || !vercode.toLowerCase().equals(session.getAttribute("validateCode")))) {
            model.addAttribute("error", (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef");
            return "login/login";
        }
        if (StaticKeys.PASSWD_EXP_DATE) {
            model.addAttribute("error", (Object)"\u5bc6\u7801\u5df2\u8fc7\u671f");
            return "login/login";
        }
        if ("ERROR".equals(StaticKeys.WGCLOUD_CAT_RELEASE_JAR_STATE)) {
            model.addAttribute("error", (Object)"\u8bf7\u5c06wgcat-release.jar\u8fd8\u539f\u540e\u518d\u767b\u5f55");
            return "login/login";
        }
        String userName = request.getParameter("userName");
        String userBlock = (String)StaticKeys.LOGIN_BLOCK_MAP.get((Object)userName);
        if (USER_BLOCK.equals(userBlock)) {
            model.addAttribute("error", (Object)"\u8bf720\u5206\u949f\u540e\u767b\u5f55\u8be5\u8d26\u53f7\u6216\u8005\u8054\u7cfb\u7ba1\u7406\u5458");
            return "login/login";
        }
        if (StaticKeys.LICENSE_STATE.equals("3")) {
            model.addAttribute("error", (Object)"\u8d26\u53f7\u6216\u6570\u636e\u5df2\u8d85\u8fc7\u6388\u6743\u6570\u91cf\uff0c\u8bf7\u5347\u7ea7\u6388\u6743");
            return "login/login";
        }
        String passwd = request.getParameter("md5pwd");
        session.setAttribute("sidebarCollapse", (Object)"sidebar-mini sidebar-collapse");
        session.setAttribute("themeNameSign", (Object)"");
        session.setAttribute("themeTableHoverSign", (Object)"table-hover");
        try {
            if (!StringUtils.isEmpty((CharSequence)userName) && !StringUtils.isEmpty((CharSequence)passwd)) {
                passwd = passwd.toLowerCase();
                AccountInfo accountInfo = new AccountInfo();
                if (MD5Utils.GetMD5Code((String)this.commonConfig.getAccountPwd()).equals(passwd) && this.commonConfig.getAccount().equals(userName)) {
                    accountInfo.setAccount(userName);
                    accountInfo.setId(userName);
                    accountInfo.setRealName(userName);
                    accountInfo.setRole("admin");
                    session.setAttribute("LOGIN_KEY", (Object)accountInfo);
                    this.saveLoginData(accountInfo, request);
                    return "redirect:/dash/main";
                }
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("account", userName);
                params.put("passwd", passwd);
                List userList = this.accountInfoService.selectAllByParams(params);
                if (userList.size() > 0) {
                    AccountInfo accountInfoFromData = (AccountInfo)userList.get(0);
                    if ("2".equals(accountInfoFromData.getState())) {
                        model.addAttribute("error", (Object)"\u8d26\u53f7\u5df2\u505c\u7528");
                        return "login/login";
                    }
                    accountInfo.setAccount(userName);
                    accountInfo.setId(userName);
                    accountInfo.setRealName(accountInfoFromData.getRealName());
                    accountInfo.setRole("user");
                    session.setAttribute("LOGIN_KEY", (Object)accountInfo);
                    this.saveLoginData(accountInfo, request);
                    return "redirect:/dash/main";
                }
            }
        }
        catch (Exception e) {
            logger.error("\u767b\u5f55\u5f02\u5e38", (Throwable)e);
        }
        model.addAttribute("error", (Object)"\u8d26\u53f7\u6216\u8005\u5bc6\u7801\u9519\u8bef");
        this.loginErrorHandle(request, model);
        return "login/login";
    }

    private void loginErrorHandle(HttpServletRequest request, Model model) {
        String requestIp = IpUtil.getIpAddr((HttpServletRequest)request);
        String userName = request.getParameter("userName");
        Integer errorCount = (Integer)StaticKeys.LOGIN_ERROR_MAP.get((Object)userName);
        if (errorCount != null) {
            StaticKeys.LOGIN_ERROR_MAP.put((Object)userName, (Object)(errorCount + 1));
        } else {
            errorCount = 1;
            StaticKeys.LOGIN_ERROR_MAP.put((Object)userName, (Object)errorCount);
        }
        if (errorCount >= 2) {
            model.addAttribute("error", (Object)"\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u82e5\u8fde\u7eed5\u6b21\u8f93\u5165\u9519\u8bef\uff0c\u9700\u7b4920\u5206\u949f\u540e\u624d\u80fd\u518d\u767b\u5f55\u8be5\u8d26\u53f7");
        }
        if (errorCount >= 5) {
            StaticKeys.LOGIN_BLOCK_MAP.put((Object)userName, (Object)USER_BLOCK);
            String errMsg = userName + "\u5bc6\u7801\u5df2\u8fde\u7eed5\u6b21\u8f93\u5165\u9519\u8bef\uff0c20\u5206\u949f\u5185\u7981\u6b62\u767b\u5f55\uff0c\u767b\u5f55IP\uff1a" + requestIp;
            Runnable runnable = () -> {
                try {
                    WarnOtherUtil.sendUtil((String)errMsg, (String)errMsg, (String)userName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            };
            ThreadPoolUtil.executor.execute(runnable);
            model.addAttribute("error", (Object)"\u5bc6\u7801\u5df2\u8fde\u7eed5\u6b21\u8f93\u5165\u9519\u8bef\uff0c\u8bf720\u5206\u949f\u540e\u518d\u767b\u5f55\u8be5\u8d26\u53f7");
            logger.error(errMsg);
        }
    }

    private void saveLoginData(AccountInfo accountInfo, HttpServletRequest request) {
        try {
            String requestIp = IpUtil.getIpAddr((HttpServletRequest)request);
            this.logInfoService.save("\u8d26\u53f7" + accountInfo.getAccount() + "\u767b\u5f55\u7cfb\u7edf\u6210\u529f\uff0c\u767b\u5f55IP\uff1a" + requestIp, "\u767b\u5f55IP\uff1a" + requestIp, "2");
        }
        catch (Exception e) {
            logger.error("saveLoginData\u9519\u8bef", (Throwable)e);
        }
    }

    @ResponseBody
    @RequestMapping(value={"ajaxSwapMenuState"})
    public String ajaxSwapMenuState(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Object object = session.getAttribute("sidebarCollapse");
        if (null != object) {
            if ("sidebar-mini sidebar-collapse".equals(object.toString())) {
                session.setAttribute("sidebarCollapse", (Object)"sidebar-mini");
            } else {
                session.setAttribute("sidebarCollapse", (Object)"sidebar-mini sidebar-collapse");
            }
        } else {
            session.setAttribute("sidebarCollapse", (Object)"sidebar-mini sidebar-collapse");
        }
        return "success";
    }
}

