/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.dto.ChartReportInfo;
import com.wgcloud.entity.HostGroup;
import com.wgcloud.entity.WorkInfo;
import com.wgcloud.service.AccountInfoService;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.PasswdInfoService;
import com.wgcloud.service.WorkHandleInfoService;
import com.wgcloud.service.WorkInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/reportInfo"})
public class ReportInfoController {
    private static final Logger logger = LoggerFactory.getLogger(ReportInfoController.class);
    @Resource
    private PasswdInfoService passwdInfoService;
    @Resource
    private AccountInfoService accountInfoService;
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private WorkInfoService workInfoService;
    @Resource
    private WorkHandleInfoService workHandleInfoService;
    @Resource
    private HostGroupService hostGroupService;
    @Autowired
    private CommonConfig commonConfig;

    @RequestMapping(value={"viewReport"})
    public String viewReport(Model model, HttpServletRequest request) {
        int dayInt;
        String days = request.getParameter("days");
        if (StringUtils.isEmpty((CharSequence)days)) {
            days = "7";
        }
        if (!StaticKeys.LICENSE_STATE.equals("1") && (dayInt = Integer.valueOf(days).intValue()) > 7) {
            days = "7";
            model.addAttribute("msg", (Object)"\u4e2a\u4eba\u7248\u53ea\u80fd\u67e5\u770b\u6700\u8fd17\u5929\u56fe\u8868\uff0c\u8bf7\u70b9\u51fb\u9875\u9762\u5e95\u90e8\u7f51\u7ad9\uff0c\u8054\u7cfb\u6211\u4eec\u5347\u7ea7\u5230\u4e13\u4e1a\u7248");
        }
        model.addAttribute("days", (Object)days);
        try {
            this.setWorkInfoSizeChart(model, days, request);
            this.setWorkTypeChart(model, days, request);
            this.setWorkStateChart(model, days, request);
            this.countAllWorkState(model, request);
            this.setWorkInfoSizeByGroupChart(model, days, request);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7edf\u8ba1\u5206\u6790\u62a5\u544a\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u7edf\u8ba1\u5206\u6790\u62a5\u544a\u9519\u8bef", e.toString(), "2");
        }
        return "report/view";
    }

    private void setWorkInfoSizeChart(Model model, String days, HttpServletRequest request) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            ArrayList<ChartReportInfo> chartInfoList = new ArrayList<ChartReportInfo>();
            List dateList = this.getDateList(Integer.valueOf(days).intValue());
            for (String dateStr : dateList) {
                params.clear();
                params.put("startTime", dateStr + " 00:00:00");
                params.put("endTime", dateStr + " 23:59:59");
                int size = this.workInfoService.countByParams(params);
                ChartReportInfo chartInfoNew = new ChartReportInfo();
                chartInfoNew.setName("\u65b0\u5efa\u5de5\u5355");
                if (dateStr.length() > 5) {
                    chartInfoNew.setDateStr(dateStr.substring(5));
                }
                chartInfoNew.setValue(Integer.valueOf(size));
                chartInfoList.add(chartInfoNew);
                params.remove("startTime");
                params.remove("endTime");
                params.put("startUpTime", dateStr + " 00:00:00");
                params.put("endUpTime", dateStr + " 23:59:59");
                params.put("state", "5");
                int completeValue = this.workInfoService.countByParams(params);
                ChartReportInfo chartInfoComplete = new ChartReportInfo();
                chartInfoComplete.setName("\u5b8c\u6210\u5de5\u5355");
                if (dateStr.length() > 5) {
                    chartInfoComplete.setDateStr(dateStr.substring(5));
                }
                chartInfoComplete.setValue(Integer.valueOf(completeValue));
                chartInfoList.add(chartInfoComplete);
            }
            model.addAttribute("workInfoSizeChart", (Object)JSONUtil.parseArray(chartInfoList));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7edf\u8ba1\u5206\u6790\u62a5\u544a\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u7edf\u8ba1\u5206\u6790\u62a5\u544a\u9519\u8bef", e.toString(), "2");
        }
    }

    private void setWorkTypeChart(Model model, String days, HttpServletRequest request) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            String[] workTypeArr = this.commonConfig.getWorkType().split(",");
            HashMap<String, Integer> workTypeMap = new HashMap<String, Integer>();
            for (String workType : workTypeArr) {
                workTypeMap.put(workType, 0);
            }
            ArrayList<ChartReportInfo> chartInfoList = new ArrayList<ChartReportInfo>();
            String startDate = DateUtil.getDateBefore((int)Integer.valueOf(days));
            startDate = startDate.substring(0, 10) + " 00:00:00";
            String endDate = DateUtil.getCurrentDateTime();
            endDate = endDate.substring(0, 10) + " 00:00:00";
            params.put("startTime", startDate);
            params.put("endTime", endDate);
            List workInfoList = this.workInfoService.selectAllByParamsNoContent(params);
            for (WorkInfo workInfo : workInfoList) {
                if (null != workTypeMap.get(workInfo.getWorkType()) && (Integer)workTypeMap.get(workInfo.getWorkType()) != 0) {
                    workTypeMap.put(workInfo.getWorkType(), (Integer)workTypeMap.get(workInfo.getWorkType()) + 1);
                    continue;
                }
                workTypeMap.put(workInfo.getWorkType(), 1);
            }
            for (String key : workTypeMap.keySet()) {
                Integer value = (Integer)workTypeMap.get(key);
                ChartReportInfo chartInfo = new ChartReportInfo();
                chartInfo.setName(key);
                chartInfo.setValue(value);
                chartInfoList.add(chartInfo);
            }
            model.addAttribute("workTypeChart", (Object)JSONUtil.parseArray(chartInfoList));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7edf\u8ba1\u5206\u6790\u62a5\u544a\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u7edf\u8ba1\u5206\u6790\u62a5\u544a\u9519\u8bef", e.toString(), "2");
        }
    }

    private void setWorkStateChart(Model model, String days, HttpServletRequest request) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            ArrayList<ChartReportInfo> chartInfoList = new ArrayList<ChartReportInfo>();
            String startDate = DateUtil.getDateBefore((int)Integer.valueOf(days));
            startDate = startDate.substring(0, 10) + " 00:00:00";
            String endDate = DateUtil.getCurrentDateTime();
            endDate = endDate.substring(0, 10) + " 00:00:00";
            params.put("startTime", startDate);
            params.put("endTime", endDate);
            params.put("state", "0");
            Integer workSize_0 = this.workHandleInfoService.countByParams(params);
            ChartReportInfo chartInfo = new ChartReportInfo();
            chartInfo.setName("\u5de5\u5355\u8bc4\u8bba\u6b21\u6570");
            chartInfo.setValue(workSize_0);
            chartInfoList.add(chartInfo);
            params.remove("state");
            ArrayList<String> stateList = new ArrayList<String>();
            stateList.add("1");
            stateList.add("2");
            params.put("stateList", stateList);
            Integer workSize_2 = this.workHandleInfoService.countByParams(params);
            ChartReportInfo chartInfo2 = new ChartReportInfo();
            chartInfo2.setName("\u5de5\u5355\u5904\u7406\u6b21\u6570");
            chartInfo2.setValue(workSize_2);
            chartInfoList.add(chartInfo2);
            params.remove("stateList");
            params.put("state", "3");
            Integer workSize_3 = this.workHandleInfoService.countByParams(params);
            ChartReportInfo chartInfo3 = new ChartReportInfo();
            chartInfo3.setName("\u5de5\u5355\u5173\u95ed\u6b21\u6570");
            chartInfo3.setValue(workSize_3);
            chartInfoList.add(chartInfo3);
            params.put("state", "4");
            Integer workSize_4 = this.workHandleInfoService.countByParams(params);
            ChartReportInfo chartInfo4 = new ChartReportInfo();
            chartInfo4.setName("\u5de5\u5355\u62d2\u7edd\u6b21\u6570");
            chartInfo4.setValue(workSize_4);
            chartInfoList.add(chartInfo4);
            params.put("state", "5");
            Integer workSize_5 = this.workHandleInfoService.countByParams(params);
            ChartReportInfo chartInfo5 = new ChartReportInfo();
            chartInfo5.setName("\u5de5\u5355\u5b8c\u6210\u6570\u91cf");
            chartInfo5.setValue(workSize_5);
            chartInfoList.add(chartInfo5);
            model.addAttribute("workStateChart", (Object)JSONUtil.parseArray(chartInfoList));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7edf\u8ba1\u5206\u6790\u62a5\u544a\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u7edf\u8ba1\u5206\u6790\u62a5\u544a\u9519\u8bef", e.toString(), "2");
        }
    }

    private void countAllWorkState(Model model, HttpServletRequest request) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("state", "1");
        Integer workSize_1 = this.workInfoService.countByParams(params);
        model.addAttribute("workStateSize_1", (Object)workSize_1);
        params.put("state", "2");
        Integer workSize_2 = this.workInfoService.countByParams(params);
        model.addAttribute("workStateSize_2", (Object)workSize_2);
        params.put("state", "4");
        Integer workSize_4 = this.workInfoService.countByParams(params);
        model.addAttribute("workStateSize_4", (Object)workSize_4);
    }

    private void setWorkInfoSizeByGroupChart(Model model, String days, HttpServletRequest request) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            ArrayList<ChartReportInfo> chartInfoList = new ArrayList<ChartReportInfo>();
            String startDate = DateUtil.getDateBefore((int)Integer.valueOf(days));
            startDate = startDate.substring(0, 10) + " 00:00:00";
            String endDate = DateUtil.getCurrentDateTime();
            endDate = endDate.substring(0, 10) + " 00:00:00";
            params.put("startTime", startDate);
            params.put("endTime", endDate);
            HashMap paramsGroup = new HashMap();
            List hostGroupList = this.hostGroupService.selectAllByParams(paramsGroup, request);
            for (HostGroup hostGroup : hostGroupList) {
                params.put("groupId", hostGroup.getId());
                int size = this.workInfoService.countByParams(params);
                ChartReportInfo chartInfoNew = new ChartReportInfo();
                chartInfoNew.setName(hostGroup.getGroupName());
                chartInfoNew.setValue(Integer.valueOf(size));
                chartInfoList.add(chartInfoNew);
            }
            model.addAttribute("workInfoGroupSizeChart", (Object)JSONUtil.parseArray(chartInfoList));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7edf\u8ba1\u5206\u6790\u62a5\u544a\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u7edf\u8ba1\u5206\u6790\u62a5\u544a\u9519\u8bef", e.toString(), "2");
        }
    }

    public List<String> getDateList(int days) {
        ArrayList<String> dateList = new ArrayList<String>();
        String sevenDayBefore = DateUtil.getDateBefore((int)days);
        for (int i = 1; i < days + 1; ++i) {
            sevenDayBefore = DateUtil.getDateBefore((int)i);
            dateList.add(sevenDayBefore.substring(0, 10));
        }
        CollectionUtil.reverse(dateList);
        return dateList;
    }
}

