/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.github.pagehelper.PageInfo;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.entity.WorkHandleInfo;
import com.wgcloud.entity.WorkInfo;
import com.wgcloud.service.AccountInfoService;
import com.wgcloud.service.ExcelExportService;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.WorkFileInfoService;
import com.wgcloud.service.WorkHandleInfoService;
import com.wgcloud.service.WorkInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.FileUtils;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.PDFUtil;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.ResDataUtils;
import com.wgcloud.util.WorkUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/workInfo"})
public class WorkInfoController {
    private static final Logger logger = LoggerFactory.getLogger(WorkInfoController.class);
    @Resource
    private WorkInfoService workInfoService;
    @Resource
    private WorkHandleInfoService workHandleInfoService;
    @Resource
    private LogInfoService logInfoService;
    @Autowired
    private AccountInfoService accountInfoService;
    @Resource
    private HostGroupService hostGroupService;
    @Autowired
    private WorkFileInfoService workFileInfoService;
    @Resource
    private ExcelExportService excelExportService;
    @Autowired
    private CommonConfig commonConfig;

    @RequestMapping(value={"list"})
    public String workInfoList(WorkInfo workInfo, Model model, HttpServletRequest request) {
        String errorMsg = "\u67e5\u8be2\u5de5\u5355\u4fe1\u606f\u9519\u8bef";
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            StringBuffer url = new StringBuffer();
            this.workInfoService.addPrefixParams(workInfo, params, url, request, model);
            if (!StringUtils.isEmpty((CharSequence)workInfo.getAcceptAccount())) {
                params.put("acceptAccount", workInfo.getAcceptAccount());
                url.append("&acceptAccount=").append(workInfo.getAcceptAccount());
            }
            if (!StringUtils.isEmpty((CharSequence)workInfo.getAddAccount())) {
                params.put("addAccount", workInfo.getAddAccount());
                url.append("&addAccount=").append(workInfo.getAddAccount());
            }
            if (!StringUtils.isEmpty((CharSequence)workInfo.getGroupId())) {
                params.put("groupId", workInfo.getGroupId());
                url.append("&groupId=").append(workInfo.getGroupId());
            }
            if (!StringUtils.isEmpty((CharSequence)workInfo.getState())) {
                params.put("state", workInfo.getState());
                url.append("&state=").append(workInfo.getState());
            }
            if (!StringUtils.isEmpty((CharSequence)workInfo.getWorkType())) {
                params.put("workType", workInfo.getWorkType());
                url.append("&workType=").append(workInfo.getWorkType());
            }
            if (!StringUtils.isEmpty((CharSequence)workInfo.getOrderBy())) {
                params.put("orderBy", workInfo.getOrderBy());
                params.put("orderType", workInfo.getOrderType());
                url.append("&orderBy=").append(workInfo.getOrderBy());
                url.append("&orderType=").append(workInfo.getOrderType());
            }
            PageInfo pageInfo = this.workInfoService.selectByParams(params, Integer.valueOf(workInfo.getPage()).intValue(), Integer.valueOf(workInfo.getPageSize()).intValue());
            HashMap<String, String> paramsHandle = new HashMap<String, String>();
            for (WorkInfo workInfo1 : pageInfo.getList()) {
                paramsHandle.put("workInfoId", workInfo1.getId());
                int fileCount = this.workFileInfoService.countByParams(paramsHandle);
                if (fileCount > 0) {
                    workInfo1.setFileCount(fileCount + "");
                    continue;
                }
                workInfo1.setFileCount("0");
            }
            for (WorkInfo workInfo1 : pageInfo.getList()) {
                workInfo1.setGroupId(this.hostGroupService.returnGroupNames(workInfo1.getGroupId()));
            }
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            HostUtil.addAccountListModel((Model)model);
            String[] workTypeArr = this.commonConfig.getWorkType().split(",");
            model.addAttribute("workTypeList", (Object)workTypeArr);
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("pageUrl", (Object)("/workInfo/list?1=1" + url.toString()));
            model.addAttribute("workInfo", (Object)workInfo);
            if (null == request.getSession().getAttribute("WorkInfoListHideColsInfo")) {
                request.getSession().setAttribute("WorkInfoListHideColsInfo", (Object)"");
            }
            if (null == request.getSession().getAttribute("WorkInfoListHideSearchsInfo")) {
                request.getSession().setAttribute("WorkInfoListHideSearchsInfo", (Object)"00,01,02,03,04,05");
            }
            HashMap paramsGroup = new HashMap();
            List hostGroupList = this.hostGroupService.selectAllByParams(paramsGroup, request);
            model.addAttribute("hostGroupList", (Object)hostGroupList);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "workInfo/list";
    }

    @RequestMapping(value={"edit"})
    public String edit(Model model, HttpServletRequest request) {
        String errorMsg = "\u6dfb\u52a0\u5de5\u5355\u4fe1\u606f\u9519\u8bef";
        String id = request.getParameter("id");
        WorkInfo workInfo = new WorkInfo();
        try {
            String[] workTypeArr = this.commonConfig.getWorkType().split(",");
            model.addAttribute("workTypeList", (Object)workTypeArr);
            HostUtil.addAccountListModel((Model)model);
            model.addAttribute("workAttachType", (Object)this.commonConfig.getWorkAttachType());
            HashMap params = new HashMap();
            List hostGroupList = this.hostGroupService.selectAllByParams(params, request);
            model.addAttribute("hostGroupList", (Object)hostGroupList);
            if (StringUtils.isEmpty((CharSequence)id)) {
                model.addAttribute("workInfo", (Object)workInfo);
                return "workInfo/add";
            }
            workInfo = this.workInfoService.selectById(id);
            model.addAttribute("workInfo", (Object)workInfo);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "workInfo/add";
    }

    @RequestMapping(value={"save"})
    public String saveWorkInfo(@RequestParam(value="file") List<MultipartFile> fileList, WorkInfo workInfo, Model model, HttpServletRequest request) {
        try {
            if (StringUtils.isEmpty((CharSequence)workInfo.getId())) {
                Object[] groupIdsArr;
                AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
                if (!StringUtils.isEmpty((CharSequence)accountInfo.getAccount())) {
                    workInfo.setAddAccount(accountInfo.getAccount());
                }
                if (null != (groupIdsArr = request.getParameterValues("groupId")) && groupIdsArr.length > 0) {
                    workInfo.setGroupId(StringUtils.join((Object[])groupIdsArr, (String)","));
                } else {
                    workInfo.setGroupId("");
                }
                this.workInfoService.save(workInfo);
                this.workInfoService.saveAttachFile(fileList, workInfo.getId());
                this.workInfoService.saveLog(request, "\u65b0\u5efa", workInfo);
            } else {
                this.workInfoService.updateById(workInfo);
                this.workInfoService.saveLog(request, "\u4fee\u6539", workInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u5de5\u5355\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58\u5de5\u5355\u4fe1\u606f\u9519\u8bef", e.toString(), "2");
        }
        return "redirect:/workInfo/list";
    }

    @ResponseBody
    @RequestMapping(value={"saveFileAjax"})
    public String saveFileAjax(@RequestParam(value="file") List<MultipartFile> fileList, Model model, HttpServletRequest request) {
        try {
            String imageUrl = "";
            for (MultipartFile file : fileList) {
                String fileSize = FormatUtil.bytesFormatUnit((String)(file.getBytes().length + ""));
                String sourceFileName = file.getOriginalFilename();
                if (StringUtils.isEmpty((CharSequence)sourceFileName)) continue;
                String fileType = sourceFileName.substring(sourceFileName.lastIndexOf(".") + 1);
                if (!this.commonConfig.getWorkAttachType().contains(fileType)) {
                    logger.error("\u4e0d\u5141\u8bb8\u4e0a\u4f20\u7684\u9644\u4ef6\u7c7b\u578b:" + sourceFileName);
                    continue;
                }
                String day = DateUtil.getCurrentDate().replace("-", "");
                String saveFolder = StaticKeys.JAR_PATH + "/uploadFile/" + day;
                FileUtils.existsFolder((String)saveFolder);
                String newFileName = DateUtil.getCurrentDateTimeNoChar() + FormatUtil.getRandInt() + "." + fileType;
                String newFilePath = saveFolder + "/" + newFileName;
                Path path = Paths.get(newFilePath, new String[0]);
                file.transferTo(path);
                imageUrl = "/uploadFile/" + day + "/" + newFileName;
            }
            return ResDataUtils.resetSuccessJson((Object)imageUrl);
        }
        catch (Exception e) {
            logger.error("\u7c98\u8d34\u56fe\u7247\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u7c98\u8d34\u56fe\u7247\u9519\u8bef", e.toString(), "2");
            return "error";
        }
    }

    @ResponseBody
    @RequestMapping(value={"del"})
    public String delete(Model model, HttpServletRequest request) {
        String errorMsg = "\u5220\u9664\u5de5\u5355\u4fe1\u606f\u9519\u8bef";
        try {
            AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
            if (!"admin".equals(accountInfo.getRole())) {
                logger.error("\u5220\u9664\u5de5\u5355\u4fe1\u606f\u9519\u8bef\uff0c\u53ea\u6709\u7ba1\u7406\u5458\u53ef\u4ee5\u5220\u9664\u5de5\u5355\u4fe1\u606f");
                return ResDataUtils.resetSuccessJson(null);
            }
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                String[] ids;
                for (String id : ids = request.getParameter("id").split(",")) {
                    WorkInfo workInfo = this.workInfoService.selectById(id);
                    this.workInfoService.deleteById(request.getParameter("id").split(","));
                    this.workInfoService.saveLog(request, "\u5220\u9664", workInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return ResDataUtils.resetSuccessJson(null);
    }

    @RequestMapping(value={"view"})
    public String viewWorkInfo(Model model, HttpServletRequest request) {
        String id = request.getParameter("id");
        WorkInfo workInfo = new WorkInfo();
        try {
            workInfo = this.workInfoService.selectById(id);
            model.addAttribute("workInfo", (Object)workInfo);
            workInfo.setGroupId(this.hostGroupService.returnGroupNames(workInfo.getGroupId()));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("workInfoId", workInfo.getId());
            List workHandleInfoList = this.workHandleInfoService.selectAllByParams(params);
            HashMap<String, String> paramsHandle = new HashMap<String, String>();
            for (WorkHandleInfo workHandleInfo : workHandleInfoList) {
                paramsHandle.put("workInfoId", workHandleInfo.getId());
                List workFileInfoList = this.workFileInfoService.selectAllByParams(paramsHandle);
                workHandleInfo.setWorkFileInfoList(workFileInfoList);
            }
            model.addAttribute("workHandleInfoList", (Object)workHandleInfoList);
            HostUtil.addAccountListModel((Model)model);
            List workFileInfoList = this.workFileInfoService.selectAllByParams(params);
            model.addAttribute("workFileInfoList", (Object)workFileInfoList);
            WorkUtil.workDurationHandle((WorkInfo)workInfo, (Integer)workHandleInfoList.size(), (Model)model);
        }
        catch (Exception e) {
            logger.error("\u67e5\u770b\u5de5\u5355\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
        return "workInfo/view";
    }

    @RequestMapping(value={"handleWork"})
    public String handleWork(@RequestParam(value="file") List<MultipartFile> fileList, WorkInfo workInfo, Model model, HttpServletRequest request) {
        String openPage = request.getParameter("openPage");
        try {
            this.workInfoService.handleWork(workInfo, request, fileList);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5de5\u5355\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u5904\u7406\u5de5\u5355\u4fe1\u606f\u9519\u8bef", e.toString(), "2");
        }
        if (!StringUtils.isEmpty((CharSequence)openPage)) {
            return "redirect:/workInfoOpen/list";
        }
        return "redirect:/workInfo/list";
    }

    @RequestMapping(value={"viewHandleWork"})
    public String viewHandleWork(Model model, HttpServletRequest request) {
        String id = request.getParameter("id");
        WorkInfo workInfo = new WorkInfo();
        try {
            workInfo = this.workInfoService.selectById(id);
            model.addAttribute("workInfo", (Object)workInfo);
            workInfo.setGroupId(this.hostGroupService.returnGroupNames(workInfo.getGroupId()));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("workInfoId", workInfo.getId());
            List workHandleInfoList = this.workHandleInfoService.selectAllByParams(params);
            HashMap<String, String> paramsHandle = new HashMap<String, String>();
            for (WorkHandleInfo workHandleInfo : workHandleInfoList) {
                paramsHandle.put("workInfoId", workHandleInfo.getId());
                List workFileInfoList = this.workFileInfoService.selectAllByParams(paramsHandle);
                workHandleInfo.setWorkFileInfoList(workFileInfoList);
            }
            model.addAttribute("workHandleInfoList", (Object)workHandleInfoList);
            HostUtil.addAccountListModel((Model)model);
            model.addAttribute("workAttachType", (Object)this.commonConfig.getWorkAttachType());
            List workFileInfoList = this.workFileInfoService.selectAllByParams(params);
            model.addAttribute("workFileInfoList", (Object)workFileInfoList);
            WorkUtil.workDurationHandle((WorkInfo)workInfo, (Integer)workHandleInfoList.size(), (Model)model);
        }
        catch (Exception e) {
            logger.error("\u67e5\u770b\u5e76\u5904\u7406\u5de5\u5355\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
        return "workInfo/workHandle";
    }

    @ResponseBody
    @RequestMapping(value={"saveWorkInfoListHideCols"})
    public String saveWorkInfoListHideCols(Model model, HttpServletRequest request) {
        try {
            Object[] hostListHideCols = request.getParameterValues("hostListHideCols");
            if (null != hostListHideCols) {
                request.getSession().setAttribute("WorkInfoListHideColsInfo", (Object)StringUtils.join((Object[])hostListHideCols, (String)","));
            } else {
                request.getSession().setAttribute("WorkInfoListHideColsInfo", (Object)"");
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u5de5\u5355\u5217\u8868\u9700\u8981\u9690\u85cf\u7684\u5217\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58\u5de5\u5355\u5217\u8868\u9700\u8981\u9690\u85cf\u7684\u5217\u9519\u8bef", e.toString(), "2");
        }
        return "redirect:/workInfo/list";
    }

    @ResponseBody
    @RequestMapping(value={"saveWorkInfoListHideSearchs"})
    public String saveWorkInfoListHideSearchs(Model model, HttpServletRequest request) {
        try {
            Object[] hostListHideCols = request.getParameterValues("hostListHideSearchs");
            if (null != hostListHideCols) {
                request.getSession().setAttribute("WorkInfoListHideSearchsInfo", (Object)StringUtils.join((Object[])hostListHideCols, (String)","));
            } else {
                request.getSession().setAttribute("WorkInfoListHideSearchsInfo", (Object)"");
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u5de5\u5355\u5217\u8868\u9700\u8981\u9690\u85cf\u7684\u67e5\u8be2\u6761\u4ef6\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58\u5de5\u5355\u5217\u8868\u9700\u8981\u9690\u85cf\u7684\u67e5\u8be2\u6761\u4ef6\u9519\u8bef", e.toString(), "2");
        }
        return "redirect:/workInfo/list";
    }

    @ResponseBody
    @RequestMapping(value={"assign"})
    public String assign(Model model, HttpServletRequest request) {
        String errorMsg = "\u5de5\u5355\u7cfb\u7edf\u5206\u914d\u53d7\u7406\u4eba\u5458";
        try {
            this.workInfoService.assignWork(request);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return ResDataUtils.resetSuccessJson(null);
    }

    @ResponseBody
    @RequestMapping(value={"receive"})
    public String receive(Model model, HttpServletRequest request) {
        String errorMsg = "\u5de5\u5355\u7cfb\u7edf\u63a5\u6536\u5de5\u5355";
        try {
            this.workInfoService.receiveWork(request);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return ResDataUtils.resetSuccessJson(null);
    }

    @ResponseBody
    @RequestMapping(value={"comment"})
    public String comment(Model model, HttpServletRequest request) {
        String errorMsg = "\u5de5\u5355\u7cfb\u7edf\u6dfb\u52a0\u8bc4\u8bba";
        try {
            this.workInfoService.commentWork(request);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return ResDataUtils.resetSuccessJson(null);
    }

    @ResponseBody
    @RequestMapping(value={"delComment"})
    public String delComment(Model model, HttpServletRequest request) {
        String errorMsg = "\u5de5\u5355\u7cfb\u7edf\u5220\u9664\u5de5\u5355\u8bc4\u8bba";
        try {
            this.workInfoService.delComment(request);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return ResDataUtils.resetSuccessJson(null);
    }

    @ResponseBody
    @RequestMapping(value={"reopen"})
    public String reopen(Model model, HttpServletRequest request) {
        String errorMsg = "\u5de5\u5355\u7cfb\u7edf\u91cd\u65b0\u6253\u5f00\u5de5\u5355";
        try {
            this.workInfoService.reopenWork(request);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return ResDataUtils.resetSuccessJson(null);
    }

    @ResponseBody
    @RequestMapping(value={"close"})
    public String close(Model model, HttpServletRequest request) {
        String errorMsg = "\u5de5\u5355\u7cfb\u7edf\u5173\u95ed\u5de5\u5355";
        try {
            this.workInfoService.closeWork(request);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return ResDataUtils.resetSuccessJson(null);
    }

    @RequestMapping(value={"exportPDF"})
    public void exportPDF(HttpServletResponse response, HttpServletRequest request) {
        try {
            if (!StaticKeys.LICENSE_STATE.equals("1")) {
                response.setContentType("text/html;charset=UTF-8");
                response.getOutputStream().write("The module needs to professional version. Please contact us at www.wgstart.com".getBytes());
                return;
            }
            WorkInfo workInfo = new WorkInfo();
            String id = request.getParameter("id");
            workInfo = this.workInfoService.selectById(id);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("workInfoId", workInfo.getId());
            List workHandleInfoList = this.workHandleInfoService.selectAllByParams(params);
            HashMap<String, String> paramsHandle = new HashMap<String, String>();
            for (WorkHandleInfo workHandleInfo : workHandleInfoList) {
                paramsHandle.put("workInfoId", workHandleInfo.getId());
                List workFileInfoList = this.workFileInfoService.selectAllByParams(paramsHandle);
                workHandleInfo.setWorkFileInfoList(workFileInfoList);
            }
            List workFileInfoList = this.workFileInfoService.selectAllByParams(params);
            workInfo.setGroupId(this.hostGroupService.returnGroupNames(workInfo.getGroupId()));
            if (StringUtils.isEmpty((CharSequence)workInfo.getGroupId())) {
                workInfo.setGroupId("\u65e0");
            }
            PDFUtil.exportPDF((WorkInfo)workInfo, (List)workHandleInfoList, (List)workFileInfoList, (HttpServletResponse)response);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faPDF\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u5bfc\u51faPDF\u9519\u8bef", e.toString(), "2");
        }
    }

    @RequestMapping(value={"exportListExcel"})
    public void exportListExcel(WorkInfo workInfo, Model model, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (!StaticKeys.LICENSE_STATE.equals("1")) {
                response.setContentType("text/html;charset=UTF-8");
                response.getOutputStream().write("The module needs to professional version. Please contact us at www.wgstart.com".getBytes());
                return;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            StringBuffer url = new StringBuffer();
            this.workInfoService.addPrefixParams(workInfo, params, url, request, model);
            if (!StringUtils.isEmpty((CharSequence)workInfo.getAcceptAccount())) {
                params.put("acceptAccount", workInfo.getAcceptAccount());
                url.append("&acceptAccount=").append(workInfo.getAcceptAccount());
            }
            if (!StringUtils.isEmpty((CharSequence)workInfo.getAddAccount())) {
                params.put("addAccount", workInfo.getAddAccount());
                url.append("&addAccount=").append(workInfo.getAddAccount());
            }
            if (!StringUtils.isEmpty((CharSequence)workInfo.getGroupId())) {
                params.put("groupId", workInfo.getGroupId());
                url.append("&groupId=").append(workInfo.getGroupId());
            }
            if (!StringUtils.isEmpty((CharSequence)workInfo.getState())) {
                params.put("state", workInfo.getState());
                url.append("&state=").append(workInfo.getState());
            }
            if (!StringUtils.isEmpty((CharSequence)workInfo.getWorkType())) {
                params.put("workType", workInfo.getWorkType());
                url.append("&workType=").append(workInfo.getWorkType());
            }
            if (!StringUtils.isEmpty((CharSequence)workInfo.getOrderBy())) {
                params.put("orderBy", workInfo.getOrderBy());
                params.put("orderType", workInfo.getOrderType());
                url.append("&orderBy=").append(workInfo.getOrderBy());
                url.append("&orderType=").append(workInfo.getOrderType());
            }
            PageInfo pageInfo = this.workInfoService.selectByParams(params, 1, 10000);
            HashMap<String, String> paramsHandle = new HashMap<String, String>();
            for (WorkInfo workInfo1 : pageInfo.getList()) {
                paramsHandle.put("workInfoId", workInfo1.getId());
                int fileCount = this.workFileInfoService.countByParams(paramsHandle);
                if (fileCount > 0) {
                    workInfo1.setFileCount(fileCount + "");
                    continue;
                }
                workInfo1.setFileCount("0");
            }
            for (WorkInfo workInfo1 : pageInfo.getList()) {
                workInfo1.setGroupId(this.hostGroupService.returnGroupNames(workInfo1.getGroupId()));
            }
            this.excelExportService.exportWorkInfoListExcel(pageInfo.getList(), response);
        }
        catch (Exception e) {
            logger.error("\u5de5\u5355\u5217\u8868\u5bfc\u51faexcel\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u5de5\u5355\u5217\u8868\u5bfc\u51faexcel\u9519\u8bef", e.toString(), "2");
        }
    }
}

