/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.github.pagehelper.PageInfo;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.entity.WorkHandleInfo;
import com.wgcloud.entity.WorkInfo;
import com.wgcloud.service.AccountInfoService;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.WorkFileInfoService;
import com.wgcloud.service.WorkHandleInfoService;
import com.wgcloud.service.WorkInfoService;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.WorkUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/workInfoOpen"})
public class WorkInfoOpenController {
    private static final Logger logger = LoggerFactory.getLogger(WorkInfoOpenController.class);
    @Resource
    private WorkInfoService workInfoService;
    @Resource
    private WorkHandleInfoService workHandleInfoService;
    @Autowired
    private WorkFileInfoService workFileInfoService;
    @Resource
    private LogInfoService logInfoService;
    @Autowired
    private AccountInfoService accountInfoService;
    @Resource
    private HostGroupService hostGroupService;
    @Autowired
    private CommonConfig commonConfig;

    @RequestMapping(value={"list"})
    public String workInfoList(WorkInfo workInfo, Model model, HttpServletRequest request) {
        String errorMsg = "\u67e5\u8be2\u5f85\u63a5\u6536\u548c\u5f85\u5904\u7406\u7684\u5de5\u5355\u4fe1\u606f\u9519\u8bef";
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            StringBuffer url = new StringBuffer();
            this.workInfoService.addPrefixParams(workInfo, params, url, request, model);
            AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
            if (!"admin".equals(accountInfo.getRole())) {
                params.put("acceptAccount", accountInfo.getAccount());
            }
            if (!StringUtils.isEmpty((CharSequence)workInfo.getState())) {
                params.put("state", workInfo.getState());
                url.append("&state=").append(workInfo.getState());
            } else {
                ArrayList<String> stateList = new ArrayList<String>();
                stateList.add("1");
                stateList.add("2");
                params.put("stateList", stateList);
            }
            if (!StringUtils.isEmpty((CharSequence)workInfo.getOrderBy())) {
                params.put("orderBy", workInfo.getOrderBy());
                params.put("orderType", workInfo.getOrderType());
                url.append("&orderBy=").append(workInfo.getOrderBy());
                url.append("&orderType=").append(workInfo.getOrderType());
            }
            PageInfo pageInfo = this.workInfoService.selectByParams(params, Integer.valueOf(workInfo.getPage()).intValue(), Integer.valueOf(workInfo.getPageSize()).intValue());
            HashMap<String, String> paramsHandle = new HashMap<String, String>();
            for (WorkInfo workInfo1 : pageInfo.getList()) {
                paramsHandle.put("workInfoId", workInfo1.getId());
                int fileCount = this.workFileInfoService.countByParams(paramsHandle);
                if (fileCount > 0) {
                    workInfo1.setFileCount(fileCount + "");
                    continue;
                }
                workInfo1.setFileCount("0");
            }
            for (WorkInfo workInfo1 : pageInfo.getList()) {
                workInfo1.setGroupId(this.hostGroupService.returnGroupNames(workInfo1.getGroupId()));
            }
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            HostUtil.addAccountListModel((Model)model);
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("pageUrl", (Object)("/workInfoOpen/list?1=1" + url.toString()));
            model.addAttribute("workInfo", (Object)workInfo);
            if (null == request.getSession().getAttribute("WorkOpenListHideColsInfo")) {
                request.getSession().setAttribute("WorkOpenListHideColsInfo", (Object)"");
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "workOpen/list";
    }

    @ResponseBody
    @RequestMapping(value={"saveWorkInfoOpenListHideCols"})
    public String saveWorkInfoOpenListHideCols(Model model, HttpServletRequest request) {
        try {
            Object[] hostListHideCols = request.getParameterValues("hostListHideCols");
            if (null != hostListHideCols) {
                request.getSession().setAttribute("WorkOpenListHideColsInfo", (Object)StringUtils.join((Object[])hostListHideCols, (String)","));
            } else {
                request.getSession().setAttribute("WorkOpenListHideColsInfo", (Object)"");
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u5f85\u529e\u5217\u8868\u9700\u8981\u9690\u85cf\u7684\u5217\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58\u5f85\u529e\u5217\u8868\u9700\u8981\u9690\u85cf\u7684\u5217\u9519\u8bef", e.toString(), "2");
        }
        return "redirect:/workInfoOpen/list";
    }

    @RequestMapping(value={"viewHandleWork"})
    public String viewHandleWork(Model model, HttpServletRequest request) {
        String id = request.getParameter("id");
        WorkInfo workInfo = new WorkInfo();
        try {
            workInfo = this.workInfoService.selectById(id);
            model.addAttribute("workInfo", (Object)workInfo);
            workInfo.setGroupId(this.hostGroupService.returnGroupNames(workInfo.getGroupId()));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("workInfoId", workInfo.getId());
            List workHandleInfoList = this.workHandleInfoService.selectAllByParams(params);
            model.addAttribute("workHandleInfoList", (Object)workHandleInfoList);
            HostUtil.addAccountListModel((Model)model);
            model.addAttribute("openPage", (Object)"1");
            model.addAttribute("workAttachType", (Object)this.commonConfig.getWorkAttachType());
            List workFileInfoList = this.workFileInfoService.selectAllByParams(params);
            model.addAttribute("workFileInfoList", (Object)workFileInfoList);
            WorkUtil.workDurationHandle((WorkInfo)workInfo, (Integer)workHandleInfoList.size(), (Model)model);
        }
        catch (Exception e) {
            logger.error("\u67e5\u770b\u5e76\u5904\u7406\u5de5\u5355\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
        return "workOpen/workHandle";
    }

    @RequestMapping(value={"view"})
    public String viewWorkInfo(Model model, HttpServletRequest request) {
        String id = request.getParameter("id");
        WorkInfo workInfo = new WorkInfo();
        try {
            workInfo = this.workInfoService.selectById(id);
            model.addAttribute("workInfo", (Object)workInfo);
            workInfo.setGroupId(this.hostGroupService.returnGroupNames(workInfo.getGroupId()));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("workInfoId", workInfo.getId());
            List workHandleInfoList = this.workHandleInfoService.selectAllByParams(params);
            HashMap<String, String> paramsHandle = new HashMap<String, String>();
            for (WorkHandleInfo workHandleInfo : workHandleInfoList) {
                paramsHandle.put("workInfoId", workHandleInfo.getId());
                List workFileInfoList = this.workFileInfoService.selectAllByParams(paramsHandle);
                workHandleInfo.setWorkFileInfoList(workFileInfoList);
            }
            model.addAttribute("workHandleInfoList", (Object)workHandleInfoList);
            HostUtil.addAccountListModel((Model)model);
            List workFileInfoList = this.workFileInfoService.selectAllByParams(params);
            model.addAttribute("workFileInfoList", (Object)workFileInfoList);
            WorkUtil.workDurationHandle((WorkInfo)workInfo, (Integer)workHandleInfoList.size(), (Model)model);
        }
        catch (Exception e) {
            logger.error("\u67e5\u770b\u5de5\u5355\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
        return "workOpen/view";
    }
}

