/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.entity.WorkFileInfo;
import com.wgcloud.entity.WorkHandleInfo;
import com.wgcloud.entity.WorkInfo;
import com.wgcloud.mapper.WorkInfoMapper;
import com.wgcloud.service.AccountInfoService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.WorkFileInfoService;
import com.wgcloud.service.WorkHandleInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.FileUtils;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.UUIDUtil;
import com.wgcloud.util.WorkUtil;
import com.wgcloud.util.msg.WarnOtherUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.web.multipart.MultipartFile;

@Service
public class WorkInfoService {
    private static final Logger logger = LoggerFactory.getLogger(WorkInfoService.class);
    @Autowired
    private WorkInfoMapper workInfoMapper;
    @Autowired
    private LogInfoService logInfoService;
    @Autowired
    private AccountInfoService accountInfoService;
    @Resource
    private WorkHandleInfoService workHandleInfoService;
    @Resource
    private WorkFileInfoService workFileInfoService;
    @Autowired
    private CommonConfig commonConfig;

    public PageInfo selectByParams(Map<String, Object> params, int currPage, int pageSize) throws Exception {
        PageHelper.startPage((int)currPage, (int)pageSize);
        List list = this.workInfoMapper.selectByParams(params);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public synchronized void save(WorkInfo workInfo) throws Exception {
        HashMap paramsWorkCode = new HashMap();
        Integer workCode = 1;
        Integer maxWorkCode = this.workInfoMapper.selectMaxWorkCode(paramsWorkCode);
        if (maxWorkCode != null) {
            workCode = maxWorkCode + 1;
        }
        workInfo.setWorkCode(workCode);
        workInfo.setId(UUIDUtil.getUUID());
        workInfo.setCreateTime(new Date());
        workInfo.setUpdateTime(new Date());
        workInfo.setState("1");
        String addAccountRealName = WorkUtil.getRealName((String)workInfo.getAddAccount());
        workInfo.setAddAccountName(addAccountRealName);
        String acceptRealName = WorkUtil.getRealName((String)workInfo.getAcceptAccount());
        workInfo.setAcceptAccountName(acceptRealName);
        this.workInfoMapper.save(workInfo);
        WorkHandleInfo workHandleInfo = this.saveWorkHandleInfo(workInfo.getId(), "\u65b0\u5efa\u5de5\u5355", workInfo.getState(), workInfo.getAddAccountName(), acceptRealName);
        Runnable runnable = () -> WarnOtherUtil.sendUtil((String)("\u5de5\u5355\u5904\u7406\u63d0\u9192\uff1a" + workInfo.getWorkTitle()), (String)(workInfo.getAddAccountName() + "\u65b0\u5efa\u4e86\u5de5\u5355\u3010" + workInfo.getWorkTitle() + "\u3011\uff0c\u53d7\u7406\u4eba\uff1a" + workInfo.getAcceptAccountName()), (String)workInfo.getAcceptAccount());
        ThreadPoolUtil.executor.execute(runnable);
    }

    public void saveAttachFile(List<MultipartFile> fileList, String workInfoId) {
        try {
            if (fileList.size() < 1) {
                logger.info("\u5de5\u5355\u6ca1\u6709\u4e0a\u4f20\u9644\u4ef6:" + workInfoId);
                return;
            }
            for (MultipartFile file : fileList) {
                String fileSize = FormatUtil.bytesFormatUnit((String)(file.getBytes().length + ""));
                String sourceFileName = file.getOriginalFilename();
                if (StringUtils.isEmpty((CharSequence)sourceFileName)) continue;
                String fileType = sourceFileName.substring(sourceFileName.lastIndexOf(".") + 1);
                if (!this.commonConfig.getWorkAttachType().contains(fileType)) {
                    logger.error("\u4e0d\u5141\u8bb8\u4e0a\u4f20\u7684\u9644\u4ef6\u7c7b\u578b:" + sourceFileName);
                    return;
                }
                String day = DateUtil.getCurrentDate().replace("-", "");
                String saveFolder = StaticKeys.JAR_PATH + "/uploadFile/" + day;
                FileUtils.existsFolder((String)saveFolder);
                String newFileName = DateUtil.getCurrentDateTimeNoChar() + FormatUtil.getRandInt() + "." + fileType;
                String newFilePath = saveFolder + "/" + newFileName;
                Path path = Paths.get(newFilePath, new String[0]);
                file.transferTo(path);
                WorkFileInfo workFileInfo = new WorkFileInfo();
                workFileInfo.setFileName(sourceFileName);
                workFileInfo.setWorkInfoId(workInfoId);
                workFileInfo.setFilePath("/uploadFile/" + day + "/" + newFileName);
                workFileInfo.setFileSize(fileSize);
                this.workFileInfoService.save(workFileInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u9519\u8bef", (Throwable)e);
        }
    }

    @Transactional
    public int deleteById(String[] id) throws Exception {
        return this.workInfoMapper.deleteById(id);
    }

    public void updateById(WorkInfo workInfo) throws Exception {
        workInfo.setUpdateTime(new Date());
        this.workInfoMapper.updateById(workInfo);
    }

    public WorkInfo selectById(String id) throws Exception {
        return this.workInfoMapper.selectById(id);
    }

    public List<WorkInfo> selectAllByParams(Map<String, Object> params) throws Exception {
        return this.workInfoMapper.selectAllByParams(params);
    }

    public List<WorkInfo> selectAllByParamsNoContent(Map<String, Object> params) throws Exception {
        return this.workInfoMapper.selectAllByParamsNoContent(params);
    }

    public int countByParams(Map<String, Object> params) throws Exception {
        return this.workInfoMapper.countByParams(params);
    }

    public int closeWorkInfoAuto(Map<String, Object> params) throws Exception {
        return this.workInfoMapper.closeWorkInfoAuto(params);
    }

    public void setRealNameInList(List<WorkInfo> recordList) throws Exception {
        HashMap params = new HashMap();
        List accountInfoList = this.accountInfoService.selectAllByParams(params);
        HashMap<String, String> accountMap = new HashMap<String, String>();
        for (AccountInfo accountInfo : accountInfoList) {
            accountMap.put(accountInfo.getAccount(), accountInfo.getRealName());
        }
        for (WorkInfo workInfo : recordList) {
            if (!StringUtils.isEmpty((CharSequence)workInfo.getAddAccount()) && !StringUtils.isEmpty((CharSequence)((CharSequence)accountMap.get(workInfo.getAddAccount())))) {
                workInfo.setAddAccount((String)accountMap.get(workInfo.getAddAccount()));
            }
            if (StringUtils.isEmpty((CharSequence)workInfo.getAcceptAccount()) || StringUtils.isEmpty((CharSequence)((CharSequence)accountMap.get(workInfo.getAcceptAccount())))) continue;
            workInfo.setAcceptAccount((String)accountMap.get(workInfo.getAcceptAccount()));
        }
    }

    public void addPrefixParams(WorkInfo workInfo, Map<String, Object> params, StringBuffer url, HttpServletRequest request, Model model) throws Exception {
        String timeRange;
        if (!StringUtils.isEmpty((CharSequence)workInfo.getWorkTitle())) {
            params.put("workTitle", workInfo.getWorkTitle());
            url.append("&workTitle=").append(workInfo.getWorkTitle());
        }
        if (null != workInfo.getWorkCode()) {
            params.put("workCode", workInfo.getWorkCode());
            url.append("&workCode=").append(workInfo.getWorkCode());
        }
        if (!StringUtils.isEmpty((CharSequence)(timeRange = request.getParameter("startTime")))) {
            String startTime = timeRange.split(" - ")[0].trim();
            String endTime = timeRange.split(" - ")[1].trim();
            params.put("startTime", startTime + " 00:00:00");
            params.put("endTime", endTime + " 23:59:59");
            url.append("&startTime=").append(timeRange);
            model.addAttribute("startTime", (Object)timeRange);
        }
    }

    public void handleWork(WorkInfo workInfo, HttpServletRequest request, List<MultipartFile> fileList) throws Exception {
        AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
        if (!StringUtils.isEmpty((CharSequence)workInfo.getId())) {
            WorkInfo savedData = this.selectById(workInfo.getId());
            if (!accountInfo.getAccount().equals(savedData.getAcceptAccount()) && !"admin".equals(accountInfo.getRole())) {
                logger.error("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u5904\u7406\u8be5\u5de5\u5355:" + accountInfo.getAccount() + "-------" + savedData.getWorkTitle());
                this.logInfoService.save("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u5904\u7406\u8be5\u5de5\u5355:" + accountInfo.getAccount(), savedData.getWorkTitle(), "");
                return;
            }
            if (!"1".equals(savedData.getState()) && !"2".equals(savedData.getState())) {
                logger.error("\u5de5\u5355\u5df2\u7ecf\u7ed3\u675f\uff0c\u65e0\u6cd5\u5904\u7406:" + accountInfo.getAccount() + "-------" + savedData.getWorkTitle());
                this.logInfoService.save("\u5de5\u5355\u5df2\u7ecf\u7ed3\u675f\uff0c\u65e0\u6cd5\u5904\u7406:" + accountInfo.getAccount(), savedData.getWorkTitle(), "");
                return;
            }
            WorkInfo workInfoUpdate = new WorkInfo();
            workInfoUpdate.setId(workInfo.getId());
            workInfoUpdate.setState(workInfo.getState());
            workInfoUpdate.setUpdateTime(new Date());
            if (!StringUtils.isEmpty((CharSequence)workInfo.getAcceptAccount())) {
                workInfoUpdate.setAcceptAccount(workInfo.getAcceptAccount());
                String acceptRealName = WorkUtil.getRealName((String)workInfoUpdate.getAcceptAccount());
                workInfoUpdate.setAcceptAccountName(acceptRealName);
            }
            this.updateById(workInfoUpdate);
            WorkHandleInfo workHandleInfo = this.saveWorkHandleInfo(workInfoUpdate.getId(), workInfo.getWorkContent(), workInfoUpdate.getState(), accountInfo.getRealName(), workInfoUpdate.getAcceptAccountName());
            this.saveAttachFile(fileList, workHandleInfo.getId());
            this.saveLog(request, "\u66f4\u65b0", savedData);
            Runnable runnable = () -> {
                if (workInfoUpdate.getState().equals("4")) {
                    WarnOtherUtil.sendUtil((String)("\u5de5\u5355\u5904\u7406\u63d0\u9192\uff1a" + savedData.getWorkTitle()), (String)(workHandleInfo.getHandleAccountName() + "\u62d2\u7edd\u4e86\u5de5\u5355\u3010" + savedData.getWorkTitle() + "\u3011\uff0c\u5de5\u5355ID\u4e3a\u3010" + savedData.getWorkCode() + "\u3011"), (String)savedData.getAddAccount());
                }
                if (workInfoUpdate.getState().equals("5")) {
                    WarnOtherUtil.sendUtil((String)("\u5de5\u5355\u5904\u7406\u63d0\u9192\uff1a" + savedData.getWorkTitle()), (String)(workHandleInfo.getHandleAccountName() + "\u5b8c\u6210\u4e86\u5de5\u5355\u3010" + savedData.getWorkTitle() + "\u3011\uff0c\u5de5\u5355ID\u4e3a\u3010" + savedData.getWorkCode() + "\u3011"), (String)savedData.getAddAccount());
                }
                if (workInfoUpdate.getState().equals("1") || workInfoUpdate.getState().equals("2")) {
                    WarnOtherUtil.sendUtil((String)("\u5de5\u5355\u5904\u7406\u63d0\u9192\uff1a" + savedData.getWorkTitle()), (String)(workHandleInfo.getHandleAccountName() + "\u66f4\u65b0\u4e86\u5de5\u5355\u3010" + savedData.getWorkTitle() + "\u3011\uff0c\u5de5\u5355ID\u4e3a\u3010" + savedData.getWorkCode() + "\u3011\uff0c\u5de5\u5355\u5f53\u524d\u72b6\u6001\uff1a" + this.getStateName(workInfoUpdate.getState()) + "\uff0c\u53d7\u7406\u4eba\uff1a" + workHandleInfo.getAcceptAccountName()), (String)workInfo.getAcceptAccount());
                }
            };
            ThreadPoolUtil.executor.execute(runnable);
        }
    }

    public String getStateName(String state) {
        String result = "";
        if (StringUtils.isEmpty((CharSequence)state)) {
            return result;
        }
        switch (state) {
            case "1": {
                result = "\u5f85\u63a5\u6536";
                break;
            }
            case "2": {
                result = "\u5904\u7406\u4e2d";
                break;
            }
            case "3": {
                result = "\u5df2\u5173\u95ed";
                break;
            }
            case "4": {
                result = "\u5df2\u62d2\u7edd";
                break;
            }
            case "5": {
                result = "\u5df2\u5b8c\u6210";
                break;
            }
            default: {
                result = "\u5904\u7406\u4e2d";
            }
        }
        return result;
    }

    public void assignWork(HttpServletRequest request) throws Exception {
        AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
        String id = request.getParameter("id");
        if (!StringUtils.isEmpty((CharSequence)id)) {
            WorkInfo savedData = this.selectById(id);
            if (!accountInfo.getAccount().equals(savedData.getAcceptAccount()) && !"admin".equals(accountInfo.getRole())) {
                logger.error("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u5904\u7406\u8be5\u5de5\u5355:" + accountInfo.getAccount() + "-------" + savedData.getWorkTitle());
                this.logInfoService.save("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u5904\u7406\u8be5\u5de5\u5355:" + accountInfo.getAccount(), savedData.getWorkTitle(), "");
                return;
            }
            if (!"1".equals(savedData.getState()) && !"2".equals(savedData.getState())) {
                logger.error("\u5de5\u5355\u5df2\u7ecf\u7ed3\u675f\uff0c\u65e0\u6cd5\u5206\u914d:" + accountInfo.getAccount() + "-------" + savedData.getWorkTitle());
                this.logInfoService.save("\u5de5\u5355\u5df2\u7ecf\u7ed3\u675f\uff0c\u65e0\u6cd5\u5206\u914d:" + accountInfo.getAccount(), savedData.getWorkTitle(), "");
                return;
            }
            WorkInfo workInfoUpdate = new WorkInfo();
            workInfoUpdate.setId(id);
            workInfoUpdate.setState("1");
            workInfoUpdate.setUpdateTime(new Date());
            workInfoUpdate.setAcceptAccount(request.getParameter("acceptAccount"));
            String acceptRealName = WorkUtil.getRealName((String)workInfoUpdate.getAcceptAccount());
            workInfoUpdate.setAcceptAccountName(acceptRealName);
            this.updateById(workInfoUpdate);
            WorkHandleInfo workHandleInfo = this.saveWorkHandleInfo(workInfoUpdate.getId(), request.getParameter("workContent"), workInfoUpdate.getState(), accountInfo.getRealName(), acceptRealName);
            this.saveLog(request, "\u5206\u914d", savedData);
            Runnable runnable = () -> {
                String title = "\u5de5\u5355\u5206\u914d\u63d0\u9192\uff1a" + savedData.getWorkTitle();
                String content = workHandleInfo.getHandleAccountName() + "\u5206\u914d\u4e86\u5de5\u5355\u3010" + savedData.getWorkTitle() + "\u3011\uff0c\u5de5\u5355ID\u4e3a\u3010" + savedData.getWorkCode() + "\u3011\uff0c\u53d7\u7406\u4eba\uff1a" + workHandleInfo.getAcceptAccountName();
                WarnOtherUtil.sendUtil((String)title, (String)content, (String)workInfoUpdate.getAcceptAccount());
            };
            ThreadPoolUtil.executor.execute(runnable);
        }
    }

    public void commentWork(HttpServletRequest request) throws Exception {
        AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
        String id = request.getParameter("id");
        if (!StringUtils.isEmpty((CharSequence)id)) {
            WorkInfo savedData = this.selectById(id);
            if ("3".equals(savedData.getState())) {
                logger.error("\u8be5\u5de5\u5355\u5df2\u7ecf\u5173\u95ed\uff0c\u65e0\u6cd5\u8bc4\u8bba:" + accountInfo.getAccount() + "-------" + savedData.getWorkTitle());
                this.logInfoService.save("\u8be5\u5de5\u5355\u5df2\u7ecf\u5173\u95ed\uff0c\u65e0\u6cd5\u8bc4\u8bba:" + accountInfo.getAccount(), savedData.getWorkTitle(), "");
                return;
            }
            WorkInfo workInfoUpdate = new WorkInfo();
            workInfoUpdate.setId(id);
            workInfoUpdate.setUpdateTime(new Date());
            this.updateById(workInfoUpdate);
            WorkHandleInfo workHandleInfo = this.saveWorkHandleInfo(workInfoUpdate.getId(), request.getParameter("workContent"), "0", accountInfo.getRealName(), "");
            this.saveLog(request, "\u8bc4\u8bba", savedData);
            Runnable runnable = () -> WarnOtherUtil.sendUtil((String)("\u5de5\u5355\u8bc4\u8bba\u63d0\u9192\uff1a" + savedData.getWorkTitle()), (String)(workHandleInfo.getHandleAccountName() + "\u8bc4\u8bba\u4e86\u5de5\u5355\u3010" + savedData.getWorkTitle() + "\u3011\uff0c\u5de5\u5355ID\u4e3a\u3010" + savedData.getWorkCode() + "\u3011\uff0c\u8bc4\u8bba\u5185\u5bb9\uff1a" + workHandleInfo.getWorkContent()), (String)"");
            ThreadPoolUtil.executor.execute(runnable);
        }
    }

    public void receiveWork(HttpServletRequest request) throws Exception {
        AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
        if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
            String[] ids;
            for (String id : ids = request.getParameter("id").split(",")) {
                WorkInfo savedData = this.selectById(id);
                if (!accountInfo.getAccount().equals(savedData.getAcceptAccount()) && !"admin".equals(accountInfo.getRole())) {
                    logger.error("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u5904\u7406\u8be5\u5de5\u5355:" + accountInfo.getAccount() + "-------" + savedData.getWorkTitle());
                    this.logInfoService.save("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u5904\u7406\u8be5\u5de5\u5355:" + accountInfo.getAccount(), savedData.getWorkTitle(), "");
                    continue;
                }
                WorkInfo workInfoUpdate = new WorkInfo();
                workInfoUpdate.setId(id);
                workInfoUpdate.setState("2");
                workInfoUpdate.setUpdateTime(new Date());
                this.updateById(workInfoUpdate);
                WorkHandleInfo workHandleInfo = this.saveWorkHandleInfo(workInfoUpdate.getId(), "\u5df2\u63a5\u6536\u5de5\u5355", workInfoUpdate.getState(), accountInfo.getRealName(), "");
                this.saveLog(request, "\u63a5\u6536\u4e86", savedData);
                Runnable runnable = () -> WarnOtherUtil.sendUtil((String)("\u5de5\u5355\u72b6\u6001\u66f4\u65b0\u63d0\u9192\uff1a" + savedData.getWorkTitle()), (String)(workHandleInfo.getHandleAccountName() + "\u63a5\u6536\u4e86\u5de5\u5355\u3010" + savedData.getWorkTitle() + "\u3011\uff0c\u5de5\u5355ID\u4e3a\u3010" + savedData.getWorkCode() + "\u3011"), (String)savedData.getAddAccount());
                ThreadPoolUtil.executor.execute(runnable);
            }
        }
    }

    public void delComment(HttpServletRequest request) throws Exception {
        AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
        String id = request.getParameter("id");
        if (!StringUtils.isEmpty((CharSequence)id)) {
            WorkHandleInfo workHandleInfo = this.workHandleInfoService.selectById(id);
            WorkInfo savedData = this.selectById(workHandleInfo.getWorkInfoId());
            if (!accountInfo.getRealName().equals(workHandleInfo.getHandleAccountName()) && !"admin".equals(accountInfo.getRole())) {
                logger.error("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u5220\u9664\u8be5\u5de5\u5355\u8bc4\u8bba:" + accountInfo.getAccount() + "-------" + savedData.getWorkTitle());
                this.logInfoService.save("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u5220\u9664\u8be5\u5de5\u5355\u8bc4\u8bba:" + accountInfo.getAccount(), savedData.getWorkTitle(), "");
                return;
            }
            this.workHandleInfoService.deleteById(id.split(","));
            this.saveLog(request, "\u5220\u9664\u5de5\u5355\u8bc4\u8bba", savedData);
        }
    }

    public void reopenWork(HttpServletRequest request) throws Exception {
        AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
        String id = request.getParameter("id");
        String workContent = request.getParameter("workContent");
        if (!StringUtils.isEmpty((CharSequence)id)) {
            WorkInfo savedData = this.selectById(id);
            if (!accountInfo.getAccount().equals(savedData.getAddAccount()) && !"admin".equals(accountInfo.getRole())) {
                logger.error("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u91cd\u65b0\u6253\u5f00\u8be5\u5de5\u5355:" + accountInfo.getAccount() + "-------" + savedData.getWorkTitle());
                this.logInfoService.save("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u91cd\u65b0\u6253\u5f00\u8be5\u5de5\u5355:" + accountInfo.getAccount(), savedData.getWorkTitle(), "");
                return;
            }
            WorkInfo workInfoUpdate = new WorkInfo();
            workInfoUpdate.setId(id);
            workInfoUpdate.setState("1");
            workInfoUpdate.setAcceptAccount(request.getParameter("acceptAccount"));
            String acceptRealName = WorkUtil.getRealName((String)workInfoUpdate.getAcceptAccount());
            workInfoUpdate.setAcceptAccountName(acceptRealName);
            workInfoUpdate.setUpdateTime(new Date());
            this.updateById(workInfoUpdate);
            WorkHandleInfo workHandleInfo = this.saveWorkHandleInfo(workInfoUpdate.getId(), workContent, workInfoUpdate.getState(), accountInfo.getRealName(), acceptRealName);
            this.saveLog(request, "\u91cd\u65b0\u6253\u5f00", savedData);
            Runnable runnable = () -> WarnOtherUtil.sendUtil((String)("\u5de5\u5355\u91cd\u65b0\u6253\u5f00\u63d0\u9192\uff1a" + savedData.getWorkTitle()), (String)(workHandleInfo.getHandleAccountName() + "\u91cd\u65b0\u6253\u5f00\u4e86\u5de5\u5355\u3010" + savedData.getWorkTitle() + "\u3011\uff0c\u5de5\u5355ID\u4e3a\u3010" + savedData.getWorkCode() + "\u3011\uff0c\u53d7\u7406\u4eba\uff1a" + workHandleInfo.getAcceptAccountName()), (String)workInfoUpdate.getAcceptAccount());
            ThreadPoolUtil.executor.execute(runnable);
        }
    }

    public void closeWork(HttpServletRequest request) throws Exception {
        AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
        String id = request.getParameter("id");
        if (!StringUtils.isEmpty((CharSequence)id)) {
            WorkInfo savedData = this.selectById(id);
            if (!accountInfo.getAccount().equals(savedData.getAddAccount()) && !"admin".equals(accountInfo.getRole())) {
                logger.error("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u5173\u95ed\u8be5\u5de5\u5355:" + accountInfo.getAccount() + "-------" + savedData.getWorkTitle());
                this.logInfoService.save("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u5173\u95ed\u8be5\u5de5\u5355:" + accountInfo.getAccount(), savedData.getWorkTitle(), "");
                return;
            }
            WorkInfo workInfoUpdate = new WorkInfo();
            workInfoUpdate.setId(id);
            workInfoUpdate.setState("3");
            workInfoUpdate.setUpdateTime(new Date());
            this.updateById(workInfoUpdate);
            WorkHandleInfo workHandleInfo = this.saveWorkHandleInfo(workInfoUpdate.getId(), "\u5173\u95ed\u5de5\u5355", workInfoUpdate.getState(), accountInfo.getRealName(), "");
            this.saveLog(request, "\u5173\u95ed", savedData);
            Runnable runnable = () -> WarnOtherUtil.sendUtil((String)("\u5de5\u5355\u5173\u95ed\u63d0\u9192\uff1a" + savedData.getWorkTitle()), (String)(workHandleInfo.getHandleAccountName() + "\u5173\u95ed\u4e86\u5de5\u5355\u3010" + savedData.getWorkTitle() + "\u3011\uff0c\u5de5\u5355ID\u4e3a\u3010" + savedData.getWorkCode() + "\u3011"), (String)workInfoUpdate.getAcceptAccount());
            ThreadPoolUtil.executor.execute(runnable);
        }
    }

    public WorkHandleInfo saveWorkHandleInfo(String workInfoId, String workContent, String state, String handleAccountName, String acceptAccountName) {
        WorkHandleInfo workHandleInfo = new WorkHandleInfo();
        try {
            workHandleInfo.setWorkInfoId(workInfoId);
            workHandleInfo.setWorkContent(workContent);
            workHandleInfo.setState(state);
            workHandleInfo.setHandleAccountName(handleAccountName);
            workHandleInfo.setAcceptAccountName(acceptAccountName);
            this.workHandleInfoService.save(workHandleInfo);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u5de5\u5355\u5904\u7406\u8bb0\u5f55\u4fe1\u606f\u8868\u9519\u8bef", (Throwable)e);
        }
        return workHandleInfo;
    }

    public void saveLog(HttpServletRequest request, String action, WorkInfo workInfo) {
        if (null == workInfo) {
            return;
        }
        try {
            String acceptRealName = "";
            acceptRealName = null == StaticKeys.ACCOUNT_INFO_MAP.get(workInfo.getAcceptAccount()) ? workInfo.getAcceptAccount() : ((AccountInfo)StaticKeys.ACCOUNT_INFO_MAP.get(workInfo.getAcceptAccount())).getRealName();
            this.logInfoService.save(HostUtil.getAccountByRequest((HttpServletRequest)request).getRealName() + action + "\u5de5\u5355\uff1a" + workInfo.getWorkTitle(), "\u53d7\u7406\u4eba\uff1a" + acceptRealName + "\uff0c\u5de5\u5355ID\u4e3a\u3010" + workInfo.getWorkCode() + "\u3011", "2");
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u5de5\u5355\u64cd\u4f5c\u65e5\u5fd7\u9519\u8bef", (Throwable)e);
        }
    }
}

