/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.common;

import com.wgcloud.config.CommonConfig;
import com.wgcloud.util.MD5Utils;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.UUIDUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ApplicationStartListener
implements ApplicationRunner {
    private Logger logger = LoggerFactory.getLogger(ApplicationStartListener.class);
    @Autowired
    CommonConfig commonConfig;
    @Autowired
    private ServletContext servletContext;
    @Autowired
    private Environment env;

    public void run(ApplicationArguments args) throws Exception {
        this.servletContext.setAttribute("sidebarCollapse", (Object)this.commonConfig.getSidebarCollapse());
        this.servletContext.setAttribute("hostGroup", (Object)this.commonConfig.getHostGroup());
        this.servletContext.setAttribute("SESSION_VERCODE", (Object)this.commonConfig.getVercodeCheck());
        this.servletContext.setAttribute("SESSION_SHOWEQUIPMENTMENU", (Object)this.commonConfig.getShowEquipmentMenu());
        this.servletContext.setAttribute("SESSION_SHOWPASSWDINFOMENU", (Object)this.commonConfig.getShowPasswdInfoMenu());
        this.servletContext.setAttribute("SESSION_SHOWNOTEINFOMENU", (Object)this.commonConfig.getShowNoteInfoMenu());
        StaticKeys.PAGE_SIZE = this.commonConfig.getPageSize();
        ApplicationHome h = new ApplicationHome(this.getClass());
        String jarPath = h.getSource().getParentFile().toString();
        this.logger.debug("jar\u5305\u8def\u5f84-----------------" + jarPath);
        StaticKeys.JAR_PATH = jarPath;
        this.servletContext.setAttribute("serverInfoId", (Object)UUIDUtil.getUUID());
        if (null != this.commonConfig.getMaxPoolSize()) {
            ThreadPoolUtil.executor.setMaximumPoolSize(this.commonConfig.getMaxPoolSize());
        }
        StaticKeys.SERVER_WGTOKEN_MD5STR = MD5Utils.GetMD5Code((String)this.commonConfig.getWgToken());
        String serverServletContextPath = this.env.getProperty("server.servlet.context-path");
        if (!StringUtils.isEmpty((CharSequence)serverServletContextPath) && !"/".equals(serverServletContextPath)) {
            StaticKeys.SERVER_SERVLET_CONTEXT_PATH = serverServletContextPath;
            this.servletContext.setAttribute("SERVER_SERVLET_CONTEXT_PATH", (Object)StaticKeys.SERVER_SERVLET_CONTEXT_PATH);
            this.logger.info("server.servlet.context-path--------------" + serverServletContextPath);
        } else {
            this.servletContext.setAttribute("SERVER_SERVLET_CONTEXT_PATH", (Object)"");
        }
        StaticKeys.WGCLOUD_CAT_RELEASE_JAR_MD5 = MD5Utils.getMD5ForFile((String)(StaticKeys.JAR_PATH + "/wgcat-release.jar"));
    }
}

