/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.service.AccountInfoService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.MD5Utils;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/accountInfo"})
public class AccountInfoController {
    private static final Logger logger = LoggerFactory.getLogger(AccountInfoController.class);
    @Resource
    private AccountInfoService accountInfoService;
    @Resource
    private LogInfoService logInfoService;

    private void testThread() {
        new Thread(() -> logger.info("\u542f\u52a8\u5b50\u7ebf\u7a0b\u6d4b\u8bd5")).start();
    }

    @RequestMapping(value={"list"})
    public String AccountInfoList(AccountInfo accountInfo, Model model, HttpServletRequest request) {
        String errorMsg = "\u67e5\u8be2\u6210\u5458\u8d26\u53f7\u4fe1\u606f\u9519\u8bef";
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            LicenseUtil.maxLicense_10((Model)model, (HttpServletRequest)request, (Object)accountInfo);
            StringBuffer url = new StringBuffer();
            if (!StringUtils.isEmpty((CharSequence)accountInfo.getRealName())) {
                params.put("realName", accountInfo.getRealName());
                url.append("&realName=").append(accountInfo.getRealName());
            }
            PageInfo pageInfo = this.accountInfoService.selectByParams(params, Integer.valueOf(accountInfo.getPage()).intValue(), Integer.valueOf(accountInfo.getPageSize()).intValue());
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("pageUrl", (Object)("/accountInfo/list?1=1" + url.toString()));
            model.addAttribute("accountInfo", (Object)accountInfo);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "accountInfo/list";
    }

    @RequestMapping(value={"editPasswd"})
    public String editPasswd(Model model, HttpServletRequest request) {
        String errorMsg = "\u4fee\u6539\u6210\u5458\u5bc6\u7801\u9519\u8bef";
        if (!this.isAdminRole(request)) {
            return "error/guestError";
        }
        String id = request.getParameter("id");
        AccountInfo accountInfo = new AccountInfo();
        try {
            accountInfo = this.accountInfoService.selectById(id);
            model.addAttribute("accountInfo", (Object)accountInfo);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "accountInfo/passwd";
    }

    @RequestMapping(value={"edit"})
    public String edit(Model model, HttpServletRequest request) {
        String errorMsg = "\u6dfb\u52a0\u6210\u5458\u8d26\u53f7\u4fe1\u606f\u9519\u8bef";
        String id = request.getParameter("id");
        AccountInfo accountInfo = new AccountInfo();
        try {
            if (StringUtils.isEmpty((CharSequence)id)) {
                model.addAttribute("accountInfo", (Object)accountInfo);
                if (!this.isAddContinue()) {
                    return "redirect:/accountInfo/list?liceFlage=1";
                }
                return "accountInfo/add";
            }
            accountInfo = this.accountInfoService.selectById(id);
            model.addAttribute("accountInfo", (Object)accountInfo);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "accountInfo/add";
    }

    @RequestMapping(value={"save"})
    public String saveAccountInfo(AccountInfo accountInfo, Model model, HttpServletRequest request) {
        if (!this.isAdminRole(request)) {
            return "error/guestError";
        }
        if (!StringUtils.isEmpty((CharSequence)accountInfo.getPasswd())) {
            accountInfo.setPasswd(MD5Utils.GetMD5Code((String)accountInfo.getPasswd()));
        }
        try {
            if (StringUtils.isEmpty((CharSequence)accountInfo.getId())) {
                this.accountInfoService.save(accountInfo);
                this.accountInfoService.saveLog(request, "\u6dfb\u52a0", accountInfo);
            } else {
                this.accountInfoService.updateById(accountInfo);
                this.accountInfoService.saveLog(request, "\u4fee\u6539", accountInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6210\u5458\u8d26\u53f7\u4fe1\u606f\u9519\u8bef\uff1a", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58\u6210\u5458\u8d26\u53f7\u4fe1\u606f\u9519\u8bef", "\u4fdd\u5b58\u6210\u5458\u4fe1\u606f\u9519\u8bef\uff1a" + e.toString(), "2");
        }
        return "redirect:/accountInfo/list";
    }

    @RequestMapping(value={"savePasswd"})
    public String savePasswd(AccountInfo accountInfo, Model model, HttpServletRequest request) {
        if (!this.isAdminRole(request)) {
            return "error/guestError";
        }
        if (!StringUtils.isEmpty((CharSequence)accountInfo.getPasswd())) {
            accountInfo.setPasswd(MD5Utils.GetMD5Code((String)accountInfo.getPasswd()));
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)accountInfo.getId())) {
                this.accountInfoService.updateById(accountInfo);
                AccountInfo accountInfoView = this.accountInfoService.selectById(accountInfo.getId());
                this.accountInfoService.saveLog(request, "\u4fee\u6539", accountInfoView);
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6210\u5458\u8d26\u53f7\u5bc6\u7801\u9519\u8bef\uff1a", (Throwable)e);
            this.logInfoService.save("\u4fee\u6539\u6210\u5458\u8d26\u53f7\u5bc6\u7801\u9519\u8bef", "\u4fee\u6539\u6210\u5458\u8d26\u53f7\u5bc6\u7801\u9519\u8bef\uff1a" + e.toString(), "2");
        }
        return "redirect:/accountInfo/list";
    }

    @ResponseBody
    @RequestMapping(value={"moveToAccount"})
    public String moveToAccount(Model model, HttpServletRequest request) {
        try {
            if (!this.isAdminRole(request)) {
                return "error/guestError";
            }
            String accountSource = request.getParameter("idSourceAccount");
            String accountTarget = request.getParameter("account");
            String resourceType = request.getParameter("resourceType");
            this.accountInfoService.moveToAccount(accountTarget, accountSource, resourceType);
        }
        catch (Exception e) {
            logger.error("\u8fc1\u79fb\u8d26\u53f7\u8d44\u6e90\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u8fc1\u79fb\u8d26\u53f7\u8d44\u6e90\u9519\u8bef", e.toString(), "2");
        }
        return "redirect:/accountInfo/list";
    }

    @RequestMapping(value={"del"})
    public String delete(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        if (!this.isAdminRole(request)) {
            return "error/guestError";
        }
        String errorMsg = "\u5220\u9664\u6210\u5458\u8d26\u53f7\u9519\u8bef";
        try {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                String[] ids;
                for (String id : ids = request.getParameter("id").split(",")) {
                    AccountInfo accountInfo = this.accountInfoService.selectById(id);
                    this.accountInfoService.saveLog(request, "\u5220\u9664", accountInfo);
                }
                this.accountInfoService.deleteById(ids);
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "redirect:/accountInfo/list";
    }

    @RequestMapping(value={"updateState"})
    public String updateState(Model model, HttpServletRequest request) {
        String errorMsg = "\u6279\u91cf\u542f\u7528\u548c\u505c\u6b62\u8d26\u53f7\u9519\u8bef";
        try {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                String[] ids = request.getParameter("id").split(",");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("ids", ids);
                String stateValue = request.getParameter("state");
                params.put("state", stateValue);
                this.accountInfoService.updateState(params);
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "redirect:/accountInfo/list";
    }

    private boolean isAdminRole(HttpServletRequest request) {
        AccountInfo accountInfoSession = HostUtil.getAccountByRequest((HttpServletRequest)request);
        return "admin".equals(accountInfoSession.getRole());
    }

    private boolean isAddContinue() {
        try {
            HashMap params;
            int dbSize;
            if (!StaticKeys.LICENSE_STATE.equals("1") && (dbSize = this.accountInfoService.countByParams(params = new HashMap())) >= 5) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error("isAddContinue error", (Throwable)e);
        }
        return true;
    }
}

