/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.github.pagehelper.PageInfo;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.service.AccountInfoService;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.PasswdInfoService;
import com.wgcloud.service.WorkHandleInfoService;
import com.wgcloud.service.WorkInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/accountReportInfo"})
public class AccountReportController {
    private static final Logger logger = LoggerFactory.getLogger(AccountReportController.class);
    @Resource
    private PasswdInfoService passwdInfoService;
    @Resource
    private AccountInfoService accountInfoService;
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private WorkInfoService workInfoService;
    @Resource
    private WorkHandleInfoService workHandleInfoService;
    @Resource
    private HostGroupService hostGroupService;
    @Autowired
    private CommonConfig commonConfig;

    @RequestMapping(value={"viewReport"})
    public String viewReport(AccountInfo accountInfo, Model model, HttpServletRequest request) {
        int dayInt;
        String days = request.getParameter("days");
        if (StringUtils.isEmpty((CharSequence)days)) {
            days = "7";
        }
        if (!StaticKeys.LICENSE_STATE.equals("1") && (dayInt = Integer.valueOf(days).intValue()) > 7) {
            days = "7";
            model.addAttribute("msg", (Object)"\u4e2a\u4eba\u7248\u53ea\u80fd\u67e5\u770b\u6700\u8fd17\u5929\u56fe\u8868\uff0c\u8bf7\u70b9\u51fb\u9875\u9762\u5e95\u90e8\u7f51\u7ad9\uff0c\u8054\u7cfb\u6211\u4eec\u5347\u7ea7\u5230\u4e13\u4e1a\u7248");
        }
        model.addAttribute("days", (Object)days);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            StringBuffer url = new StringBuffer();
            if (!StringUtils.isEmpty((CharSequence)accountInfo.getRealName())) {
                params.put("realName", accountInfo.getRealName());
                url.append("&realName=").append(accountInfo.getRealName());
            }
            if (!StringUtils.isEmpty((CharSequence)days)) {
                url.append("&days=").append(days);
            }
            PageInfo pageInfo = this.accountInfoService.selectByParams(params, Integer.valueOf(accountInfo.getPage()).intValue(), Integer.valueOf(accountInfo.getPageSize()).intValue());
            for (AccountInfo accountInfo1 : pageInfo.getList()) {
                this.setWorkStateData(accountInfo1, days, request);
                this.setWorkNewStateData(accountInfo1, days, request);
            }
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("pageUrl", (Object)("/accountReportInfo/viewReport?1=1" + url.toString()));
            model.addAttribute("accountInfo", (Object)accountInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7edf\u8ba1\u5206\u6790\u62a5\u544a\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u7edf\u8ba1\u5206\u6790\u62a5\u544a\u9519\u8bef", e.toString(), "2");
        }
        return "accountReport/list";
    }

    private void setWorkNewStateData(AccountInfo accountInfo, String days, HttpServletRequest request) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            String startDate = DateUtil.getDateBefore((int)Integer.valueOf(days));
            startDate = startDate.substring(0, 10) + " 00:00:00";
            String endDate = DateUtil.getCurrentDateTime();
            params.put("startTime", startDate);
            params.put("endTime", endDate);
            params.put("addAccount", accountInfo.getAccount());
            int size = this.workInfoService.countByParams(params);
            accountInfo.setXinjianNum(size + "");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7edf\u8ba1\u5206\u6790\u62a5\u544a\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u7edf\u8ba1\u5206\u6790\u62a5\u544a\u9519\u8bef", e.toString(), "2");
        }
    }

    private void setWorkStateData(AccountInfo accountInfo, String days, HttpServletRequest request) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            String startDate = DateUtil.getDateBefore((int)Integer.valueOf(days));
            startDate = startDate.substring(0, 10) + " 00:00:00";
            String endDate = DateUtil.getCurrentDateTime();
            params.put("startTime", startDate);
            params.put("endTime", endDate);
            params.put("state", "0");
            params.put("handleAccountNameEQ", accountInfo.getRealName());
            Integer workSize_0 = this.workHandleInfoService.countByParams(params);
            accountInfo.setPinglunNum(workSize_0 + "");
            params.remove("state");
            ArrayList<String> stateList = new ArrayList<String>();
            stateList.add("1");
            stateList.add("2");
            params.put("stateList", stateList);
            params.put("handleAccountNameEQ", accountInfo.getRealName());
            Integer workSize_2 = this.workHandleInfoService.countByParams(params);
            accountInfo.setChuliNum(workSize_2 + "");
            params.remove("stateList");
            params.put("state", "3");
            params.put("handleAccountNameEQ", accountInfo.getRealName());
            Integer workSize_3 = this.workHandleInfoService.countByParams(params);
            accountInfo.setGuanbiNum(workSize_3 + "");
            params.put("state", "4");
            params.put("handleAccountNameEQ", accountInfo.getRealName());
            Integer workSize_4 = this.workHandleInfoService.countByParams(params);
            accountInfo.setJujueNum(workSize_4 + "");
            params.put("state", "5");
            params.put("handleAccountNameEQ", accountInfo.getRealName());
            Integer workSize_5 = this.workHandleInfoService.countByParams(params);
            accountInfo.setWanchengNum(workSize_5 + "");
            params.put("state", "1");
            params.remove("handleAccountNameEQ");
            params.put("acceptAccountNameEQ", accountInfo.getRealName());
            Integer workSize_6 = this.workHandleInfoService.countByParams(params);
            accountInfo.setJieshouNum(workSize_6 + "");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7edf\u8ba1\u5206\u6790\u62a5\u544a\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u7edf\u8ba1\u5206\u6790\u62a5\u544a\u9519\u8bef", e.toString(), "2");
        }
    }
}

