/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.WorkInfo;
import com.wgcloud.service.AccountInfoService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.WorkFileInfoService;
import com.wgcloud.service.WorkHandleInfoService;
import com.wgcloud.service.WorkInfoService;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/workInfoGuest"})
public class WorkInfoGuestController {
    private static final Logger logger = LoggerFactory.getLogger(WorkInfoGuestController.class);
    @Resource
    private WorkInfoService workInfoService;
    @Resource
    private WorkHandleInfoService workHandleInfoService;
    @Autowired
    private WorkFileInfoService workFileInfoService;
    @Resource
    private LogInfoService logInfoService;
    @Autowired
    private AccountInfoService accountInfoService;
    @Autowired
    private CommonConfig commonConfig;

    @RequestMapping(value={"toAddView"})
    public String toAddView(WorkInfo workInfo, Model model, HttpServletRequest request) {
        if (!StaticKeys.LICENSE_STATE.equals("1")) {
            model.addAttribute("info", (Object)"\u8bf7\u5347\u7ea7\u5230\u4e13\u4e1a\u7248\uff08www.wgstart.com\uff09\uff0c\u4f7f\u7528\u6b64\u529f\u80fd");
            return "guest/info";
        }
        if (!"true".equals(this.commonConfig.getShareDataView())) {
            model.addAttribute("info", (Object)"\u7cfb\u7edf\u672a\u5f00\u542f\u5206\u4eab\u65b0\u5efa\u5de5\u5355");
            return "guest/info";
        }
        String[] workTypeArr = this.commonConfig.getWorkType().split(",");
        model.addAttribute("workTypeList", (Object)workTypeArr);
        model.addAttribute("workAttachType", (Object)this.commonConfig.getWorkAttachType());
        String acceptAccount = request.getParameter("acceptAccount");
        model.addAttribute("acceptAccount", (Object)acceptAccount);
        return "guest/add";
    }

    @RequestMapping(value={"toSuccessView"})
    public String toSuccessView(WorkInfo workInfo, Model model, HttpServletRequest request) {
        String acceptAccount = request.getParameter("acceptAccount");
        model.addAttribute("acceptAccount", (Object)acceptAccount);
        return "guest/success";
    }

    @RequestMapping(value={"save"})
    public String saveWorkInfo(@RequestParam(value="file") List<MultipartFile> fileList, WorkInfo workInfo, Model model, HttpServletRequest request) {
        try {
            if (StringUtils.isEmpty((CharSequence)workInfo.getId())) {
                String telephone;
                String contentSuffix = "";
                String contactPerson = request.getParameter("contactPerson");
                if (!StringUtils.isEmpty((CharSequence)contactPerson)) {
                    contentSuffix = contentSuffix + "\u8054\u7cfb\u4eba\uff1a" + contactPerson + "\uff0c";
                }
                if (!StringUtils.isEmpty((CharSequence)(telephone = request.getParameter("telephone")))) {
                    contentSuffix = contentSuffix + "\u8054\u7cfb\u65b9\u5f0f\uff1a" + telephone;
                }
                if (!StringUtils.isEmpty((CharSequence)contentSuffix)) {
                    workInfo.setWorkContent(workInfo.getWorkContent() + "<br>" + contentSuffix);
                }
                workInfo.setWorkTitle(this.commonConfig.getGuestWorkTitlePrefix() + workInfo.getWorkTitle());
                this.workInfoService.save(workInfo);
                this.workInfoService.saveAttachFile(fileList, workInfo.getId());
                this.workInfoService.saveLog(request, this.commonConfig.getGuestWorkTitlePrefix(), workInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u5ba2\u6237\u65b0\u5efa\u5de5\u5355\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u5ba2\u6237\u65b0\u5efa\u5de5\u5355\u4fe1\u606f\u9519\u8bef", e.toString(), "2");
        }
        return "redirect:/workInfoGuest/toSuccessView";
    }
}

