/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.mapper.AccountInfoMapper;
import com.wgcloud.service.EquipmentService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.PasswdInfoService;
import com.wgcloud.service.ShellNoteInfoService;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.UUIDUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountInfoService {
    @Autowired
    private AccountInfoMapper accountInfoMapper;
    @Resource
    private PasswdInfoService passwdInfoService;
    @Autowired
    private EquipmentService equipmentService;
    @Resource
    private LogInfoService logInfoService;
    @Autowired
    private ShellNoteInfoService shellNoteInfoService;

    public PageInfo selectByParams(Map<String, Object> params, int currPage, int pageSize) throws Exception {
        PageHelper.startPage((int)currPage, (int)pageSize);
        List list = this.accountInfoMapper.selectByParams(params);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public void save(AccountInfo accountInfo) throws Exception {
        accountInfo.setId(UUIDUtil.getUUID());
        accountInfo.setCreateTime(new Date());
        this.accountInfoMapper.save(accountInfo);
    }

    @Transactional
    public int deleteById(String[] id) throws Exception {
        return this.accountInfoMapper.deleteById(id);
    }

    public void updateById(AccountInfo accountInfo) throws Exception {
        this.accountInfoMapper.updateById(accountInfo);
    }

    public AccountInfo selectById(String id) throws Exception {
        return this.accountInfoMapper.selectById(id);
    }

    public List<AccountInfo> selectAllByParams(Map<String, Object> params) throws Exception {
        return this.accountInfoMapper.selectAllByParams(params);
    }

    public int countByParams(Map<String, Object> params) throws Exception {
        return this.accountInfoMapper.countByParams(params);
    }

    public AccountInfo selectByAccount(String account) throws Exception {
        if (StringUtils.isEmpty((CharSequence)account)) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("account", account);
        List list = this.accountInfoMapper.selectAllByParams(params);
        if (list.size() > 0) {
            return (AccountInfo)list.get(0);
        }
        return null;
    }

    public void moveToAccount(String accountTarget, String ids, String resourceType) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountTarget", accountTarget);
        params.put("ids", ids.split(","));
        if ("7".equals(resourceType)) {
            this.passwdInfoService.updateToTargetAccount(params);
        }
        if ("8".equals(resourceType)) {
            this.equipmentService.updateToTargetAccount(params);
        }
        if ("9".equals(resourceType)) {
            this.shellNoteInfoService.updateToTargetAccount(params);
        }
    }

    public int updateState(Map<String, Object> params) throws Exception {
        return this.accountInfoMapper.updateState(params);
    }

    public void saveLog(HttpServletRequest request, String action, AccountInfo accountInfo) {
        if (null == accountInfo) {
            return;
        }
        this.logInfoService.save(HostUtil.getAccountByRequest((HttpServletRequest)request).getAccount() + action + "\u8d26\u53f7\uff1a" + accountInfo.getAccount(), "\u8d26\u53f7\uff1a" + accountInfo.getRemark(), "2");
    }
}

